/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.AbstractNodeRepositoryManager;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.StructureBuilder;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;

public class SimpleRepositoryManager
extends AbstractNodeRepositoryManager {
    public SimpleRepositoryManager(StructureBuilder structureBuilder, Logger log) {
        super(log, null);
        if (structureBuilder == null) {
            throw new IllegalArgumentException("Null structure builder!");
        }
        this.setAddCacheAsRoot(true);
        this.setCache(new DefaultRepository(structureBuilder.createRoot()));
    }

    public SimpleRepositoryManager(CmrRepository root, Logger log) {
        this(root, log, null);
    }

    public SimpleRepositoryManager(CmrRepository root, Logger log, Overrides overrides) {
        super(log, overrides);
        if (root == null) {
            throw new IllegalArgumentException("Null root!");
        }
        this.setAddCacheAsRoot(true);
        this.setCache(root);
    }

    @Override
    protected ArtifactResult getArtifactResult(ArtifactContext context, Node node) throws RepositoryException {
        return this.cache.getArtifactResult(this, node);
    }

    public String toString() {
        return "SimpleRepositoryManager: " + this.getCache();
    }
}

