/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactCreator;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class SourceArtifactCreatorImpl
implements ArtifactCreator {
    private final ArtifactContext srcContext;
    private final RepositoryManager repoManager;
    private File originalSrcFile;
    private boolean verbose;
    private Logger log;
    private final Iterable<? extends File> sourcePaths;

    public SourceArtifactCreatorImpl(RepositoryManager repoManager, Iterable<? extends File> sourcePaths, String moduleName, String moduleVersion, boolean verbose, Logger log) throws IOException {
        this.repoManager = repoManager;
        this.verbose = verbose;
        this.log = log;
        this.sourcePaths = sourcePaths;
        this.srcContext = new ArtifactContext(moduleName, moduleVersion, ".src");
        this.originalSrcFile = repoManager.getArtifact(this.srcContext);
    }

    private void setupSrcOutput() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> copy(Collection<String> sources) throws IOException {
        final HashSet<String> copiedFiles = new HashSet<String>();
        File outputSrcFile = File.createTempFile("ceylon-", ".src");
        try (JarOutputStream srcOutputStream = new JarOutputStream(new FileOutputStream(outputSrcFile));){
            HashSet<String> uniqueSources = new HashSet<String>(sources);
            HashSet<String> folders = new HashSet<String>();
            for (String prefixedSourceFile : uniqueSources) {
                String sourceFile = JarUtils.toPlatformIndependentPath(this.sourcePaths, prefixedSourceFile);
                if (copiedFiles.contains(sourceFile)) continue;
                srcOutputStream.putNextEntry(new ZipEntry(sourceFile));
                try (FileInputStream inputStream = new FileInputStream(prefixedSourceFile);){
                    JarUtils.copy(inputStream, srcOutputStream);
                }
                finally {
                    srcOutputStream.closeEntry();
                }
                copiedFiles.add(sourceFile);
                String folder = JarUtils.getFolder(sourceFile);
                if (folder == null) continue;
                folders.add(folder);
            }
            JarUtils.finishUpdatingJar(this.originalSrcFile, outputSrcFile, this.srcContext, srcOutputStream, new JarUtils.JarEntryFilter(){

                @Override
                public boolean avoid(String entryFullName) {
                    return copiedFiles.contains(entryFullName);
                }
            }, this.repoManager, this.verbose, this.log, folders);
        }
        finally {
            FileUtil.deleteQuietly(outputSrcFile);
        }
        return copiedFiles;
    }

    @Override
    public Iterable<? extends File> getPaths() {
        return this.sourcePaths;
    }
}

