/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.PathFilterParser;
import com.redhat.ceylon.cmr.impl.ModulesDependencyResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlDependencyResolver
extends ModulesDependencyResolver {
    public static final XmlDependencyResolver INSTANCE = new XmlDependencyResolver();

    private XmlDependencyResolver() {
        super("module.xml");
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        try {
            Module module = XmlDependencyResolver.parse(stream);
            LinkedHashSet<ModuleDependencyInfo> infos = new LinkedHashSet<ModuleDependencyInfo>();
            for (ModuleIdentifier mi : module.getDependencies()) {
                infos.add(new ModuleDependencyInfo(mi.getName(), mi.getSlot(), mi.isOptional(), mi.isExport()));
            }
            ModuleInfo ret = new ModuleInfo(module.getFilter(), infos);
            if (overrides != null) {
                ret = overrides.applyOverrides(name, version2, ret);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Module parse(InputStream is) throws Exception {
        try {
            Element filterNode;
            Document document = XmlDependencyResolver.parseXml(is);
            Element root = document.getDocumentElement();
            ModuleIdentifier main = XmlDependencyResolver.getModuleIdentifier(root);
            Module module = new Module(main);
            Element dependencies = XmlDependencyResolver.getChildElement(root, "dependencies");
            if (dependencies != null) {
                for (Element dependency : XmlDependencyResolver.getElements(dependencies, "module")) {
                    module.addDependency(XmlDependencyResolver.getModuleIdentifier(dependency));
                }
            }
            if ((filterNode = XmlDependencyResolver.getChildElement(root, "exports")) != null) {
                module.setFilter(PathFilterParser.convertNodeToString(filterNode));
            }
            Module module2 = module;
            return module2;
        }
        finally {
            is.close();
        }
    }

    protected static ModuleIdentifier getModuleIdentifier(Element root) {
        return new ModuleIdentifier(root.getAttribute("name"), root.getAttribute("slot"), Boolean.parseBoolean(root.getAttribute("optional")), Boolean.parseBoolean(root.getAttribute("export")));
    }

    protected static Document parseXml(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputStream);
        doc.getDocumentElement().normalize();
        return doc;
    }

    protected static List<Element> getElements(Element parent, String tagName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodes = parent.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            elements.add((Element)Element.class.cast(node));
        }
        return elements;
    }

    protected static Element getChildElement(Element parent, String tagName) {
        List<Element> elements = XmlDependencyResolver.getElements(parent, tagName);
        return elements.size() > 0 ? elements.get(0) : null;
    }

    private static class Module {
        private ModuleIdentifier module;
        private Set<ModuleIdentifier> dependencies = new LinkedHashSet<ModuleIdentifier>();
        private String filter;

        public Module(ModuleIdentifier module) {
            this.module = module;
        }

        public void addDependency(ModuleIdentifier mi) {
            this.dependencies.add(mi);
        }

        public ModuleIdentifier getModule() {
            return this.module;
        }

        public Set<ModuleIdentifier> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Module module1 = (Module)o;
            return this.module.equals(module1.module);
        }

        public int hashCode() {
            return this.module.hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("\nModule: " + this.module + "\n");
            builder.append("Dependencies: ").append(this.dependencies.size()).append("\n");
            for (ModuleIdentifier dep : this.dependencies) {
                builder.append("\t").append(dep).append("\n");
            }
            builder.append("Filter: ").append(this.filter).append("\n");
            return builder.toString();
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    private static class ModuleIdentifier
    implements Comparable<ModuleIdentifier> {
        private String name;
        private String slot;
        private boolean optional;
        private boolean export;

        public ModuleIdentifier(String name, String slot, boolean optional, boolean export) {
            this.name = name;
            if (slot == null || slot.length() == 0) {
                slot = "main";
            }
            this.slot = slot;
            this.optional = optional;
            this.export = export;
        }

        public static ModuleIdentifier create(String string) {
            String[] split = string.split(":");
            return new ModuleIdentifier(split[0], split.length > 1 ? split[1] : null, false, false);
        }

        public String getName() {
            return this.name;
        }

        public String getSlot() {
            return this.slot;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isExport() {
            return this.export;
        }

        @Override
        public int compareTo(ModuleIdentifier o) {
            int diff = this.name.compareTo(o.getName());
            if (diff != 0) {
                return diff;
            }
            return this.slot.compareTo(o.getSlot());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleIdentifier that = (ModuleIdentifier)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.slot.equals(that.slot);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.slot.hashCode();
            return result;
        }

        public String toString() {
            return this.name + ":" + this.slot;
        }
    }
}

