/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactOverrides;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.DependencyOverride;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.PathFilterParser;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.AbstractArtifactResult;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.LazyArtifactResult;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.maven.SingleScopedStrategy;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.ImportType;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.ResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.Resolvers;
import org.jboss.shrinkwrap.resolver.api.VersionResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenArtifactInfo;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenVersionRangeResult;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AetherUtils {
    private static final ScopeType[] SCOPES = new ScopeType[]{ScopeType.COMPILE, ScopeType.PROVIDED, ScopeType.RUNTIME};
    private static final SingleScopedStrategy SCOPED_STRATEGY = new SingleScopedStrategy(SCOPES);
    private Logger log;
    private int timeout;
    private boolean offline;
    private String settingsXml;

    AetherUtils(Logger log, boolean offline, int timeout) {
        this.log = log;
        this.timeout = timeout;
        this.offline = offline;
        this.settingsXml = AetherUtils.getDefaultMavenSettings();
    }

    MavenArtifactInfo[] getDependencies(File pomXml, String name, String version2) {
        MavenResolverSystem system = this.getResolver();
        PomEquippedResolveStage resolverStage = (PomEquippedResolveStage)system.loadPomFromFile(pomXml);
        String coordinates = AetherUtils.toCanonicalForm(name, version2);
        MavenStrategyStage strategyStage = (MavenStrategyStage)resolverStage.resolve(coordinates);
        MavenFormatStage formatStage = (MavenFormatStage)strategyStage.using((ResolutionStrategy)SCOPED_STRATEGY);
        return ((MavenResolvedArtifact)formatStage.asSingleResolvedArtifact()).getDependencies();
    }

    MavenArtifactInfo[] getDependencies(InputStream pomXml, String name, String version2) {
        File tempFile = null;
        try {
            tempFile = IOUtils.toTempFile(pomXml);
            MavenArtifactInfo[] mavenArtifactInfoArray = this.getDependencies(tempFile, name, version2);
            return mavenArtifactInfoArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    static boolean isOptional(MavenArtifactInfo info) {
        return info.isOptional() || info.getScope() != ScopeType.COMPILE && info.getScope() != ScopeType.RUNTIME;
    }

    void overrideSettingsXml(String settingsXml) {
        if (settingsXml != null) {
            this.settingsXml = settingsXml;
        }
    }

    File findDependency(Node node) {
        ArtifactResult result = this.findDependencies(null, node, true);
        return result != null ? result.artifact() : null;
    }

    ArtifactResult findDependencies(RepositoryManager manager, Node node) {
        return this.findDependencies(manager, node, null);
    }

    String[] nameToGroupArtifactIds(String name) {
        int p = name.lastIndexOf(":");
        if (p == -1) {
            return null;
        }
        String groupId = name.substring(0, p);
        String artifactId = name.substring(p + 1);
        return new String[]{groupId, artifactId};
    }

    private ArtifactResult findDependencies(RepositoryManager manager, Node node, Boolean fetchSingleArtifact) {
        ArtifactContext ac = ArtifactContext.fromNode(node);
        if (ac == null) {
            return null;
        }
        String name = ac.getName();
        String[] groupArtifactIds = this.nameToGroupArtifactIds(name);
        if (groupArtifactIds == null) {
            return null;
        }
        String groupId = groupArtifactIds[0];
        String artifactId = groupArtifactIds[1];
        String version2 = ac.getVersion();
        String repositoryDisplayString = NodeUtils.getRepositoryDisplayString(node);
        CmrRepository repository = NodeUtils.getRepository(node);
        if (CeylonUtils.arrayContains(ac.getSuffixes(), "-sources.jar")) {
            return this.fetchWithClassifier(repository, groupId, artifactId, version2, "sources", repositoryDisplayString);
        }
        return this.fetchDependencies(manager, repository, groupId, artifactId, version2, fetchSingleArtifact != null ? fetchSingleArtifact.booleanValue() : ac.isIgnoreDependencies(), repositoryDisplayString);
    }

    private ArtifactResult fetchDependencies(RepositoryManager manager, CmrRepository repository, String groupId, String artifactId, String version2, boolean fetchSingleArtifact, String repositoryDisplayString) {
        MavenCoordinate mc = MavenCoordinates.createCoordinate((String)groupId, (String)artifactId, (String)version2, (PackagingType)PackagingType.JAR, null);
        Overrides overrides = repository.getRoot().getService(Overrides.class);
        ArtifactOverrides ao = null;
        this.log.debug("Overrides: " + overrides);
        ArtifactContext context = this.getArtifactContext(mc);
        if (overrides != null) {
            ao = overrides.getArtifactOverrides(context);
            this.log.debug(" [" + mc + "] => " + ao);
        }
        ArtifactContext replacementContext = null;
        if (ao != null && ao.getReplace() != null) {
            replacementContext = ao.getReplace().getArtifactContext();
        } else if (overrides != null) {
            replacementContext = overrides.replace(context);
        }
        if (replacementContext != null) {
            this.log.debug(String.format("[Maven-Overrides] Replacing %s with %s.", mc, replacementContext));
            String[] nameToGroupArtifactIds = this.nameToGroupArtifactIds(replacementContext.getName());
            if (nameToGroupArtifactIds != null) {
                groupId = nameToGroupArtifactIds[0];
                artifactId = nameToGroupArtifactIds[1];
                version2 = replacementContext.getVersion();
                mc = MavenCoordinates.createCoordinate((String)groupId, (String)artifactId, (String)version2, (PackagingType)PackagingType.JAR, null);
                context = this.getArtifactContext(mc);
                ao = overrides.getArtifactOverrides(context);
            }
        }
        if (overrides != null && overrides.isVersionOverridden(context)) {
            version2 = overrides.getVersionOverride(context);
            context.setVersion(version2);
            mc = MavenCoordinates.createCoordinate((String)groupId, (String)artifactId, (String)version2, (PackagingType)PackagingType.JAR, null);
        }
        String name = AetherUtils.toCanonicalForm(groupId, artifactId);
        String coordinates = AetherUtils.toCanonicalForm(name, version2);
        try {
            SingleArtifactResult result;
            MavenStrategyStage mss = (MavenStrategyStage)this.getResolver().resolve(coordinates);
            MavenFormatStage mfs = (MavenFormatStage)mss.using((ResolutionStrategy)SCOPED_STRATEGY);
            MavenResolvedArtifact info = (MavenResolvedArtifact)mfs.asSingleResolvedArtifact();
            if (info == null) {
                this.log.debug("No artifact found: " + coordinates);
                return null;
            }
            if (fetchSingleArtifact) {
                result = new SingleArtifactResult(repository, name, version2, info.asFile(), repositoryDisplayString);
            } else {
                MavenArtifactInfo[] infos;
                ArrayList<ArtifactResult> dependencies = new ArrayList<ArtifactResult>();
                for (MavenArtifactInfo dep : infos = info.getDependencies()) {
                    MavenCoordinate dCo = dep.getCoordinate();
                    String dGroupId = dCo.getGroupId();
                    String dArtifactId = dCo.getArtifactId();
                    String dVersion = dCo.getVersion();
                    boolean export = false;
                    boolean optional = false;
                    try {
                        optional = dep.isOptional();
                    }
                    catch (NoSuchMethodError e) {
                        URL locationURL;
                        CodeSource cs;
                        e.printStackTrace();
                        String locationMessage = "";
                        Class<?> clazz = dep.getClass();
                        ProtectionDomain d = clazz.getProtectionDomain();
                        if (d != null && (cs = d.getCodeSource()) != null && (locationURL = cs.getLocation()) != null) {
                            locationMessage = " loaded from : " + locationURL.toString();
                        }
                        System.err.println("MavenArtifactInfo class : " + clazz.getName() + locationMessage);
                    }
                    boolean isCeylon = false;
                    ArtifactContext dContext = null;
                    if (overrides != null) {
                        dContext = this.getArtifactContext(dCo);
                    }
                    if (overrides != null) {
                        if (overrides.isRemoved(dContext) || ao != null && ao.isRemoved(dContext)) {
                            this.log.debug(String.format("[Maven-Overrides] Removing %s from %s.", dCo, mc));
                            continue;
                        }
                        if (ao != null && ao.isAddedOrUpdated(dContext)) {
                            this.log.debug(String.format("[Maven-Overrides] Replacing %s from %s.", dCo, mc));
                            continue;
                        }
                        ArtifactContext replace = overrides.replace(dContext);
                        if (replace != null) {
                            dContext = replace;
                            String[] groupArtifactIds = this.nameToGroupArtifactIds(replace.getName());
                            if (groupArtifactIds == null) {
                                isCeylon = true;
                            } else {
                                dGroupId = groupArtifactIds[0];
                                dArtifactId = groupArtifactIds[1];
                            }
                            dVersion = replace.getVersion();
                        }
                        if (ao != null) {
                            if (ao.isShareOverridden(dContext)) {
                                export = ao.isShared(dContext);
                            }
                            if (ao.isOptionalOverridden(dContext)) {
                                optional = ao.isOptional(dContext);
                            }
                        }
                    }
                    if (overrides != null && overrides.isVersionOverridden(dContext)) {
                        dVersion = overrides.getVersionOverride(dContext);
                    }
                    ArtifactResult dr = isCeylon ? this.createArtifactResult(manager, dContext.getName(), dVersion, export, optional, repositoryDisplayString) : this.createArtifactResult(manager, repository, dGroupId, dArtifactId, dVersion, export, optional, repositoryDisplayString);
                    dependencies.add(dr);
                }
                if (ao != null) {
                    for (DependencyOverride addon : ao.getAdd()) {
                        ArtifactContext dContext = addon.getArtifactContext();
                        String dVersion = overrides.getVersionOverride(dContext);
                        dependencies.add(this.createArtifactResult(manager, repository, dContext, dVersion, addon.isShared(), addon.isOptional(), repositoryDisplayString));
                        this.log.debug(String.format("[Maven-Overrides] Added %s to %s.", addon.getArtifactContext(), mc));
                    }
                }
                result = new AetherArtifactResult(repository, name, version2, info.asFile(), dependencies, repositoryDisplayString);
            }
            if (ao != null && ao.getFilter() != null) {
                result.setFilter(PathFilterParser.parse(ao.getFilter()));
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ResolutionException e) {
            this.log.debug("Could not resolve artifact [" + coordinates + "] : " + (Object)((Object)e));
            return null;
        }
    }

    public void search(String groupId, String artifactId, String version2, ModuleVersionResult result, Overrides overrides, String repositoryDisplayString) {
        MavenResolverSystem resolver = this.getResolver();
        if (version2 == null || version2.isEmpty()) {
            MavenVersionRangeResult resolveVersionRange = (MavenVersionRangeResult)resolver.resolveVersionRange(groupId + ":" + artifactId + ":(,)");
            List versions = resolveVersionRange.getVersions();
            for (MavenCoordinate co : versions) {
                if (co.getVersion() == null || co.getVersion().isEmpty()) continue;
                this.addSearchResult(co.getGroupId(), co.getArtifactId(), co.getVersion(), result, overrides, repositoryDisplayString);
            }
        } else {
            try {
                MavenVersionRangeResult resolveVersionRange = (MavenVersionRangeResult)resolver.resolveVersionRange(groupId + ":" + artifactId + ":[" + version2 + ",]");
                List versions = resolveVersionRange.getVersions();
                for (MavenCoordinate co : versions) {
                    if (co.getVersion() == null || !co.getVersion().startsWith(version2)) continue;
                    this.addSearchResult(co.getGroupId(), co.getArtifactId(), co.getVersion(), result, overrides, repositoryDisplayString);
                }
            }
            catch (VersionResolutionException x) {
                this.addSearchResult(groupId, artifactId, version2, result, overrides, repositoryDisplayString);
            }
        }
    }

    private void addSearchResult(String groupId, String artifactId, String version2, ModuleVersionResult result, Overrides overrides, String repositoryDisplayString) {
        MavenResolverSystem resolver;
        MavenStrategyStage mss;
        MavenFormatStage mfs;
        MavenResolvedArtifact info;
        ArtifactOverrides artifactOverrides = null;
        if (overrides != null) {
            ArtifactContext ctx = new ArtifactContext(groupId + ":" + artifactId, version2);
            ArtifactContext replaceContext = overrides.replace(ctx);
            if (replaceContext != null) {
                String[] groupArtifactIds = this.nameToGroupArtifactIds(replaceContext.getName());
                if (groupArtifactIds == null) {
                    return;
                }
                groupId = groupArtifactIds[0];
                artifactId = groupArtifactIds[1];
                version2 = replaceContext.getVersion();
                ctx = replaceContext;
            } else if (overrides.isVersionOverridden(ctx)) {
                version2 = overrides.getVersionOverride(ctx);
                ctx.setVersion(version2);
            }
            artifactOverrides = overrides.getArtifactOverrides(ctx);
        }
        if ((info = (MavenResolvedArtifact)(mfs = (MavenFormatStage)(mss = (MavenStrategyStage)(resolver = this.getResolver()).resolve(groupId + ":" + artifactId + ":" + version2)).using((ResolutionStrategy)SCOPED_STRATEGY)).asSingleResolvedArtifact()) != null) {
            StringBuilder description = new StringBuilder();
            StringBuilder licenseBuilder = new StringBuilder();
            this.collectInfo(info, description, licenseBuilder);
            HashSet<ModuleDependencyInfo> dependencies = new HashSet<ModuleDependencyInfo>();
            HashSet<ModuleVersionArtifact> artifactTypes = new HashSet<ModuleVersionArtifact>();
            artifactTypes.add(new ModuleVersionArtifact(".jar", null, null));
            HashSet<String> authors = new HashSet<String>();
            for (MavenArtifactInfo dep : info.getDependencies()) {
                MavenCoordinate depCo = dep.getCoordinate();
                String depName = depCo.getGroupId() + ":" + depCo.getArtifactId();
                String depVersion = depCo.getVersion();
                boolean export = false;
                boolean optional = dep.isOptional();
                if (overrides != null) {
                    ArtifactContext depCtx = new ArtifactContext(depName, depCo.getVersion());
                    if (overrides.isRemoved(depCtx) || artifactOverrides != null && (artifactOverrides.isRemoved(depCtx) || artifactOverrides.isAddedOrUpdated(depCtx))) continue;
                    ArtifactContext replaceCtx = overrides.replace(depCtx);
                    if (replaceCtx != null) {
                        depCtx = replaceCtx;
                        depName = replaceCtx.getName();
                    }
                    if (overrides.isVersionOverridden(depCtx)) {
                        depVersion = overrides.getVersionOverride(depCtx);
                    }
                    if (artifactOverrides != null) {
                        if (artifactOverrides.isShareOverridden(depCtx)) {
                            export = artifactOverrides.isShared(depCtx);
                        }
                        if (artifactOverrides.isOptionalOverridden(depCtx)) {
                            optional = artifactOverrides.isOptional(depCtx);
                        }
                    }
                }
                ModuleDependencyInfo moduleDependencyInfo = new ModuleDependencyInfo(depName, depVersion, optional, export);
                dependencies.add(moduleDependencyInfo);
            }
            if (artifactOverrides != null) {
                for (DependencyOverride add : artifactOverrides.getAdd()) {
                    ModuleDependencyInfo moduleDependencyInfo = new ModuleDependencyInfo(add.getArtifactContext().getName(), add.getArtifactContext().getVersion(), add.isOptional(), add.isShared());
                    dependencies.add(moduleDependencyInfo);
                }
            }
            ModuleVersionDetails moduleVersionDetails = new ModuleVersionDetails(groupId + ":" + artifactId, version2, description.length() > 0 ? description.toString() : null, licenseBuilder.length() > 0 ? licenseBuilder.toString() : null, authors, dependencies, artifactTypes, true, repositoryDisplayString);
            result.addVersion(moduleVersionDetails);
        }
    }

    private void collectInfo(MavenResolvedArtifact info, StringBuilder description, StringBuilder licenseBuilder) {
        File pomFile;
        File jarFile = info.asFile();
        if (jarFile != null && jarFile.getName().endsWith(".jar") && (pomFile = new File(jarFile.getParentFile(), jarFile.getName().substring(0, jarFile.getName().length() - 4) + ".pom")).exists()) {
            try (FileInputStream is = new FileInputStream(pomFile);){
                Element license;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(is);
                doc.getDocumentElement().normalize();
                Element root = doc.getDocumentElement();
                this.collectText(root, description, "name", "description", "url");
                Element licenses = this.getFirstElement(root, "licenses");
                if (licenses != null && (license = this.getFirstElement(licenses, "license")) != null) {
                    this.collectText(license, licenseBuilder, "name", "url");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    private String getText(Element element, String childName) {
        NodeList elems = element.getElementsByTagName(childName);
        if (elems != null && elems.getLength() > 0) {
            return elems.item(0).getTextContent();
        }
        return null;
    }

    private Element getFirstElement(Element element, String childName) {
        NodeList elems = element.getElementsByTagName(childName);
        if (elems != null && elems.getLength() > 0 && elems.item(0) instanceof Element) {
            return (Element)elems.item(0);
        }
        return null;
    }

    private void collectText(Element element, StringBuilder builder, String ... tags) {
        for (String tag : tags) {
            String desc = this.getText(element, tag);
            if (desc == null) continue;
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(desc);
        }
    }

    private ArtifactContext getArtifactContext(MavenCoordinate mc) {
        String packaging = mc.getPackaging() == PackagingType.JAR ? null : mc.getPackaging().getExtension();
        String classifier = mc.getClassifier();
        if (classifier != null && classifier.isEmpty()) {
            classifier = null;
        }
        return Overrides.createMavenArtifactContext(mc.getGroupId(), mc.getArtifactId(), mc.getVersion(), packaging, classifier);
    }

    protected ArtifactResult createArtifactResult(RepositoryManager manager, CmrRepository repository, ArtifactContext dCo, String version2, boolean shared, boolean optional, String repositoryDisplayString) {
        String[] groupArtifactIds = this.nameToGroupArtifactIds(dCo.getName());
        if (groupArtifactIds == null) {
            return this.createArtifactResult(manager, dCo.getName(), version2, shared, optional, repositoryDisplayString);
        }
        return this.createArtifactResult(manager, repository, groupArtifactIds[0], groupArtifactIds[1], version2, shared, optional, repositoryDisplayString);
    }

    protected ArtifactResult createArtifactResult(final RepositoryManager manager, CmrRepository repository, final String groupId, final String artifactId, final String dVersion, final boolean shared, final boolean optional, final String repositoryDisplayString) {
        String dName = AetherUtils.toCanonicalForm(groupId, artifactId);
        return new MavenArtifactResult(repository, dName, dVersion, repositoryDisplayString){
            private ArtifactResult result;

            @Override
            public ImportType importType() {
                return shared ? ImportType.EXPORT : (optional ? ImportType.OPTIONAL : ImportType.UNDEFINED);
            }

            private synchronized ArtifactResult getResult() {
                if (this.result == null) {
                    this.result = AetherUtils.this.fetchDependencies(manager, (CmrRepository)this.repository(), groupId, artifactId, dVersion, false, repositoryDisplayString);
                }
                return this.result;
            }

            @Override
            protected File artifactInternal() throws RepositoryException {
                return this.getResult().artifact();
            }

            @Override
            public List<ArtifactResult> dependencies() throws RepositoryException {
                return this.getResult().dependencies();
            }
        };
    }

    protected ArtifactResult createArtifactResult(RepositoryManager manager, String module, String dVersion, boolean shared, boolean optional, String repositoryDisplayString) {
        return new LazyArtifactResult(manager, module, dVersion, shared ? ImportType.EXPORT : (optional ? ImportType.OPTIONAL : ImportType.UNDEFINED));
    }

    private ArtifactResult fetchWithClassifier(CmrRepository repository, String groupId, String artifactId, String version2, String classifier, String repositoryDisplayString) {
        String name = AetherUtils.toCanonicalForm(groupId, artifactId);
        String coordinates = AetherUtils.toCanonicalForm(AetherUtils.toCanonicalForm(AetherUtils.toCanonicalForm(name, "jar"), classifier), version2);
        try {
            MavenStrategyStage source_mss = (MavenStrategyStage)this.getResolver().resolve(coordinates);
            MavenFormatStage source_mfs = (MavenFormatStage)source_mss.using((ResolutionStrategy)SCOPED_STRATEGY);
            MavenResolvedArtifact info = (MavenResolvedArtifact)source_mfs.asSingleResolvedArtifact();
            if (info != null) {
                return new SingleArtifactResult(repository, name, version2, info.asFile(), repositoryDisplayString);
            }
        }
        catch (ResolutionException e) {
            this.log.debug("Could not resolve " + classifier + " for artifact [" + coordinates + "] : " + (Object)((Object)e));
        }
        this.log.debug("No artifact found: " + coordinates);
        return null;
    }

    static String toCanonicalForm(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public static String getDefaultMavenSettings() {
        File file;
        String path = System.getProperty("maven.repo.local");
        if (path != null && (file = new File(path, "settings.xml")).exists()) {
            return file.getAbsolutePath();
        }
        path = System.getProperty("user.home");
        if (path != null && (file = new File(path, ".m2/settings.xml")).exists()) {
            return file.getAbsolutePath();
        }
        path = System.getenv("M2_HOME");
        if (path != null && (file = new File(path, "conf/settings.xml")).exists()) {
            return file.getAbsolutePath();
        }
        return "classpath:settings.xml";
    }

    private MavenResolverSystem getResolver() {
        ClassLoader classLoader = AetherUtils.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ConfigurableMavenResolverSystem factory = (ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Resolvers.use(ConfigurableMavenResolverSystem.class, (ClassLoader)classLoader)).workOffline(this.offline);
        if (this.settingsXml.startsWith("classpath:")) {
            return (MavenResolverSystem)factory.fromClassloaderResource(this.settingsXml.substring(10), classLoader);
        }
        return (MavenResolverSystem)factory.fromFile(this.settingsXml);
    }

    private static class AetherArtifactResult
    extends SingleArtifactResult {
        private List<ArtifactResult> dependencies;

        private AetherArtifactResult(CmrRepository repository, String name, String version2, File file, List<ArtifactResult> dependencies, String repositoryDisplayString) {
            super(repository, name, version2, file, repositoryDisplayString);
            this.dependencies = dependencies;
        }

        @Override
        public List<ArtifactResult> dependencies() throws RepositoryException {
            return Collections.unmodifiableList(this.dependencies);
        }
    }

    private static class SingleArtifactResult
    extends MavenArtifactResult {
        private File file;

        private SingleArtifactResult(CmrRepository repository, String name, String version2, File file, String repositoryDisplayString) {
            super(repository, name, version2, repositoryDisplayString);
            this.file = file;
        }

        @Override
        protected File artifactInternal() throws RepositoryException {
            return this.file;
        }

        void setFilter(PathFilter filter) {
            this.setFilterInternal(filter);
        }

        @Override
        public List<ArtifactResult> dependencies() throws RepositoryException {
            return Collections.emptyList();
        }
    }

    private static abstract class MavenArtifactResult
    extends AbstractArtifactResult {
        private String repositoryDisplayString;

        protected MavenArtifactResult(CmrRepository repository, String name, String version2, String repositoryDisplayString) {
            super(repository, name, version2);
            this.repositoryDisplayString = repositoryDisplayString;
        }

        @Override
        public ArtifactResultType type() {
            return ArtifactResultType.MAVEN;
        }

        @Override
        public String repositoryDisplayString() {
            return this.repositoryDisplayString;
        }
    }
}

