/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolver;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.CMRJULLogger;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.maven.AetherUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import org.jboss.shrinkwrap.resolver.api.maven.MavenArtifactInfo;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;

public class MavenDependencyResolver
extends AbstractDependencyResolver {
    private static final Logger logger = new CMRJULLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        if (!context.ignoreInner()) {
            ArtifactResult result = context.result();
            String name = result.name();
            int p = name.indexOf(58);
            if (p < 0) {
                p = name.lastIndexOf(46);
            }
            if (p < 0) {
                return null;
            }
            String groupId = name.substring(0, p);
            String artifactId = name.substring(p + 1);
            String descriptorPath = String.format("META-INF/maven/%s/%s/pom.xml", groupId, artifactId);
            InputStream inputStream = IOUtils.findDescriptor(result, descriptorPath);
            if (inputStream != null) {
                try {
                    ModuleInfo moduleInfo = this.resolveFromInputStream(inputStream, name, result.version(), overrides);
                    return moduleInfo;
                }
                finally {
                    IOUtils.safeClose(inputStream);
                }
            }
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        if (!file.exists()) {
            return null;
        }
        AetherUtils utils = new AetherUtils(logger, false, 20000);
        MavenArtifactInfo[] dependencies = utils.getDependencies(file, name, version2);
        return MavenDependencyResolver.toModuleInfo(dependencies, name, version2, overrides);
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        if (stream == null) {
            return null;
        }
        AetherUtils utils = new AetherUtils(logger, false, 20000);
        MavenArtifactInfo[] dependencies = utils.getDependencies(stream, name, version2);
        return MavenDependencyResolver.toModuleInfo(dependencies, name, version2, overrides);
    }

    @Override
    public Node descriptor(Node artifact) {
        return NodeUtils.firstParent(artifact).getChild("pom.xml");
    }

    protected static ModuleInfo toModuleInfo(MavenArtifactInfo[] dependencies, String name, String version2, Overrides overrides) {
        HashSet<ModuleDependencyInfo> infos = new HashSet<ModuleDependencyInfo>();
        for (MavenArtifactInfo dep : dependencies) {
            MavenCoordinate co = dep.getCoordinate();
            infos.add(new ModuleDependencyInfo(AetherUtils.toCanonicalForm(co.getGroupId(), co.getArtifactId()), co.getVersion(), AetherUtils.isOptional(dep), false));
        }
        ModuleInfo ret = new ModuleInfo(null, infos);
        if (overrides != null) {
            ret = overrides.applyOverrides(name, version2, ret);
        }
        return ret;
    }
}

