/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.NonTransitiveFilter;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.AcceptScopesStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveExclusionPolicy;

class SingleScopedStrategy
implements MavenResolutionStrategy {
    private static final MavenResolutionFilter[] EMPTY_CHAIN = new MavenResolutionFilter[0];
    private MavenResolutionFilter[] filters;
    private TransitiveExclusionPolicy tep;

    SingleScopedStrategy(ScopeType ... scopes) {
        AcceptScopesStrategy scopesStrategy = new AcceptScopesStrategy(scopes);
        final MavenResolutionFilter[] scopesFilters = scopesStrategy.getResolutionFilters();
        this.filters = new MavenResolutionFilter[scopesFilters.length];
        for (int i = 0; i < this.filters.length; ++i) {
            final int index = i;
            this.filters[i] = new MavenResolutionFilter(){

                public boolean accepts(MavenDependency dependency, List<MavenDependency> dependenciesForResolution, List<MavenDependency> dependencyAncestors) {
                    return scopesFilters[index].accepts(dependency, dependenciesForResolution, dependencyAncestors) && NonTransitiveFilter.INSTANCE.accepts(dependency, dependenciesForResolution, dependencyAncestors);
                }
            };
        }
        this.tep = new SingleTransitiveExclusionPolicy(scopes);
    }

    public MavenResolutionFilter[] getPreResolutionFilters() {
        return EMPTY_CHAIN;
    }

    public MavenResolutionFilter[] getResolutionFilters() {
        return this.filters;
    }

    public TransitiveExclusionPolicy getTransitiveExclusionPolicy() {
        return this.tep;
    }

    private class SingleTransitiveExclusionPolicy
    implements TransitiveExclusionPolicy {
        private ScopeType[] scopes;

        private SingleTransitiveExclusionPolicy(ScopeType[] scopes) {
            EnumSet<ScopeType> used = EnumSet.copyOf(Arrays.asList(scopes));
            EnumSet<ScopeType> set = EnumSet.complementOf(used);
            this.scopes = set.toArray(new ScopeType[set.size()]);
        }

        public boolean allowOptional() {
            return false;
        }

        public ScopeType[] getFilteredScopes() {
            return this.scopes;
        }
    }
}

