/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.SardineImpl;
import com.github.sardine.impl.io.ContentLengthInputStream;
import com.redhat.ceylon.cmr.impl.AbstractRemoteContentStore;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.URLContentStore;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.http.ProtocolException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.config.Registry;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class WebDAVContentStore
extends URLContentStore {
    private volatile SardineImpl sardine;
    private boolean forcedAuthenticationForPutOnHerd = false;

    public WebDAVContentStore(String root, Logger log, boolean offline, int timeout, Proxy proxy, String apiVersion) {
        super(root, log, offline, timeout, proxy, apiVersion);
    }

    public WebDAVContentStore(String root, Logger log, boolean offline, int timeout, Proxy proxy) {
        super(root, log, offline, timeout, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SardineImpl getSardine() {
        if (this.sardine == null) {
            WebDAVContentStore webDAVContentStore = this;
            synchronized (webDAVContentStore) {
                if (this.sardine == null) {
                    this.sardine = new SardineImpl(this.username, this.password, null){

                        @Override
                        protected HttpClientConnectionManager createDefaultConnectionManager(Registry<ConnectionSocketFactory> schemeRegistry) {
                            HttpClientConnectionManager connMan = super.createDefaultConnectionManager(schemeRegistry);
                            if (connMan instanceof PoolingHttpClientConnectionManager) {
                                PoolingHttpClientConnectionManager phccm = (PoolingHttpClientConnectionManager)connMan;
                                SocketConfig config = SocketConfig.custom().setSoTimeout(WebDAVContentStore.this.timeout).build();
                                phccm.setDefaultSocketConfig(config);
                            }
                            return connMan;
                        }
                    };
                }
            }
        }
        return this.sardine;
    }

    @Override
    public OpenNode create(Node parent, String child) {
        if (!this.connectionAllowed()) {
            return null;
        }
        try {
            if (!this.isHerd()) {
                this.mkdirs(this.getSardine(), parent);
            }
            return this.createNode(child);
        }
        catch (IOException e) {
            throw this.convertIOException(e);
        }
    }

    @Override
    public ContentHandle peekContent(Node node) {
        if (!this.connectionAllowed()) {
            return null;
        }
        try {
            String url = this.getUrlAsString(node);
            return this.getSardine().exists(url) ? new WebDAVContentHandle(url) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ContentHandle getContent(Node node) throws IOException {
        return new WebDAVContentHandle(this.getUrlAsString(node));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ContentHandle putContent(Node node, InputStream stream, ContentOptions options) throws IOException {
        if (!this.connectionAllowed()) {
            return null;
        }
        SardineImpl s = this.getSardine();
        try {
            if (this.isHerd() && !this.forcedAuthenticationForPutOnHerd) {
                s.exists(this.getUrlAsString(node));
                this.forcedAuthenticationForPutOnHerd = true;
            }
            Node parent = NodeUtils.firstParent(node);
            if (!this.isHerd()) {
                this.mkdirs(s, parent);
            }
            String pUrl = this.getUrlAsString(parent);
            String token = null;
            if (!this.isHerd()) {
                token = s.lock(pUrl);
            }
            String url = this.getUrlAsString(node);
            try {
                s.put(url, stream);
                WebDAVContentHandle webDAVContentHandle = new WebDAVContentHandle(url);
                return webDAVContentHandle;
            }
            catch (SocketTimeoutException x) {
                SocketTimeoutException ret = new SocketTimeoutException("Timed out writing to " + url);
                ret.initCause(x);
                throw ret;
            }
            finally {
                if (!this.isHerd()) {
                    s.unlock(pUrl, token);
                }
            }
        }
        catch (IOException x) {
            throw this.convertIOException(x);
        }
    }

    public RepositoryException convertIOException(IOException x) {
        if (x instanceof SardineException) {
            SardineException sx = (SardineException)x;
            if (sx.getStatusCode() == 403) {
                return new RepositoryException("authentication failed on repository " + this.root);
            }
            return new RepositoryException(sx.getMessage() + ": " + sx.getResponsePhrase() + " " + sx.getStatusCode());
        }
        if (x instanceof ClientProtocolException && x.getCause() != null && x.getCause() instanceof ProtocolException) {
            return new RepositoryException(x.getCause().getMessage());
        }
        return new RepositoryException(x);
    }

    protected void mkdirs(Sardine s, Node parent) throws IOException {
        if (parent == null) {
            return;
        }
        this.mkdirs(s, NodeUtils.firstParent(parent));
        String url = this.getUrlAsString(parent);
        if (!s.exists(url)) {
            s.createDirectory(url);
        }
    }

    @Override
    protected ContentHandle createContentHandle(Node parent, String child, String path, Node node) {
        return new WebDAVContentHandle(this.root + path);
    }

    @Override
    public Iterable<? extends OpenNode> find(Node parent) {
        if (!this.connectionAllowed()) {
            return Collections.emptyList();
        }
        String url = this.getUrlAsString(parent);
        try {
            ArrayList<AbstractRemoteContentStore.RemoteNode> nodes = new ArrayList<AbstractRemoteContentStore.RemoteNode>();
            List<DavResource> resources = this.getSardine().list(url);
            for (DavResource dr : resources) {
                String label = dr.getName();
                AbstractRemoteContentStore.RemoteNode node = new AbstractRemoteContentStore.RemoteNode(label);
                if (dr.isDirectory()) {
                    node.setContentMarker();
                } else {
                    node.setHandle(new WebDAVContentHandle(url + label));
                }
                nodes.add(node);
            }
            return nodes;
        }
        catch (IOException e) {
            this.log.debug("Failed to list url: " + url);
            return Collections.emptyList();
        }
    }

    @Override
    protected boolean urlExists(String path) {
        if (!this.connectionAllowed()) {
            return false;
        }
        try {
            return this.getSardine().exists(this.getUrlAsString(path));
        }
        catch (IOException e) {
            this.log.debug("Failed to check url: " + path);
            return false;
        }
    }

    @Override
    protected boolean urlExists(URL url) {
        if (!this.connectionAllowed()) {
            return false;
        }
        try {
            return this.getSardine().exists(url.toExternalForm());
        }
        catch (IOException e) {
            this.log.debug("Failed to check url: " + url);
            return false;
        }
    }

    public String toString() {
        return "WebDAV content store: " + this.root;
    }

    private class WebDAVContentHandle
    implements ContentHandle {
        private final String url;

        private WebDAVContentHandle(String url) {
            this.url = url;
        }

        @Override
        public boolean hasBinaries() {
            if (!WebDAVContentStore.this.connectionAllowed()) {
                return false;
            }
            try {
                List<DavResource> list = WebDAVContentStore.this.getSardine().list(this.url);
                return list.size() == 1 && !list.get(0).isDirectory();
            }
            catch (IOException e) {
                WebDAVContentStore.this.log.warning("Cannot list resources: " + this.url + "; error - " + e);
                return false;
            }
        }

        @Override
        public InputStream getBinariesAsStream() throws IOException {
            SizedInputStream ret = this.getBinariesAsSizedStream();
            return ret != null ? ret.inputStream : null;
        }

        @Override
        public SizedInputStream getBinariesAsSizedStream() throws IOException {
            ContentLengthInputStream inputStream;
            if (!WebDAVContentStore.this.connectionAllowed()) {
                return null;
            }
            Long length = (inputStream = WebDAVContentStore.this.getSardine().get(this.url)).getLength();
            return new SizedInputStream(inputStream, length != null ? length : -1L);
        }

        @Override
        public File getContentAsFile() throws IOException {
            return null;
        }

        @Override
        public long getSize() throws IOException {
            if (WebDAVContentStore.this.connectionAllowed()) {
                Long length;
                if (WebDAVContentStore.this.isHerd()) {
                    return WebDAVContentStore.this.size(new URL(this.url));
                }
                List<DavResource> list = WebDAVContentStore.this.getSardine().list(this.url);
                if (!list.isEmpty() && !list.get(0).isDirectory() && (length = list.get(0).getContentLength()) != null) {
                    return length;
                }
            }
            return -1L;
        }

        @Override
        public long getLastModified() throws IOException {
            if (WebDAVContentStore.this.connectionAllowed()) {
                Date modified;
                if (WebDAVContentStore.this.isHerd()) {
                    return WebDAVContentStore.this.lastModified(new URL(this.url));
                }
                List<DavResource> list = WebDAVContentStore.this.getSardine().list(this.url);
                if (!list.isEmpty() && !list.get(0).isDirectory() && (modified = list.get(0).getModified()) != null) {
                    return modified.getTime();
                }
            }
            return -1L;
        }

        @Override
        public void clean() {
        }
    }
}

