/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import com.redhat.ceylon.common.Backends;
import java.util.HashSet;
import java.util.Set;

public class Backend {
    public static final Backend Header;
    public static final Backend Java;
    public static final Backend JavaScript;
    private static final Set<Backend> registeredBackends;
    private static final Set<Backend> allBackends;
    public final String name;
    public final String nativeAnnotation;

    private Backend(String name, String nativeAnnotation) {
        this.name = name;
        this.nativeAnnotation = nativeAnnotation;
    }

    public Backends asSet() {
        return Backends.fromAnnotation(this.nativeAnnotation);
    }

    public boolean isRegistered() {
        return registeredBackends.contains(this);
    }

    public static Backend registerBackend(String name, String backend) {
        Backend b = Backend.findAnnotation(backend);
        if (b == null) {
            b = Backend.createBackend(name, backend);
            registeredBackends.add(b);
        }
        return b;
    }

    public static Backends getRegisteredBackends() {
        return new Backends(registeredBackends);
    }

    public static boolean isRegisteredBackend(String backend) {
        if (backend.isEmpty()) {
            return true;
        }
        for (Backend b : registeredBackends) {
            if (!b.nativeAnnotation.equals(backend)) continue;
            return true;
        }
        return false;
    }

    public static Backend fromAnnotation(String backend) {
        if (backend == null) {
            return null;
        }
        Backend b = Backend.findAnnotation(backend);
        if (b == null) {
            b = Backend.createBackend("Unregistered", backend);
        }
        return b;
    }

    private static Backend findAnnotation(String backend) {
        if (backend != null) {
            if (backend.isEmpty()) {
                return Header;
            }
            for (Backend b : allBackends) {
                if (!b.nativeAnnotation.equals(backend)) continue;
                return b;
            }
        }
        return null;
    }

    private static Backend createBackend(String name, String backend) {
        Backend b = new Backend(name, backend);
        allBackends.add(b);
        return b;
    }

    public int hashCode() {
        return this.nativeAnnotation.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof Backend) {
            return this.nativeAnnotation.equals(((Backend)that).nativeAnnotation);
        }
        return false;
    }

    public String toString() {
        return this.nativeAnnotation.isEmpty() ? "native" : "native(" + this.nativeAnnotation + ")";
    }

    static {
        registeredBackends = new HashSet<Backend>();
        allBackends = new HashSet<Backend>();
        Header = Backend.createBackend("Header", "");
        Java = Backend.registerBackend("Java", "jvm");
        JavaScript = Backend.registerBackend("JavaScript", "js");
        Backend.registerBackend("Dart", "dart");
    }
}

