/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.BackendSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Backends
implements Iterable<Backend>,
BackendSupport {
    private final Set<Backend> backends;
    private static final Map<String, Backends> collections = new HashMap<String, Backends>();
    public static final Backends ANY = new Backends(Collections.emptySet());
    public static final Backends HEADER = Backends.fromAnnotation(Backend.Header.nativeAnnotation);
    public static final Backends JAVA = Backends.fromAnnotation(Backend.Java.nativeAnnotation);
    public static final Backends JS = Backends.fromAnnotation(Backend.JavaScript.nativeAnnotation);

    Backends(Set<Backend> backends) {
        assert (backends.size() <= 1 || !backends.contains(Backend.Header));
        this.backends = backends;
    }

    @Override
    public Backends getSupportedBackends() {
        return this;
    }

    public boolean none() {
        return this.backends.isEmpty();
    }

    public boolean header() {
        return this == HEADER;
    }

    public boolean supports(Backend backend) {
        return !this.supported(backend.asSet()).none();
    }

    public boolean supports(Backends backends) {
        return !this.supported(backends).none();
    }

    public Backends supported(Backends backends) {
        if (this.backends.containsAll(backends.backends)) {
            return backends;
        }
        HashSet<Backend> result = new HashSet<Backend>(backends.backends);
        result.retainAll(this.backends);
        if (result.isEmpty()) {
            return ANY;
        }
        if (result.size() == 1) {
            Backend backend = result.iterator().next();
            return backend.asSet();
        }
        return new Backends(result);
    }

    public Backends merged(Backend backend) {
        if (this.none()) {
            return backend.asSet();
        }
        if (this.backends.contains(backend)) {
            return this;
        }
        HashSet<Backend> bs = new HashSet<Backend>(this.backends);
        bs.add(backend);
        return new Backends(bs);
    }

    public Backends merged(Backends backends) {
        if (this.none()) {
            return backends;
        }
        if (backends.none() || backends.backends.equals(this.backends)) {
            return this;
        }
        HashSet<Backend> bs = new HashSet<Backend>(this.backends);
        bs.addAll(backends.backends);
        return new Backends(bs);
    }

    @Override
    public Iterator<Backend> iterator() {
        return this.backends.iterator();
    }

    public static Backends fromAnnotations(Collection<String> backends) {
        if (backends == null) {
            return null;
        }
        if (backends.isEmpty()) {
            return ANY;
        }
        if (backends.size() == 1) {
            String backend = backends.iterator().next();
            return Backends.fromAnnotation(backend);
        }
        HashSet<Backend> bs = new HashSet<Backend>(backends.size());
        for (String backend : backends) {
            Backend b = Backend.fromAnnotation(backend);
            bs.add(b);
        }
        return new Backends(bs);
    }

    public static Backends fromAnnotation(String backend) {
        if (backend == null) {
            return ANY;
        }
        Backends bs = collections.get(backend);
        if (bs == null) {
            bs = new Backends(Collections.singleton(Backend.fromAnnotation(backend)));
            collections.put(backend, bs);
        }
        return bs;
    }

    public int hashCode() {
        return this.backends.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof Backends) {
            return this.backends.equals(((Backends)that).backends);
        }
        return false;
    }

    public String names() {
        StringBuilder str = new StringBuilder();
        for (Backend b : this.backends) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(b.nativeAnnotation);
        }
        return str.toString();
    }

    public String toString() {
        if (this.none()) {
            return "<none>";
        }
        if (this.header()) {
            return "native";
        }
        StringBuilder str = new StringBuilder();
        str.append("native(");
        for (Backend b : this.backends) {
            if (str.length() > 7) {
                str.append(", ");
            }
            str.append("\"");
            str.append(b.nativeAnnotation);
            str.append("\"");
        }
        str.append(")");
        return str.toString();
    }
}

