/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import com.redhat.ceylon.common.OSUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class FileUtil {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final File[] EMPTY_FILES = new File[0];

    public static File makeTempDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void delete(File f) {
        FileUtil.delete_(f, false);
    }

    public static void deleteQuietly(File f) {
        if (!FileUtil.delete_(f, true)) {
            f.deleteOnExit();
        }
    }

    private static boolean delete_(File f, boolean silent) {
        boolean ok;
        block6: {
            ok = true;
            if (f.exists()) {
                if (f.isDirectory()) {
                    for (File c : f.listFiles()) {
                        ok = ok && FileUtil.delete_(c, silent);
                    }
                }
                try {
                    boolean deleted = f.delete();
                    boolean bl = ok = ok && deleted;
                    if (!deleted && !silent) {
                        throw new RuntimeException("Failed to delete file or directory: " + f.getPath());
                    }
                }
                catch (Exception ex) {
                    ok = false;
                    if (silent) break block6;
                    throw new RuntimeException("Failed to delete file or directory: " + f.getPath(), ex);
                }
            }
        }
        return ok;
    }

    public static File absoluteFile(File file) {
        if (file != null) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = file.getAbsoluteFile();
            }
        }
        return file;
    }

    public static List<File> applyCwd(File cwd, List<File> files) {
        if (files != null) {
            ArrayList<File> result = new ArrayList<File>(files.size());
            for (File f : files) {
                result.add(FileUtil.applyCwd(cwd, f));
            }
            return result;
        }
        return null;
    }

    public static Iterable<File> applyCwd(File cwd, Iterable<File> files) {
        if (files != null) {
            ArrayList<File> result = new ArrayList<File>();
            for (File f : files) {
                result.add(FileUtil.applyCwd(cwd, f));
            }
            return result;
        }
        return null;
    }

    public static File applyCwd(File cwd, File file) {
        if (cwd != null && !cwd.getPath().equals(".") && file != null && !file.isAbsolute()) {
            File absCwd = FileUtil.absoluteFile(cwd);
            file = new File(absCwd, file.getPath());
        }
        return file;
    }

    public static File relativeFile(File root, File file) {
        if (root != null && file != null) {
            String absRoot = FileUtil.absoluteFile(root).getPath();
            String absFile = FileUtil.absoluteFile(file).getPath();
            if (absFile.startsWith(absRoot)) {
                String path = absFile.substring(absRoot.length());
                if (path.startsWith(File.separator)) {
                    path = path.substring(1);
                }
                file = new File(path);
            }
        }
        return file;
    }

    public static File relativeFile(File f) {
        if (f.isAbsolute()) {
            f = FileUtil.relativeFile(new File("."), f);
        }
        return f;
    }

    public static File getSystemConfigDir() {
        File configDir = null;
        String ceylonConfigDir = System.getProperty("ceylon.config.dir");
        if (ceylonConfigDir != null) {
            configDir = new File(ceylonConfigDir);
        } else if (OSUtil.isWindows()) {
            String appDir = System.getenv("ALLUSERSPROFILE");
            if (appDir != null) {
                configDir = new File(appDir, "ceylon");
            }
        } else {
            configDir = OSUtil.isMac() ? new File("/etc/ceylon") : new File("/etc/ceylon");
        }
        return configDir;
    }

    public static File getInstallDir() {
        String ceylonHome = System.getProperty("ceylon.home");
        if (ceylonHome != null) {
            return new File(ceylonHome);
        }
        return null;
    }

    public static File getDefaultUserDir() {
        String userHome = System.getProperty("user.home");
        return new File(userHome, ".ceylon");
    }

    public static File getUserDir() {
        String ceylonUserDir = System.getProperty("ceylon.user.dir");
        if (ceylonUserDir != null) {
            return new File(ceylonUserDir);
        }
        return FileUtil.getDefaultUserDir();
    }

    public static File[] getExecPath() {
        String path = System.getenv("PATH");
        if (path != null && !path.isEmpty()) {
            String[] items = path.split(Pattern.quote(File.pathSeparator));
            File[] result = new File[items.length];
            for (int i = 0; i < items.length; ++i) {
                result[i] = new File(items[i]);
            }
            return result;
        }
        return EMPTY_FILES;
    }

    public static List<File> pathsToFileList(Collection<String> paths) {
        if (paths != null) {
            ArrayList<File> result = new ArrayList<File>(paths.size());
            for (String s : paths) {
                result.add(new File(s));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static File[] pathsToFileArray(String[] paths) {
        if (paths != null) {
            File[] result = new File[paths.length];
            int idx = 0;
            for (String s : paths) {
                result[idx++] = new File(s);
            }
            return result;
        }
        return EMPTY_FILES;
    }

    public static List<String> filesToPathList(Collection<File> files) {
        if (files != null) {
            ArrayList<String> result = new ArrayList<String>(files.size());
            for (File f : files) {
                result.add(f.getPath());
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static String[] filesToPathArray(File[] files) {
        if (files != null) {
            String[] result = new String[files.length];
            int idx = 0;
            for (File f : files) {
                result[idx++] = f.getPath();
            }
            return result;
        }
        return EMPTY_STRINGS;
    }

    public static String relativeFile(Iterable<? extends File> paths, String file) {
        File path = FileUtil.selectPath(paths, file);
        File relFile = FileUtil.relativeFile(path, new File(file));
        return relFile.getPath();
    }

    public static File selectPath(Iterable<? extends File> paths, String file) {
        file = FileUtil.absoluteFile(new File(file)).getPath();
        int srcDirLength = 0;
        File srcDirFile = null;
        for (File file2 : paths) {
            String absPrefix = FileUtil.absoluteFile(file2).getPath() + File.separatorChar;
            if (!file.startsWith(absPrefix) || absPrefix.length() <= srcDirLength) continue;
            srcDirLength = absPrefix.length();
            srcDirFile = file2;
        }
        return srcDirFile;
    }

    public static File searchPaths(Iterable<? extends File> paths, String relFile) {
        for (File file : paths) {
            File f = new File(file, relFile);
            if (!f.exists()) continue;
            return file;
        }
        return null;
    }

    public static File applyPath(Iterable<? extends File> paths, String relFile) {
        File path = FileUtil.searchPaths(paths, relFile);
        if (path != null) {
            return new File(path, relFile);
        }
        return null;
    }

    public static boolean sameFile(File a, File b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        try {
            return Files.isSameFile(a.toPath(), b.toPath());
        }
        catch (IOException e) {
            return FileUtil.absoluteFile(a).equals(FileUtil.absoluteFile(b));
        }
    }

    public static boolean containsFile(Collection<File> files, File file) {
        for (File f : files) {
            if (!FileUtil.sameFile(f, file)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChildOfOrEquals(File parent, File child) {
        try {
            String parentPath = parent.getCanonicalPath();
            String childPath = child.getCanonicalPath();
            if (parentPath.equals(childPath)) {
                return true;
            }
            if (!parentPath.endsWith(File.separator)) {
                parentPath = parentPath + File.separator;
            }
            return childPath.startsWith(parentPath);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean containsFile(File dir) {
        try {
            final boolean[] found = new boolean[]{false};
            Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        found[0] = true;
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return found[0];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyAll(File root, File dest) throws IOException {
        if (root.isDirectory()) {
            for (File child : root.listFiles()) {
                File childDest = new File(dest, child.getName());
                if (child.isDirectory()) {
                    if (!childDest.exists() && !FileUtil.mkdirs(childDest)) {
                        throw new IOException("Failed to create dir " + childDest.getPath());
                    }
                    FileUtil.copyAll(child, childDest);
                    continue;
                }
                Files.copy(child.toPath(), childDest.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            }
        } else {
            File childDest = new File(dest, root.getName());
            if (!dest.exists() && !FileUtil.mkdirs(dest)) {
                throw new IOException("Failed to create dir " + dest.getPath());
            }
            Files.copy(root.toPath(), childDest.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    public static void copy(File srcDir, File relSrcFile, File destDir, File relDestFile) throws IOException {
        File finalSrcFile = srcDir != null ? new File(srcDir, relSrcFile.getPath()) : relSrcFile;
        File relDestDir = relDestFile.getParentFile();
        if (relDestDir != null) {
            File finalDestDir = destDir != null ? new File(destDir, relDestDir.getPath()) : relDestDir;
            FileUtil.mkdirs(finalDestDir);
        }
        File finalDestFile = new File(destDir, relDestFile.getPath());
        Files.copy(finalSrcFile.toPath(), finalDestFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static boolean mkdirs(File dir) {
        String path = dir.getPath().replace('\\', '/');
        if (path.equals("~") || path.startsWith("~/") || path.contains("/~/")) {
            return false;
        }
        return dir.mkdirs();
    }
}

