/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.NoSuchElementException;

public class Java9ModuleUtil {
    public static Object getModule(Class<?> klass) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method getModule = Class.class.getMethod("getModule", new Class[0]);
        return getModule.invoke(klass, new Object[0]);
    }

    public static Object findModule(Object fromModule, String name) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> moduleClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.reflect.Module");
        Method getLayer = moduleClass.getMethod("getLayer", new Class[0]);
        Object layer = getLayer.invoke(fromModule, new Object[0]);
        return Java9ModuleUtil.findModuleFromLayer(layer, name);
    }

    private static Object findModuleFromLayer(Object layer, String name) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> layerClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.reflect.Layer");
        Method findModule = layerClass.getMethod("findModule", String.class);
        Object optionalModule = findModule.invoke(layer, name);
        Class<?> optionalClass = ClassLoader.getSystemClassLoader().loadClass("java.util.Optional");
        Method get = optionalClass.getMethod("get", new Class[0]);
        try {
            return get.invoke(optionalModule, new Object[0]);
        }
        catch (InvocationTargetException x) {
            if (x.getTargetException() instanceof NoSuchElementException) {
                return null;
            }
            throw x;
        }
    }

    public static ClassLoader getClassLoader(Object module) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> moduleClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.reflect.Module");
        Method getClassLoader = moduleClass.getMethod("getClassLoader", new Class[0]);
        Object classLoader = getClassLoader.invoke(module, new Object[0]);
        return (ClassLoader)classLoader;
    }

    public static boolean isNamedModule(Object module) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> moduleClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.reflect.Module");
        Method isNamed = moduleClass.getMethod("isNamed", new Class[0]);
        Boolean ret = (Boolean)isNamed.invoke(module, new Object[0]);
        return ret;
    }

    public static Object loadModuleDynamically(String module) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        String modulePath = System.getProperty("jdk.module.path");
        String[] modulePathEntries = modulePath.split(File.pathSeparator);
        return Java9ModuleUtil.loadModulesDynamically(modulePathEntries, module);
    }

    public static Object loadModulesDynamically(String[] modulePath, String ... modules) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Path[] paths = new Path[modulePath.length];
        int i = 0;
        for (String moduleFolder : modulePath) {
            paths[i++] = Paths.get(moduleFolder, new String[0]);
        }
        Class<?> moduleFinderClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.module.ModuleFinder");
        Method ofMethod = moduleFinderClass.getMethod("of", Path[].class);
        Object moduleFinder = ofMethod.invoke(null, new Object[]{paths});
        Class<?> configurationClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.module.Configuration");
        Class<?> layerClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.reflect.Layer");
        Method resolveMethod = configurationClass.getMethod("resolve", moduleFinderClass, layerClass, moduleFinderClass, String[].class);
        Method emptyMethod = moduleFinderClass.getMethod("empty", new Class[0]);
        Object emptyModuleFinder = emptyMethod.invoke(null, new Object[0]);
        Method bootMethod = layerClass.getMethod("boot", new Class[0]);
        Object bootLayer = bootMethod.invoke(null, new Object[0]);
        Object configuration = resolveMethod.invoke(null, emptyModuleFinder, bootLayer, moduleFinder, modules);
        Method bindMethod = configurationClass.getMethod("bind", new Class[0]);
        configuration = bindMethod.invoke(configuration, new Object[0]);
        Class<?> moduleClassLoaderClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.ModuleClassLoader");
        Constructor<?> moduleClassLoaderConstructor = moduleClassLoaderClass.getConstructor(configurationClass);
        final Object moduleClassLoader = moduleClassLoaderConstructor.newInstance(configuration);
        Class<?> classLoaderFinderClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.reflect.Layer$ClassLoaderFinder");
        Method createMethod = layerClass.getMethod("create", configurationClass, classLoaderFinderClass);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return moduleClassLoader;
            }
        };
        Object classLoaderFinder = Proxy.newProxyInstance(Java9ModuleUtil.class.getClassLoader(), new Class[]{classLoaderFinderClass}, handler);
        Object newLayer = createMethod.invoke(null, configuration, classLoaderFinder);
        return Java9ModuleUtil.findModuleFromLayer(newLayer, modules[0]);
    }
}

