/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import com.redhat.ceylon.common.FileUtil;
import java.io.File;

public abstract class ModuleUtil {
    private ModuleUtil() {
    }

    public static String moduleName(String moduleNameOptVersion) {
        int p = moduleNameOptVersion.indexOf(47);
        if (p == -1) {
            return moduleNameOptVersion;
        }
        return moduleNameOptVersion.substring(0, p);
    }

    public static String moduleVersion(String moduleNameOptVersion) {
        int p = moduleNameOptVersion.indexOf(47);
        if (p == -1 || p == moduleNameOptVersion.length() - 1) {
            return null;
        }
        return moduleNameOptVersion.substring(p + 1);
    }

    public static boolean isDefaultModule(String moduleName) {
        return "default".equals(moduleName);
    }

    public static String makeModuleName(String moduleName, String version2) {
        if (ModuleUtil.isDefaultModule(moduleName) || version2 == null) {
            return moduleName;
        }
        return moduleName + "/" + version2;
    }

    public static File moduleToPath(String moduleName) {
        return new File(moduleName.replace('.', File.separatorChar));
    }

    public static File moduleToPath(File dir, String moduleName) {
        return new File(dir, moduleName.replace('.', File.separatorChar));
    }

    public static String pathToModule(File modulePath) {
        return modulePath.getPath().replace('/', '.').replace('\\', '.');
    }

    public static boolean isModuleFolder(Iterable<File> paths, File modPath) {
        File modDesc = new File(modPath, "module.ceylon");
        File path = FileUtil.searchPaths(paths, modDesc.getPath());
        return path != null && new File(path, modDesc.getPath()).isFile();
    }

    public static File moduleFolder(Iterable<File> paths, File relFile) {
        while (relFile != null && !ModuleUtil.isModuleFolder(paths, relFile)) {
            relFile = relFile.getParentFile();
        }
        return relFile;
    }

    public static String moduleName(Iterable<File> paths, File relFile) {
        File modPath = ModuleUtil.moduleFolder(paths, relFile);
        if (modPath != null) {
            return ModuleUtil.pathToModule(modPath);
        }
        return "default";
    }

    public static String toCeylonModuleName(String name) {
        int firstColon = name.indexOf(58);
        if (firstColon == -1) {
            return name;
        }
        if (name.indexOf(58, firstColon + 1) != -1 && name.startsWith("maven:")) {
            name = name.substring("maven:".length());
        }
        return name.replace(':', '.');
    }

    public static boolean isMavenModule(String name) {
        return name != null && name.indexOf(58) != -1;
    }
}

