/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.Authentication;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.Repositories;
import java.io.File;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DefaultToolOptions {
    public static final String DEFAULTS_ENCODING = "defaults.encoding";
    public static final String DEFAULTS_OFFLINE = "defaults.offline";
    public static final String DEFAULTS_TIMEOUT = "defaults.timeout";
    public static final String DEFAULTS_MAVENOVERRIDES = "defaults.mavenoverrides";
    public static final String DEFAULTS_OVERRIDES = "defaults.overrides";
    public static final String DEFAULTS_FLAT_CLASSPATH = "defaults.flatclasspath";
    public static final String DEFAULTS_AUTO_EPORT_MAVEN_DEPENDENCIES = "defaults.autoexportmavendependencies";
    public static final String COMPILER_SOURCE = "compiler.source";
    public static final String COMPILER_RESOURCE = "compiler.resource";
    public static final String COMPILER_RESOURCE_ROOT = "compiler.resourceroot";
    public static final String COMPILER_SCRIPT = "compiler.script";
    public static final String COMPILER_DOC = "compiler.doc";
    public static final String COMPILER_SUPPRESSWARNING = "compiler.suppresswarning";
    public static final String COMPILER_NOOSGI = "compiler.noosgi";
    public static final String COMPILER_OSGIPROVIDEDBUNDLES = "compiler.osgiprovidedbundles";
    public static final String COMPILER_NOPOM = "compiler.nopom";
    public static final String COMPILER_GENERATE_MODULE_INFO = "compiler.generatemoduleinfo";
    public static final String COMPILER_PACK200 = "compiler.pack200";
    public static final String RUNTOOL_COMPILE = "runtool.compile";
    public static final String TESTTOOL_COMPILE = "testtool.compile";

    private DefaultToolOptions() {
    }

    public static String getDefaultEncoding() {
        return DefaultToolOptions.getDefaultEncoding(CeylonConfig.get());
    }

    public static String getDefaultEncoding(CeylonConfig config) {
        return config.getOption(DEFAULTS_ENCODING);
    }

    public static boolean getDefaultOffline() {
        return DefaultToolOptions.getDefaultOffline(CeylonConfig.get());
    }

    public static boolean getDefaultOffline(CeylonConfig config) {
        return config.getBoolOption(DEFAULTS_OFFLINE, false);
    }

    public static long getDefaultTimeout() {
        return DefaultToolOptions.getDefaultTimeout(CeylonConfig.get());
    }

    public static long getDefaultTimeout(CeylonConfig config) {
        return DefaultToolOptions.timeoutFromString(config.getOption(DEFAULTS_TIMEOUT), 20000);
    }

    public static int timeoutFromString(String num, int defaultTimeout) {
        if (num != null) {
            int fact = 1000;
            if (num.endsWith("ms")) {
                num = num.substring(0, num.length() - 2);
                fact = 1;
            }
            return Integer.parseInt(num) * fact;
        }
        return defaultTimeout;
    }

    public static Proxy getDefaultProxy() {
        return DefaultToolOptions.getDefaultProxy(CeylonConfig.get());
    }

    public static Proxy getDefaultProxy(CeylonConfig config) {
        Authentication auth = Authentication.fromConfig(config);
        return auth.getProxy();
    }

    public static String getDefaultOverrides() {
        return DefaultToolOptions.getDefaultOverrides(CeylonConfig.get());
    }

    public static String getDefaultOverrides(CeylonConfig config) {
        String ov = config.getOption(DEFAULTS_OVERRIDES);
        if (ov != null) {
            return ov;
        }
        return config.getOption(DEFAULTS_MAVENOVERRIDES);
    }

    public static boolean getDefaultFlatClasspath() {
        return DefaultToolOptions.getDefaultFlatClasspath(CeylonConfig.get());
    }

    public static boolean getDefaultFlatClasspath(CeylonConfig config) {
        return config.getBoolOption(DEFAULTS_FLAT_CLASSPATH, false);
    }

    public static boolean getDefaultAutoExportMavenDependencies() {
        return DefaultToolOptions.getDefaultAutoExportMavenDependencies(CeylonConfig.get());
    }

    public static boolean getDefaultAutoExportMavenDependencies(CeylonConfig config) {
        return config.getBoolOption(DEFAULTS_AUTO_EPORT_MAVEN_DEPENDENCIES, false);
    }

    public static List<File> getCompilerSourceDirs() {
        return DefaultToolOptions.getCompilerSourceDirs(CeylonConfig.get());
    }

    public static List<File> getCompilerSourceDirs(CeylonConfig config) {
        String[] dirs = config.getOptionValues(COMPILER_SOURCE);
        if (dirs != null) {
            return Arrays.asList(FileUtil.pathsToFileArray(dirs));
        }
        return Collections.singletonList(new File("source"));
    }

    public static List<File> getCompilerResourceDirs() {
        return DefaultToolOptions.getCompilerResourceDirs(CeylonConfig.get());
    }

    public static List<File> getCompilerResourceDirs(CeylonConfig config) {
        String[] dirs = config.getOptionValues(COMPILER_RESOURCE);
        if (dirs != null) {
            return Arrays.asList(FileUtil.pathsToFileArray(dirs));
        }
        return Collections.singletonList(new File("resource"));
    }

    public static List<File> getCompilerScriptDirs() {
        return DefaultToolOptions.getCompilerScriptDirs(CeylonConfig.get());
    }

    public static List<File> getCompilerScriptDirs(CeylonConfig config) {
        String[] dirs = config.getOptionValues(COMPILER_SCRIPT);
        if (dirs != null) {
            return Arrays.asList(FileUtil.pathsToFileArray(dirs));
        }
        return Collections.singletonList(new File("script"));
    }

    public static String getCompilerResourceRootName() {
        return DefaultToolOptions.getCompilerResourceRootName(CeylonConfig.get());
    }

    public static String getCompilerResourceRootName(CeylonConfig config) {
        return config.getOption(COMPILER_RESOURCE_ROOT, "ROOT");
    }

    public static List<File> getCompilerDocDirs() {
        return DefaultToolOptions.getCompilerDocDirs(CeylonConfig.get());
    }

    public static List<File> getCompilerDocDirs(CeylonConfig config) {
        String[] dirs = config.getOptionValues(COMPILER_DOC);
        if (dirs != null) {
            return Arrays.asList(FileUtil.pathsToFileArray(dirs));
        }
        return Collections.singletonList(new File("doc"));
    }

    public static String getCompilerOutputRepo() {
        return DefaultToolOptions.getCompilerOutputRepo(CeylonConfig.get());
    }

    public static String getCompilerOutputRepo(CeylonConfig config) {
        return Repositories.withConfig(config).getOutputRepository().getUrl();
    }

    public static List<String> getCompilerSuppressWarnings() {
        return DefaultToolOptions.getCompilerSuppressWarnings(CeylonConfig.get());
    }

    public static List<String> getCompilerSuppressWarnings(CeylonConfig config) {
        String[] warnings = config.getOptionValues(COMPILER_SUPPRESSWARNING);
        if (warnings != null) {
            return Arrays.asList(warnings);
        }
        return null;
    }

    public static boolean getCompilerNoOsgi() {
        return DefaultToolOptions.getCompilerNoOsgi(CeylonConfig.get());
    }

    public static boolean getCompilerNoOsgi(CeylonConfig config) {
        return config.getBoolOption(COMPILER_NOOSGI, false);
    }

    public static String getCompilerOsgiProvidedBundles() {
        return DefaultToolOptions.getCompilerOsgiProvidedBundles(CeylonConfig.get());
    }

    public static String getCompilerOsgiProvidedBundles(CeylonConfig config) {
        return config.getOption(COMPILER_OSGIPROVIDEDBUNDLES, "");
    }

    public static boolean getCompilerNoPom() {
        return DefaultToolOptions.getCompilerNoPom(CeylonConfig.get());
    }

    public static boolean getCompilerNoPom(CeylonConfig config) {
        return config.getBoolOption(COMPILER_NOPOM, false);
    }

    public static boolean getCompilerGenerateModuleInfo() {
        return DefaultToolOptions.getCompilerGenerateModuleInfo(CeylonConfig.get());
    }

    public static boolean getCompilerGenerateModuleInfo(CeylonConfig config) {
        return config.getBoolOption(COMPILER_GENERATE_MODULE_INFO, false);
    }

    public static boolean getCompilerPack200() {
        return DefaultToolOptions.getCompilerPack200(CeylonConfig.get());
    }

    public static boolean getCompilerPack200(CeylonConfig config) {
        return config.getBoolOption(COMPILER_PACK200, false);
    }

    public static String getRunToolCompileFlags() {
        return DefaultToolOptions.getRunToolCompileFlags(CeylonConfig.get());
    }

    public static String getRunToolCompileFlags(CeylonConfig config) {
        return config.getOption(RUNTOOL_COMPILE, "never");
    }

    public static String getTestToolCompileFlags() {
        return DefaultToolOptions.getTestToolCompileFlags(CeylonConfig.get());
    }

    public static String getTestToolCompileFlags(CeylonConfig config) {
        return config.getOption(TESTTOOL_COMPILE, "never");
    }
}

