/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.config.ConfigReaderListener;
import com.redhat.ceylon.common.config.ImprovedConfigReaderListener;
import java.io.IOException;
import java.util.ArrayList;

class ImprovedConfigReaderListenerAdapter
implements ConfigReaderListener {
    private ImprovedConfigReaderListener listener;
    private String currentSection;
    private boolean skipToNewline;
    private ArrayList<Text> buffer;

    public ImprovedConfigReaderListenerAdapter(ImprovedConfigReaderListener listener) {
        this.listener = listener;
        this.currentSection = null;
        this.skipToNewline = false;
        this.buffer = new ArrayList();
    }

    @Override
    public void setup() throws IOException {
    }

    @Override
    public void onSection(String section, String text) throws IOException {
        if (this.currentSection != null) {
            this.listener.onSectionEnd(this.currentSection);
        }
        this.flushBuffer();
        this.currentSection = section;
        this.listener.onSection(section, text);
        this.skipToNewline = true;
    }

    @Override
    public void onOption(String name, String value, String text) throws IOException {
        this.flushBuffer();
        this.listener.onOption(name, value, text);
        this.skipToNewline = true;
    }

    @Override
    public void onComment(String text) throws IOException {
        if (this.skipToNewline) {
            this.listener.onComment(text);
            this.skipToNewline = !text.contains("\n");
        } else {
            this.buffer.add(new Comment(text));
        }
    }

    @Override
    public void onWhitespace(String text) throws IOException {
        if (this.skipToNewline) {
            this.listener.onWhitespace(text);
            this.skipToNewline = !text.contains("\n");
        } else {
            this.buffer.add(new Whitespace(text));
        }
    }

    @Override
    public void cleanup() throws IOException {
        if (this.currentSection != null) {
            this.listener.onSectionEnd(this.currentSection);
        }
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        for (Text t : this.buffer) {
            if (t instanceof Comment) {
                this.listener.onComment(t.getText());
                continue;
            }
            if (!(t instanceof Whitespace)) continue;
            this.listener.onWhitespace(t.getText());
        }
        this.buffer.clear();
    }

    class Whitespace
    implements Text {
        private String text;

        public Whitespace(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    class Comment
    implements Text {
        private String text;

        public Comment(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    static interface Text {
        public String getText();
    }
}

