/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class Keystores {
    private static final String SECTION_KEYSTORE = "keystore";
    private static final String ITEM_FILE = "file";
    private static final String DEFAULT_FILE = "keystore";
    private static final String ITEM_PROTECTION = "protection";
    private static final String DEFAULT_PROTECTION = "both";
    private static final String ITEM_STORE_TYPE = "store-type";
    private static final String DEFAULT_STORE_TYPE = "jceks";
    private static final String ITEM_STORE_PROVIDER = "store-provider";
    private static final String DEFAULT_STORE_PROVIDER = "SunJCE";
    private static final String ITEM_KEY_FACTORY_ALGO = "key-factory-algo";
    private static final String DEFAULT_KEY_FACTORY_ALGO = "PBEWithMD5AndDES";
    private static final String ITEM_KEY_FACTORY_PROVIDER = "key-factory-provider";
    private static final String DEFAULT_KEY_FACTORY_PROVIDER = "SunJCE";
    private static final Object MUTEX = KeyStore.class;
    private final CeylonConfig config;
    private static Keystores instance;

    private String keystoreKey(String keystoreName, String itemName) {
        return "keystore" + (keystoreName != null ? "." + keystoreName : "") + "." + itemName;
    }

    private Keystores() {
        this(CeylonConfig.get());
    }

    private Keystores(CeylonConfig config) {
        this.config = config;
    }

    public static Keystores get() {
        if (instance == null) {
            instance = new Keystores();
        }
        return instance;
    }

    public static void set(Keystores keystores) {
        instance = keystores;
    }

    public static Keystores withConfig(CeylonConfig config) {
        return new Keystores(config);
    }

    public Store getStore(String keystore) {
        String file = this.config.getOption(this.keystoreKey(keystore, ITEM_FILE), "keystore");
        String keyStoreType = this.config.getOption(this.keystoreKey(keystore, ITEM_STORE_TYPE), DEFAULT_STORE_TYPE);
        String keyStoreProvider = this.config.getOption(this.keystoreKey(keystore, ITEM_STORE_PROVIDER), "SunJCE");
        String keyFactoryAlgorithm = this.config.getOption(this.keystoreKey(keystore, ITEM_KEY_FACTORY_ALGO), DEFAULT_KEY_FACTORY_ALGO);
        String keyFactoryProvider = this.config.getOption(this.keystoreKey(keystore, ITEM_KEY_FACTORY_PROVIDER), "SunJCE");
        String protection = this.config.getOption(this.keystoreKey(keystore, ITEM_PROTECTION), DEFAULT_PROTECTION);
        return new Store(file, keyStoreType, keyStoreProvider, keyFactoryAlgorithm, keyFactoryProvider, protection);
    }

    public class Store {
        private String filename;
        private String keyStoreType;
        private String keyStoreProvider;
        private String keyFactoryAlgorithm;
        private String keyFactoryProvider;
        private String protection;

        public Store(String storeFile, String keyStoreType, String keyStoreProvider, String keyFactoryAlgorithm, String keyFactoryProvider, String protection) {
            this.filename = storeFile;
            this.keyStoreType = keyStoreType;
            this.keyStoreProvider = keyStoreProvider;
            this.keyFactoryAlgorithm = keyFactoryAlgorithm;
            this.keyFactoryProvider = keyFactoryProvider;
            this.protection = protection;
        }

        public String getFilename() {
            return this.filename;
        }

        private File getStoreFile() {
            return this.getFilename() != null ? new File(FileUtil.getUserDir(), this.getFilename()) : null;
        }

        public boolean fileExists() {
            File file = this.getStoreFile();
            return file == null || file.exists();
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public String getKeyStoreProvider() {
            return this.keyStoreProvider;
        }

        public String getKeyFactoryAlgorithm() {
            return this.keyFactoryAlgorithm;
        }

        public String getKeyFactoryProvider() {
            return this.keyFactoryProvider;
        }

        public String getProtection() {
            return this.protection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyStore loadKeyStore(char[] storePassword) throws GeneralSecurityException, IOException {
            KeyStore ks = KeyStore.getInstance(this.getKeyStoreType(), this.getKeyStoreProvider());
            try (FileInputStream stream = this.fileExists() ? new FileInputStream(this.getStoreFile()) : null;){
                ks.load(stream, storePassword);
            }
            return ks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveKeystore(KeyStore ks, char[] storePassword) throws FileNotFoundException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
            File file = this.getStoreFile();
            if (file != null) {
                try (FileOutputStream out = new FileOutputStream(file);){
                    ks.store(out, storePassword);
                }
            }
        }

        private String canonicalizeAlias(String keystoreAlias) {
            return keystoreAlias.toLowerCase();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char[] getPassword(String keystoreAlias, char[] storePassword, char[] entryPassword) throws GeneralSecurityException, IOException {
            keystoreAlias = this.canonicalizeAlias(keystoreAlias);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(this.getKeyFactoryAlgorithm(), this.getKeyFactoryProvider());
            PBEKeySpec keySpec = null;
            Object object = MUTEX;
            synchronized (object) {
                KeyStore ks = this.loadKeyStore(storePassword);
                KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)ks.getEntry(keystoreAlias, new KeyStore.PasswordProtection(entryPassword));
                if (entry != null) {
                    keySpec = (PBEKeySpec)keyFac.getKeySpec(entry.getSecretKey(), PBEKeySpec.class);
                }
            }
            return keySpec != null ? keySpec.getPassword() : null;
        }

        public char[] getPassword(String keystoreAlias, char[] accessPassword) throws GeneralSecurityException, IOException {
            return this.getPassword(keystoreAlias, accessPassword, accessPassword);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPassword(String keystoreAlias, char[] storePassword, char[] entryPassword, char[] password) throws Exception {
            keystoreAlias = this.canonicalizeAlias(keystoreAlias);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(this.keyFactoryAlgorithm, this.keyFactoryProvider);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            KeyStore.SecretKeyEntry credentials = new KeyStore.SecretKeyEntry(pbeKey);
            Object object = MUTEX;
            synchronized (object) {
                KeyStore ks = this.loadKeyStore(storePassword);
                ks.setEntry(keystoreAlias, credentials, entryPassword != null ? new KeyStore.PasswordProtection(entryPassword) : null);
                this.saveKeystore(ks, storePassword);
            }
        }

        public void setPassword(String keystoreAlias, char[] accessPassword, char[] password) throws Exception {
            this.setPassword(keystoreAlias, accessPassword, accessPassword, password);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deletePassword(String keystoreAlias, char[] storePassword) throws Exception {
            keystoreAlias = this.canonicalizeAlias(keystoreAlias);
            Object object = MUTEX;
            synchronized (object) {
                KeyStore ks = this.loadKeyStore(storePassword);
                if (ks.containsAlias(keystoreAlias)) {
                    ks.deleteEntry(keystoreAlias);
                }
                this.saveKeystore(ks, storePassword);
            }
        }
    }
}

