/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.tool.ArgumentModel;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.SubtoolModel;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolModel;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

public class AnnotatedToolModel<T extends Tool>
extends ToolModel<T> {
    private Class<T> toolClass;
    private boolean loaded;

    public AnnotatedToolModel(String name) {
        super(name);
    }

    public Class<T> getToolClass() {
        return this.toolClass;
    }

    public void setToolClass(Class<T> toolClass) {
        this.toolClass = toolClass;
    }

    private void setup() {
        if (!this.loaded) {
            this.loaded = true;
            this.getToolLoader().setupModel(this);
        }
    }

    @Override
    public Collection<OptionModel<?>> getOptions() {
        this.setup();
        return super.getOptions();
    }

    @Override
    public OptionModel<?> getOption(String longName) {
        this.setup();
        return super.getOption(longName);
    }

    @Override
    public OptionModel<?> getOptionByShort(char shortName) {
        this.setup();
        return super.getOptionByShort(shortName);
    }

    @Override
    public List<ArgumentModel<?>> getArguments() {
        this.setup();
        return super.getArguments();
    }

    @Override
    public SubtoolModel<?> getSubtoolModel() {
        this.setup();
        return super.getSubtoolModel();
    }

    @Override
    public List<ArgumentModel<?>> getArgumentsAndSubtool() {
        this.setup();
        return super.getArgumentsAndSubtool();
    }

    @Override
    public Method getRest() {
        this.setup();
        return super.getRest();
    }

    public boolean isHidden() {
        return this.toolClass != null && this.toolClass.getAnnotation(Hidden.class) != null;
    }

    @Override
    public boolean isPorcelain() {
        return super.isPorcelain() && !this.isHidden();
    }

    @Override
    public boolean isPlumbing() {
        return super.isPlumbing() && (this.toolClass == null || this.isHidden());
    }
}

