/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tools.CeylonTool;
import java.io.File;
import java.util.List;

public abstract class CeylonBaseTool
implements Tool {
    protected File cwd;
    public String verbose;

    public File getCwd() {
        return this.cwd;
    }

    @OptionArgument(longName="cwd", argumentName="dir")
    @Description(value="Specifies the current working directory for this tool. (default: the directory where the tool is run from)")
    public void setCwd(File cwd) {
        this.cwd = cwd;
    }

    public String getVerbose() {
        return this.verbose;
    }

    @Option(shortName=100)
    @OptionArgument(argumentName="flags")
    @Description(value="Produce verbose output. If no `flags` are given then be verbose about everything, otherwise just be verbose about the flags which are present. Allowed flags include: `all`, `loader`.")
    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    protected File validCwd() {
        return this.cwd != null ? this.cwd : new File(".");
    }

    protected List<File> applyCwd(List<File> files) {
        return FileUtil.applyCwd(this.getCwd(), files);
    }

    protected File applyCwd(File file) {
        return FileUtil.applyCwd(this.getCwd(), file);
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
    }
}

