/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.tool.AnnotatedToolModel;
import com.redhat.ceylon.common.tool.ModelException;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class PluginToolModel<T extends Tool>
extends AnnotatedToolModel<T> {
    private final String pluginPath;
    private final Properties pluginProperties;
    private final String pluginSummary;
    private final ModuleSpec pluginModule;
    private final String pluginClassName;
    private final boolean pluginHidden;

    public PluginToolModel(String name, String pluginPath) {
        super(name);
        this.pluginPath = pluginPath;
        this.pluginProperties = new Properties();
        try (FileInputStream is = new FileInputStream(pluginPath);){
            this.pluginProperties.load(is);
        }
        catch (IOException e) {
            throw new ModelException("Could not load tool plugin file for '" + name + "'", e);
        }
        this.pluginSummary = this.pluginProperties.getProperty("summary", "");
        String module = this.pluginProperties.getProperty("module");
        if (module == null || module.isEmpty()) {
            throw new ModelException("Missing 'module' property in tool plugin file for '" + name + "'");
        }
        this.pluginModule = ModuleSpec.parse(module, ModuleSpec.Option.VERSION_REQUIRED);
        this.pluginClassName = this.pluginProperties.getProperty("class", PluginToolModel.getDefaultToolClassName(this.pluginModule.getName(), name));
        this.pluginHidden = "true".equals(this.pluginProperties.getProperty("hidden", ""));
    }

    private static String getDefaultToolClassName(String module, String name) {
        String[] parts = name.split("-");
        StringBuilder newName = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            newName.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            newName.append(part.substring(1).toLowerCase());
        }
        String className = "Ceylon" + newName.toString() + "Tool";
        if (!"default".equals(module)) {
            className = module + "." + className;
        }
        return className;
    }

    public String getToolPath() {
        return this.pluginPath;
    }

    @Override
    public boolean isHidden() {
        return this.pluginHidden || super.isHidden();
    }

    @Override
    public boolean isPlumbing() {
        return false;
    }

    public String getToolSummary() {
        return this.pluginSummary;
    }

    public ModuleSpec getToolModule() {
        return this.pluginModule;
    }

    public String getToolClassName() {
        return this.pluginClassName;
    }

    @Override
    public Class<T> getToolClass() {
        Class<Object> tc = super.getToolClass();
        if (tc == null) {
            ClassLoader mcl = this.getToolLoader().loadModule(this.pluginModule.getName(), this.pluginModule.getVersion());
            try {
                tc = mcl.loadClass(this.pluginClassName);
            }
            catch (ClassNotFoundException e) {
                throw new ModelException("Could not load plugin class '" + this.pluginClassName + "'", e);
            }
            this.getToolLoader().checkClass(tc);
            this.setToolClass(tc);
        }
        return tc;
    }
}

