/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.tool.ArgumentParser;
import com.redhat.ceylon.common.tool.EnumUtil;
import com.redhat.ceylon.common.tool.EnumerableParser;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolLoader;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tool.ToolModelArgumentParser;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;

public class StandardArgumentParsers {
    public static final ArgumentParser<String> CHAR_SEQUENCE_PARSER = new ArgumentParser<String>(){

        @Override
        public String parse(String argument, Tool tool) {
            return argument != null ? argument : null;
        }
    };
    public static final ArgumentParser<Boolean> BOOLEAN_PARSER = new ArgumentParser<Boolean>(){

        @Override
        public Boolean parse(String argument, Tool tool) {
            return argument.matches("1|yes|true");
        }
    };
    public static final ArgumentParser<Integer> INTEGER_PARSER = new ArgumentParser<Integer>(){

        @Override
        public Integer parse(String argument, Tool tool) {
            return Integer.valueOf(argument);
        }
    };
    public static final ArgumentParser<URI> URI_PARSER = new ArgumentParser<URI>(){

        @Override
        public URI parse(String argument, Tool tool) {
            try {
                return new URI(argument);
            }
            catch (URISyntaxException e) {
                try {
                    return new URI(argument.replace('\\', '/'));
                }
                catch (URISyntaxException e2) {
                    File f = new File(argument);
                    return f.toURI();
                }
            }
        }
    };
    public static final PathArgumentParser PATH_PARSER = new PathArgumentParser();

    public static ArgumentParser<?> forClass(Class<?> setterType, ToolLoader toolLoader, boolean isSimpleType) {
        if (CharSequence.class.isAssignableFrom(setterType)) {
            return CHAR_SEQUENCE_PARSER;
        }
        if (Integer.class.isAssignableFrom(setterType) || Integer.TYPE.isAssignableFrom(setterType)) {
            return INTEGER_PARSER;
        }
        if (Boolean.class.isAssignableFrom(setterType) || Boolean.TYPE.isAssignableFrom(setterType)) {
            return BOOLEAN_PARSER;
        }
        if (File.class.isAssignableFrom(setterType)) {
            return new ConstructorArgumentParser<File>(File.class);
        }
        if (URI.class.isAssignableFrom(setterType)) {
            return URI_PARSER;
        }
        if (URL.class.isAssignableFrom(setterType)) {
            return new ConstructorArgumentParser<URL>(URL.class);
        }
        if (Enum.class.isAssignableFrom(setterType)) {
            if (isSimpleType) {
                return new EnumArgumentParser(setterType, true);
            }
            return new EnumArgumentsParser(setterType, true);
        }
        if (ToolModel.class.isAssignableFrom(setterType)) {
            return new ToolModelArgumentParser(toolLoader);
        }
        return null;
    }

    public static class EnumArgumentsParser<E extends Enum<E>>
    extends EnumParserBase<List<E>, E> {
        public EnumArgumentsParser(Class<E> enumClass, boolean denormalize) {
            super(enumClass, denormalize);
        }

        @Override
        public List<E> parse(String argument, Tool tool) {
            if (!argument.isEmpty()) {
                String[] elems = argument.split(",");
                ArrayList result = new ArrayList(elems.length);
                for (String elem : elems) {
                    elem = elem.trim();
                    if (this.denormalize) {
                        elem = this.denormalize(elem);
                    }
                    result.add(this.valueOf(elem));
                }
                return result;
            }
            return new ArrayList(EnumSet.allOf(this.enumClass));
        }
    }

    public static class EnumArgumentParser<E extends Enum<E>>
    extends EnumParserBase<E, E> {
        public EnumArgumentParser(Class<E> enumClass, boolean denormalize) {
            super(enumClass, denormalize);
        }

        @Override
        public E parse(String argument, Tool tool) {
            if (this.denormalize) {
                argument = this.denormalize(argument);
            }
            return this.valueOf(argument);
        }
    }

    public static abstract class EnumParserBase<A, E extends Enum<E>>
    implements EnumerableParser<A> {
        protected final boolean denormalize;
        protected final Class<E> enumClass;

        public EnumParserBase(Class<E> enumClass, boolean denormalize) {
            this.enumClass = enumClass;
            this.denormalize = denormalize;
        }

        protected String denormalize(String argument) {
            argument = argument.replace('-', '_');
            for (String nm : this.possibilities()) {
                if (!nm.equalsIgnoreCase(argument)) continue;
                argument = nm;
            }
            return argument;
        }

        protected E valueOf(String name) {
            return EnumUtil.valueOf(this.enumClass, name);
        }

        @Override
        public Iterable<String> possibilities() {
            return EnumUtil.possibilities(this.enumClass);
        }
    }

    public static class ConstructorArgumentParser<T>
    implements ArgumentParser<T> {
        private Constructor<T> ctor;

        public ConstructorArgumentParser(Class<T> clazz) {
            try {
                this.ctor = clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public T parse(String argument, Tool tool) {
            try {
                return this.ctor.newInstance(argument);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class PathArgumentParser
    implements ArgumentParser<List<File>> {
        @Override
        public List<File> parse(String argument, Tool tool) {
            String[] dirs = argument.split(Pattern.quote(File.pathSeparator));
            ArrayList<File> result = new ArrayList<File>(dirs.length);
            for (String dir : dirs) {
                result.add(new File(dir));
            }
            return result;
        }
    }
}

