/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.tool.AnnotatedToolModel;
import com.redhat.ceylon.common.tool.ArgumentModel;
import com.redhat.ceylon.common.tool.ArgumentParser;
import com.redhat.ceylon.common.tool.Multiplicity;
import com.redhat.ceylon.common.tool.OptionArgumentException;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolArgumentParser;
import com.redhat.ceylon.common.tool.ToolError;
import com.redhat.ceylon.common.tool.ToolException;
import com.redhat.ceylon.common.tool.ToolLoader;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tools.CeylonTool;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ToolFactory {
    private static final String SHORT_PREFIX = "-";
    private static final char LONG_SEP = '=';
    private static final String LONG_PREFIX = "--";

    public <T extends Tool> T newInstance(ToolModel<T> toolModel) {
        T result = toolModel.getToolLoader().instance(toolModel, null);
        if (result == null) {
            throw new ToolException("Couldn't create new instance for tool '" + toolModel.getName() + "'");
        }
        return result;
    }

    private <T extends Tool> void setToolLoaderAndModel(ToolModel<T> toolModel, T tool) {
        if (toolModel instanceof AnnotatedToolModel) {
            AnnotatedToolModel amodel = (AnnotatedToolModel)toolModel;
            try {
                amodel.getToolClass().getMethod("setToolLoader", ToolLoader.class).invoke(tool, toolModel.getToolLoader());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ReflectiveOperationException e) {
                throw new ToolException("Could not instantitate tool " + amodel.getToolClass(), e);
            }
            try {
                amodel.getToolClass().getMethod("setToolModel", ToolModel.class).invoke(tool, toolModel);
            }
            catch (NoSuchMethodException e) {
            }
            catch (ReflectiveOperationException e) {
                throw new ToolException("Could not instantitate tool " + amodel.getToolClass(), e);
            }
        }
    }

    public <T extends Tool> T bindArguments(ToolModel<T> toolModel, CeylonTool mainTool, Iterable<String> args) {
        T tool = this.newInstance(toolModel);
        return this.bindArguments(toolModel, tool, mainTool, args);
    }

    public <T extends Tool> T bindArguments(ToolModel<T> toolModel, T tool, CeylonTool mainTool, Iterable<String> args) {
        this.setToolLoaderAndModel(toolModel, tool);
        ArgumentProcessor invocation = new ArgumentProcessor(this, toolModel, tool, mainTool, args.iterator());
        invocation.processArguments();
        return tool;
    }

    public boolean isEoo(String arg) {
        return arg.equals(LONG_PREFIX);
    }

    public boolean isLongForm(String arg) {
        return arg.startsWith(LONG_PREFIX);
    }

    public String getLongFormOption(String arg) {
        int eq = arg.indexOf(61);
        String longName = eq == -1 ? arg.substring(LONG_PREFIX.length()) : arg.substring(LONG_PREFIX.length(), eq);
        return longName;
    }

    public String getLongFormArgument(String arg, Iterator<String> iter) {
        int eq = arg.indexOf(61);
        if (eq == -1) {
            return null;
        }
        String argument = arg.substring(eq + 1);
        return argument;
    }

    public boolean isShortForm(String arg) {
        return arg.startsWith(SHORT_PREFIX) && !arg.equals(SHORT_PREFIX);
    }

    public boolean isArgument(String arg) {
        return true;
    }

    private void checkMultiplicity(ArgumentModel<?> argument, List<Binding<?>> values) {
        int size;
        OptionModel<?> option = argument.getOption();
        Multiplicity multiplicity = argument.getMultiplicity();
        int n = size = values != null ? values.size() : 0;
        if (size < multiplicity.getMin()) {
            if (option != null) {
                throw new OptionArgumentException.OptionMultiplicityException(argument.getOption(), this.getGivenOptions(values), multiplicity.getMin(), "option.too.few");
            }
            throw new OptionArgumentException.ArgumentMultiplicityException(argument, multiplicity.getMin(), "argument.too.few");
        }
        if (size > multiplicity.getMax()) {
            if (option != null) {
                throw new OptionArgumentException.OptionMultiplicityException(argument.getOption(), this.getGivenOptions(values), multiplicity.getMax(), "option.too.many");
            }
            throw new OptionArgumentException.ArgumentMultiplicityException(argument, multiplicity.getMax(), "argument.too.many");
        }
    }

    private String getGivenOptions(List<Binding<?>> values) {
        TreeSet<String> given = new TreeSet<String>();
        for (Binding<?> binding : values) {
            if (binding.optionModel.getLongName().equals(binding.givenOption)) {
                given.add(LONG_PREFIX + binding.givenOption);
            }
            if (binding.optionModel.getShortName() == null || !binding.givenOption.equals(binding.optionModel.getShortName().toString())) continue;
            given.add(SHORT_PREFIX + binding.givenOption);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : given) {
            sb.append('\'').append(s).append("'/");
        }
        return sb.substring(0, sb.length() - 1);
    }

    static class ArgumentProcessor<T extends Tool> {
        final List<OptionArgumentException.UnknownOptionException> unrecognised = new ArrayList<OptionArgumentException.UnknownOptionException>(1);
        final List<String> rest = new ArrayList<String>(1);
        final Map<ArgumentModel<?>, List<Binding<?>>> bindings = new HashMap(1);
        final Iterator<String> iter;
        final ToolModel<T> toolModel;
        final T tool;
        private CeylonTool mainTool;
        final /* synthetic */ ToolFactory this$0;

        ArgumentProcessor(ToolModel<T> toolModel, T tool, CeylonTool mainTool, Iterator<String> iter) {
            this.this$0 = var1_1;
            this.toolModel = toolModel;
            this.tool = tool;
            this.iter = iter;
            this.mainTool = mainTool;
        }

        void processArguments() {
            boolean eoo = false;
            int argumentModelIndex = 0;
            int argumentsBoundThisIndex = 0;
            block11: while (this.iter.hasNext()) {
                String argument;
                OptionModel<?> option;
                String arg = this.iter.next();
                if (!eoo && this.this$0.isEoo(arg)) {
                    eoo = true;
                    continue;
                }
                if (!eoo && this.this$0.isLongForm(arg)) {
                    String longName = this.this$0.getLongFormOption(arg);
                    option = this.toolModel.getOption(longName);
                    if (option == null) {
                        this.rest.add(arg);
                        continue;
                    }
                    switch (option.getArgumentType()) {
                        case NOT_ALLOWED: {
                            argument = "true";
                            break;
                        }
                        case OPTIONAL: 
                        case REQUIRED: {
                            argument = this.this$0.getLongFormArgument(arg, this.iter);
                            if (argument != null) break;
                            if (option.getArgumentType() == OptionModel.ArgumentType.REQUIRED) {
                                if (this.iter.hasNext()) {
                                    argument = this.iter.next();
                                    break;
                                }
                                throw new OptionArgumentException.OptionWithoutArgumentException(option, arg);
                            }
                            argument = "";
                            break;
                        }
                        default: {
                            throw new RuntimeException("Assertion failed");
                        }
                    }
                    this.processArgument(new Binding(longName, option, argument));
                    continue;
                }
                if (!eoo && this.this$0.isShortForm(arg)) {
                    for (int idx = 1; idx < arg.length(); ++idx) {
                        char shortName = arg.charAt(idx);
                        option = this.toolModel.getOptionByShort(shortName);
                        if (option == null) {
                            this.unrecognised.add(OptionArgumentException.UnknownOptionException.shortOption(this.toolModel, shortName, arg));
                            continue block11;
                        }
                        switch (option.getArgumentType()) {
                            case NOT_ALLOWED: {
                                argument = "true";
                                break;
                            }
                            case REQUIRED: {
                                if (idx == arg.length() - 1) {
                                    if (!this.iter.hasNext()) {
                                        throw new OptionArgumentException.OptionWithoutArgumentException(option, arg);
                                    }
                                    argument = this.iter.next();
                                    break;
                                }
                                argument = arg.substring(idx + 1);
                                idx = arg.length() - 1;
                                break;
                            }
                            case OPTIONAL: {
                                argument = "";
                                break;
                            }
                            default: {
                                throw new RuntimeException("Assertion failed");
                            }
                        }
                        this.processArgument(new Binding(String.valueOf(shortName), option, argument));
                    }
                    continue;
                }
                if (this.toolModel.getRest() != null) {
                    eoo = true;
                }
                option = null;
                argument = arg;
                if (this.this$0.isArgument(arg)) {
                    List<ArgumentModel<?>> argumentModels = this.toolModel.getArgumentsAndSubtool();
                    if (argumentModelIndex >= argumentModels.size()) {
                        if (this.toolModel.getRest() != null) {
                            this.rest.add(arg);
                            continue;
                        }
                        throw new OptionArgumentException.UnexpectedArgumentException(arg, this.toolModel);
                    }
                    ArgumentModel<?> argumentModel = argumentModels.get(argumentModelIndex);
                    this.processArgument(new Binding(argumentModel, argument));
                    if (++argumentsBoundThisIndex < argumentModel.getMultiplicity().getMax()) continue;
                    ++argumentModelIndex;
                    argumentsBoundThisIndex = 0;
                    continue;
                }
                this.rest.add(arg);
            }
            try {
                this.checkMultiplicities();
                this.applyBindings();
                this.handleRest();
                this.assertAllRecognised();
                this.invokeInitialize();
            }
            catch (IllegalAccessException e) {
                throw new ToolException(e);
            }
        }

        private <A> void processArgument(Binding<A> binding) {
            List<Binding<?>> values = this.bindings.get(binding.argumentModel);
            if (values == null) {
                values = new ArrayList(1);
                this.bindings.put(binding.argumentModel, values);
            }
            if (binding.argumentModel.getMultiplicity().isMultivalued()) {
                binding.value = this.parseArgument(binding);
            } else {
                this.parseAndSetValue(binding);
            }
            values.add(binding);
        }

        private <A> void parseAndSetValue(Binding<A> binding) {
            binding.value = this.parseArgument(binding);
            this.setValue(binding);
        }

        private <A> A parseArgument(Binding<A> binding) {
            ArgumentParser parser = binding.argumentModel.getParser();
            try {
                Object value = parser.parse(binding.unparsedArgumentValue, (Tool)this.tool);
                if (value instanceof Tool) {
                    ToolLoader loader = ((ToolArgumentParser)parser).getToolLoader();
                    ToolModel model = loader.loadToolModel(binding.unparsedArgumentValue);
                    model.setParentTool(this.toolModel);
                    return (A)this.this$0.bindArguments(model, (Tool)value, this.mainTool, new Iterable<String>(){

                        @Override
                        public Iterator<String> iterator() {
                            return ArgumentProcessor.this.iter;
                        }
                    });
                }
                return value;
            }
            catch (OptionArgumentException e) {
                throw e;
            }
            catch (ToolException e) {
                throw e;
            }
            catch (Exception e) {
                throw binding.invalid(e, parser);
            }
        }

        private <A> void setValue(Binding<A> binding) {
            try {
                Object value = binding.argumentModel.getSetter().getParameterTypes()[0].equals(EnumSet.class) ? EnumSet.copyOf((List)binding.value) : binding.value;
                binding.argumentModel.getSetter().invoke(this.tool, value);
            }
            catch (IllegalAccessException e) {
                throw new ToolException(e);
            }
            catch (InvocationTargetException e) {
                throw binding.invalid(e.getCause(), null);
            }
        }

        private void applyBindings() {
            for (Map.Entry<ArgumentModel<?>, List<Binding<?>>> entry : this.bindings.entrySet()) {
                ArgumentModel<?> argument = entry.getKey();
                List values = entry.getValue();
                if (!argument.getMultiplicity().isMultivalued()) continue;
                Binding mv = Binding.mv(values);
                this.setValue(mv);
            }
        }

        private void handleRest() throws IllegalAccessException {
            if (this.toolModel.getRest() != null) {
                try {
                    this.toolModel.getRest().invoke(this.tool, this.rest);
                }
                catch (InvocationTargetException e) {
                    throw new OptionArgumentException.ToolInitializationException(this.toolModel, e.getCause());
                }
            } else {
                for (String arg : this.rest) {
                    this.unrecognised.add(OptionArgumentException.UnknownOptionException.longOption(this.toolModel, arg));
                }
            }
        }

        private void invokeInitialize() {
            try {
                this.tool.initialize(this.mainTool);
            }
            catch (ToolError to) {
                throw to;
            }
            catch (Exception e) {
                throw new OptionArgumentException.ToolInitializationException(this.toolModel, (Throwable)e);
            }
        }

        private void checkMultiplicities() {
            ArgumentModel<Object> argument;
            for (Map.Entry<ArgumentModel<?>, List<Binding<?>>> entry : this.bindings.entrySet()) {
                argument = entry.getKey();
                List<Binding<?>> values = entry.getValue();
                this.this$0.checkMultiplicity(argument, values);
            }
            for (OptionModel optionModel : this.toolModel.getOptions()) {
                argument = optionModel.getArgument();
                this.this$0.checkMultiplicity(argument, this.bindings.get(argument));
            }
            for (ArgumentModel argumentModel : this.toolModel.getArgumentsAndSubtool()) {
                argumentModel.getMultiplicity().getMin();
                this.this$0.checkMultiplicity(argumentModel, this.bindings.get(argumentModel));
            }
        }

        private void assertAllRecognised() {
            switch (this.unrecognised.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    throw this.unrecognised.get(0);
                }
                default: {
                    throw OptionArgumentException.UnknownOptionException.aggregate(this.unrecognised);
                }
            }
        }
    }

    private static class Binding<A> {
        final String givenOption;
        final OptionModel<A> optionModel;
        final ArgumentModel<A> argumentModel;
        final String unparsedArgumentValue;
        A value;

        public Binding(String givenOption, OptionModel<A> optionModel, String unparsedArgumentValue) {
            this.givenOption = givenOption;
            this.optionModel = optionModel;
            this.argumentModel = optionModel.getArgument();
            this.unparsedArgumentValue = unparsedArgumentValue;
        }

        public Binding(ArgumentModel<A> argumentModel, String unparsedArgumentValue) {
            this.givenOption = null;
            this.optionModel = null;
            this.argumentModel = argumentModel;
            this.unparsedArgumentValue = unparsedArgumentValue;
        }

        private Binding(String givenOption, OptionModel<A> optionModel, ArgumentModel<A> argumentModel, A value) {
            this.givenOption = givenOption;
            this.optionModel = optionModel;
            this.argumentModel = argumentModel;
            this.unparsedArgumentValue = null;
            this.value = value;
        }

        static <A> Binding<List<A>> mv(List<Binding<A>> bindings) {
            ArrayList<A> listValue = new ArrayList<A>(bindings.size());
            String givenOption = null;
            OptionModel<A> om = null;
            ArgumentModel<A> am = null;
            for (Binding<A> binding : bindings) {
                if (binding.value instanceof Collection) {
                    listValue.addAll((Collection)binding.value);
                } else {
                    listValue.add(binding.value);
                }
                if (om == null) {
                    om = binding.optionModel;
                    am = binding.argumentModel;
                    givenOption = binding.givenOption;
                    continue;
                }
                if (om == binding.optionModel && am == binding.argumentModel) continue;
                throw new ToolException();
            }
            return new Binding<List<A>>(givenOption, om, am, listValue);
        }

        public OptionArgumentException invalid(Throwable throwable, ArgumentParser<?> parser) {
            String badValue;
            Object[] args = new Object[3];
            String string = badValue = this.unparsedArgumentValue != null ? this.unparsedArgumentValue : String.valueOf(this.value);
            if (this.optionModel != null) {
                throw new OptionArgumentException.InvalidOptionValueException(throwable, this.optionModel, this.givenOption, badValue);
            }
            throw new OptionArgumentException.InvalidArgumentValueException(throwable, this.argumentModel, badValue);
        }
    }
}

