/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import java.io.Flushable;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.TreeSet;

public class WordWrap {
    private final int width;
    private int rightIndent = 0;
    private TreeSet<Integer> tabstops = new TreeSet();
    private int indentFirstLine;
    private int indentRestLines;
    private final LineOutput out;
    private String prepend = "";

    public WordWrap() {
        this(System.out);
    }

    public WordWrap(Appendable out) {
        this(out, Integer.getInteger("com.redhat.ceylon.common.tool.terminal.width", 80));
    }

    public WordWrap(Appendable out, int width) {
        if (width <= 0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.out = new LineOutput(out);
    }

    private void boundsCheck(int column) {
        if (column < 0 || column >= this.width) {
            throw new IllegalArgumentException();
        }
    }

    public void setIndent(int indent) {
        this.setIndentFirstLine(indent);
        this.setIndentRestLines(indent);
    }

    public void setIndentFirstLine(int indent) {
        this.boundsCheck(indent);
        this.indentFirstLine = indent;
    }

    public int getIndentFirstLine() {
        return this.indentFirstLine;
    }

    public void setIndentRestLines(int indent) {
        this.boundsCheck(indent);
        this.indentRestLines = indent;
    }

    public int getIndentRestLines() {
        return this.indentRestLines;
    }

    public void setRightIndent(int indent) {
        this.boundsCheck(indent);
        this.rightIndent = indent;
    }

    public int getRightIndent() {
        return this.rightIndent;
    }

    public void setPrefix(String prefix) {
        this.out.prefix = prefix;
    }

    public String getPrefix() {
        return this.out.prefix;
    }

    public int getWidth() {
        return this.width;
    }

    public void addTabStop(int stop) {
        this.boundsCheck(stop);
        this.tabstops.add(stop);
    }

    public void removeTabStop(int stop) {
        this.tabstops.remove(stop);
    }

    public void clearTabStops() {
        this.tabstops.clear();
    }

    private String collapseWs(String s) {
        return s.replaceAll("\\s+", " ");
    }

    private String trimRight(String s) {
        return s.replaceAll("\\s+$", "");
    }

    public WordWrap append(String s) {
        int ii;
        String prependNext = (s = this.collapseWs(s)).endsWith(" ") ? " " : "";
        s = this.prepend + this.trimRight(s);
        this.prepend = prependNext;
        BreakIterator bi = BreakIterator.getLineInstance();
        bi.setText(s);
        int endOfLast = 0;
        for (ii = 0; ii < s.length(); ++ii) {
            if (!this.exceedsWidth(endOfLast, ii)) continue;
            endOfLast = this.addLineBreak(s, bi, endOfLast, ii);
        }
        if (this.exceedsWidth(endOfLast, ii)) {
            endOfLast = this.addLineBreak(s, bi, endOfLast, --ii);
        }
        s = s.substring(endOfLast);
        this.out.append(s);
        return this;
    }

    private int addLineBreak(String s, BreakIterator bi, int endOfLast, int ii) {
        int safe = ii;
        while (!bi.isBoundary(ii)) {
            if (--ii >= endOfLast) continue;
            ii = safe;
            break;
        }
        this.out.append(this.trimRight(s.substring(endOfLast, ii)));
        this.out.newlineSoft();
        endOfLast = ii;
        return endOfLast;
    }

    private boolean exceedsWidth(int endOfLast, int ii) {
        return this.out.column() + (ii - endOfLast) >= this.width - this.rightIndent;
    }

    public WordWrap newline() {
        this.prepend = "";
        this.out.newlineHard();
        return this;
    }

    public WordWrap tab() {
        this.out.spacesToColumn(this.tabstops.higher(this.out.column()));
        return this;
    }

    public WordWrap column(int column) {
        this.out.spacesToColumn(column);
        return this;
    }

    public int getColumn() {
        return this.out.column();
    }

    public void flush() {
        try {
            if (this.out instanceof Flushable) {
                ((Flushable)((Object)this.out)).flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class LineOutput {
        private final Appendable out;
        private int pos = 0;
        private boolean bol = true;
        private boolean fl = true;
        private String prefix = null;

        public LineOutput(Appendable out) {
            this.out = out;
        }

        public void append(String word) {
            try {
                if (this.bol) {
                    this.spaces(this.fl ? WordWrap.this.indentFirstLine : WordWrap.this.indentRestLines);
                    this.prefix();
                }
                this.out.append(word);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.pos += word.length();
        }

        private void prefix() throws IOException {
            if (this.prefix != null) {
                this.out.append(this.prefix);
                this.pos += this.prefix.length();
                this.bol = this.pos == 0;
            }
        }

        private void newline(boolean fl) {
            try {
                this.out.append(System.getProperty("line.separator"));
                this.pos = 0;
                this.bol = true;
                this.fl = fl;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void newlineHard() {
            this.newline(true);
        }

        private void newlineSoft() {
            this.newline(false);
        }

        private void spaces(int num) {
            for (int ii = 0; ii < num; ++ii) {
                this.bol = false;
                try {
                    this.out.append(' ');
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.pos += num;
        }

        public void spacesToColumn(int column) {
            this.spaces(Math.max(column - this.pos, 0));
        }

        public int column() {
            return this.pos;
        }
    }
}

