/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleDescriptorReader;
import com.redhat.ceylon.common.tools.ModuleSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ModuleWildcardsHelper {
    private static final Pattern idPattern = Pattern.compile("\\p{IsLowercase}[\\p{IsAlphabetic}\\p{IsDigit}_]*");

    public static List<ModuleSpec> expandSpecWildcards(File dir, List<ModuleSpec> modules, Backend forBackend) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(dir);
        return ModuleWildcardsHelper.expandSpecWildcards(dirs, modules, forBackend);
    }

    public static List<ModuleSpec> expandSpecWildcards(List<File> dirs, List<ModuleSpec> modules, Backend forBackend) {
        ArrayList<ModuleSpec> result = new ArrayList<ModuleSpec>(modules.size());
        for (ModuleSpec spec : modules) {
            ArrayList<String> names = new ArrayList<String>();
            ModuleWildcardsHelper.expandWildcard(names, dirs, spec.getName(), forBackend);
            for (String name : names) {
                result.add(new ModuleSpec(name, spec.getVersion()));
            }
        }
        return result;
    }

    public static List<String> expandWildcards(File dir, List<String> modules, Backend forBackend) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(dir);
        return ModuleWildcardsHelper.expandWildcards(dirs, modules, forBackend);
    }

    public static List<String> expandWildcards(Iterable<File> dirs, List<String> names, Backend forBackend) {
        ArrayList<String> result = new ArrayList<String>(names.size());
        for (String name : names) {
            ModuleWildcardsHelper.expandWildcard(result, dirs, name, forBackend);
        }
        return result;
    }

    public static void expandWildcard(List<String> result, Iterable<File> dirs, String name, Backend forBackend) {
        if (name.endsWith("*")) {
            int p = name.lastIndexOf(46);
            String parentPath = ".";
            String namePrefix = "";
            if (p >= 0) {
                String parentName = name.substring(0, p);
                parentPath = parentName.replace('.', File.separatorChar);
                namePrefix = name.substring(p + 1, name.length() - 1);
            } else {
                namePrefix = name.substring(0, name.length() - 1);
            }
            List<String> modules = ModuleWildcardsHelper.findModules(dirs, parentPath, namePrefix, forBackend);
            result.addAll(modules);
        } else {
            result.add(name);
        }
    }

    public static boolean isValidModuleDir(Iterable<File> dirs, String name) {
        String path;
        return ModuleWildcardsHelper.isModuleName(name) && ModuleWildcardsHelper.existsSourceSubDir(dirs, path = name.replace('.', File.separatorChar));
    }

    public static boolean isModuleName(String name) {
        String[] parts;
        for (String part : parts = name.split("\\.")) {
            if (part.isEmpty()) {
                return false;
            }
            Matcher m = idPattern.matcher(part);
            if (m.matches()) continue;
            return false;
        }
        return true;
    }

    private static boolean existsSourceSubDir(Iterable<File> dirs, String file) {
        for (File dir : dirs) {
            File subDir = new File(dir, file);
            if (!subDir.isDirectory() || !subDir.canRead()) continue;
            return true;
        }
        return false;
    }

    private static List<String> findModules(Iterable<File> dirs, String modPath, String prefix, Backend forBackend) {
        ArrayList<String> modules = new ArrayList<String>();
        for (File dir : dirs) {
            File modDir = new File(dir, modPath);
            if (!modDir.isDirectory() || !modDir.canRead()) continue;
            ModuleWildcardsHelper.findModules(modules, dir, modDir, prefix, forBackend, true);
        }
        return modules;
    }

    private static void findModules(List<String> modules, File root, File dir, String prefix, Backend forBackend, boolean first) {
        File descriptor = new File(dir, "module.ceylon");
        if (descriptor.isFile()) {
            File modDir = FileUtil.relativeFile(root, dir);
            String modName = modDir.getPath().replace(File.separatorChar, '.');
            if (ModuleWildcardsHelper.includeModule(modName, root, prefix, forBackend)) {
                modules.add(modName);
            }
        } else if (first || prefix == null || prefix.isEmpty()) {
            File[] files;
            for (File f : files = dir.listFiles()) {
                if (!f.isDirectory() || !f.canRead() || !ModuleWildcardsHelper.isModuleName(f.getName())) continue;
                ModuleWildcardsHelper.findModules(modules, root, f, prefix, forBackend, false);
            }
        }
    }

    private static boolean includeModule(String name, File sourceRoot, String prefix, Backend forBackend) {
        if (prefix != null) {
            String lastPart;
            int p = name.lastIndexOf(46);
            String string = lastPart = p >= 0 ? name.substring(p + 1) : name;
            if (!lastPart.startsWith(prefix)) {
                return false;
            }
        }
        if (forBackend != null) {
            try {
                ModuleDescriptorReader mdr = new ModuleDescriptorReader(name, sourceRoot);
                List<String> backends = mdr.getModuleBackends();
                return backends.isEmpty() || backends.contains(forBackend.nativeAnnotation);
            }
            catch (ModuleDescriptorReader.NoSuchModuleException x) {
                x.printStackTrace();
            }
        }
        return true;
    }
}

