/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonToolMessages;
import com.redhat.ceylon.common.tools.ModuleWildcardsHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class SourceArgumentsResolver {
    private final Iterable<File> sourceDirs;
    private final Iterable<File> resourceDirs;
    private final String[] sourceSuffixes;
    private File cwd;
    private boolean expandSingleSources;
    private List<String> srcModules;
    private List<String> resModules;
    private List<File> srcFiles;
    private List<File> resFiles;

    public SourceArgumentsResolver(Iterable<File> sourceDirs, Iterable<File> resourceDirs, String ... sourceSuffixes) {
        this.sourceDirs = sourceDirs;
        this.resourceDirs = resourceDirs;
        this.sourceSuffixes = sourceSuffixes;
        this.srcModules = new LinkedList<String>();
        this.resModules = new LinkedList<String>();
        this.srcFiles = new LinkedList<File>();
        this.resFiles = new LinkedList<File>();
    }

    public SourceArgumentsResolver cwd(File cwd) {
        this.cwd = cwd;
        return this;
    }

    public SourceArgumentsResolver expandSingleSources(boolean expandSingleSources) {
        this.expandSingleSources = expandSingleSources;
        return this;
    }

    public List<String> getSourceModules() {
        return this.srcModules;
    }

    public List<String> getResourceModules() {
        return this.resModules;
    }

    public List<File> getSourceFiles() {
        return this.srcFiles;
    }

    public List<File> getResourceFiles() {
        return this.resFiles;
    }

    public void expandAndParse(List<String> modulesOrFiles, Backend forBackend) throws IOException {
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        List<String> expandedModulesOrFiles = ModuleWildcardsHelper.expandWildcards(srcs, modulesOrFiles, forBackend);
        this.parse(expandedModulesOrFiles);
    }

    public void parse(List<String> modulesOrFiles) throws IOException {
        HashSet<String> srcMods = new HashSet<String>();
        HashSet<String> resMods = new HashSet<String>();
        HashSet<String> singleFileMods = new HashSet<String>();
        this.srcFiles = new LinkedList<File>();
        this.resFiles = new LinkedList<File>();
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        Iterable<File> resrcs = FileUtil.applyCwd(this.cwd, this.resourceDirs);
        for (String moduleOrFile : modulesOrFiles) {
            File file = new File(moduleOrFile);
            if (file.isFile()) {
                String relFileName;
                File path;
                if (SourceArgumentsResolver.hasAcceptedSuffix(file, this.sourceSuffixes)) {
                    path = FileUtil.selectPath(srcs, moduleOrFile);
                    if (path == null) {
                        String srcPath = this.sourceDirs.toString();
                        throw new ToolUsageError(CeylonToolMessages.msg("error.not.in.source.path", moduleOrFile, srcPath));
                    }
                    if (!this.expandSingleSources) {
                        relFileName = FileUtil.relativeFile(srcs, file.getPath());
                        this.srcFiles.add(new File(path, relFileName));
                    } else {
                        singleFileMods.add(this.moduleName(srcs, path, file));
                    }
                    srcMods.add(this.moduleName(srcs, path, file));
                } else if (resrcs != null) {
                    path = FileUtil.selectPath(resrcs, moduleOrFile);
                    if (path == null) {
                        String resrcPath = this.resourceDirs.toString();
                        throw new ToolUsageError(CeylonToolMessages.msg("error.not.in.resource.path", moduleOrFile, resrcPath));
                    }
                    relFileName = FileUtil.relativeFile(resrcs, file.getPath());
                    this.resFiles.add(new File(path, relFileName));
                    resMods.add(this.moduleName(srcs, path, file));
                }
            } else {
                this.visitModuleFiles(this.srcFiles, srcs, moduleOrFile, this.sourceSuffixes);
                srcMods.add(moduleOrFile);
                if (resrcs != null) {
                    this.visitModuleFiles(this.resFiles, resrcs, moduleOrFile, null);
                    resMods.add(moduleOrFile);
                }
            }
            if (!this.srcFiles.isEmpty() || !this.resFiles.isEmpty()) continue;
            throw new ToolUsageError(CeylonToolMessages.msg("error.no.files", moduleOrFile));
        }
        for (String modName : singleFileMods) {
            this.visitModuleFiles(this.srcFiles, srcs, modName, this.sourceSuffixes);
        }
        this.srcModules = new ArrayList<String>(srcMods);
        this.resModules = new ArrayList<String>(resMods);
    }

    private void visitModuleFiles(List<File> files, Iterable<File> paths, String modName, String[] suffixes) throws IOException {
        if (ModuleUtil.isDefaultModule(modName)) {
            SourceArgumentsResolver.visitFiles(paths, null, new RootedFileVisitor(files, true, suffixes));
        } else {
            File modPath = ModuleUtil.moduleToPath(modName);
            if (this.isModuleFolder(modPath)) {
                SourceArgumentsResolver.visitFiles(paths, modPath, new RootedFileVisitor(files, false, suffixes));
            } else {
                File dir = this.searchModulePath(modPath);
                if (dir == null || !dir.isDirectory()) {
                    if (modName.contains("/")) {
                        throw new ToolUsageError(CeylonToolMessages.msg("error.invalid.module.or.file", modName));
                    }
                    for (String suffix : suffixes) {
                        if (!modName.endsWith(suffix)) continue;
                        throw new ToolUsageError(CeylonToolMessages.msg("error.file.not.found", modName));
                    }
                    String ps = this.sourceDirs.toString();
                    ps = ps.substring(1, ps.length() - 1);
                    throw new ToolUsageError(CeylonToolMessages.msg("error.module.not.found", modName, ps));
                }
                throw new ToolUsageError(CeylonToolMessages.msg("error.not.module", modName));
            }
        }
    }

    private static void visitFiles(Iterable<File> dirs, File modPath, RootedFileVisitor visitor) throws IOException {
        for (File dir : dirs) {
            SourceArgumentsResolver.visitFiles(dir, modPath, visitor);
        }
    }

    private static void visitFiles(File dir, File modPath, RootedFileVisitor visitor) throws IOException {
        File moduleDir = dir;
        if (modPath != null) {
            moduleDir = new File(dir, modPath.getPath());
        }
        visitor.rootPath = dir;
        if (moduleDir.isDirectory()) {
            Files.walkFileTree(moduleDir.toPath(), visitor);
        }
    }

    private static boolean hasAcceptedSuffix(File file, String ... suffixes) {
        for (String ext : suffixes) {
            if (!file.toString().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private boolean isModuleFolder(File rootPath, File modPath) {
        File relPath = FileUtil.relativeFile(rootPath, modPath);
        return this.isModuleFolder(relPath);
    }

    private boolean isModuleFolder(File modPath) {
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        return ModuleUtil.isModuleFolder(srcs, modPath);
    }

    private File searchModulePath(File modPath) {
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        return FileUtil.searchPaths(srcs, modPath.getPath());
    }

    private String moduleName(Iterable<File> srcs, File rootPath, File file) {
        File relFile = FileUtil.relativeFile(rootPath, file);
        return ModuleUtil.moduleName(srcs, relFile);
    }

    private class RootedFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<File> result;
        private final boolean excludeModules;
        private final String[] acceptedSuffixes;
        public File rootPath;

        public RootedFileVisitor(List<File> result, boolean excludeModules, String[] acceptedFiles) {
            this.result = result;
            this.excludeModules = excludeModules;
            this.acceptedSuffixes = acceptedFiles;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.excludeModules && SourceArgumentsResolver.this.isModuleFolder(this.rootPath, dir.toFile())) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            boolean add = true;
            if (this.acceptedSuffixes != null) {
                add = SourceArgumentsResolver.hasAcceptedSuffix(file.toFile(), this.acceptedSuffixes);
            }
            if (add) {
                this.result.add(file.toFile());
            }
            return super.visitFile(file, attrs);
        }
    }
}

