/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools;

import com.redhat.ceylon.common.tool.ArgumentParser;
import com.redhat.ceylon.common.tool.EnumerableParser;
import com.redhat.ceylon.common.tool.FatalToolError;
import com.redhat.ceylon.common.tool.OptionArgumentException;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.ToolError;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tool.Tools;
import com.redhat.ceylon.common.tool.WordWrap;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.CeylonToolMessages;
import com.redhat.ceylon.common.tools.help.CeylonHelpTool;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class Usage {
    private final CeylonTool rootTool;
    private final String toolName;
    private final Exception t;
    private final WordWrap out;

    public static int getLevenshteinDistance(CharSequence s, CharSequence t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static boolean isSuggestionFor(String given, String possibleSuggestion) {
        int ld = Usage.getLevenshteinDistance(given, possibleSuggestion);
        return ld <= Math.min(given.length() / 2, 4);
    }

    Usage(CeylonTool rootTool, String toolName, Exception t) {
        this.rootTool = rootTool;
        this.toolName = toolName;
        this.t = t;
        this.out = new WordWrap(System.err);
    }

    static void handleException(CeylonTool rootTool, String toolName, Exception t) throws Exception {
        new Usage(rootTool, toolName, t).run();
    }

    void run() throws Exception {
        if (!this.validToolName()) {
            this.printFirstLineBadToolName(this.toolName);
            if (this.t instanceof OptionArgumentException.InvalidArgumentValueException) {
                this.printSuggestions(this.toolName, this.rootTool.getPluginLoader().getToolNames());
            }
            this.printHelpInvocation();
            this.out.flush();
        } else {
            this.printErrorMessage();
            if (this.t instanceof OptionArgumentException) {
                this.printUsage((OptionArgumentException)this.t);
            }
            if ((this.rootTool.getStacktraces() || this.t instanceof FatalToolError || !(this.t instanceof ToolError)) && !this.isNetworkTimeoutException(this.t)) {
                this.out.flush();
                this.t.printStackTrace(System.err);
            }
            this.out.flush();
        }
    }

    private void printErrorMessage() {
        String[] lines;
        StringBuilder sb = new StringBuilder();
        sb.append(Tools.progName());
        if (this.toolName != null) {
            sb.append(' ').append(this.toolName);
        }
        sb.append(": ");
        if (this.t instanceof FatalToolError) {
            sb.append(CeylonToolMessages.msg("fatal.error", new Object[0])).append(": ");
            sb.append(((FatalToolError)this.t).getErrorMessage());
        } else if (this.t instanceof ToolError) {
            sb.append(((ToolError)this.t).getErrorMessage());
        } else if (this.isNetworkTimeoutException(this.t)) {
            if (this.t.getClass().getName().endsWith(".RepositoryException")) {
                sb.append(CeylonToolMessages.msg("error.network.timeout.cmr", new Object[0]));
            } else {
                sb.append(CeylonToolMessages.msg("error.network.timeout", new Object[0]));
            }
        } else {
            sb.append(this.t.getLocalizedMessage());
        }
        for (String line : lines = sb.toString().split("\n")) {
            this.out.append(line).newline();
        }
    }

    private boolean isNetworkTimeoutException(Exception ex) {
        return this.rootCause(ex) instanceof SocketTimeoutException;
    }

    private Throwable rootCause(Throwable th) {
        if (th.getCause() != null && th.getCause() != th) {
            return this.rootCause(th.getCause());
        }
        return th;
    }

    private void printFirstLineBadToolName(String toolName) {
        StringBuilder sb = new StringBuilder();
        sb.append(Tools.progName()).append(": ");
        sb.append(CeylonToolMessages.msg("bad.tool.name", toolName));
        this.out.append(sb.toString()).newline();
    }

    private void printUsage(OptionArgumentException t) throws Exception {
        if (t instanceof OptionArgumentException.UnknownOptionException) {
            OptionArgumentException.UnknownOptionException e = (OptionArgumentException.UnknownOptionException)t;
            this.printSynopsis(e.getToolModel());
            this.printOptionSuggestions(e);
        } else if (t instanceof OptionArgumentException.OptionMultiplicityException) {
            OptionArgumentException.OptionMultiplicityException e = (OptionArgumentException.OptionMultiplicityException)t;
            this.printSynopsis(e.getToolModel());
            this.printOptions(e.getOptionModel().getLongName());
        } else if (t instanceof OptionArgumentException.ArgumentMultiplicityException) {
            OptionArgumentException.ArgumentMultiplicityException e = (OptionArgumentException.ArgumentMultiplicityException)t;
            this.printSynopsis(e.getToolModel());
        } else if (t instanceof OptionArgumentException.OptionWithoutArgumentException) {
            OptionArgumentException.OptionWithoutArgumentException e = (OptionArgumentException.OptionWithoutArgumentException)t;
            this.printSynopsis(e.getToolModel());
            this.printOptions(e.getOptionModel().getLongName());
            this.printSuggestions(e.getOptionModel().getArgument().getParser(), null);
        } else if (t instanceof OptionArgumentException.InvalidArgumentValueException) {
            OptionArgumentException.InvalidArgumentValueException e = (OptionArgumentException.InvalidArgumentValueException)t;
            this.printSynopsis(e.getToolModel());
            this.printSuggestions(e.getArgumentModel().getParser(), e.getBadValue());
        } else if (t instanceof OptionArgumentException.InvalidOptionValueException) {
            OptionArgumentException.InvalidOptionValueException e = (OptionArgumentException.InvalidOptionValueException)t;
            this.printSynopsis(e.getToolModel());
            this.printOptions(e.getOptionModel().getLongName());
            this.printSuggestions(e.getOptionModel().getArgument().getParser(), e.getBadValue());
        } else if (t instanceof OptionArgumentException.ToolInitializationException) {
            OptionArgumentException.ToolInitializationException e = (OptionArgumentException.ToolInitializationException)t;
            this.printSynopsis(e.getToolModel());
        } else {
            this.printSynopsis(null);
        }
        this.printHelpInvocation();
    }

    private void printSynopsis(ToolModel<?> toolModel) throws Exception {
        if (!this.validToolName()) {
            return;
        }
        this.out.newline();
        this.out.append(CeylonToolMessages.msg("usage", new Object[0])).newline();
        this.out.flush();
        CeylonHelpTool r = new CeylonHelpTool();
        r.setToolLoader(this.rootTool.getPluginLoader());
        r.setSynopsis(true);
        r.setTool(toolModel);
        r.run();
        this.out.newline();
    }

    private void printOptions(String option) throws Exception {
        this.out.flush();
        CeylonHelpTool r = new CeylonHelpTool();
        r.setToolLoader(this.rootTool.getPluginLoader());
        r.setOptions(option != null ? option : "");
        r.run();
    }

    private void printHelpInvocation() {
        String helpInvocation = Tools.progName() + " help";
        if (this.toolName != null && this.validToolName()) {
            helpInvocation = helpInvocation + " " + this.toolName;
        }
        this.out.append(CeylonToolMessages.msg("run.ceylon.help", helpInvocation));
        this.out.newline();
    }

    private void printSuggestions(ArgumentParser<?> parser, String badValue) {
        if (parser instanceof EnumerableParser) {
            EnumerableParser enumerableParser = (EnumerableParser)parser;
            this.printSuggestions(badValue, enumerableParser.possibilities());
        }
    }

    private void printSuggestions(String badValue, Iterable<String> valids) {
        ArrayList<String> l = new ArrayList<String>();
        for (String valid : valids) {
            if (badValue != null && !Usage.isSuggestionFor(badValue, valid)) continue;
            l.add(valid);
        }
        Collections.sort(l);
        this.printSuggestions(l);
    }

    private void printOptionSuggestions(OptionArgumentException.UnknownOptionException e) {
        if (e.getAggregating() == null || e.getAggregating().size() == 0) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (OptionModel<?> model : e.getToolModel().getOptions()) {
                if (e.getLongName() != null && Usage.isSuggestionFor(e.getLongName(), model.getLongName())) {
                    suggestions.add("--" + model.getLongName());
                }
                if (e.getShortName() == null) continue;
                if (model.getShortName() != null) {
                    suggestions.add("-" + model.getShortName());
                }
                if (Usage.getLevenshteinDistance(model.getLongName(), e.getShortName().toString()) > 1) continue;
                suggestions.add("--" + model.getLongName());
            }
            this.printSuggestions(suggestions);
        }
    }

    private boolean validToolName() {
        for (String toolName : this.rootTool.getToolNames()) {
            if (this.rootTool.getToolModel(toolName) != null) continue;
            return false;
        }
        return true;
    }

    private void printSuggestions(List<String> l) {
        if (l.isEmpty()) {
            return;
        }
        this.out.append(CeylonToolMessages.msg("did.you.mean", new Object[0])).newline();
        this.out.setIndent(4);
        for (String valid : l) {
            this.out.append(valid).newline();
        }
        this.out.setIndent(0);
        this.out.newline();
    }
}

