/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.config;

import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.CeylonConfigFinder;
import com.redhat.ceylon.common.config.ConfigException;
import com.redhat.ceylon.common.config.ConfigFinder;
import com.redhat.ceylon.common.config.ConfigWriter;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Subtool;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tools.CeylonTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

@Summary(value="Manages Ceylon configuration files")
@Description(value="Can be used to list, update and remove settings in Ceylon's configuration files.\n\nSetting names are of form `<section>.<key>`, for example, `defaults.encoding`.\n")
@RemainingSections(value="##EXAMPLE\n\nThe following would list the settings active from within the current folder:\n\n    ceylon config list\n\nThis reads a named setting:\n\n    ceylon config get defaults.encoding\n\nThis writes a named setting:\n\n    ceylon config --file=.ceylon/config set defaults.encoding UTF-8\n\n")
public class CeylonConfigTool
extends CeylonBaseTool {
    private Tool action;
    private File file;
    private boolean system;
    private boolean user;
    private boolean local;
    private int configFileArgCount = 0;

    @OptionArgument(argumentName="file")
    @Description(value="The file to operate on.")
    public void setFile(File file) {
        this.file = file;
    }

    @Option(longName="system")
    @Description(value="Apply operation to the system configuration.")
    public void setSystem(boolean system) {
        this.system = system;
    }

    @Option(longName="user")
    @Description(value="Apply operation to the user configuration.")
    public void setUser(boolean user) {
        this.user = user;
    }

    @Option(longName="local")
    @Description(value="Apply operation to the local configuration.")
    public void setLocal(boolean local) {
        this.local = local;
    }

    @Subtool(argumentName="action", classes={List.class, Get.class, Set.class, Remove.class, RenameSection.class, RemoveSection.class, Keystore.class})
    public void setAction(Tool action) {
        this.action = action;
    }

    private CeylonConfig readConfig() throws IOException {
        ConfigFinder finder = CeylonConfigFinder.DEFAULT;
        if (this.file != null) {
            if (this.file.exists()) {
                return finder.loadConfigFromFile(this.applyCwd(this.file));
            }
            return new CeylonConfig();
        }
        try {
            if (this.system) {
                return finder.loadSystemConfig();
            }
            if (this.user) {
                return finder.loadUserConfig();
            }
            if (this.local) {
                return finder.loadConfigFromFile(finder.findLocalConfig(this.applyCwd(new File("."))));
            }
        }
        catch (FileNotFoundException ex) {
            return new CeylonConfig();
        }
        return CeylonConfig.get();
    }

    private void writeConfig(CeylonConfig config) throws IOException {
        File cfgFile;
        ConfigFinder finder = CeylonConfigFinder.DEFAULT;
        if (this.file != null) {
            cfgFile = this.applyCwd(this.file);
        } else if (this.system) {
            cfgFile = finder.findSystemConfig();
        } else if (this.user) {
            cfgFile = finder.findUserConfig();
        } else if (this.local) {
            cfgFile = finder.findLocalConfig(this.applyCwd(new File(".")));
        } else {
            throw new IllegalStateException("A configuration must be specified");
        }
        ConfigWriter.write(config, cfgFile);
    }

    private void initSubtool() {
        this.configFileArgCount = 0;
        if (this.file != null) {
            ++this.configFileArgCount;
        }
        if (this.system) {
            ++this.configFileArgCount;
        }
        if (this.user) {
            ++this.configFileArgCount;
        }
        if (this.local) {
            ++this.configFileArgCount;
        }
        if (this.configFileArgCount > 1) {
            throw new IllegalStateException("Only one argument specifying a configuration can be used at a time");
        }
    }

    private void initUpdatingSubtool() {
        this.initSubtool();
        if (this.configFileArgCount == 0) {
            throw new IllegalStateException("A configuration must be specified");
        }
    }

    @Override
    public void initialize(CeylonTool mainTool) {
    }

    @Override
    public void run() throws Exception {
        this.action.run();
    }

    public static void main(String[] args) throws Exception {
        CeylonConfigTool x = new CeylonConfigTool();
        x.action = x.new Get();
        x.run();
    }

    @Description(value="Modifies keystores")
    public class Keystore
    implements Tool {
        private Tool tool;
        private String storePassword;

        @OptionArgument
        @Option
        @Description(value="The password for accessing the keystore")
        public void setStorePassword(String storePassword) {
            this.storePassword = storePassword;
        }

        @Subtool(argumentName="action", classes={GetPassword.class, SetPassword.class, UnsetPassword.class})
        public void setAction(Tool action) {
            this.tool = action;
        }

        @Override
        public void initialize(CeylonTool mainTool) {
        }

        @Override
        public void run() throws Exception {
            this.tool.run();
        }

        @Description(value="Unsets the password for `<alias>` in the keystore, removing the alias and its corresponding password.")
        public class UnsetPassword
        implements Tool {
            private String alias;

            @Argument(argumentName="alias", multiplicity="1", order=1)
            public void setAlias(String alias) {
                this.alias = alias;
            }

            @Override
            public void initialize(CeylonTool mainTool) {
            }

            @Override
            public void run() throws Exception {
            }
        }

        @Description(value="Sets the password for `<alias>` in the keystore. The program will issue a password prompt if `<password>` is omitted.")
        public class SetPassword
        implements Tool {
            private String alias;
            private String password;

            @Argument(argumentName="alias", multiplicity="1", order=1)
            public void setAlias(String alias) {
                this.alias = alias;
            }

            @Argument(argumentName="password", multiplicity="?", order=2)
            public void setPassword(String password) {
                this.password = password;
            }

            @Override
            public void initialize(CeylonTool mainTool) {
            }

            @Override
            public void run() throws Exception {
            }
        }

        @Description(value="Gets the password for `<alias>` in the keystore")
        public class GetPassword
        implements Tool {
            private String alias;

            @Argument(argumentName="alias", multiplicity="1", order=1)
            public void setAlias(String alias) {
                this.alias = alias;
            }

            @Override
            public void initialize(CeylonTool mainTool) {
            }

            @Override
            public void run() throws Exception {
            }
        }
    }

    @Description(value="Removes the named `<section>` from the config file")
    public class RemoveSection
    implements Tool {
        private String name;

        @Argument(argumentName="name", multiplicity="1", order=1)
        public void setSection(String name) {
            this.name = name;
        }

        @Override
        public void initialize(CeylonTool mainTool) {
            CeylonConfigTool.this.initUpdatingSubtool();
        }

        @Override
        public void run() throws IOException {
            CeylonConfig config = CeylonConfigTool.this.readConfig();
            try {
                config.removeSection(this.name);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigException(ex.getMessage());
            }
            CeylonConfigTool.this.writeConfig(config);
        }
    }

    @Description(value="Renames the section `<old-name>` in the config file to `<new-name>`")
    public class RenameSection
    implements Tool {
        private String oldName;
        private String newName;

        @Argument(argumentName="old-name", multiplicity="1", order=1)
        public void setOldName(String oldName) {
            this.oldName = oldName;
        }

        @Argument(argumentName="new-name", multiplicity="1", order=2)
        public void setNewName(String newName) {
            this.newName = newName;
        }

        @Override
        public void initialize(CeylonTool mainTool) {
            CeylonConfigTool.this.initUpdatingSubtool();
        }

        @Override
        public void run() throws IOException {
            throw new ConfigException("Not implemented yet");
        }
    }

    @Description(value="Removes the value of the `<key>` in the config file")
    public class Remove
    implements Tool {
        private String key;

        @Argument(argumentName="key", multiplicity="1")
        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public void initialize(CeylonTool mainTool) {
            CeylonConfigTool.this.initUpdatingSubtool();
        }

        @Override
        public void run() throws IOException {
            CeylonConfig config = CeylonConfigTool.this.readConfig();
            try {
                config.removeOption(this.key);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigException(ex.getMessage());
            }
            CeylonConfigTool.this.writeConfig(config);
        }
    }

    @Description(value="Set the value of the `<key>` to `<values>` in the config file")
    public class Set
    implements Tool {
        private String key;
        private java.util.List<String> values;

        @Argument(argumentName="key", multiplicity="1", order=1)
        public void setKey(String key) {
            this.key = key;
        }

        @Argument(argumentName="values", multiplicity="+", order=2)
        public void setValues(java.util.List<String> values) {
            this.values = values;
        }

        @Override
        public void initialize(CeylonTool mainTool) {
            CeylonConfigTool.this.initUpdatingSubtool();
        }

        @Override
        public void run() throws IOException {
            CeylonConfig config = CeylonConfigTool.this.readConfig();
            String[] vals = this.values.toArray(new String[this.values.size()]);
            try {
                config.setOptionValues(this.key, vals);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigException(ex.getMessage());
            }
            CeylonConfigTool.this.writeConfig(config);
        }
    }

    @Description(value="Get the value defined for `<key>` in the config file")
    public class Get
    implements Tool {
        private String key;

        @Argument(argumentName="key", multiplicity="1")
        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public void initialize(CeylonTool mainTool) {
            CeylonConfigTool.this.initSubtool();
        }

        @Override
        public void run() throws IOException {
            CeylonConfig config = CeylonConfigTool.this.readConfig();
            String[] values = config.getOptionValues(this.key);
            if (values != null) {
                for (String value : values) {
                    System.out.println(ConfigWriter.escape(value));
                }
            }
        }
    }

    @Description(value="Lists configuration values")
    public class List
    implements Tool {
        @Override
        public void initialize(CeylonTool mainTool) {
            CeylonConfigTool.this.initSubtool();
        }

        @Override
        public void run() throws IOException {
            CeylonConfig config = CeylonConfigTool.this.readConfig();
            System.out.print(config.toString());
        }
    }
}

