/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import java.io.IOException;
import org.tautua.markdownpapers.HtmlEmitter;
import org.tautua.markdownpapers.ast.Node;

class AbstractMl<M extends AbstractMl<M>> {
    protected final Appendable out;
    private IOException error;

    public AbstractMl(Appendable out) {
        this.out = out;
    }

    protected M append(String s) {
        if (this.error == null) {
            try {
                this.out.append(s);
            }
            catch (IOException e) {
                this.error = e;
            }
        }
        return (M)this;
    }

    protected M append(char s) {
        if (this.error == null) {
            try {
                this.out.append(s);
            }
            catch (IOException e) {
                this.error = e;
            }
        }
        return (M)this;
    }

    public M doctype(String type) {
        return ((AbstractMl)((AbstractMl)this.append("<!DOCTYPE ")).append(type)).append('>');
    }

    public M open(String ... tags) {
        for (String tag : tags) {
            this.open(tag);
        }
        return (M)this;
    }

    public M open(String tag) {
        return ((AbstractMl)((AbstractMl)this.append('<')).append(tag)).append('>');
    }

    public M close(String ... tags) {
        for (String tag : tags) {
            this.close(tag);
        }
        return (M)this;
    }

    public M close(String tag) {
        return ((AbstractMl)((AbstractMl)this.append("</")).append(tag)).append('>');
    }

    public M text(String text) {
        return this.append(text.replace("&", "&mp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"));
    }

    public M unescaped(String html) {
        return this.append(html);
    }

    public M markdown(Node doc) {
        HtmlEmitter markdownVisitor = new HtmlEmitter(this.out);
        doc.accept(markdownVisitor);
        return (M)this;
    }

    public M tag(String tag) {
        return ((AbstractMl)((AbstractMl)this.append('<')).append(tag)).append("/>");
    }
}

