/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolLoader;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tool.Tools;
import com.redhat.ceylon.common.tool.WordWrap;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.help.AbstractMl;
import com.redhat.ceylon.common.tools.help.CeylonHelpToolMessages;
import com.redhat.ceylon.common.tools.help.DocBookVisitor;
import com.redhat.ceylon.common.tools.help.DocBuilder;
import com.redhat.ceylon.common.tools.help.HtmlVisitor;
import com.redhat.ceylon.common.tools.help.PlainVisitor;
import com.redhat.ceylon.common.tools.help.model.Doc;
import com.redhat.ceylon.common.tools.help.model.Visitor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

@Summary(value="Generates documentation about a tool")
@Description(value="Generates documentation about the named `<tool>`s in the directory named by the `--output` option.")
@RemainingSections(value="## See Also\n\n* `ceylon help` For generating help about ceylon tools at the command line\n* `ceylon doc` For generating API documentation about ceylon modules\n")
public class CeylonDocToolTool
extends CeylonBaseTool {
    private List<ToolModel<?>> tools;
    private File dir = new File(".");
    private Format format = Format.html;
    private int width = 80;
    private boolean index = false;
    private boolean allPlumbing;
    private boolean allPorcelain;
    protected ToolLoader toolLoader;
    private DocBuilder docBuilder;
    private boolean omitDoctype;

    public final void setToolLoader(ToolLoader toolLoader) {
        this.toolLoader = toolLoader;
        this.docBuilder = new DocBuilder(toolLoader);
    }

    @Argument(argumentName="tool", multiplicity="*")
    public void setTool(List<ToolModel<?>> tools) {
        this.tools = tools;
    }

    @Option
    @Description(value="Generate documentation about all low level tools, in addition to the tools named by the `<tool>` argument")
    public void setAllPlumbing(boolean allPlumbing) {
        this.allPlumbing = allPlumbing;
    }

    @Option
    @Description(value="Generate documentation about all high level tools, in addition to the tools named by the `<tool>` argument")
    public void setAllPorcelain(boolean allPorcelain) {
        this.allPorcelain = allPorcelain;
    }

    @Option
    @Description(value="Generate an `index.html` file when `--format=html`")
    public void setIndex(boolean index) {
        this.index = index;
    }

    @Option
    @Description(value="Omit the doctype when outputting XML-based formats")
    public void setOmitDoctype(boolean omitDoctype) {
        this.omitDoctype = omitDoctype;
    }

    @OptionArgument(shortName=111, argumentName="dir")
    @Description(value="Directory to generate the output files in (default: The current directory)")
    public void setOutput(File dir) {
        this.dir = dir;
    }

    @OptionArgument(argumentName="format")
    @Description(value="The format to generate the documentation in (allowable values: `html`, `docbook` or `txt`, default: `html`)")
    public void setFormat(Format format) {
        this.format = format;
    }

    @OptionArgument(argumentName="cols")
    @Description(value="The line length to use for word wrapping when `--format=txt` (default: 80)")
    public void setWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
    }

    @Override
    public void initialize(CeylonTool mainTool) {
        if (!(this.allPlumbing || this.allPorcelain || this.tools != null && !this.tools.isEmpty())) {
            throw new IllegalStateException("No tools to process");
        }
        if (this.index && this.format != Format.html) {
            throw new IllegalStateException("--index is only supported when --format=html");
        }
    }

    @Override
    public void run() throws IOException {
        List<Doc> models = this.loadModels();
        this.prepareDirectory();
        this.generateDoc(models);
        this.copyResources();
    }

    private List<Doc> loadModels() {
        ToolModel model;
        ArrayList<Doc> models = new ArrayList<Doc>();
        if (this.allPlumbing) {
            for (String string : this.toolLoader.getToolNames()) {
                model = this.toolLoader.loadToolModel(string);
                if (!model.isPlumbing()) continue;
                models.add(this.docBuilder.buildDoc(model));
            }
        }
        if (this.allPorcelain) {
            for (String string : this.toolLoader.getToolNames()) {
                model = this.toolLoader.loadToolModel(string);
                if (!model.isPorcelain()) continue;
                models.add(this.docBuilder.buildDoc(model));
            }
        }
        if (this.tools != null) {
            for (ToolModel toolModel : this.tools) {
                models.add(this.docBuilder.buildDoc(toolModel));
            }
        }
        models.add(this.docBuilder.buildDoc(this.toolLoader.loadToolModel(""), true));
        return models;
    }

    private void generateDoc(List<Doc> docs) throws IOException {
        for (Doc doc : docs) {
            File out = new File(this.applyCwd(this.dir), this.filename(doc));
            FileWriter writer = new FileWriter(out);
            Throwable throwable = null;
            try {
                Visitor visitor = this.format.newOutput(this, writer);
                doc.accept(visitor);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                writer.close();
            }
        }
        if (this.index && this.format == Format.html) {
            this.generateIndexHtml(docs);
        }
    }

    private String filename(Doc doc) {
        if (doc.getName().isEmpty()) {
            return Tools.progName() + this.format.extension;
        }
        return Tools.progName() + "-" + doc.getName() + this.format.extension;
    }

    private void generateIndexHtml(List<Doc> docs) throws IOException {
        File indexFile = new File(this.applyCwd(this.dir), "index" + this.format.extension);
        ResourceBundle bundle = CeylonHelpToolMessages.RESOURCE_BUNDLE;
        try (FileWriter writer = new FileWriter(indexFile);){
            HtmlVisitor htmlOutput = (HtmlVisitor)Format.html.newOutput(this, writer);
            AbstractMl html = htmlOutput.getHtml();
            this.indexHeader(html, bundle.getString("index.title"), bundle.getString("index.overview"));
            ArrayList<Doc> porcelain = new ArrayList<Doc>();
            ArrayList<Doc> plumbing = new ArrayList<Doc>();
            for (Doc model : docs) {
                if (model.getToolModel().isPorcelain() || model.getName().isEmpty()) {
                    porcelain.add(model);
                    continue;
                }
                if (!model.getToolModel().isPlumbing()) continue;
                plumbing.add(model);
            }
            if (!porcelain.isEmpty()) {
                this.generateToolList(porcelain, html, bundle.getString("index.porcelain.tools"));
            }
            if (!plumbing.isEmpty()) {
                this.generateToolList(plumbing, html, bundle.getString("index.plumbing.tools"));
            }
            this.indexFooter(html);
        }
    }

    private void indexHeader(AbstractMl html, String title, String overview) {
        ((AbstractMl)html.doctype("html")).text("\n");
        ((AbstractMl)html.open("html", "head")).text("\n");
        ((AbstractMl)html.tag("meta charset='UTF-8'")).text("\n");
        ((AbstractMl)((AbstractMl)((AbstractMl)html.open("title")).text(title)).close("title")).text("\n");
        ((AbstractMl)html.tag("link rel='stylesheet' type='text/css' href='bootstrap.min.css'")).text("\n");
        ((AbstractMl)html.tag("link rel='stylesheet' type='text/css' href='doc-tool.css'")).text("\n");
        ((AbstractMl)html.close("head")).text("\n");
        ((AbstractMl)html.open("body")).text("\n");
        ((AbstractMl)html.open("div class='navbar navbar-inverse navbar-static-top'")).text("\n");
        ((AbstractMl)html.open("div class='navbar-inner'")).text("\n");
        ((AbstractMl)html.open("a class='tool-header' href='index.html'")).text("\n");
        ((AbstractMl)((AbstractMl)html.open("i class='tool-logo'")).close("i")).text("\n");
        ((AbstractMl)((AbstractMl)((AbstractMl)html.open("span class='tool-label'")).text(title)).close("span")).text("\n");
        ((AbstractMl)((AbstractMl)((AbstractMl)html.open("span class='tool-name'")).text(overview)).close("span")).text("\n");
        ((AbstractMl)html.close("a")).text("\n");
        ((AbstractMl)html.close("div")).text("\n");
        ((AbstractMl)html.close("div")).text("\n");
        ((AbstractMl)html.tag("div class='tool-description'")).text("\n");
        ((AbstractMl)html.open("div class='container-fluid'")).text("\n");
    }

    private void indexFooter(AbstractMl html) {
        html.close("div", "body", "html");
    }

    private void generateToolList(List<Doc> docs, AbstractMl html, String title) {
        ((AbstractMl)html.open("table class='table table-condensed table-bordered table-hover'")).text("\n");
        ((AbstractMl)html.open("thead")).text("\n");
        html.open("tr class='table-header'");
        ((AbstractMl)((AbstractMl)html.open("td colspan='2'")).text(title)).close("td");
        ((AbstractMl)html.close("tr")).text("\n");
        ((AbstractMl)html.close("thead")).text("\n");
        html.open("tbody");
        for (Doc doc : docs) {
            html.open("tr");
            html.open("td class='span3'", "a class='link' href='" + this.filename(doc) + "'");
            ((AbstractMl)((AbstractMl)html.open("code")).text(Tools.progName() + " " + doc.getName())).close("code");
            ((AbstractMl)html.close("a", "td")).text("\n");
            html.open("td", "p");
            html.text(doc.getSummary().getSummary());
            html.close("p", "td");
            ((AbstractMl)html.close("tr")).text("\n");
        }
        ((AbstractMl)html.close("tbody")).text("\n");
        ((AbstractMl)html.close("table")).text("\n");
    }

    private void prepareDirectory() {
        File actualDir = this.applyCwd(this.dir);
        if (!actualDir.exists()) {
            FileUtil.mkdirs(actualDir);
        }
        if (!actualDir.isDirectory()) {
            throw new RuntimeException(this.dir + " is not a directory");
        }
    }

    private void copyResources() throws IOException {
        URL[] resources = this.format.supportingResources();
        if (resources != null) {
            for (URL resource : resources) {
                this.copyResource(resource, this.applyCwd(this.dir));
            }
        }
    }

    private void copyResource(URL resource, File dir) throws IOException {
        File toFile = new File(dir, new File(resource.getPath()).getName());
        byte[] buf = new byte[1024];
        try (InputStream in = resource.openStream();
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile));){
            int read = in.read(buf);
            while (read != -1) {
                out.write(buf, 0, read);
                read = in.read(buf);
            }
        }
    }

    public static enum Format {
        html(".html"){

            @Override
            HtmlVisitor newOutput(CeylonDocToolTool tool, Writer writer) {
                return new HtmlVisitor(writer, tool.omitDoctype);
            }

            @Override
            URL[] supportingResources() {
                return new URL[]{((Object)((Object)this)).getClass().getResource("resources/doc-tool.css"), ((Object)((Object)this)).getClass().getResource("resources/bootstrap.min.css"), ((Object)((Object)this)).getClass().getResource("resources/bootstrap.min.js"), ((Object)((Object)this)).getClass().getResource("resources/jquery-1.8.2.min.js"), ((Object)((Object)this)).getClass().getResource("resources/NOTICE.txt"), ((Object)((Object)this)).getClass().getResource("resources/doc-tool.js"), ((Object)((Object)this)).getClass().getResource("resources/ceylondoc-icons.png"), ((Object)((Object)this)).getClass().getResource("resources/ceylondoc-logo.png")};
            }
        }
        ,
        docbook(".xml"){

            @Override
            DocBookVisitor newOutput(CeylonDocToolTool tool, Writer writer) {
                return new DocBookVisitor(writer, tool.omitDoctype);
            }

            @Override
            URL[] supportingResources() {
                return null;
            }
        }
        ,
        txt(".txt"){

            @Override
            PlainVisitor newOutput(CeylonDocToolTool tool, Writer writer) {
                return new PlainVisitor(new WordWrap(writer, tool.width));
            }

            @Override
            URL[] supportingResources() {
                return null;
            }
        };

        private final String extension;

        private Format(String extension) {
            this.extension = extension;
        }

        abstract Visitor newOutput(CeylonDocToolTool var1, Writer var2);

        abstract URL[] supportingResources();
    }
}

