/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolLoader;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tool.WordWrap;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.help.DocBuilder;
import com.redhat.ceylon.common.tools.help.OptionsOnlyVisitor;
import com.redhat.ceylon.common.tools.help.PlainVisitor;
import com.redhat.ceylon.common.tools.help.SynopsisOnlyVisitor;
import com.redhat.ceylon.common.tools.help.model.Doc;
import com.redhat.ceylon.common.tools.help.model.Visitor;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;

@Summary(value="Displays help information about other Ceylon tools")
@Description(value="If a `<tool>` is given, displays help about that ceylon tool on the standard output.\n\nIf no `<tool>` is given, displays the synopsis of the top level `ceylon` command. ")
@RemainingSections(value="## SEE ALSO\n\n* `ceylon doc-tool` for generating documentation about ceylon tools\n")
public class CeylonHelpTool
implements Tool {
    private Appendable out;
    private boolean includeHidden;
    private ToolLoader toolLoader;
    private DocBuilder docBuilder;
    private ToolModel<?> tool;
    private boolean synopsis = false;
    private String options = null;
    private boolean wantsPager;

    public final void setToolLoader(ToolLoader toolLoader) {
        this.toolLoader = toolLoader;
        this.docBuilder = new DocBuilder(toolLoader);
    }

    @Option
    public void setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
    }

    @Hidden
    @Option
    @Description(value="Used to generate a synopsis when another tool was invoked incorrectly")
    public void setSynopsis(boolean synopsis) {
        this.synopsis = synopsis;
    }

    @Hidden
    @Option
    @OptionArgument
    @Description(value="Used to generate doc on a given option (or options)")
    public void setOptions(String options) {
        this.options = options;
    }

    @Argument(argumentName="tool", multiplicity="?")
    public void setTool(ToolModel<?> tool) {
        this.tool = tool;
    }

    public void setOut(Appendable out) {
        this.out = out;
    }

    @Override
    public void initialize(CeylonTool mainTool) {
        String option;
        Boolean wantsPager = mainTool.getWantsPager();
        if (wantsPager == null && (option = CeylonConfig.get().getOption("help.pager")) != null) {
            wantsPager = CeylonConfig.isFalsish(option) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (wantsPager == null && (option = CeylonConfig.get().getOption("defaults.pager")) != null) {
            wantsPager = CeylonConfig.isFalsish(option) ? Boolean.FALSE : Boolean.TRUE;
        }
        if ((wantsPager == null || wantsPager.booleanValue()) && System.console() != null) {
            this.wantsPager = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Doc doc;
        if (this.wantsPager && OSUtil.isWindows() && this.tool != null && this.openHelpInBrowser()) {
            return;
        }
        this.docBuilder.setIncludeHidden(this.includeHidden);
        if (this.tool != null) {
            doc = this.docBuilder.buildDoc(this.tool);
        } else {
            ToolModel root = this.toolLoader.loadToolModel("");
            doc = this.docBuilder.buildDoc(root, true);
        }
        Process pagerProcess = null;
        if (this.wantsPager && !OSUtil.isWindows()) {
            pagerProcess = this.startPager();
        }
        OutputStream pagerPipe = null;
        if (pagerProcess != null) {
            pagerPipe = pagerProcess.getOutputStream();
        }
        try {
            WordWrap wrap = this.getWrap(pagerPipe);
            Visitor plain = new PlainVisitor(wrap);
            if (this.synopsis) {
                plain = new SynopsisOnlyVisitor(plain);
            } else if (this.options != null) {
                plain = new OptionsOnlyVisitor(plain, new HashSet<String>(Arrays.asList(this.options.trim().split("\\s*,\\s*"))));
            }
            doc.accept(plain);
            wrap.flush();
        }
        finally {
            if (pagerPipe != null) {
                try {
                    pagerPipe.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    int errorCode = pagerProcess.waitFor();
                    if (errorCode != 0) {
                        throw new ToolUsageError("Pager process returned an error exit code: " + errorCode + ". Try fixing your $CEYLON_PAGER or $PAGER environment variable or invoke with the --no-pager command-line option.");
                    }
                }
                catch (InterruptedException e) {
                    throw new ToolUsageError("Pager process interrupted. Try fixing your $CEYLON_PAGER or $PAGER environment variable or invoke with the --no-pager command-line option.");
                }
            }
        }
    }

    private boolean openHelpInBrowser() {
        File docHome;
        File toolDocFile;
        String ceylonHome = System.getProperty("ceylon.home");
        if (ceylonHome == null || ceylonHome.isEmpty()) {
            return false;
        }
        String toolDoc = "ceylon";
        if (this.tool.getName() != null && !this.tool.getName().isEmpty()) {
            toolDoc = toolDoc + "-" + this.tool.getName();
        }
        if ((toolDocFile = new File(docHome = new File(ceylonHome, "doc/en/toolset/"), toolDoc = toolDoc + ".html")).exists() && toolDocFile.isFile()) {
            try {
                Desktop.getDesktop().browse(toolDocFile.toURI());
            }
            catch (Exception e) {
                throw new ToolUsageError("Could not open browser for uri '" + toolDocFile.toURI() + "'. Please invoke with the --no-pager command-line option.");
            }
            return true;
        }
        return false;
    }

    private Process startPager() {
        String option;
        String pager = System.getenv("CEYLON_PAGER");
        if (pager == null && (option = CeylonConfig.get().getOption("help.pager")) != null && !CeylonConfig.isTrueish(option) && !CeylonConfig.isFalsish(option)) {
            pager = option;
        }
        if (pager == null && (option = CeylonConfig.get().getOption("defaults.pager")) != null && !CeylonConfig.isTrueish(option) && !CeylonConfig.isFalsish(option)) {
            pager = option;
        }
        if (pager == null) {
            pager = System.getenv("PAGER");
        }
        if (pager == null) {
            pager = "less";
        }
        if (!pager.equals("cat")) {
            ProcessBuilder pb = new ProcessBuilder(pager);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            try {
                return pb.start();
            }
            catch (IOException e) {
                throw new ToolUsageError("Could not start pager process '" + pager + "'. Try fixing your $CEYLON_PAGER or $PAGER environment variable or invoke with the --no-pager command-line option.", e);
            }
        }
        return null;
    }

    private WordWrap getWrap(OutputStream pagerPipe) {
        Appendable destination = null;
        if (pagerPipe != null) {
            destination = new PrintStream(pagerPipe);
        }
        if (destination == null) {
            destination = this.out;
        }
        if (destination == null) {
            destination = this.synopsis || this.options != null ? System.err : System.out;
        }
        return new WordWrap(destination);
    }
}

