/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import com.redhat.ceylon.common.tool.ArgumentModel;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tools.help.AbstractMl;
import com.redhat.ceylon.common.tools.help.CeylonHelpToolMessages;
import com.redhat.ceylon.common.tools.help.DocBook;
import com.redhat.ceylon.common.tools.help.model.DescribedSection;
import com.redhat.ceylon.common.tools.help.model.Doc;
import com.redhat.ceylon.common.tools.help.model.Option;
import com.redhat.ceylon.common.tools.help.model.OptionsSection;
import com.redhat.ceylon.common.tools.help.model.SubtoolVisitor;
import com.redhat.ceylon.common.tools.help.model.SummarySection;
import com.redhat.ceylon.common.tools.help.model.SynopsesSection;
import com.redhat.ceylon.common.tools.help.model.Synopsis;
import com.redhat.ceylon.common.tools.help.model.Visitor;
import java.util.ResourceBundle;

public class DocBookVisitor
implements Visitor {
    private final DocBook docbook;
    private boolean hadFirstArgument;
    private boolean hadOptions;
    private Doc doc;
    private int optionsDepth = 0;
    private final boolean omitDoctype;
    private int openVariablelist;

    DocBookVisitor(Appendable out, boolean omitDoctype) {
        this.docbook = new DocBook(out);
        this.omitDoctype = omitDoctype;
    }

    AbstractMl getDocbook() {
        return this.docbook;
    }

    @Override
    public void start(Doc doc) {
        this.doc = doc;
        ResourceBundle bundle = CeylonHelpToolMessages.RESOURCE_BUNDLE;
        if (!this.omitDoctype) {
            ((DocBook)this.docbook.doctype("refentry PUBLIC \"-//OASIS//DTD DocBook XML V4.1.2//EN\"\n\"http://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd\"")).text("\n");
        }
        ((DocBook)this.docbook.open("refentry")).text("\n");
        ((DocBook)this.docbook.open("refmeta")).text("\n");
        ((DocBook)((DocBook)((DocBook)this.docbook.open("refentrytitle")).text(doc.getInvocation())).close("refentrytitle")).text("\n");
        ((DocBook)((DocBook)((DocBook)this.docbook.open("manvolnum")).text("1")).close("manvolnum")).text("\n");
        ((DocBook)this.docbook.close("refmeta")).text("\n");
    }

    @Override
    public void end(Doc doc) {
        this.docbook.close("refentry");
    }

    @Override
    public void visitAdditionalSection(DescribedSection describedSection) {
        this.describedSection(0, describedSection);
    }

    private void describedSection(int depth, DescribedSection describedSection) {
        if (depth > 2) {
            throw new RuntimeException("No refsect4");
        }
        ((DocBook)this.docbook.open("refsect" + (depth + 1))).text("\n");
        this.docbook.markdown(describedSection.getTitle()).text("\n");
        this.docbook.markdown(describedSection.getDescription());
        for (DescribedSection subsection : describedSection.getSubsections()) {
            this.describedSection(depth + 1, subsection);
        }
        ((DocBook)this.docbook.close("refsect" + (depth + 1))).text("\n");
    }

    @Override
    public void startOptions(OptionsSection optionsSection) {
        if (this.optionsDepth <= 2) {
            if (this.optionsDepth > 0) {
                this.docbook.close("variablelist");
                --this.openVariablelist;
            }
            ((DocBook)this.docbook.open("refsect" + (this.optionsDepth + 1))).text("\n");
            this.docbook.markdown(optionsSection.getTitle()).text("\n");
            ((DocBook)this.docbook.open("variablelist")).text("\n");
            ++this.openVariablelist;
        } else {
            throw new RuntimeException();
        }
        ++this.optionsDepth;
    }

    @Override
    public void visitOption(Option option) {
        String longName = option.getLongName();
        String shortName = option.getShortName();
        String argumentName = option.getArgumentName();
        OptionModel.ArgumentType argumentType = option.getOption().getArgumentType();
        ((DocBook)this.docbook.open("varlistentry")).text("\n");
        ((DocBook)this.docbook.open("term")).text(longName);
        if (argumentType == OptionModel.ArgumentType.OPTIONAL) {
            this.docbook.text("[");
        }
        if (argumentType != OptionModel.ArgumentType.NOT_ALLOWED) {
            ((DocBook)((DocBook)((DocBook)this.docbook.text("=")).open("replaceable")).text(argumentName)).close("replaceable");
        }
        if (argumentType == OptionModel.ArgumentType.OPTIONAL) {
            this.docbook.text("]");
        }
        ((DocBook)this.docbook.close("term")).text("\n");
        if (shortName != null) {
            this.docbook.open("term");
            this.docbook.text(shortName);
            if (argumentType == OptionModel.ArgumentType.REQUIRED) {
                this.docbook.text(" ");
                ((DocBook)((DocBook)this.docbook.open("replaceable")).text(argumentName)).close("replaceable");
            }
            ((DocBook)this.docbook.close("term")).text("\n");
        }
        ((DocBook)this.docbook.open("listitem")).text("\n");
        this.docbook.markdown(option.getDescription());
        ((DocBook)this.docbook.close("listitem")).text("\n");
        ((DocBook)this.docbook.close("varlistentry")).text("\n");
    }

    @Override
    public void endOptions(OptionsSection optionsSection) {
        --this.optionsDepth;
        if (this.optionsDepth < 3) {
            if (this.openVariablelist > 0) {
                ((DocBook)this.docbook.close("variablelist")).text("\n");
                --this.openVariablelist;
            }
            ((DocBook)this.docbook.close("refsect" + (this.optionsDepth + 1))).text("\n");
        }
    }

    @Override
    public void visitSummary(SummarySection summarySection) {
        ((DocBook)this.docbook.open("refnamediv")).text("\n");
        ((DocBook)((DocBook)((DocBook)this.docbook.open("refname")).text(this.doc.getInvocation())).close("refname")).text("\n");
        ((DocBook)((DocBook)((DocBook)this.docbook.open("refpurpose")).text(this.doc.getSummary().getSummary())).close("refpurpose")).text("\n");
        ((DocBook)this.docbook.close("refnamediv")).text("\n");
    }

    @Override
    public void startSynopses(SynopsesSection synopsesSection) {
        ((DocBook)this.docbook.open("refsynopsisdiv")).text("\n");
    }

    private void longOptionSynopsis(OptionModel<?> option) {
        this.docbook.text("--" + option.getLongName());
    }

    private void shortOptionSynopsis(OptionModel<?> option) {
        this.docbook.text("-" + option.getShortName());
    }

    private void argumentSynopsis(String name) {
        this.docbook.text(name);
    }

    private void subtoolSynopsis(SubtoolVisitor.ToolModelAndSubtoolModel nast) {
        String name = nast.getName();
        ((DocBook)((DocBook)((DocBook)this.docbook.open("arg choice=\"plain\"")).text(name)).close("arg")).text("\n");
    }

    private void multiplicity(ArgumentModel<?> argument, String name) {
        ((DocBook)((DocBook)this.docbook.open("replaceable")).text(name)).close("replaceable");
        if (argument.getMultiplicity().isMultivalued()) {
            this.docbook.text("...");
        }
    }

    @Override
    public void startSynopsis(Synopsis synopsis) {
        this.hadFirstArgument = false;
        this.hadOptions = false;
        ((DocBook)this.docbook.open("cmdsynopsis")).text("\n");
        ((DocBook)((DocBook)((DocBook)this.docbook.open("command")).text(this.doc.getInvocation())).close("command")).text("\n");
    }

    @Override
    public void endSynopsis(Synopsis synopsis) {
        ((DocBook)this.docbook.close("cmdsynopsis")).text("\n");
    }

    @Override
    public void visitSynopsisArgument(ArgumentModel<?> argument) {
        if (!this.hadFirstArgument) {
            ((DocBook)((DocBook)((DocBook)this.docbook.open("arg choice=\"opt\"")).text("--")).close("arg")).text("\n");
            this.hadFirstArgument = true;
        }
        String argTag = "arg";
        argTag = argument.getMultiplicity().isRequired() ? argTag + " choice=\"req\"" : argTag + " choice=\"opt\"";
        if (argument.getMultiplicity().isMultivalued()) {
            argTag = argTag + " rep=\"repeat\"";
        }
        ((DocBook)((DocBook)((DocBook)this.docbook.open(argTag)).text(argument.getName())).close("arg")).text("\n");
    }

    @Override
    public void visitSynopsisOption(OptionModel<?> option) {
        this.hadOptions = true;
        String argTag = "arg";
        ArgumentModel<?> argument = option.getArgument();
        argTag = argument.getMultiplicity().isRequired() ? argTag + " choice=\"req\"" : argTag + " choice=\"opt\"";
        this.docbook.open(argTag);
        if (option.getLongName() != null) {
            this.longOptionSynopsis(option);
            if (option.getArgumentType() == OptionModel.ArgumentType.REQUIRED) {
                this.docbook.text("=");
                this.multiplicity(argument, argument.getName());
            } else if (option.getArgumentType() == OptionModel.ArgumentType.OPTIONAL) {
                this.docbook.text("[=");
                this.multiplicity(argument, argument.getName());
                this.docbook.text("]");
            }
        } else {
            this.shortOptionSynopsis(option);
            if (option.getArgumentType() == OptionModel.ArgumentType.REQUIRED) {
                this.multiplicity(argument, argument.getName());
            }
        }
        ((DocBook)this.docbook.close("arg")).text("\n");
    }

    @Override
    public void endSynopses(SynopsesSection synopsesSection) {
        ((DocBook)this.docbook.close("refsynopsisdiv")).text("\n");
    }

    @Override
    public void visitDescription(DescribedSection descriptionSection) {
        this.describedSection(0, descriptionSection);
    }

    @Override
    public void visitSynopsisSubtool(SubtoolVisitor.ToolModelAndSubtoolModel option) {
        this.subtoolSynopsis(option);
    }
}

