/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import com.redhat.ceylon.common.tools.help.AbstractMarkdownVisitor;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tautua.markdownpapers.ast.Document;
import org.tautua.markdownpapers.ast.Header;
import org.tautua.markdownpapers.ast.Node;
import org.tautua.markdownpapers.ast.ResourceDefinition;
import org.tautua.markdownpapers.ast.SimpleNode;
import org.tautua.markdownpapers.ast.Text;
import org.tautua.markdownpapers.parser.ParseException;
import org.tautua.markdownpapers.parser.Parser;

public class Markdown {
    public static Document markdown(String markdown) {
        Parser parser = new Parser(new StringReader(markdown.replaceAll("\\s+$", "")));
        try {
            return parser.parse();
        }
        catch (ParseException e) {
            throw new RuntimeException();
        }
    }

    static Header header(int level, String text) {
        Header header = new Header(2);
        header.setLevel(level);
        Text t = new Text(13);
        t.jjtSetValue(text);
        header.jjtAddChild(t, 0);
        return header;
    }

    static Node getFirstSibling(Node node) {
        return node.jjtGetParent().jjtGetChild(0);
    }

    static Node getLastSibling(Node node) {
        Node parent = node.jjtGetParent();
        return parent.jjtGetChild(parent.jjtGetNumChildren() - 1);
    }

    static int getIndexInParent(Node node) {
        Node parent = node.jjtGetParent();
        for (int ii = 0; ii < parent.jjtGetNumChildren(); ++ii) {
            if (parent.jjtGetChild(ii) != node) continue;
            return ii;
        }
        throw new IllegalStateException();
    }

    static Node getPrev(Node node) {
        Node parent = node.jjtGetParent();
        int ii = Markdown.getIndexInParent(node);
        return ii > 0 ? parent.jjtGetChild(ii - 1) : null;
    }

    static Node getNext(Node node) {
        Node parent = node.jjtGetParent();
        int ii = Markdown.getIndexInParent(node);
        return ii < parent.jjtGetNumChildren() - 1 ? parent.jjtGetChild(ii + 1) : null;
    }

    public static List<Section> extractSections(Document document) {
        SectionsMarkdownVisitor v = new SectionsMarkdownVisitor();
        document.accept(v);
        ArrayList<Section> result = new ArrayList<Section>();
        for (int levelIndex = 1; levelIndex <= 6; ++levelIndex) {
            List sections = (List)v.sections.get(levelIndex);
            if (sections == null) continue;
            Header header = (Header)sections.get(0);
            Node parent = header.jjtGetParent();
            Document doc = Markdown.extractBetween(v, parent, null, header);
            result.add(new Section(null, doc));
            for (int sectionIndex = 0; sectionIndex < sections.size(); ++sectionIndex) {
                Header header2 = (Header)sections.get(sectionIndex);
                Header next = sectionIndex < sections.size() - 1 ? (Header)sections.get(sectionIndex + 1) : null;
                Document doc2 = Markdown.extractBetween(v, parent, header2, next);
                result.add(new Section(header2, doc2));
            }
            break;
        }
        return result;
    }

    private static Document extractBetween(SectionsMarkdownVisitor v, Node parent, Header header1, Header header2) {
        Document doc = new Document(0);
        int numChildren = parent.jjtGetNumChildren();
        int start = header1 != null ? Markdown.getIndexInParent(header1) + 1 : 0;
        int end = header2 != null ? Markdown.getIndexInParent(header2) - 1 : numChildren - 1;
        for (int nodeIndex = start; nodeIndex <= end; ++nodeIndex) {
            Node child = parent.jjtGetChild(nodeIndex);
            child.jjtSetParent(doc);
            doc.jjtAddChild(child, nodeIndex - start);
        }
        for (ResourceDefinition rd : v.resourceDefinitions) {
            ResourceDefinition copy = Markdown.copy(rd);
            copy.jjtSetParent(doc);
            doc.jjtAddChild(copy, doc.jjtGetNumChildren());
        }
        return doc;
    }

    private static ResourceDefinition copy(ResourceDefinition rd) {
        ResourceDefinition copy = new ResourceDefinition(8);
        copy.setId(rd.getId());
        copy.setResource(rd.getResource());
        return copy;
    }

    public static void adjustHeadings(Document document, final int increment) {
        document.accept(new AbstractMarkdownVisitor(){

            @Override
            public void visit(Header header) {
                header.setLevel(header.getLevel() + increment);
            }
        });
    }

    public static class Section {
        private Header heading;
        private Document doc;

        public Section(Header heading, Document doc) {
            this.heading = heading;
            this.doc = doc;
        }

        public Header getHeading() {
            return this.heading;
        }

        public Document getDoc() {
            return this.doc;
        }
    }

    private static class SectionsMarkdownVisitor
    extends AbstractMarkdownVisitor {
        private Map<Integer, List<Header>> sections = new HashMap<Integer, List<Header>>();
        private List<ResourceDefinition> resourceDefinitions = new ArrayList<ResourceDefinition>();

        private SectionsMarkdownVisitor() {
        }

        @Override
        public void visit(Header arg0) {
            List<Header> headers = this.sections.get(arg0.getLevel());
            if (headers == null) {
                headers = new ArrayList<Header>();
                this.sections.put(arg0.getLevel(), headers);
            }
            headers.add(arg0);
        }

        @Override
        public void visit(ResourceDefinition node) {
            this.resourceDefinitions.add(node);
        }

        @Override
        public void visit(SimpleNode that) {
            if (!this.sections.isEmpty() || that instanceof Header || !(that instanceof ResourceDefinition)) {
                // empty if block
            }
            super.visit(that);
        }
    }
}

