/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import com.redhat.ceylon.common.tool.ArgumentModel;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.WordWrap;
import com.redhat.ceylon.common.tools.help.CeylonHelpToolMessages;
import com.redhat.ceylon.common.tools.help.Markdown;
import com.redhat.ceylon.common.tools.help.PlaintextMarkdownVisitor;
import com.redhat.ceylon.common.tools.help.model.DescribedSection;
import com.redhat.ceylon.common.tools.help.model.Doc;
import com.redhat.ceylon.common.tools.help.model.Option;
import com.redhat.ceylon.common.tools.help.model.OptionsSection;
import com.redhat.ceylon.common.tools.help.model.SubtoolVisitor;
import com.redhat.ceylon.common.tools.help.model.SummarySection;
import com.redhat.ceylon.common.tools.help.model.SynopsesSection;
import com.redhat.ceylon.common.tools.help.model.Synopsis;
import com.redhat.ceylon.common.tools.help.model.Visitor;
import org.tautua.markdownpapers.ast.Node;

public class PlainVisitor
implements Visitor {
    private int numOptions;
    protected final WordWrap out;
    protected String ceylonName;
    boolean hadFirstArgument = false;
    private boolean hadOptions;
    private boolean suboptions;
    private boolean hasSubTools;
    private boolean skipInvocation;
    private boolean firstSynopsis;

    public PlainVisitor(WordWrap wrap) {
        this.out = wrap;
    }

    private void markdown(Node doc) {
        PlaintextMarkdownVisitor markdownVisitor = new PlaintextMarkdownVisitor(this.out);
        doc.accept(markdownVisitor);
    }

    @Override
    public void start(Doc doc) {
        this.ceylonName = doc.getInvocation();
        this.hasSubTools = doc.getSynopses().getSynopses().size() > 1;
        this.firstSynopsis = true;
    }

    @Override
    public void end(Doc doc) {
        this.out.flush();
    }

    private String multiplicity(ArgumentModel<?> argument, String name) {
        name = "<" + name + ">";
        if (argument.getMultiplicity().isMultivalued()) {
            name = name + "...";
        }
        return name;
    }

    @Override
    public void startSynopsis(Synopsis synopsis) {
        int indent = this.out.getIndentFirstLine();
        String invocation = synopsis.getInvocation();
        this.out.setIndentRestLines(indent + invocation.length() + 1);
        if (!this.hasSubTools || this.firstSynopsis) {
            this.out.append(invocation);
        } else {
            this.out.append("*");
        }
        this.skipInvocation = this.hasSubTools && !this.firstSynopsis;
        this.hadFirstArgument = false;
        this.hadOptions = false;
    }

    @Override
    public void endSynopsis(Synopsis synopsis) {
        this.out.newline();
        if (this.hasSubTools) {
            this.out.newline();
        }
    }

    @Override
    public void visitSynopsisArgument(ArgumentModel<?> argument) {
        if (this.skipInvocation) {
            return;
        }
        if (this.hadOptions && !this.hadFirstArgument) {
            this.out.append(" [--]");
            this.hadFirstArgument = true;
        }
        this.out.append(" ");
        String name = argument.getName();
        if (!argument.getMultiplicity().isRequired()) {
            this.out.append("[");
        }
        this.out.append("<" + name);
        if (argument.getMultiplicity().isMultivalued()) {
            this.out.append("...");
        }
        this.out.append(">");
        if (!argument.getMultiplicity().isRequired()) {
            this.out.append("]");
        }
    }

    @Override
    public void visitSynopsisSubtool(SubtoolVisitor.ToolModelAndSubtoolModel option) {
        String name = option.getModel().getName();
        if (this.hasSubTools) {
            if (this.firstSynopsis) {
                this.out.append(" ");
                this.out.append(CeylonHelpToolMessages.msg("synopsis.subtool.commands", new Object[0]));
                this.out.newline();
                this.out.newline();
                this.out.append(CeylonHelpToolMessages.msg("synopsis.subtool.list", new Object[0]));
                this.out.newline();
                this.out.newline();
                this.out.append("*");
            }
            this.out.append(" ");
        } else {
            this.out.append(" ");
        }
        this.out.append(name);
        this.firstSynopsis = false;
        this.skipInvocation = false;
    }

    @Override
    public void visitSynopsisOption(OptionModel<?> option) {
        if (this.skipInvocation) {
            return;
        }
        this.hadOptions = true;
        this.out.append(" ");
        ArgumentModel<?> argument = option.getArgument();
        if (!argument.getMultiplicity().isRequired()) {
            this.out.append("[");
        }
        if (option.getLongName() != null) {
            this.out.append("--" + option.getLongName());
            if (option.getArgumentType() == OptionModel.ArgumentType.REQUIRED) {
                this.out.append("=");
                this.out.append(this.multiplicity(argument, argument.getName()));
            } else if (option.getArgumentType() == OptionModel.ArgumentType.OPTIONAL) {
                this.out.append("[=");
                this.out.append(this.multiplicity(argument, argument.getName()));
                this.out.append("]");
            }
        } else {
            this.out.append("-" + option.getShortName());
            if (option.getArgumentType() == OptionModel.ArgumentType.REQUIRED) {
                this.out.append(" ");
                this.out.append(this.multiplicity(argument, argument.getName()));
            }
        }
        if (!argument.getMultiplicity().isRequired()) {
            this.out.append("]");
        }
    }

    @Override
    public void startSynopses(SynopsesSection synopsesSection) {
        this.out.append(synopsesSection.getTitle().toUpperCase()).newline().newline();
        this.out.setIndent(8);
        this.hasSubTools = synopsesSection.getSynopses().size() > 1;
        this.firstSynopsis = true;
    }

    @Override
    public void endSynopses(SynopsesSection synopsesSection) {
        this.out.setIndent(0);
        this.out.newline();
        this.out.newline();
    }

    @Override
    public void startOptions(OptionsSection optionsSection) {
        if (this.suboptions) {
            this.out.setIndent(3);
        }
        this.markdown(optionsSection.getTitle());
        this.out.setIndent(8);
        this.suboptions = true;
    }

    @Override
    public void visitOption(Option option) {
        String shortName = option.getShortName();
        String longName = option.getLongName();
        String argumentName = option.getArgumentName();
        OptionModel.ArgumentType argumentType = option.getOption().getArgumentType();
        ++this.numOptions;
        this.out.append(longName);
        if (argumentType == OptionModel.ArgumentType.OPTIONAL) {
            this.out.append("[");
        }
        if (argumentType != OptionModel.ArgumentType.NOT_ALLOWED) {
            this.out.append("=<" + argumentName + ">");
        }
        if (argumentType == OptionModel.ArgumentType.OPTIONAL) {
            this.out.append("]");
        }
        if (shortName != null) {
            this.out.append(", ");
            this.out.append(shortName);
            if (argumentType == OptionModel.ArgumentType.REQUIRED) {
                this.out.append(" ");
                this.out.append("<" + argumentName + ">");
            }
        }
        this.out.setIndent(12);
        this.out.newline();
        this.markdown(option.getDescription());
        this.out.newline();
        this.out.setIndent(8);
    }

    @Override
    public void endOptions(OptionsSection optionsSection) {
        if (this.numOptions == 0) {
            this.out.append(this.ceylonName + " has no options").newline();
        }
        this.out.setIndent(0);
        this.out.newline();
    }

    @Override
    public void visitAdditionalSection(DescribedSection describedSection) {
        this.describedSection(describedSection);
    }

    private void describedSection(DescribedSection describedSection) {
        this.markdown(describedSection.getTitle());
        this.markdown(describedSection.getDescription());
        for (DescribedSection subsection : describedSection.getSubsections()) {
            this.describedSection(subsection);
        }
        this.out.setIndent(0);
        this.out.newline();
    }

    @Override
    public void visitSummary(SummarySection summarySection) {
        this.markdown(summarySection.getTitle());
        this.markdown(Markdown.markdown("`" + this.ceylonName + "` - " + summarySection.getSummary()));
        this.out.setIndent(0);
        this.out.newline();
    }

    @Override
    public void visitDescription(DescribedSection descriptionSection) {
        this.describedSection(descriptionSection);
    }
}

