/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import com.redhat.ceylon.common.tool.WordWrap;
import com.redhat.ceylon.common.tools.help.AbstractMarkdownVisitor;
import com.redhat.ceylon.common.tools.help.Markdown;
import org.tautua.markdownpapers.ast.CharRef;
import org.tautua.markdownpapers.ast.Code;
import org.tautua.markdownpapers.ast.CodeSpan;
import org.tautua.markdownpapers.ast.CodeText;
import org.tautua.markdownpapers.ast.Document;
import org.tautua.markdownpapers.ast.Emphasis;
import org.tautua.markdownpapers.ast.Header;
import org.tautua.markdownpapers.ast.Image;
import org.tautua.markdownpapers.ast.InlineUrl;
import org.tautua.markdownpapers.ast.Item;
import org.tautua.markdownpapers.ast.Line;
import org.tautua.markdownpapers.ast.LineBreak;
import org.tautua.markdownpapers.ast.Link;
import org.tautua.markdownpapers.ast.List;
import org.tautua.markdownpapers.ast.Node;
import org.tautua.markdownpapers.ast.Paragraph;
import org.tautua.markdownpapers.ast.Quote;
import org.tautua.markdownpapers.ast.Resource;
import org.tautua.markdownpapers.ast.Ruler;
import org.tautua.markdownpapers.ast.Tag;
import org.tautua.markdownpapers.ast.Text;

public class PlaintextMarkdownVisitor
extends AbstractMarkdownVisitor {
    private WordWrap out;
    private int headerLevel = -1;
    private boolean inCode;

    public PlaintextMarkdownVisitor(WordWrap out) {
        this.out = out;
    }

    @Override
    public void visit(Header node) {
        Node parent = node.jjtGetParent();
        for (int ii = 0; ii < parent.jjtGetNumChildren(); ++ii) {
            if (parent.jjtGetChild(ii) == node && ii != 0) continue;
        }
        switch (node.getLevel()) {
            case 1: 
            case 2: {
                this.out.setIndent(0);
                break;
            }
            case 3: {
                this.out.setIndent(3);
                break;
            }
            case 4: {
                this.out.setIndent(5);
                break;
            }
            case 5: {
                this.out.setIndent(6);
                break;
            }
            default: {
                this.out.setIndent(7);
            }
        }
        if (!(node.jjtGetParent() instanceof Document) || Markdown.getIndexInParent(node) != 0) {
            this.out.newline();
        }
        switch (node.getLevel()) {
            case 1: {
                int col = this.out.getColumn();
                this.headerLevel = node.getLevel();
                node.childrenAccept(this);
                this.headerLevel = -1;
                int num = this.out.getColumn() - col;
                this.out.newline();
                for (int ii = 0; ii < num; ++ii) {
                    this.out.append("=");
                }
                this.out.newline();
                this.out.setIndent(8);
                break;
            }
            default: {
                this.headerLevel = node.getLevel();
                node.childrenAccept(this);
                this.headerLevel = -1;
                this.out.newline();
                this.out.setIndent(8);
            }
        }
        this.out.newline();
    }

    @Override
    public void visit(Item node) {
        int rest = this.out.getIndentRestLines();
        if (((List)node.jjtGetParent()).isOrdered()) {
            for (int ii = 0; ii < node.jjtGetParent().jjtGetNumChildren(); ++ii) {
                if (node.jjtGetParent().jjtGetChild(ii) != node) continue;
                this.out.append(ii + 1 + ". ");
                this.out.setIndent(rest + 3);
                break;
            }
        } else {
            this.out.append("* ");
            this.out.setIndent(rest + 2);
        }
        node.childrenAccept(this);
        this.out.setIndent(rest);
        this.out.newline().newline();
    }

    @Override
    public void visit(Paragraph node) {
        node.childrenAccept(this);
        if (!(node.jjtGetParent() instanceof Item)) {
            this.out.newline().newline();
        }
    }

    @Override
    public void visit(Quote node) {
        this.out.setPrefix("> ");
        node.childrenAccept(this);
        this.out.setPrefix(null);
    }

    @Override
    public void visit(CodeText node) {
        this.out.append(node.getValue());
        this.out.newline();
    }

    @Override
    public void visit(Code node) {
        this.inCode = true;
        node.childrenAccept(this);
        this.inCode = false;
    }

    @Override
    public void visit(Ruler node) {
        this.out.newline();
        this.out.column(this.out.getWidth() / 2 - 2);
        this.out.append("* * *").newline().newline();
    }

    @Override
    public void visit(Tag node) {
        this.out.append("<").append(node.getName()).append(">");
        node.childrenAccept(this);
        this.out.append("</").append(node.getName()).append(">");
    }

    @Override
    public void visit(CharRef node) {
        this.out.append(node.getValue());
    }

    @Override
    public void visit(CodeSpan node) {
        String text = node.getText();
        if (this.uppercaseText()) {
            text = text.toUpperCase();
        }
        this.out.append("'").append(text).append("'");
    }

    @Override
    public void visit(Emphasis node) {
        String text = node.getText();
        if (this.uppercaseText()) {
            text = text.toUpperCase();
        }
        switch (node.getType()) {
            case ITALIC_AND_BOLD: 
            case BOLD: {
                text = text.toUpperCase();
                break;
            }
        }
        this.out.append(text);
    }

    @Override
    public void visit(Image node) {
        node.childrenAccept(this);
    }

    @Override
    public void visit(Line node) {
        node.childrenAccept(this);
        if (!node.isEmpty() && !node.isEnding()) {
            if (this.inCode && Markdown.getNext(node) != null) {
                this.out.append("");
            } else if (!this.inCode) {
                this.out.append(" ");
            }
        }
        if (node.isEmpty() && this.inCode) {
            this.out.newline();
        }
    }

    @Override
    public void visit(LineBreak node) {
        this.out.append(" ");
        node.childrenAccept(this);
    }

    @Override
    public void visit(Link node) {
        Resource resource = node.getResource();
        if (resource == null) {
            Node doc = node.jjtGetParent();
            while (!(doc instanceof Document)) {
                doc = doc.jjtGetParent();
            }
            resource = ((Document)doc).findResource(node.getReference());
        }
        if (resource != null) {
            this.out.append(node.getText()).append(" (").append(resource.getLocation()).append(")");
        } else {
            this.out.append(node.getText());
        }
    }

    @Override
    public void visit(InlineUrl node) {
        this.out.append(node.getUrl());
    }

    @Override
    public void visit(Text node) {
        if (node.isWhitespace() && this.headerLevel >= 1 && node.jjtGetParent().jjtGetChild(0) == node) {
            return;
        }
        String text = node.getValue();
        if (this.uppercaseText()) {
            text = text.toUpperCase();
        }
        this.out.append(text);
    }

    private boolean uppercaseText() {
        return this.headerLevel == 1 || this.headerLevel == 2;
    }
}

