/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler;

import com.redhat.ceylon.common.Messages;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class CeylonCompileMessages
extends Messages {
    public static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.redhat.ceylon.compiler.resources.messages");

    public static String msg(String msgKey, Object ... msgArgs) {
        return CeylonCompileMessages.msg(RESOURCE_BUNDLE, msgKey, msgArgs);
    }

    static String msgCompilerErrors(int numErrors) {
        MessageFormat fmt = new MessageFormat("");
        fmt.setLocale(Locale.getDefault());
        double[] limits = new double[]{1.0, 2.0};
        String[] keys = new String[]{RESOURCE_BUNDLE.getString("compile.errors.one"), RESOURCE_BUNDLE.getString("compile.errors.several")};
        ChoiceFormat choice = new ChoiceFormat(limits, keys);
        fmt.applyPattern(RESOURCE_BUNDLE.getString("compile.errors.pattern"));
        Format[] formats = new Format[]{choice, NumberFormat.getInstance()};
        fmt.setFormats(formats);
        return fmt.format(new Object[]{numErrors});
    }

    static String msgSystemError() {
        return CeylonCompileMessages.msg("error.system", new Object[0]) + CeylonCompileMessages.msg("error.report.url", new Object[0]) + CeylonCompileMessages.msg("error.report.list", new Object[0]) + CeylonCompileMessages.msg("error.report.description", new Object[0]) + CeylonCompileMessages.msg("error.report.thanks", new Object[0]);
    }

    static String msgBug(int code, Throwable cause, boolean stackDumpedAbove) {
        String message = CeylonCompileMessages.msg("error.bug", code) + CeylonCompileMessages.msg("error.report.url", new Object[0]);
        message = message + CeylonCompileMessages.msg("error.report.list", new Object[0]);
        if (stackDumpedAbove) {
            message = message + CeylonCompileMessages.msg("error.report.stacktrace.above", new Object[0]);
        }
        if (cause != null) {
            message = message + CeylonCompileMessages.msg("error.report.stacktrace.below", new Object[0]);
        }
        message = message + CeylonCompileMessages.msg("error.report.description", new Object[0]);
        message = message + CeylonCompileMessages.msg("error.report.thanks", new Object[0]);
        return message;
    }
}

