/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler;

import com.redhat.ceylon.cmr.ceylon.OutputRepoUsingTool;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.EnumUtil;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleWildcardsHelper;
import com.redhat.ceylon.common.tools.SourceArgumentsResolver;
import com.redhat.ceylon.compiler.CeylonCompileMessages;
import com.redhat.ceylon.compiler.CompilerBugException;
import com.redhat.ceylon.compiler.CompilerErrorException;
import com.redhat.ceylon.compiler.SystemErrorException;
import com.redhat.ceylon.compiler.java.launcher.Main;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.langtools.tools.javac.main.JavacOption;
import com.redhat.ceylon.langtools.tools.javac.main.OptionName;
import com.redhat.ceylon.langtools.tools.javac.main.RecognizedOptions;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

@Summary(value="Compiles Ceylon and Java source code and directly produces module and source archives in a module repository.")
@Description(value="The default module repositories are `modules` and `https://modules.ceylon-lang.org/repo/1`, while the default source directory is `source` and the default resource directory is `resource`. The default output module repository is `modules`.\n\nThe `<moduleOrFile>` arguments can be either module names (without versions) or file paths specifying the Ceylon or Java source code to compile.\n\nWhen `<moduleOrFile>` specifies a module the compiler searches for compilation units and resource files belonging to the specified modules in the specified source and resource directories. For each specified module, the compiler generates a module archive, source archive, and their checksum files in the specified output module repository.\n\nWhen `<moduleOrFile>` specifies a source file only that file is compiled and the module archive is created or updated with the .class files produced. The source file path is treated as relative to the current directory (it still needs to be located either in the default source folder or in any folder defined by the configuration file or `--source` options!).\n\nWhen `<moduleOrFile>` specifies a resource file only that file is added to the module archive. The resource file path is treated as relative to the current directory (it still needs to be located either in the default resource folder or in any folder defined by the configuration file or `--resource` options!).\n\nAll program elements imported by a compilation unit must belong to the same module as the compilation unit, or must belong to a module that is explicitly imported in the module descriptor.\n\nThe compiler searches for dependencies in the following locations:\n\n* module archives in the specified repositories,\n* source archives in the specified repositories, and\n* module directories in the specified source directories.\n")
@RemainingSections(value="## Configuration file\n\nThe compile tool accepts the following options from the Ceylon configuration file: `defaults.offline`, `defaults.encoding`, `compiler.source`, `compiler.resource` and `repositories` (the equivalent options on the command line always have precedence).\n\n## Repositories\n\nRepositories like those specified with the `--rep` or `--out` options can be file paths, HTTP urls to remote servers or can be names of repositories when prepended with a `+` symbol. These names refer to repositories defined in the configuration file or can be any of the following predefined names `+SYSTEM`, `+CACHE`, `+LOCAL`, `+USER`, `+REMOTE` or `+MAVEN`. For more information see http://ceylon-lang.org/documentation/1.2/reference/repository/tools\n\n## Specifying `javac` options\n\nIt is possible to pass options to the `javac` compiler by prefixing them with `--javac=` and separating the javac option from its argument (if any) using another `=`. For example:\n\n* The option `--javac=-target=1.6` is equivalent to `javac`'s `-target 1.6` and,\n* the option `--javac=-g:none` is equivalent to `javac`'s `-g:none`\n\nExecute `ceylon compile --javac=-help` for a list of the standard javac options, and ceylon compile --javac=-X for a list of the non-standard javac options.\n\n**Important note**: There is no guarantee that any particular `javac` option or combination of options will work, or continue to work in future releases.")
public class CeylonCompileTool
extends OutputRepoUsingTool {
    private static final Helper HELPER = new Helper();
    private List<File> sources = DefaultToolOptions.getCompilerSourceDirs();
    private List<File> resources = DefaultToolOptions.getCompilerResourceDirs();
    private List<String> modulesOrFiles = Arrays.asList("*");
    private boolean continueOnErrors;
    private boolean progress;
    private List<String> javac = Collections.emptyList();
    private String encoding;
    private String resourceRoot = DefaultToolOptions.getCompilerResourceRootName();
    private boolean noOsgi = DefaultToolOptions.getCompilerNoOsgi();
    private String osgiProvidedBundles = DefaultToolOptions.getCompilerOsgiProvidedBundles();
    private boolean noPom = DefaultToolOptions.getCompilerNoPom();
    private boolean pack200 = DefaultToolOptions.getCompilerPack200();
    private EnumSet<Warning> suppressWarnings = EnumUtil.enumsFromStrings(Warning.class, DefaultToolOptions.getCompilerSuppressWarnings());
    private boolean flatClasspath;
    private boolean autoExportMavenDependencies;
    private boolean jigsaw = DefaultToolOptions.getCompilerGenerateModuleInfo();
    private List<String> arguments;
    private Main compiler;

    public CeylonCompileTool() {
        super(CeylonCompileMessages.RESOURCE_BUNDLE);
    }

    @Option(longName="flat-classpath")
    @Description(value="Launches the Ceylon module using a flat classpath.")
    public void setFlatClasspath(boolean flatClasspath) {
        this.flatClasspath = flatClasspath;
    }

    @Option(longName="auto-export-maven-dependencies")
    @Description(value="When using JBoss Modules (the default), treats all module dependencies between Maven modules as shared.")
    public void setAutoExportMavenDependencies(boolean autoExportMavenDependencies) {
        this.autoExportMavenDependencies = autoExportMavenDependencies;
    }

    @Option(longName="no-osgi")
    @Description(value="Indicates that the generated car file should not contain OSGi module declarations.")
    public void setNoOsgi(boolean noOsgi) {
        this.noOsgi = noOsgi;
    }

    @OptionArgument(longName="osgi-provided-bundles", argumentName="modules")
    @Description(value="Comma-separated list of module names. The listed modules are expected to be OSGI bundles provided by the framework, and will be omitted from the generated MANIFEST 'Required-Bundle' OSGI header.")
    public void setOsgiProvidedBundles(String osgiProvidedBundles) {
        this.osgiProvidedBundles = osgiProvidedBundles;
    }

    @Option(longName="generate-module-info")
    @Description(value="Generate Java 9 (Jigsaw) `module-info.class` module descriptor in the generated Ceylon archive.")
    public void setJigsaw(boolean jigsaw) {
        this.jigsaw = jigsaw;
    }

    @Option(longName="no-pom")
    @Description(value="Indicates that the generated car file should not contain Maven POM module declarations.")
    public void setNoPom(boolean noPom) {
        this.noPom = noPom;
    }

    @Option(longName="pack200")
    @Description(value="Try to make the generated car file smaller by repacking it using `pack200`.")
    public void setPack200(boolean pack200) {
        this.pack200 = pack200;
    }

    @OptionArgument(shortName=115, longName="src", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="Path to directory containing source files. Can be specified multiple times; you can also specify several paths separated by your operating system's `PATH` separator. (default: `./source`)")
    public void setSrc(List<File> source) {
        this.sources = source;
    }

    @OptionArgument(longName="source", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="An alias for `--src` (default: `./source`)")
    public void setSource(List<File> source) {
        this.setSrc(source);
    }

    @OptionArgument(shortName=114, longName="resource", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="Path to directory containing resource files. Can be specified multiple times; you can also specify several paths separated by your operating system's `PATH` separator. (default: `./resource`)")
    public void setResource(List<File> resource) {
        this.resources = resource;
    }

    @OptionArgument(shortName=82, argumentName="folder-name")
    @Description(value="Sets the special resource folder name whose files will end up in the root of the resulting module CAR file (default: ROOT).")
    public void setResourceRoot(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    @Hidden
    @Option(longName="continue-on-errors")
    @Description(value="Set to continue compiling even when errors are found.")
    public void setContinueOnErrors(boolean continueOnErrors) {
        this.continueOnErrors = continueOnErrors;
    }

    @Option(longName="progress")
    @Description(value="Print progress information.")
    public void setProgress(boolean progress) {
        this.progress = progress;
    }

    @OptionArgument(shortName=69, argumentName="encoding")
    @Description(value="Sets the encoding used for reading source files(default: platform-specific).")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Argument(argumentName="moduleOrFile", multiplicity="*")
    public void setModule(List<String> moduleOrFile) {
        this.modulesOrFiles = moduleOrFile;
    }

    @Override
    @Option(shortName=100)
    @OptionArgument(argumentName="flags")
    @Description(value="Produce verbose output. If no `flags` are given then be verbose about everything, otherwise just be verbose about the flags which are present. Allowed flags include: `all`, `loader`, `ast`, `code`, `cmr`, `benchmark`.")
    public void setVerbose(String verbose) {
        super.setVerbose(verbose);
    }

    @OptionArgument(argumentName="option")
    @Description(value="Passes an option to the underlying java compiler.")
    public void setJavac(List<String> javac) {
        this.javac = javac;
    }

    @Option(shortName=87)
    @OptionArgument(argumentName="warnings")
    @Description(value="Suppress the reporting of the given warnings. If no `warnings` are given then suppresss the reporting of all warnings, otherwise just suppresss those which are present. Allowed flags include: `filenameNonAscii`, `filenameCaselessCollision`, `deprecation`, `compilerAnnotation`, `doclink`, `expressionTypeNothing`, `unusedDeclaration`, `unusedImport`, `ceylonNamespace`, `javaNamespace`, `suppressedAlready`, `suppressesNothing`, `unknownWarning`, `ambiguousAnnotation`, `similarModule`, `importsOtherJdk`, `javaAnnotationElement`.")
    public void setSuppressWarning(EnumSet<Warning> warnings) {
        this.suppressWarnings = warnings;
    }

    @Override
    protected List<File> getSourceDirs() {
        return this.sources;
    }

    private static void validateWithJavac(Options options, JavacOption encodingOpt, String option, String argument, String key) {
        if (!encodingOpt.matches(option)) {
            throw new IllegalArgumentException(CeylonCompileMessages.msg(key, option));
        }
        CeylonCompileTool.HELPER.lastError = null;
        if (encodingOpt.hasArg() ? encodingOpt.process(options, option, argument) || CeylonCompileTool.HELPER.lastError != null : encodingOpt.process(options, option) || CeylonCompileTool.HELPER.lastError != null) {
            throw new IllegalArgumentException(CeylonCompileTool.HELPER.lastError);
        }
    }

    @Override
    public void initialize(CeylonTool mainTool) throws IOException {
        String fileEncoding;
        this.compiler = new Main("ceylon compile");
        Options options = Options.instance(new Context());
        if (this.modulesOrFiles.isEmpty() && !this.javac.contains("-help") && !this.javac.contains("-X") && !this.javac.contains("-version")) {
            throw new IllegalStateException("Argument moduleOrFile should appear at least 1 time(s)");
        }
        this.arguments = new ArrayList<String>();
        if (this.cwd != null) {
            this.arguments.add("-cwd");
            this.arguments.add(this.cwd.getPath());
        }
        for (File source : this.applyCwd(this.sources)) {
            this.arguments.add("-src");
            this.arguments.add(source.getPath());
            options.addMulti(OptionName.SOURCEPATH, source.getPath());
        }
        for (File resource : this.applyCwd(this.resources)) {
            this.arguments.add("-res");
            this.arguments.add(resource.getPath());
        }
        if (this.resourceRoot != null) {
            this.arguments.add("-resroot");
            this.arguments.add(this.resourceRoot);
        }
        if (this.continueOnErrors) {
            this.arguments.add("-continue");
        }
        if (this.progress) {
            this.arguments.add("-progress");
        }
        if (this.offline) {
            this.arguments.add("-offline");
        }
        if (this.timeout != -1) {
            this.arguments.add("-timeout");
            this.arguments.add(String.valueOf(this.timeout));
        }
        if (this.flatClasspath) {
            this.arguments.add("-flat-classpath");
        }
        if (this.autoExportMavenDependencies) {
            this.arguments.add("-auto-export-maven-dependencies");
        }
        if (this.overrides != null) {
            this.arguments.add("-overrides");
            if (this.overrides.startsWith("classpath:")) {
                this.arguments.add(this.overrides);
            } else {
                this.arguments.add(this.applyCwd(new File(this.overrides)).getPath());
            }
        }
        if (this.jigsaw) {
            this.arguments.add("-module-info");
        }
        if (this.noOsgi) {
            this.arguments.add("-noosgi");
        }
        if (this.osgiProvidedBundles != null && !this.osgiProvidedBundles.isEmpty()) {
            this.arguments.add("-osgi-provided-bundles");
            this.arguments.add(this.osgiProvidedBundles);
        }
        if (this.noPom) {
            this.arguments.add("-nopom");
        }
        if (this.pack200) {
            this.arguments.add("-pack200");
        }
        if (this.verbose != null) {
            if (this.verbose.isEmpty()) {
                this.arguments.add("-verbose");
            } else {
                this.arguments.add("-verbose:" + this.verbose);
            }
        }
        if (this.out != null) {
            this.arguments.add("-out");
            this.arguments.add(this.out);
        }
        if (this.user != null) {
            this.arguments.add("-user");
            this.arguments.add(this.user);
        }
        if (this.pass != null) {
            this.arguments.add("-pass");
            this.arguments.add(this.pass);
        }
        if ((fileEncoding = this.encoding) == null) {
            fileEncoding = DefaultToolOptions.getDefaultEncoding();
        }
        if (fileEncoding != null) {
            JavacOption encodingOpt = CeylonCompileTool.getJavacOpt(OptionName.ENCODING.toString());
            CeylonCompileTool.validateWithJavac(options, encodingOpt, OptionName.ENCODING.toString(), fileEncoding, "option.error.syntax.encoding");
            this.arguments.add(OptionName.ENCODING.toString());
            this.arguments.add(fileEncoding);
        }
        if (this.systemRepo != null) {
            this.arguments.add("-sysrep");
            this.arguments.add(this.systemRepo);
        }
        if (this.cacheRepo != null) {
            this.arguments.add("-cacherep");
            this.arguments.add(this.cacheRepo);
        }
        if (this.noDefRepos) {
            this.arguments.add("-nodefreps");
        }
        if (this.repo != null) {
            for (URI uri : this.repo) {
                this.arguments.add("-rep");
                this.arguments.add(uri.toString());
            }
        }
        if (this.suppressWarnings != null) {
            this.arguments.add("-suppress-warnings");
            this.arguments.add(EnumUtil.enumsToString(this.suppressWarnings));
        }
        this.addJavacArguments(this.arguments);
        List<File> srcs = this.applyCwd(this.sources);
        List<String> expandedModulesOrFiles = ModuleWildcardsHelper.expandWildcards(srcs, this.modulesOrFiles, Backend.Java);
        if (expandedModulesOrFiles.isEmpty()) {
            throw new ToolUsageError("No modules or source files to compile");
        }
        JavacOption sourceFileOpt = CeylonCompileTool.getJavacOpt(OptionName.SOURCEFILE.toString());
        if (sourceFileOpt != null) {
            for (String moduleOrFile : expandedModulesOrFiles) {
                CeylonCompileTool.validateWithJavac(options, sourceFileOpt, moduleOrFile, moduleOrFile, "argument.error");
            }
        }
        this.validateSourceArguments(expandedModulesOrFiles);
        this.arguments.addAll(expandedModulesOrFiles);
        if (this.verbose != null) {
            System.out.println(this.arguments);
            System.out.flush();
        }
    }

    private void validateSourceArguments(List<String> modulesOrFiles) throws IOException {
        SourceArgumentsResolver resolver = new SourceArgumentsResolver(this.sources, this.resources, ".ceylon", ".java");
        resolver.cwd(this.cwd).parse(modulesOrFiles);
    }

    private static JavacOption getJavacOpt(String optionName) {
        for (JavacOption.Option o : RecognizedOptions.getJavaCompilerOptions(HELPER)) {
            if (!optionName.equals(o.getName().toString())) continue;
            return o;
        }
        return null;
    }

    @Override
    public void run() throws IOException {
        int result = this.compiler.compile(this.arguments.toArray(new String[this.arguments.size()]));
        this.handleExitCode(result, this.compiler.exitState);
    }

    private void handleExitCode(int javacExitCode, Main.ExitState exitState) {
        if (exitState == null) {
            throw new IllegalStateException("Missing ExitState, " + javacExitCode);
        }
        Main.ExitState.CeylonState ceylonState = exitState.ceylonState;
        switch (ceylonState) {
            case OK: {
                break;
            }
            case ERROR: {
                throw new CompilerErrorException(exitState.errorCount);
            }
            case SYS: {
                throw new SystemErrorException(exitState.abortingException);
            }
            case BUG: {
                throw new CompilerBugException(exitState);
            }
            default: {
                throw new IllegalStateException("Unexpected CeylonState " + (Object)((Object)ceylonState));
            }
        }
    }

    private void addJavacArguments(List<String> arguments) {
        Options options = Options.instance(new Context());
        for (String argument : this.javac) {
            JavacOption javacOpt;
            CeylonCompileTool.HELPER.lastError = null;
            String value = null;
            int index = argument.indexOf(61);
            if (index != -1) {
                value = index < argument.length() ? argument.substring(index + 1) : "";
                argument = argument.substring(0, index);
            }
            if ((javacOpt = CeylonCompileTool.getJavacOpt(argument.replaceAll(":.*", ":"))) == null) {
                throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.javac", argument));
            }
            if (value != null) {
                if (!javacOpt.hasArg()) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.syntax.javac", argument, "Unexpected argument given"));
                }
                if (!javacOpt.matches(argument)) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.javac", argument));
                }
                if (javacOpt.process(options, argument, value)) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.syntax.javac", argument, CeylonCompileTool.HELPER.lastError));
                }
            } else {
                if (javacOpt.hasArg()) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.syntax.javac", argument, "Missing expected argument"));
                }
                if (!javacOpt.matches(argument)) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.javac", argument));
                }
                if (javacOpt.process(options, argument)) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.syntax.javac", argument, CeylonCompileTool.HELPER.lastError));
                }
            }
            arguments.add(argument);
            if (value == null) continue;
            arguments.add(value);
        }
    }

    private static final class Helper
    implements RecognizedOptions.OptionHelper {
        String lastError;

        private Helper() {
        }

        @Override
        public void setOut(PrintWriter out) {
        }

        @Override
        public void printXhelp() {
        }

        @Override
        public void printVersion() {
        }

        @Override
        public void printHelp() {
        }

        @Override
        public void printFullVersion() {
        }

        @Override
        public void error(String key, Object ... args) {
            this.lastError = Main.getLocalizedString(key, args);
        }

        @Override
        public void addFile(File f) {
        }

        @Override
        public void addClassName(String s) {
        }
    }
}

