/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AnnotationArgument;
import com.redhat.ceylon.compiler.java.codegen.AnnotationConstructorParameter;
import com.redhat.ceylon.compiler.java.codegen.AnnotationFieldName;
import com.redhat.ceylon.compiler.java.codegen.AnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.java.codegen.ParameterAnnotationTerm;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class AnnotationInvocation {
    private Function constructorDeclaration;
    private List<AnnotationConstructorParameter> constructorParameters = new ArrayList<AnnotationConstructorParameter>();
    private Declaration primary;
    private List<AnnotationArgument> annotationArguments = new ArrayList<AnnotationArgument>();
    private boolean interop;

    public Function getConstructorDeclaration() {
        return this.constructorDeclaration;
    }

    public void setConstructorDeclaration(Function constructorDeclaration) {
        this.constructorDeclaration = constructorDeclaration;
    }

    public List<AnnotationConstructorParameter> getConstructorParameters() {
        return this.constructorParameters;
    }

    public int indexOfConstructorParameter(Parameter parameter) {
        int index = 0;
        for (AnnotationConstructorParameter acp : this.getConstructorParameters()) {
            if (acp.getParameter().equals(parameter)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Declaration getPrimary() {
        return this.primary;
    }

    public void setPrimary(Class primary) {
        this.primary = primary;
    }

    public void setPrimary(Function primary) {
        this.primary = primary;
    }

    public boolean isInstantiation() {
        return this.getPrimary() instanceof Class;
    }

    public Type getAnnotationClassType() {
        if (this.isInstantiation()) {
            return ((Class)this.getPrimary()).getType();
        }
        return ((Function)this.getPrimary()).getType();
    }

    public List<Parameter> getParameters() {
        return ((Functional)((Object)this.primary)).getFirstParameterList().getParameters();
    }

    public List<Parameter> getClassParameters() {
        return ((Class)this.getAnnotationClassType().getDeclaration()).getParameterList().getParameters();
    }

    public List<AnnotationArgument> getAnnotationArguments() {
        return this.annotationArguments;
    }

    public boolean isInterop() {
        return this.interop;
    }

    public void setInterop(boolean interop) {
        this.interop = interop;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getConstructorDeclaration() != null) {
            sb.append(this.getConstructorDeclaration().getName()).append("(");
            List<AnnotationConstructorParameter> ctorParams = this.getConstructorParameters();
            for (AnnotationConstructorParameter param : ctorParams) {
                sb.append(param).append(", ");
            }
            if (!ctorParams.isEmpty()) {
                sb.setLength(sb.length() - 2);
            }
            sb.append(")\n\t=> ");
        }
        sb.append(this.primary != null ? this.primary.getName() : "NULL").append("{");
        for (AnnotationArgument argument : this.annotationArguments) {
            sb.append(argument).append(";\n");
        }
        return sb.append("}").toString();
    }

    public JCTree.JCExpression makeAnnotationType(ExpressionTransformer exprGen) {
        Type type = this.getAnnotationClassType();
        if (this.isInterop()) {
            return exprGen.makeJavaType(type.getSatisfiedTypes().get(0));
        }
        return exprGen.makeJavaType(type, 4096);
    }

    public JCTree.JCExpression makeAnnotation(ExpressionTransformer exprGen, AnnotationInvocation ai, com.redhat.ceylon.langtools.tools.javac.util.List<AnnotationFieldName> parameterPath) {
        ListBuffer args = ListBuffer.lb();
        for (AnnotationArgument aa : this.getAnnotationArguments()) {
            Parameter name = aa.getParameter();
            if (!this.isInstantiation()) {
                AnnotationInvocation annotationInvocation = (AnnotationInvocation)this.getConstructorDeclaration().getAnnotationConstructor();
                for (AnnotationArgument a2 : annotationInvocation.getAnnotationArguments()) {
                    if (!(a2.getTerm() instanceof ParameterAnnotationTerm) || !((ParameterAnnotationTerm)a2.getTerm()).getSourceParameter().equals(aa.getParameter())) continue;
                    name = a2.getParameter();
                    break;
                }
            }
            args.append(this.makeAnnotationArgument(exprGen, ai, name, parameterPath.append(aa), aa.getTerm()));
        }
        return exprGen.make().Annotation(this.makeAnnotationType(exprGen), args.toList());
    }

    public JCTree.JCExpression makeAnnotationArgument(ExpressionTransformer exprGen, AnnotationInvocation ai, Parameter bind, com.redhat.ceylon.langtools.tools.javac.util.List<AnnotationFieldName> fieldPath, AnnotationTerm term) {
        return exprGen.make().Assign(exprGen.naming.makeName(bind.getModel(), 513), term.makeAnnotationArgumentValue(exprGen, ai, fieldPath));
    }

    public JCTree.JCAnnotation encode(AbstractTransformer gen, ListBuffer<JCTree.JCExpression> instantiations) {
        ListBuffer arguments = ListBuffer.lb();
        for (AnnotationArgument argument : this.getAnnotationArguments()) {
            arguments.append(gen.make().Literal(argument.getTerm().encode(gen, instantiations)));
        }
        JCTree.JCExpression primary = this.isInstantiation() ? gen.makeJavaType(this.getAnnotationClassType()) : gen.naming.makeName((Function)this.getPrimary(), 10);
        JCTree.JCAnnotation atInstantiation = gen.make().Annotation(gen.make().Type(gen.syms().ceylonAtAnnotationInstantiationType), com.redhat.ceylon.langtools.tools.javac.util.List.of(gen.make().Assign(gen.naming.makeUnquotedIdent("arguments"), gen.make().NewArray(null, null, arguments.toList())), gen.make().Assign(gen.naming.makeUnquotedIdent("primary"), gen.naming.makeQualIdent(primary, "class"))));
        if (instantiations.isEmpty()) {
            return atInstantiation;
        }
        return gen.make().Annotation(gen.make().Type(gen.syms().ceylonAtAnnotationInstantiationTreeType), com.redhat.ceylon.langtools.tools.javac.util.List.of(gen.make().NewArray(null, null, instantiations.prepend(atInstantiation).toList())));
    }

    public Iterable<AnnotationArgument> findAnnotationArgumentForClassParameter(Parameter classParameter) {
        ArrayList<AnnotationArgument> result = new ArrayList<AnnotationArgument>(1);
        if (this.isInstantiation()) {
            for (AnnotationArgument aa : this.getAnnotationArguments()) {
                if (!aa.getParameter().equals(classParameter)) continue;
                result.add(aa);
            }
        } else {
            AnnotationInvocation ctor = (AnnotationInvocation)((Function)this.getPrimary()).getAnnotationConstructor();
            for (AnnotationArgument otherArgument : ctor.findAnnotationArgumentForClassParameter(classParameter)) {
                if (!(otherArgument.getTerm() instanceof ParameterAnnotationTerm)) continue;
                Parameter sourceParameter = ((ParameterAnnotationTerm)otherArgument.getTerm()).getSourceParameter();
                for (AnnotationArgument aa : this.getAnnotationArguments()) {
                    if (!aa.getParameter().equals(sourceParameter)) continue;
                    result.add(aa);
                }
            }
        }
        return result;
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeExprAnnotations(ExpressionTransformer exprGen, AnnotationInvocation toplevel, com.redhat.ceylon.langtools.tools.javac.util.List<AnnotationFieldName> fieldPath) {
        LinkedHashMap groups = new LinkedHashMap();
        for (AnnotationArgument aa : this.getAnnotationArguments()) {
            AnnotationTerm term = aa.getTerm();
            ArrayList<AnnotationArgument> group = (ArrayList<AnnotationArgument>)groups.get(term.getClass());
            if (group == null) {
                group = new ArrayList<AnnotationArgument>(1);
                groups.put(term.getClass(), group);
            }
            group.add(aa);
        }
        ListBuffer exprsAnnos = ListBuffer.lb();
        for (List group : groups.values()) {
            AnnotationTerm factory = null;
            ListBuffer valueAnnos = ListBuffer.lb();
            for (AnnotationArgument aa : group) {
                AnnotationTerm term = aa.getTerm();
                com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annos = term.makeExprAnnotations(exprGen, this, fieldPath.append(aa));
                if (annos == null) continue;
                factory = ((AnnotationArgument)group.get(0)).getTerm();
                valueAnnos.appendList(annos);
            }
            if (valueAnnos.isEmpty()) continue;
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> exprs = factory.makeExprs(exprGen, valueAnnos.toList());
            if (exprs != null) {
                exprsAnnos.appendList(exprs);
                continue;
            }
            exprs = factory.makeExprs(exprGen, valueAnnos.toList());
        }
        return exprsAnnos.toList();
    }
}

