/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AnnotationArgument;
import com.redhat.ceylon.compiler.java.codegen.AnnotationConstructorParameter;
import com.redhat.ceylon.compiler.java.codegen.AnnotationFieldName;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocation;
import com.redhat.ceylon.compiler.java.codegen.AnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.java.codegen.InvocationAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.LiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ParameterAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class AnnotationInvocationVisitor
extends Visitor {
    private final Node errorNode;
    private final ExpressionTransformer exprGen;
    private final AnnotationInvocation anno;
    private Parameter parameter;
    private Type expectedType;
    private ListBuffer<JCTree.JCExpression> arrayExprs = null;
    private JCTree.JCExpression argumentExpr;

    public static Class annoClass(Tree.InvocationExpression invocation) {
        Declaration declaration = ((Tree.BaseMemberOrTypeExpression)invocation.getPrimary()).getDeclaration();
        HashSet<Declaration> ctors = new HashSet<Declaration>();
        while (declaration instanceof Function) {
            if (!ctors.add(declaration)) {
                throw new BugException(invocation, "recursive annotation constructor");
            }
            declaration = ((AnnotationInvocation)((Function)declaration).getAnnotationConstructor()).getPrimary();
        }
        if (declaration instanceof Class) {
            return (Class)declaration;
        }
        throw new BugException(invocation, "invocation primary has unexpected declaration: " + declaration);
    }

    public static Function annoCtor(Tree.InvocationExpression invocation) {
        Declaration declaration = ((Tree.BaseMemberOrTypeExpression)invocation.getPrimary()).getDeclaration();
        if (declaration instanceof Function) {
            return (Function)declaration;
        }
        if (declaration instanceof Class) {
            return null;
        }
        throw new BugException(invocation, "invocation primary has unexpected declaration: " + declaration);
    }

    public static AnnotationInvocation annoCtorModel(Tree.InvocationExpression invocation) {
        Declaration declaration = ((Tree.BaseMemberOrTypeExpression)invocation.getPrimary()).getDeclaration();
        if (declaration instanceof Function) {
            return (AnnotationInvocation)((Function)declaration).getAnnotationConstructor();
        }
        if (declaration instanceof Class) {
            AnnotationInvocation in = new AnnotationInvocation();
            in.setPrimary((Class)declaration);
            ArrayList<AnnotationArgument> args = new ArrayList<AnnotationArgument>();
            for (Parameter p : ((Class)declaration).getParameterList().getParameters()) {
                AnnotationArgument arg = new AnnotationArgument();
                arg.setParameter(p);
                ParameterAnnotationTerm term = new ParameterAnnotationTerm();
                term.setSourceParameter(p);
                term.setSpread(false);
                arg.setTerm(term);
                args.add(arg);
            }
            in.getAnnotationArguments().addAll(args);
            in.setInterop(false);
            in.setConstructorDeclaration(null);
            return in;
        }
        throw new BugException(invocation, "invocation primary has unexpected declaration: " + declaration);
    }

    private AnnotationInvocationVisitor(ExpressionTransformer expressionTransformer, Node errorNode, AnnotationInvocation anno) {
        this.exprGen = expressionTransformer;
        this.errorNode = errorNode;
        this.anno = anno;
    }

    private JCTree.JCExpression getExpression() {
        if (this.argumentExpr != null) {
            return this.argumentExpr;
        }
        if (this.arrayExprs != null) {
            return this.exprGen.make().NewArray(null, null, this.arrayExprs.toList());
        }
        if (this.anno.isInterop()) {
            return null;
        }
        return this.exprGen.makeErroneous(this.errorNode, "compiler bug: no result when transforming annotation");
    }

    public static JCTree.JCAnnotation transform(ExpressionTransformer expressionTransformer, Tree.InvocationExpression invocation) {
        AnnotationInvocationVisitor visitor = new AnnotationInvocationVisitor(expressionTransformer, invocation, AnnotationInvocationVisitor.annoCtorModel(invocation));
        visitor.visit(invocation);
        return (JCTree.JCAnnotation)visitor.getExpression();
    }

    @Override
    public void visit(Tree.InvocationExpression invocation) {
        Tree.Primary primary = invocation.getPrimary();
        try {
            if (primary instanceof Tree.BaseMemberExpression) {
                Tree.BaseMemberExpression ctor = (Tree.BaseMemberExpression)primary;
                if (!Decl.isAnnotationConstructor(ctor.getDeclaration())) {
                    this.append(this.exprGen.makeErroneous(primary, "compiler bug: " + ctor.getDeclaration().getName() + " is not an annotation constructor"));
                }
                this.append(AnnotationInvocationVisitor.transformConstructor(this.exprGen, invocation));
            } else if (primary instanceof Tree.BaseTypeExpression) {
                Tree.BaseTypeExpression bte = (Tree.BaseTypeExpression)primary;
                if (((TypeDeclaration)bte.getDeclaration()).isByte()) {
                    Tree.PositionalArgument arg = invocation.getPositionalArgumentList().getPositionalArguments().get(0);
                    arg.visit(this);
                } else {
                    if (!Decl.isAnnotationClass(bte.getDeclaration())) {
                        this.append(this.exprGen.makeErroneous(primary, "compiler bug: " + bte.getDeclaration().getName() + " is not an annotation class"));
                    }
                    this.append(AnnotationInvocationVisitor.transformInstantiation(this.exprGen, invocation));
                }
            } else {
                this.append(this.exprGen.makeErroneous(primary, "compiler bug: primary is not an annotation constructor or annotation class"));
            }
        }
        catch (BugException e) {
            e.addError(invocation);
        }
    }

    private static JCTree.JCAnnotation transformInstantiation(ExpressionTransformer exprGen, Tree.InvocationExpression invocation) {
        AnnotationInvocation ai = AnnotationInvocationVisitor.annoCtorModel(invocation);
        AnnotationInvocationVisitor visitor = new AnnotationInvocationVisitor(exprGen, invocation, AnnotationInvocationVisitor.annoCtorModel(invocation));
        ListBuffer annotationArguments = ListBuffer.lb();
        if (invocation.getPositionalArgumentList() != null) {
            for (Tree.PositionalArgument positionalArgument : invocation.getPositionalArgumentList().getPositionalArguments()) {
                visitor.parameter = positionalArgument.getParameter();
                positionalArgument.visit(visitor);
                annotationArguments.append(AnnotationInvocationVisitor.makeArgument(exprGen, invocation, visitor.parameter, visitor.getExpression()));
            }
        }
        if (invocation.getNamedArgumentList() != null) {
            for (Tree.NamedArgument namedArgument : invocation.getNamedArgumentList().getNamedArguments()) {
                visitor.parameter = namedArgument.getParameter();
                namedArgument.visit(visitor);
                annotationArguments.append(AnnotationInvocationVisitor.makeArgument(exprGen, invocation, visitor.parameter, visitor.getExpression()));
            }
        }
        return exprGen.at(invocation).Annotation(ai.makeAnnotationType(exprGen), annotationArguments.toList());
    }

    public static JCTree.JCAnnotation transformConstructor(ExpressionTransformer exprGen, Tree.InvocationExpression invocation) {
        AnnotationInvocation ai = AnnotationInvocationVisitor.annoCtorModel(invocation);
        return AnnotationInvocationVisitor.transformConstructor(exprGen, invocation, ai, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    static String checkForBannedJavaAnnotation(Tree.InvocationExpression invocation) {
        if (invocation.getPrimary() instanceof Tree.BaseMemberExpression && ((Tree.BaseMemberExpression)invocation.getPrimary()).getDeclaration() != null) {
            String name = ((Tree.BaseMemberExpression)invocation.getPrimary()).getDeclaration().getQualifiedNameString();
            if ("java.lang::deprecated".equals(name)) {
                return "inappropiate java annotation: interoperation with @Deprecated is not supported: use deprecated";
            }
            if ("java.lang::override".equals(name)) {
                return "inappropiate java annotation: interoperation with @Override is not supported: use actual";
            }
            if ("java.lang.annotation::target".equals(name)) {
                return "inappropiate java annotation: interoperation with @Target is not supported";
            }
            if ("java.lang.annotation::retention".equals(name)) {
                return "inappropiate java annotation: interoperation with @Retention is not supported";
            }
        }
        return null;
    }

    private static JCTree.JCAnnotation transformConstructor(ExpressionTransformer exprGen, Tree.InvocationExpression invocation, AnnotationInvocation ai, com.redhat.ceylon.langtools.tools.javac.util.List<AnnotationFieldName> fieldPath) {
        LinkedHashMap<Parameter, ListBuffer<JCTree.JCExpression>> args = new LinkedHashMap<Parameter, ListBuffer<JCTree.JCExpression>>();
        List<Parameter> classParameters = ai.getClassParameters();
        ArrayList<Parameter> unbound = new ArrayList<Parameter>(classParameters);
        for (Parameter classParameter : classParameters) {
            for (AnnotationArgument argument : ai.findAnnotationArgumentForClassParameter(classParameter)) {
                JCTree.JCExpression expr = AnnotationInvocationVisitor.transformConstructorArgument(exprGen, invocation, classParameter, argument, fieldPath);
                AnnotationInvocationVisitor.appendArgument(args, classParameter, expr);
                unbound.remove(classParameter);
            }
        }
        block2: for (Parameter classParameter : (ArrayList)unbound.clone()) {
            if (ai.isInstantiation()) {
                if (classParameter.isDefaulted()) {
                    unbound.remove(classParameter);
                    continue;
                }
            } else {
                Function ac2 = (Function)ai.getPrimary();
                AnnotationInvocation i = (AnnotationInvocation)ac2.getAnnotationConstructor();
                for (AnnotationArgument aa : i.getAnnotationArguments()) {
                    if (!aa.getParameter().equals(classParameter)) continue;
                    AnnotationInvocationVisitor.appendArgument(args, classParameter, aa.getTerm().makeAnnotationArgumentValue(exprGen, i, com.redhat.ceylon.langtools.tools.javac.util.List.of(aa)));
                    unbound.remove(classParameter);
                    continue block2;
                }
            }
            if (!Strategy.hasEmptyDefaultArgument(classParameter)) continue;
            AnnotationInvocationVisitor.appendArgument(args, classParameter, exprGen.make().NewArray(null, null, com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
            unbound.remove(classParameter);
        }
        for (Parameter classParameter : unbound) {
            AnnotationInvocationVisitor.appendArgument(args, classParameter, exprGen.makeErroneous(invocation, "compiler bug: unbound annotation class parameter " + classParameter.getName()));
        }
        ListBuffer assignments = ListBuffer.lb();
        for (Map.Entry entry : args.entrySet()) {
            ListBuffer exprs = (ListBuffer)entry.getValue();
            if (exprs.size() == 1) {
                assignments.append(AnnotationInvocationVisitor.makeArgument(exprGen, invocation, (Parameter)entry.getKey(), (JCTree.JCExpression)exprs.first()));
                continue;
            }
            assignments.append(AnnotationInvocationVisitor.makeArgument(exprGen, invocation, (Parameter)entry.getKey(), exprGen.make().NewArray(null, null, exprs.toList())));
        }
        JCTree.JCAnnotation annotation = exprGen.at(invocation).Annotation(ai.makeAnnotationType(exprGen), assignments.toList());
        return annotation;
    }

    private static void appendArgument(Map<Parameter, ListBuffer<JCTree.JCExpression>> args, Parameter classParameter, JCTree.JCExpression expr) {
        if (expr != null) {
            ListBuffer<JCTree.JCExpression> exprList = args.get(classParameter);
            if (exprList == null) {
                exprList = ListBuffer.lb();
                args.put(classParameter, exprList);
            }
            exprList.append(expr);
        }
    }

    public static JCTree.JCExpression transformConstructorArgument(ExpressionTransformer exprGen, Tree.InvocationExpression invocation, Parameter classParameter, AnnotationArgument argument, com.redhat.ceylon.langtools.tools.javac.util.List<AnnotationFieldName> fieldPath) {
        AnnotationInvocation anno = AnnotationInvocationVisitor.annoCtorModel(invocation);
        AnnotationInvocationVisitor visitor = new AnnotationInvocationVisitor(exprGen, invocation, anno);
        visitor.parameter = classParameter;
        AnnotationTerm term = argument.getTerm();
        if (term instanceof ParameterAnnotationTerm) {
            ParameterAnnotationTerm parameterArgument = (ParameterAnnotationTerm)term;
            Parameter sp = parameterArgument.getSourceParameter();
            int argumentIndex = ((Functional)((Object)sp.getDeclaration())).getFirstParameterList().getParameters().indexOf(sp);
            if (invocation.getPositionalArgumentList() != null) {
                List<Tree.PositionalArgument> positionalArguments = invocation.getPositionalArgumentList().getPositionalArguments();
                if (parameterArgument.isSpread()) {
                    visitor.transformSpreadArgument(positionalArguments.subList(argumentIndex, positionalArguments.size()), classParameter);
                } else if (0 <= argumentIndex && argumentIndex < positionalArguments.size()) {
                    Tree.PositionalArgument pargument = positionalArguments.get(argumentIndex);
                    if (pargument.getParameter().isSequenced()) {
                        visitor.transformVarargs(argumentIndex, positionalArguments);
                    } else {
                        visitor.transformArgument(pargument);
                    }
                } else if (sp.isDefaulted()) {
                    visitor.makeDefaultExpr(invocation, parameterArgument, sp);
                } else if (sp.isSequenced()) {
                    visitor.appendBuiltArray(visitor.startArray());
                }
            } else if (invocation.getNamedArgumentList() != null) {
                boolean found = false;
                for (Tree.NamedArgument na : invocation.getNamedArgumentList().getNamedArguments()) {
                    Parameter parameter = na.getParameter();
                    int parameterIndex = anno.indexOfConstructorParameter(parameter);
                    if (parameterIndex != argumentIndex) continue;
                    visitor.transformArgument(na);
                    found = true;
                    break;
                }
                if (!found) {
                    if (sp.isDefaulted()) {
                        visitor.makeDefaultExpr(invocation, parameterArgument, sp);
                    } else if (sp.isSequenced()) {
                        visitor.appendBuiltArray(visitor.startArray());
                    } else {
                        visitor.append(exprGen.makeErroneous(invocation, "Unable to find argument"));
                    }
                }
            }
        } else if (term instanceof LiteralAnnotationTerm) {
            visitor.append(term.makeAnnotationArgumentValue(visitor.exprGen, visitor.anno, fieldPath.append(argument)));
        } else if (term instanceof InvocationAnnotationTerm) {
            AnnotationInvocation instantiation = ((InvocationAnnotationTerm)term).getInstantiation();
            visitor.append(AnnotationInvocationVisitor.transformConstructor(visitor.exprGen, invocation, instantiation, fieldPath.append(argument)));
        } else {
            visitor.append(visitor.exprGen.makeErroneous(invocation, "Unable to find argument"));
        }
        return visitor.getExpression();
    }

    private void makeDefaultExpr(Tree.InvocationExpression invocation, ParameterAnnotationTerm parameterArgument, Parameter sp) {
        AnnotationConstructorParameter defaultedCtorParam = null;
        for (AnnotationConstructorParameter ctorParam : this.anno.getConstructorParameters()) {
            if (!ctorParam.getParameter().equals(parameterArgument.getSourceParameter())) continue;
            defaultedCtorParam = ctorParam;
            break;
        }
        if (defaultedCtorParam == null) {
            this.append(this.exprGen.makeErroneous(invocation, "compiler bug: defaulted parameter " + this.anno.getConstructorDeclaration().getName() + " could not be found"));
            return;
        }
        if (defaultedCtorParam.getDefaultArgument() instanceof LiteralAnnotationTerm) {
            JCTree.JCExpression expr = ((LiteralAnnotationTerm)defaultedCtorParam.getDefaultArgument()).makeLiteral(this.exprGen);
            this.append(expr);
        } else if (Decl.isAnnotationClass(sp.getType().getDeclaration())) {
            InvocationAnnotationTerm defaultedInvocation = (InvocationAnnotationTerm)defaultedCtorParam.getDefaultArgument();
            this.append(AnnotationInvocationVisitor.transformConstructor(this.exprGen, invocation, defaultedInvocation.getInstantiation(), com.redhat.ceylon.langtools.tools.javac.util.List.of(defaultedCtorParam)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformVarargs(int argumentIndex, List<Tree.PositionalArgument> pa) {
        ListBuffer<JCTree.JCExpression> prevCollect = this.startArray();
        try {
            for (int jj = argumentIndex; jj < pa.size(); ++jj) {
                this.transformArgument(pa.get(jj));
            }
        }
        finally {
            this.appendBuiltArray(prevCollect);
        }
    }

    private static JCTree.JCAssign makeArgument(ExpressionTransformer exprGen, Node errorNode, Parameter parameter, JCTree.JCExpression expr) {
        JCTree.JCExpression memberName = parameter != null ? exprGen.naming.makeUnquotedIdent(Naming.selector(parameter.getModel(), 512)) : exprGen.makeErroneous(errorNode, "compiler bug: null parameter in makeArgument");
        return exprGen.make().Assign(memberName, expr);
    }

    private void append(JCTree.JCExpression expr) {
        if (this.arrayExprs != null) {
            this.arrayExprs.append(expr);
        } else {
            if (this.argumentExpr != null) {
                throw new BugException(this.errorNode, "assertion failed");
            }
            this.argumentExpr = expr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformSpreadArgument(List<Tree.PositionalArgument> arguments, Parameter classParameter) {
        boolean varargs = classParameter.isSequenced() && arguments.size() > 1 || arguments.size() == 0;
        ListBuffer<JCTree.JCExpression> prevCollect = varargs ? this.startArray() : null;
        try {
            for (Tree.PositionalArgument arg : arguments) {
                this.exprGen.at(arg);
                arg.visit(this);
            }
        }
        finally {
            if (varargs) {
                this.appendBuiltArray(prevCollect);
            }
        }
    }

    private void transformArgument(Tree.NamedArgument node) {
        this.exprGen.at(node);
        node.visit(this);
    }

    private void transformArgument(Tree.PositionalArgument node) {
        this.exprGen.at(node);
        node.visit(this);
    }

    @Override
    public void handleException(Exception e, Node node) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    @Override
    public void visit(Tree.Expression term) {
        term.visitChildren(this);
    }

    @Override
    public void visit(Tree.Term term) {
        this.append(this.exprGen.makeErroneous(term, "compiler bug: " + term.getNodeType() + " is an unsupported term in an annotation invocation"));
    }

    @Override
    public void visit(Tree.NegativeOp term) {
        if (term.getTerm() instanceof Tree.NaturalLiteral || term.getTerm() instanceof Tree.FloatLiteral) {
            this.append(this.exprGen.transformExpression(term, AbstractTransformer.BoxingStrategy.UNBOXED, this.expectedType(), 128));
        } else {
            this.append(this.exprGen.makeErroneous(term, "compiler bug: " + term.getNodeType() + " is an unsupported term in an annotation invocation"));
        }
    }

    @Override
    public void visit(Tree.Literal term) {
        this.append(this.exprGen.transformExpression(term, AbstractTransformer.BoxingStrategy.UNBOXED, this.expectedType(), 128));
    }

    private Type expectedType() {
        return this.expectedType != null ? this.expectedType : this.parameter.getType();
    }

    @Override
    public void visit(Tree.BaseMemberExpression term) {
        if (this.exprGen.isBooleanTrue(term.getDeclaration()) || this.exprGen.isBooleanFalse(term.getDeclaration())) {
            this.append(this.exprGen.transformExpression(term, AbstractTransformer.BoxingStrategy.UNBOXED, term.getTypeModel()));
        } else if (Decl.isAnonCaseOfEnumeratedType(term) && !this.exprGen.isJavaEnumType(term.getTypeModel())) {
            this.append(this.exprGen.makeClassLiteral(term.getTypeModel()));
        } else if (this.anno.isInterop()) {
            if (this.exprGen.isJavaEnumType(term.getTypeModel())) {
                this.append(this.exprGen.transformExpression(term, AbstractTransformer.BoxingStrategy.UNBOXED, null));
            }
        } else {
            super.visit(term);
        }
    }

    @Override
    public void visit(Tree.MemberOrTypeExpression term) {
        if (this.anno.isInterop()) {
            Declaration decl = term.getDeclaration();
            if (decl instanceof ClassOrInterface) {
                this.append(this.exprGen.naming.makeQualIdent(this.exprGen.makeJavaType(((ClassOrInterface)decl).getType()), "class"));
            } else if (decl instanceof Value) {
                this.append(this.exprGen.transformExpression(term, AbstractTransformer.BoxingStrategy.UNBOXED, term.getTypeModel(), 256));
            }
        } else {
            this.append(this.exprGen.make().Literal(term.getDeclaration().getQualifiedNameString()));
        }
    }

    @Override
    public void visit(Tree.TypeLiteral tl) {
        if (tl.getType() != null && tl.getType().getTypeModel() != null || tl.getDeclaration() != null && tl.getDeclaration().isAnonymous()) {
            if (this.anno.isInterop()) {
                this.append(this.exprGen.naming.makeQualIdent(this.exprGen.makeJavaType(tl.getType().getTypeModel(), 12), "class"));
            } else {
                this.append(this.exprGen.makeMetaLiteralStringLiteralForAnnotation(tl));
            }
        }
    }

    @Override
    public void visit(Tree.MetaLiteral tl) {
        this.append(this.exprGen.makeMetaLiteralStringLiteralForAnnotation(tl));
    }

    private ListBuffer<JCTree.JCExpression> startArray() {
        ListBuffer<JCTree.JCExpression> prevArray = this.arrayExprs;
        this.arrayExprs = ListBuffer.lb();
        this.expectedType = this.exprGen.typeFact().getIteratedType(this.parameter.getType());
        return prevArray;
    }

    private JCTree.JCNewArray endArray(ListBuffer<JCTree.JCExpression> prevArray) {
        ListBuffer<JCTree.JCExpression> collected = this.arrayExprs;
        this.arrayExprs = prevArray;
        this.expectedType = null;
        return this.exprGen.make().NewArray(null, null, collected.toList());
    }

    private void appendBuiltArray(ListBuffer<JCTree.JCExpression> prevArray) {
        this.append(this.endArray(prevArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Tree.SequenceEnumeration term) {
        ListBuffer<JCTree.JCExpression> prevCollect = this.startArray();
        try {
            term.visitChildren(this);
        }
        finally {
            this.appendBuiltArray(prevCollect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Tree.Tuple term) {
        ListBuffer<JCTree.JCExpression> prevCollect = this.startArray();
        try {
            term.visitChildren(this);
        }
        finally {
            this.appendBuiltArray(prevCollect);
        }
    }

    @Override
    public void visit(Tree.PositionalArgument arg) {
        this.append(this.exprGen.makeErroneous(arg, "compiler bug: " + arg.getNodeType() + " is an unsupported positional argument in an annotation invocation"));
    }

    @Override
    public void visit(Tree.ListedArgument arg) {
        arg.visitChildren(this);
    }

    @Override
    public void visit(Tree.NamedArgument arg) {
        this.append(this.exprGen.makeErroneous(arg, "compiler bug: " + arg.getNodeType() + " is an unsupported named argument in an annotation invocation"));
    }

    @Override
    public void visit(Tree.SpecifiedArgument arg) {
        arg.visitChildren(this);
    }
}

