/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.AnnotationTarget;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class AnnotationUtil {
    public static EnumSet<OutputElement> interopAnnotationTargeting(EnumSet<OutputElement> outputs, Tree.Annotation annotation, boolean errors) {
        Declaration annoCtor = ((Tree.BaseMemberExpression)annotation.getPrimary()).getDeclaration();
        if (annoCtor instanceof AnnotationProxyMethod) {
            AnnotationProxyMethod proxyCtor = (AnnotationProxyMethod)annoCtor;
            AnnotationProxyClass annoClass = proxyCtor.getProxyClass();
            EnumSet<OutputElement> possibleTargets = proxyCtor.getAnnotationTarget() != null ? EnumSet.of(proxyCtor.getAnnotationTarget()) : AnnotationTarget.outputTargets(annoClass);
            Object actualTargets = possibleTargets.clone();
            ((AbstractCollection)actualTargets).retainAll(outputs);
            if (((AbstractCollection)actualTargets).size() > 1) {
                if (errors) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("ambiguous annotation target: ").append(annoCtor.getName());
                    sb.append(" could be applied to several targets, use one of ");
                    Iterator iterator = ((AbstractCollection)actualTargets).iterator();
                    while (iterator.hasNext()) {
                        OutputElement x = (OutputElement)((Object)iterator.next());
                        sb.append(Naming.getDisambigAnnoCtorName(((AnnotationProxyMethod)annoCtor).getProxyClass().iface, x));
                        if (!iterator.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append(" to disambiguate");
                    annotation.addUsageWarning(Warning.ambiguousAnnotation, sb.toString(), Backend.Java);
                }
                return null;
            }
            if (((AbstractCollection)actualTargets).size() == 0 && errors) {
                annotation.addError("no target for " + annoCtor.getName() + " annotation: @Target of @interface " + annoClass.iface.getName() + " lists " + possibleTargets + " but annotated element tranforms to " + outputs, Backend.Java);
            }
            return actualTargets;
        }
        return null;
    }

    public static EnumSet<OutputElement> outputs(Tree.ObjectDefinition that) {
        return EnumSet.of(OutputElement.TYPE, OutputElement.CONSTRUCTOR, OutputElement.FIELD, OutputElement.GETTER);
    }

    public static EnumSet<OutputElement> outputs(Tree.AnyClass that) {
        EnumSet<OutputElement> result = EnumSet.of(OutputElement.TYPE);
        if (!that.getDeclarationModel().hasConstructors()) {
            result.add(OutputElement.CONSTRUCTOR);
        }
        if (that.getDeclarationModel().isAnnotation()) {
            result.add(OutputElement.ANNOTATION_TYPE);
        }
        return result;
    }

    public static EnumSet<OutputElement> outputs(Tree.PackageDescriptor annotated) {
        return EnumSet.of(OutputElement.TYPE);
    }

    public static EnumSet<OutputElement> outputs(Tree.ImportModule annotated) {
        return EnumSet.of(OutputElement.FIELD);
    }

    public static EnumSet<OutputElement> outputs(Tree.ModuleDescriptor annotated) {
        return EnumSet.of(OutputElement.TYPE);
    }

    public static EnumSet<OutputElement> outputs(Tree.TypeAliasDeclaration that) {
        return EnumSet.of(OutputElement.TYPE);
    }

    public static EnumSet<OutputElement> outputs(Tree.AnyInterface that) {
        return EnumSet.of(OutputElement.TYPE);
    }

    public static EnumSet<OutputElement> outputs(Tree.Constructor annotated) {
        return EnumSet.of(OutputElement.CONSTRUCTOR);
    }

    public static EnumSet<OutputElement> outputs(Tree.Enumerated annotated) {
        return EnumSet.of(OutputElement.CONSTRUCTOR, OutputElement.FIELD, OutputElement.GETTER);
    }

    public static EnumSet<OutputElement> outputs(Tree.AnyMethod that) {
        return EnumSet.of(OutputElement.METHOD);
    }

    public static EnumSet<OutputElement> outputs(Tree.AttributeGetterDefinition that) {
        return EnumSet.of(OutputElement.GETTER);
    }

    public static EnumSet<OutputElement> outputs(Tree.AttributeSetterDefinition that) {
        return EnumSet.of(OutputElement.SETTER);
    }

    public static EnumSet<OutputElement> outputs(Tree.AttributeDeclaration that) {
        EnumSet<OutputElement> result = EnumSet.noneOf(OutputElement.class);
        Value declarationModel = that.getDeclarationModel();
        if (declarationModel != null) {
            if (declarationModel.isClassMember()) {
                if (declarationModel.isParameter()) {
                    result.add(OutputElement.PARAMETER);
                }
                if (declarationModel.isShared() || declarationModel.isCaptured()) {
                    result.add(OutputElement.GETTER);
                    if (!(that.getSpecifierOrInitializerExpression() instanceof Tree.LazySpecifierExpression)) {
                        result.add(OutputElement.FIELD);
                    }
                } else if (!declarationModel.isParameter()) {
                    result.add(OutputElement.LOCAL_VARIABLE);
                }
            } else if (declarationModel.isInterfaceMember()) {
                result.add(OutputElement.GETTER);
            } else if (declarationModel.isToplevel()) {
                result.add(OutputElement.GETTER);
                result.add(OutputElement.FIELD);
            } else if (declarationModel.isParameter()) {
                result.add(OutputElement.PARAMETER);
            } else {
                result.add(OutputElement.LOCAL_VARIABLE);
            }
        }
        if (result.contains((Object)OutputElement.GETTER) && (declarationModel.isVariable() || declarationModel.isLate())) {
            result.add(OutputElement.SETTER);
        }
        return result;
    }

    public static void duplicateInteropAnnotation(EnumSet<OutputElement> outputs, List<Tree.Annotation> annotations) {
        block0: for (int i = 0; i < annotations.size(); ++i) {
            TypeDeclaration td;
            Tree.Annotation ann = annotations.get(i);
            Type t = ann.getTypeModel();
            EnumSet<OutputElement> mainTargets = AnnotationUtil.interopAnnotationTargeting(outputs, ann, false);
            if (t == null || mainTargets == null || ModelUtil.isCeylonDeclaration(td = t.getDeclaration())) continue;
            for (int j = 0; j < i; ++j) {
                EnumSet<OutputElement> sameTargets;
                EnumSet<OutputElement> dupeTargets;
                TypeDeclaration otd;
                Tree.Annotation other = annotations.get(j);
                Type ot = other.getTypeModel();
                if (ot == null || !(otd = ot.getDeclaration()).equals(td) || (dupeTargets = AnnotationUtil.interopAnnotationTargeting(outputs, other, false)) == null || (sameTargets = AnnotationUtil.intersection(mainTargets, dupeTargets)).isEmpty()) continue;
                ann.addError("duplicate annotation: there are multiple annotations of type '" + td.getName() + "' for targets: '" + sameTargets + "'");
                continue block0;
            }
        }
    }

    private static EnumSet<OutputElement> intersection(EnumSet<OutputElement> mainTargets, EnumSet<OutputElement> dupeTargets) {
        EnumSet<OutputElement> intersect = EnumSet.copyOf(mainTargets);
        intersect.retainAll(dupeTargets);
        return intersect;
    }
}

