/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.Annotations;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.MethodDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ParameterDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;

public class AttributeDefinitionBuilder {
    private boolean hasField = true;
    private final String fieldName;
    private final TypedDeclaration attrTypedDecl;
    private final String attrName;
    private final String javaClassName;
    private final ClassDefinitionBuilder classBuilder;
    private final int typeFlags;
    private final Type attrType;
    private final boolean toplevel;
    private final boolean late;
    private final boolean lateWithInit;
    private final boolean variable;
    private long modifiers;
    private boolean readable = true;
    private final MethodDefinitionBuilder getterBuilder;
    private JCTree.JCExpression variableInit;
    private HasErrorException variableInitThrow;
    private boolean writable = true;
    private final MethodDefinitionBuilder setterBuilder;
    private AbstractTransformer owner;
    private int annotationFlags = 6;
    private boolean valueConstructor;
    private ListBuffer<JCTree.JCAnnotation> classAnnotations;
    private ListBuffer<JCTree.JCAnnotation> modelAnnotations;
    private ListBuffer<JCTree.JCAnnotation> userAnnotations;
    private ListBuffer<JCTree.JCAnnotation> userAnnotationsSetter;
    private ListBuffer<JCTree.JCAnnotation> fieldAnnotations;
    private boolean isHash;
    private JCTree.JCExpression setterClass;
    private JCTree.JCExpression getterClass;

    private AttributeDefinitionBuilder(AbstractTransformer owner, TypedDeclaration attrType, String javaClassName, ClassDefinitionBuilder classBuilder, String attrName, String fieldName, boolean toplevel, boolean indirect) {
        int typeFlags = 0;
        TypedReference typedRef = owner.getTypedReference(attrType);
        TypedReference nonWideningTypedRef = owner.nonWideningTypeDecl(typedRef);
        Type nonWideningType = owner.nonWideningType(typedRef, nonWideningTypedRef);
        if (attrType.isActual() && CodegenUtil.hasTypeErased(attrType)) {
            typeFlags |= 8;
        }
        if (!CodegenUtil.isUnBoxed(nonWideningTypedRef.getDeclaration())) {
            typeFlags |= 4;
        }
        this.isHash = CodegenUtil.isHashAttribute((FunctionOrValue)attrType);
        this.attrTypedDecl = attrType;
        this.owner = owner;
        this.javaClassName = javaClassName;
        this.classBuilder = javaClassName != null ? ClassDefinitionBuilder.klass(owner, javaClassName, null, false) : classBuilder;
        this.attrType = nonWideningType;
        this.typeFlags = typeFlags;
        this.attrName = attrName;
        this.fieldName = fieldName;
        this.toplevel = toplevel;
        this.late = attrType.isLate();
        this.lateWithInit = this.late && CodegenUtil.needsLateInitField(attrType, owner.typeFact());
        this.variable = attrType.isVariable();
        this.getterBuilder = MethodDefinitionBuilder.getter(owner, attrType, indirect).block(this.generateDefaultGetterBlock()).isOverride(attrType.isActual()).isTransient(Decl.isTransient(attrType)).modelAnnotations(attrType.getAnnotations()).resultType(this.attrType(), attrType);
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.systemParameter(owner, attrName);
        pdb.modifiers(16L);
        pdb.aliasName(attrName);
        int seterParamFlags = 0;
        if (owner.rawParameters(attrType)) {
            seterParamFlags |= 8;
        }
        pdb.type(MethodDefinitionBuilder.paramType(owner, nonWideningTypedRef.getDeclaration(), nonWideningType, seterParamFlags), owner.makeJavaTypeAnnotations(attrType));
        this.setterBuilder = MethodDefinitionBuilder.setter(owner, attrType).block(this.generateDefaultSetterBlock()).isOverride(attrType.isActual() && ((TypedDeclaration)attrType.getRefinedDeclaration()).isVariable()).parameter(pdb);
    }

    public static AttributeDefinitionBuilder wrapped(AbstractTransformer owner, String javaClassName, ClassDefinitionBuilder classBuilder, String attrName, TypedDeclaration attrType, boolean toplevel) {
        return new AttributeDefinitionBuilder(owner, attrType, javaClassName, classBuilder, attrName, "value", toplevel, false);
    }

    public static AttributeDefinitionBuilder singleton(AbstractTransformer owner, String javaClassName, ClassDefinitionBuilder classBuilder, String attrName, TypedDeclaration attrType, boolean toplevel) {
        AttributeDefinitionBuilder adb = new AttributeDefinitionBuilder(owner, attrType, javaClassName, classBuilder, attrName, attrName, toplevel, false);
        adb.getterBuilder.realName(attrType.getName());
        return adb;
    }

    public static AttributeDefinitionBuilder indirect(AbstractTransformer owner, String javaClassName, String attrName, TypedDeclaration attrType, boolean toplevel) {
        return new AttributeDefinitionBuilder(owner, attrType, javaClassName, null, attrName, "value", toplevel, true);
    }

    public static AttributeDefinitionBuilder getter(AbstractTransformer owner, String attrAndFieldName, TypedDeclaration attrType) {
        return new AttributeDefinitionBuilder(owner, attrType, null, null, attrAndFieldName, attrAndFieldName, false, false).skipField().immutable();
    }

    public static AttributeDefinitionBuilder setter(AbstractTransformer owner, String attrAndFieldName, TypedDeclaration attrType) {
        return new AttributeDefinitionBuilder(owner, attrType, null, null, attrAndFieldName, attrAndFieldName, false, false).skipField().skipGetter();
    }

    public AttributeDefinitionBuilder modelAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.modelAnnotations == null) {
                this.modelAnnotations = ListBuffer.lb();
            }
            this.modelAnnotations.appendList(annotations);
        }
        return this;
    }

    public AttributeDefinitionBuilder classAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.classAnnotations == null) {
                this.classAnnotations = ListBuffer.lb();
            }
            this.classAnnotations.appendList(annotations);
        }
        return this;
    }

    public AttributeDefinitionBuilder fieldAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.fieldAnnotations == null) {
                this.fieldAnnotations = ListBuffer.lb();
            }
            this.fieldAnnotations.appendList(annotations);
        }
        return this;
    }

    public AttributeDefinitionBuilder userAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.userAnnotations == null) {
                this.userAnnotations = ListBuffer.lb();
            }
            this.userAnnotations.appendList(annotations);
        }
        return this;
    }

    public AttributeDefinitionBuilder userAnnotationsSetter(List<JCTree.JCAnnotation> annotations) {
        if (annotations != null) {
            if (this.userAnnotationsSetter == null) {
                this.userAnnotationsSetter = ListBuffer.lb();
            }
            this.userAnnotationsSetter.appendList(annotations);
        }
        return this;
    }

    public List<JCTree> build() {
        ListBuffer<JCTree> defs = ListBuffer.lb();
        this.appendDefinitionsTo(defs);
        if (this.javaClassName != null) {
            this.classBuilder.getInitBuilder().modifiers(2L);
            this.classBuilder.modifiers(0x10L | this.modifiers & 3L).defs(defs.toList());
            if (this.getterClass == null) {
                this.classBuilder.annotations(this.owner.makeAtAttribute(this.setterClass)).annotations(this.owner.makeAtName(this.attrName)).satisfies(this.getSatisfies());
            } else {
                this.classBuilder.annotations(this.owner.makeAtIgnore());
                this.classBuilder.annotations(this.owner.makeAtSetter(this.getterClass));
            }
            if (this.classAnnotations != null) {
                this.classBuilder.annotations(this.classAnnotations.toList());
            }
            if (this.valueConstructor && this.hasField) {
                this.generateValueConstructor(this.classBuilder.addConstructor());
            }
            return this.classBuilder.build();
        }
        return defs.toList();
    }

    public void appendDefinitionsTo(ListBuffer<JCTree> defs) {
        if (this.hasField && this.variableInitThrow == null) {
            defs.append(this.generateField());
            if (this.hasInitFlag()) {
                defs.append(this.generateInitFlagField());
            }
            if (this.isDeferredInitError()) {
                defs.append(this.generateInitExceptionField());
            }
            if (this.variableInit != null) {
                defs.append(this.generateFieldInit());
            }
        }
        if (this.readable) {
            if (this.variableInitThrow != null) {
                this.getterBuilder.block(this.owner.make().Block(0L, List.of(this.owner.makeThrowUnresolvedCompilationError(this.variableInitThrow))));
            }
            this.getterBuilder.modifiers(this.getGetSetModifiers());
            this.getterBuilder.annotationFlags(this.annotationFlags);
            if (this.modelAnnotations != null) {
                this.getterBuilder.modelAnnotations(this.modelAnnotations.toList());
            }
            if (this.userAnnotations != null) {
                this.getterBuilder.userAnnotations(this.userAnnotations.toList());
            }
            defs.append(this.getterBuilder.build());
        }
        if (this.writable) {
            if (this.variableInitThrow != null) {
                this.setterBuilder.block(this.owner.make().Block(0L, List.of(this.owner.makeThrowUnresolvedCompilationError(this.variableInitThrow))));
            }
            this.setterBuilder.modifiers(this.getGetSetModifiers());
            this.setterBuilder.annotationFlags(this.annotationFlags | (this.late && !this.variable ? 1 : 0));
            if (this.userAnnotationsSetter != null) {
                this.setterBuilder.userAnnotations(this.userAnnotationsSetter.toList());
            }
            defs.append(this.setterBuilder.build());
        }
    }

    private boolean isDeferredInitError() {
        return this.toplevel && !this.late;
    }

    private List<Type> getSatisfies() {
        List<Type> types = List.nil();
        if (this.javaClassName != null && this.readable && !this.toplevel) {
            types = types.append(this.owner.getGetterInterfaceType(this.attrTypedDecl));
        }
        return types;
    }

    private void generateValueConstructor(MethodDefinitionBuilder methodDefinitionBuilder) {
        ParameterDefinitionBuilder paramBuilder = ParameterDefinitionBuilder.systemParameter(this.owner, this.fieldName).type(this.attrType(), null);
        JCTree.JCAssign init = this.owner.make().Assign(this.owner.makeQualIdent(this.owner.naming.makeThis(), this.fieldName), this.owner.makeUnquotedIdent(this.fieldName));
        methodDefinitionBuilder.parameter(paramBuilder).body(this.owner.make().Exec(init));
    }

    private JCTree.JCExpression attrType() {
        if (this.isHash) {
            return this.owner.make().Type(this.owner.syms().intType);
        }
        return this.owner.makeJavaType(this.attrType, this.typeFlags);
    }

    private JCTree.JCExpression attrTypeRaw() {
        if (this.isHash) {
            return this.owner.make().Type(this.owner.syms().intType);
        }
        return this.owner.makeJavaType(this.attrType, 8);
    }

    private long getGetSetModifiers() {
        long mods = this.modifiers;
        if (this.javaClassName != null) {
            mods |= 1L;
        }
        return mods & 0x41BL;
    }

    private JCTree generateField() {
        long flags = 2L | this.modifiers & 8L;
        if (!this.writable && (this.variableInit != null || this.valueConstructor)) {
            flags |= 0x10L;
        }
        return this.owner.make().VarDef(this.owner.make().Modifiers(flags, this.fieldAnnotations != null ? this.fieldAnnotations.toList() : List.nil()), this.owner.names().fromString(Naming.quoteFieldName(this.fieldName)), this.attrType(), null);
    }

    private JCTree generateInitFlagField() {
        long flags = 2L | this.modifiers & 8L | 0x40L;
        if ((flags & 8L) == 0L) {
            flags |= 0x80L;
        }
        return this.owner.make().VarDef(this.owner.make().Modifiers(flags), this.owner.names().fromString(Naming.getInitializationFieldName(this.fieldName)), this.owner.make().Type(this.owner.syms().booleanType), this.owner.make().Literal(false));
    }

    private JCTree generateInitExceptionField() {
        long flags = 26L;
        return this.owner.make().VarDef(this.owner.make().Modifiers(flags), this.owner.names().fromString(Naming.quoteIfJavaKeyword(Naming.getToplevelAttributeSavedExceptionName())), this.owner.makeJavaType(this.owner.syms().throwableType.tsym), null);
    }

    private JCTree generateFieldInit() {
        List<JCTree.JCStatement> stmts;
        long flags = this.modifiers & 8L;
        JCTree.JCExpression varInit = this.variableInit;
        if (this.hasInitFlag()) {
            varInit = this.variableInit;
        }
        JCTree.JCAssign init = this.owner.make().Assign(this.owner.makeUnquotedIdent(Naming.quoteFieldName(this.fieldName)), varInit);
        if (this.isDeferredInitError()) {
            String exceptionName = "x";
            JCTree.JCExpressionStatement saveException = this.owner.make().Exec(this.owner.make().Assign(this.owner.makeUnquotedIdent(Naming.getToplevelAttributeSavedExceptionName()), this.owner.makeUnquotedIdent(exceptionName)));
            JCTree.JCExpressionStatement nullValue = this.owner.make().Exec(this.owner.make().Assign(this.owner.makeUnquotedIdent(this.fieldName), this.owner.makeDefaultExprForType(this.attrType)));
            JCTree.JCExpressionStatement initFlagFalse = this.owner.make().Exec(this.owner.make().Assign(this.owner.naming.makeUnquotedIdent(Naming.getInitializationFieldName(this.fieldName)), this.owner.make().Literal(false)));
            JCTree.JCBlock handlerBlock = this.owner.make().Block(0L, List.of(saveException, nullValue, initFlagFalse));
            JCTree.JCExpression throwableType = this.owner.makeJavaType(this.owner.syms().throwableType.tsym);
            JCTree.JCVariableDecl exceptionParam = this.owner.make().VarDef(this.owner.make().Modifiers(0L), this.owner.naming.makeUnquotedName(exceptionName), throwableType, null);
            JCTree.JCCatch catchers = this.owner.make().Catch(exceptionParam, handlerBlock);
            JCTree.JCAssign nullException = this.owner.make().Assign(this.owner.makeUnquotedIdent(Naming.getToplevelAttributeSavedExceptionName()), this.owner.makeNull());
            JCTree.JCAssign initFlagTrue = this.owner.make().Assign(this.owner.naming.makeUnquotedIdent(Naming.getInitializationFieldName(this.fieldName)), this.owner.make().Literal(true));
            List<JCTree.JCStatement> body = List.of(this.owner.make().Exec(init), this.owner.make().Exec(nullException), this.owner.make().Exec(initFlagTrue));
            JCTree.JCTry try_ = this.owner.make().Try(this.owner.make().Block(0L, body), List.of(catchers), null);
            stmts = List.of(try_);
        } else {
            stmts = List.of(this.owner.make().Exec(init));
        }
        return this.owner.make().Block(flags, stmts);
    }

    private JCTree.JCBlock generateDefaultGetterBlock() {
        JCTree.JCBlock block;
        JCTree.JCExpression returnExpr = this.owner.makeQuotedIdent(this.fieldName);
        if (this.isHash) {
            returnExpr = this.owner.convertToIntForHashAttribute(returnExpr);
        }
        JCTree.JCReturn returnValue = this.owner.make().Return(returnExpr);
        List<JCTree.JCStatement> stmts = List.of(returnValue);
        if (this.toplevel || this.late) {
            List<JCTree.JCStatement> catchStmts;
            JCTree.JCLiteral msg = this.owner.make().Literal(this.late ? "Accessing uninitialized 'late' attribute '" + this.attrName + "'" : "Cyclic initialization trying to read the value of '" + this.attrName + "' before it was set");
            JCTree.JCThrow throwStmt = this.owner.make().Throw(this.owner.makeNewClass(this.owner.makeIdent(this.owner.syms().ceylonInitializationErrorType), List.of(msg)));
            if (this.isDeferredInitError()) {
                JCTree.JCExpressionStatement rethrow = this.owner.make().Exec(this.owner.utilInvocation().rethrow(this.owner.makeUnquotedIdent(Naming.getToplevelAttributeSavedExceptionName())));
                JCTree.JCIf ifThrow = this.owner.make().If(this.owner.make().Binary(63, this.owner.makeUnquotedIdent(Naming.getToplevelAttributeSavedExceptionName()), this.owner.makeNull()), rethrow, null);
                catchStmts = List.of(ifThrow, throwStmt);
            } else {
                catchStmts = List.of(throwStmt);
            }
            block = this.owner.make().Block(0L, List.of(this.owner.make().If(this.makeInitFlagExpr(true), this.owner.make().Block(0L, stmts), this.owner.make().Block(0L, catchStmts))));
        } else {
            block = this.owner.make().Block(0L, stmts);
        }
        return block;
    }

    private boolean hasInitFlag() {
        return this.toplevel || this.lateWithInit;
    }

    public JCTree.JCBlock generateDefaultSetterBlock() {
        JCTree.JCExpression fld = this.fld();
        JCTree.JCExpressionStatement assign = this.owner.make().Exec(this.owner.make().Assign(fld, this.owner.makeQuotedIdent(this.attrName)));
        List<JCTree.JCStatement> stmts = List.of(assign);
        if (this.late) {
            JCTree.JCExpressionStatement makeInit = null;
            if (this.lateWithInit) {
                makeInit = this.owner.make().Exec(this.owner.make().Assign(this.makeInitFlagExpr(true), this.owner.make().Literal(true)));
            }
            if (this.variable) {
                if (makeInit != null) {
                    stmts = List.of(assign, makeInit);
                }
            } else {
                List<JCTree.JCStatement> then = List.of(this.owner.make().Return(null));
                if (makeInit != null) {
                    then = then.prepend(makeInit);
                }
                then = then.prepend((JCTree.JCReturn)((Object)assign));
                stmts = List.of(this.owner.make().If(this.makeInitFlagExpr(false), this.owner.make().Block(0L, then), null), this.owner.make().Throw(this.owner.makeNewClass(this.owner.make().Type(this.owner.syms().ceylonInitializationErrorType), List.of(this.owner.make().Literal("Re-initialization of 'late' attribute")))));
            }
        }
        if (this.hasInitFlag() && this.isDeferredInitError()) {
            JCTree.JCExpressionStatement rethrow = this.owner.make().Exec(this.owner.utilInvocation().rethrow(this.owner.makeUnquotedIdent(Naming.getToplevelAttributeSavedExceptionName())));
            JCTree.JCIf ifThrow = this.owner.make().If(this.owner.make().Binary(63, this.owner.makeUnquotedIdent(Naming.getToplevelAttributeSavedExceptionName()), this.owner.makeNull()), rethrow, null);
            stmts = stmts.prepend(ifThrow);
        }
        return this.owner.make().Block(0L, stmts);
    }

    private JCTree.JCExpression makeInitFlagExpr(boolean positiveIfTest) {
        JCTree.JCExpression initFlagFieldOwner = this.toplevel ? (this.classBuilder != null ? this.owner.naming.makeUnquotedIdent(this.classBuilder.getClassName()) : this.owner.naming.makeUnquotedIdent(this.javaClassName)) : this.owner.naming.makeThis();
        if (this.toplevel || this.lateWithInit) {
            JCTree.JCExpression ret = this.owner.naming.makeQualIdent(initFlagFieldOwner, Naming.getInitializationFieldName(this.fieldName));
            if (!positiveIfTest) {
                return this.owner.make().Unary(50, ret);
            }
            return ret;
        }
        return this.owner.make().Binary(positiveIfTest ? 63 : 62, this.owner.naming.makeQualIdent(initFlagFieldOwner, this.fieldName), this.owner.makeNull());
    }

    private JCTree.JCExpression fld() {
        JCTree.JCExpression fld = this.fieldName.equals(this.attrName) ? this.owner.makeSelect("this", Naming.quoteFieldName(this.fieldName)) : this.owner.makeQuotedIdent(this.fieldName);
        return fld;
    }

    public AttributeDefinitionBuilder modifiers(long ... modifiers) {
        long mods = 0L;
        for (long mod : modifiers) {
            mods |= mod;
        }
        this.modifiers = mods;
        return this;
    }

    public AttributeDefinitionBuilder is(long flag, boolean value) {
        this.modifiers = value ? (this.modifiers |= flag) : (this.modifiers &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    public AttributeDefinitionBuilder noModelAnnotations() {
        this.annotationFlags = Annotations.noModel(this.annotationFlags);
        return this;
    }

    public AttributeDefinitionBuilder ignoreAnnotations() {
        this.annotationFlags = Annotations.noUserOrModel(Annotations.ignore(this.annotationFlags));
        return this;
    }

    public AttributeDefinitionBuilder noAnnotations() {
        this.annotationFlags = 0;
        return this;
    }

    public AttributeDefinitionBuilder isFormal(boolean isFormal) {
        this.getterBuilder.isAbstract(isFormal);
        this.setterBuilder.isAbstract(isFormal);
        return this;
    }

    public AttributeDefinitionBuilder skipField() {
        this.hasField = false;
        return this;
    }

    public AttributeDefinitionBuilder getterBlock(JCTree.JCBlock getterBlock) {
        this.skipField();
        this.getterBuilder.block(getterBlock);
        return this;
    }

    public AttributeDefinitionBuilder skipGetter() {
        this.readable = false;
        return this;
    }

    public AttributeDefinitionBuilder setterBlock(JCTree.JCBlock setterBlock) {
        this.setterBuilder.block(setterBlock);
        return this;
    }

    public AttributeDefinitionBuilder immutable() {
        this.writable = false;
        return this;
    }

    public AttributeDefinitionBuilder initialValue(JCTree.JCExpression initialValue) {
        this.variableInit = initialValue;
        return this;
    }

    public AttributeDefinitionBuilder initialValueError(HasErrorException variableInitThrow) {
        this.variableInitThrow = variableInitThrow;
        return this;
    }

    public AttributeDefinitionBuilder notActual() {
        this.getterBuilder.isOverride(false);
        this.setterBuilder.isOverride(false);
        return this;
    }

    public AttributeDefinitionBuilder valueConstructor() {
        this.valueConstructor = true;
        return this;
    }

    public void setterClass(JCTree.JCExpression setterClass) {
        this.setterClass = setterClass;
    }

    public void isSetter(JCTree.JCExpression getterClass) {
        this.getterClass = getterClass;
    }
}

