/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashMap;
import java.util.Map;

public abstract class BoxingDeclarationVisitor
extends Visitor {
    private Map<Function, Function> optimisedMethodSpecifiersToMethods = new HashMap<Function, Function>();
    private static final boolean forceBoxedLocals = Boolean.getBoolean("ceylon.compiler.forceBoxedLocals");

    protected abstract boolean isCeylonBasicType(Type var1);

    protected abstract boolean isNull(Type var1);

    protected abstract boolean isObject(Type var1);

    protected abstract boolean isCallable(Type var1);

    protected abstract boolean hasErasure(Type var1);

    protected abstract boolean willEraseToObject(Type var1);

    protected abstract boolean isRaw(Type var1);

    protected abstract boolean isWideningTypedDeclaration(TypedDeclaration var1);

    protected abstract boolean hasSubstitutedBounds(Type var1);

    @Override
    public void visit(Tree.FunctionArgument that) {
        super.visit(that);
        that.getDeclarationModel().setUnboxed(false);
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        super.visit(that);
        that.getDeclarationModel().setUnboxed(false);
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        super.visit(that);
        this.visitMethod(that.getDeclarationModel(), that);
    }

    private void visitMethod(Function method, Node that) {
        this.boxMethod(method, that);
        this.rawTypedDeclaration(method);
        this.setErasureState(method);
    }

    @Override
    public void visit(Tree.FunctionalParameterDeclaration that) {
        if (Strategy.createMethod(that.getParameterModel())) {
            this.visitMethod((Function)that.getParameterModel().getModel(), that);
            that.visitChildren(this);
        } else {
            super.visit(that);
        }
    }

    private void setErasureState(TypedDeclaration decl) {
        if (decl == null) {
            return;
        }
        Type type = decl.getType();
        if (type != null) {
            if (this.hasErasure(type) || this.hasSubstitutedBounds(type) || type.isTypeConstructor()) {
                decl.setTypeErased(true);
            }
            if (decl.isActual() && decl.getContainer() instanceof ClassOrInterface && this.isWideningTypedDeclaration(decl)) {
                decl.setUntrustedType(true);
                decl.setTypeErased(true);
            }
        }
    }

    private void rawTypedDeclaration(TypedDeclaration decl) {
        if (decl == null) {
            return;
        }
        Type type = decl.getType();
        if (type != null && this.isRaw(type)) {
            type.setRaw(true);
        }
    }

    private void boxMethod(Function method, Node that) {
        if (method == null) {
            return;
        }
        Declaration refined = CodegenUtil.getTopmostRefinedDeclaration(method, this.optimisedMethodSpecifiersToMethods);
        if (refined == null || !(refined instanceof Function)) {
            return;
        }
        TypedDeclaration refinedMethod = (TypedDeclaration)refined;
        if (method.getName() != null) {
            this.setBoxingState(method, refinedMethod, that);
        } else {
            method.setUnboxed(false);
        }
    }

    private void setBoxingState(TypedDeclaration declaration, TypedDeclaration refinedDeclaration, Node that) {
        FunctionOrValue methodOrValueForParam;
        Type type = declaration.getType();
        if (type == null) {
            return;
        }
        if (Decl.equal(declaration, refinedDeclaration) && declaration instanceof FunctionOrValue && ((FunctionOrValue)declaration).isParameter() && declaration.getContainer() instanceof Class && (methodOrValueForParam = (FunctionOrValue)declaration) != null) {
            refinedDeclaration = (TypedDeclaration)methodOrValueForParam.getRefinedDeclaration();
        }
        if (!Decl.equal(refinedDeclaration, declaration) && type.getUnderlyingType() == null && refinedDeclaration.getType() != null) {
            type.setUnderlyingType(refinedDeclaration.getType().getUnderlyingType());
        }
        if (declaration.getUnboxed() != null) {
            return;
        }
        if (declaration instanceof Function && ((Function)declaration).isParameter() && !JvmBackendUtil.createMethod((Function)declaration)) {
            declaration.setUnboxed(false);
            return;
        }
        if (!Decl.equal(refinedDeclaration, declaration)) {
            if (refinedDeclaration.getUnboxed() == null) {
                this.setBoxingState(refinedDeclaration, refinedDeclaration, that);
            }
            declaration.setUnboxed(refinedDeclaration.getUnboxed());
        } else if (!(!(declaration instanceof Function) || !CodegenUtil.isVoid(declaration.getType()) || !Strategy.useBoxedVoid((Function)declaration) || refinedDeclaration.getTypeDeclaration() instanceof TypeParameter || CodegenUtil.isContainerFunctionalParameter(refinedDeclaration) || refinedDeclaration instanceof Functional && Decl.isMpl((Functional)((Object)refinedDeclaration)))) {
            declaration.setUnboxed(false);
        } else if (!(!this.isCeylonBasicType(type) && !Decl.isUnboxedVoid(declaration) || refinedDeclaration.getTypeDeclaration() instanceof TypeParameter || refinedDeclaration.getContainer() instanceof Declaration && CodegenUtil.isContainerFunctionalParameter(refinedDeclaration) || refinedDeclaration instanceof Functional && Decl.isMpl((Functional)((Object)refinedDeclaration)))) {
            boolean unbox = !forceBoxedLocals || !(declaration instanceof Value) || !Decl.isLocal(declaration) || Decl.isParameter(declaration) || Decl.isTransient(declaration);
            declaration.setUnboxed(unbox);
        } else if (Decl.isValueParameter(declaration) && CodegenUtil.isContainerFunctionalParameter(declaration) && JvmBackendUtil.createMethod((FunctionOrValue)((Object)declaration.getContainer()))) {
            Function functionalParameter = (Function)declaration.getContainer();
            TypedDeclaration refinedFrom = (TypedDeclaration)CodegenUtil.getTopmostRefinedDeclaration(functionalParameter, this.optimisedMethodSpecifiersToMethods);
            if (Decl.equal(refinedFrom, functionalParameter)) {
                if (declaration.getUnit().getAnythingType().isExactly(declaration.getType()) || declaration.getUnit().isOptionalType(declaration.getType())) {
                    declaration.setUnboxed(false);
                } else {
                    declaration.setUnboxed(true);
                }
            } else {
                if (refinedFrom.getUnboxed() == null) {
                    this.setBoxingState(refinedFrom, refinedFrom, that);
                }
                declaration.setUnboxed(refinedFrom.getUnboxed());
            }
        } else {
            declaration.setUnboxed(false);
        }
        this.boxFromAnnotation(declaration, that);
    }

    private void boxAttribute(TypedDeclaration declaration, Node that) {
        if (declaration == null) {
            return;
        }
        TypedDeclaration refinedDeclaration = null;
        refinedDeclaration = (TypedDeclaration)CodegenUtil.getTopmostRefinedDeclaration(declaration, this.optimisedMethodSpecifiersToMethods);
        if (refinedDeclaration == null) {
            return;
        }
        this.setBoxingState(declaration, refinedDeclaration, that);
    }

    private void boxFromAnnotation(TypedDeclaration declaration, Node that) {
        if (that instanceof Tree.StatementOrArgument) {
            if (CodegenUtil.hasCompilerAnnotation((Tree.StatementOrArgument)that, "boxed")) {
                declaration.setUnboxed(false);
            } else if (CodegenUtil.hasCompilerAnnotation((Tree.StatementOrArgument)that, "unboxed")) {
                declaration.setUnboxed(true);
            }
        }
    }

    @Override
    public void visit(Tree.Parameter that) {
        super.visit(that);
        FunctionOrValue declaration = that.getParameterModel().getModel();
        this.visitAttributeOrParameter(declaration, that);
    }

    @Override
    public void visit(Tree.ValueParameterDeclaration that) {
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyAttribute that) {
        super.visit(that);
        TypedDeclaration declaration = that.getDeclarationModel();
        this.visitAttributeOrParameter(declaration, that);
    }

    private void visitAttributeOrParameter(TypedDeclaration declaration, Node that) {
        this.boxAttribute(declaration, that);
        this.rawTypedDeclaration(declaration);
        this.setErasureState(declaration);
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (that.getSpecifierOrInitializerExpression() != null && that.getDeclarationModel() != null && that.getType() instanceof Tree.ValueModifier && that.getDeclarationModel().getType().equals(that.getSpecifierOrInitializerExpression().getExpression().getTypeModel())) {
            that.getDeclarationModel().setType(that.getDeclarationModel().getType().withoutUnderlyingType());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        super.visit(that);
        this.boxAttribute(that.getDeclarationModel(), that);
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        super.visit(that);
        Setter declaration = that.getDeclarationModel();
        if (declaration == null) {
            return;
        }
        FunctionOrValue paramDeclaration = declaration.getParameter().getModel();
        this.boxAttribute(paramDeclaration, that);
        declaration.setUnboxed(paramDeclaration.getUnboxed());
        this.boxFromAnnotation(declaration, that);
        paramDeclaration.setUnboxed(declaration.getUnboxed());
    }

    @Override
    public void visit(Tree.Variable that) {
        super.visit(that);
        Value declaration = that.getDeclarationModel();
        if (declaration == null) {
            return;
        }
        this.setBoxingState(declaration, declaration, that);
        this.rawTypedDeclaration(declaration);
        this.setErasureState(declaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Tree.SpecifierStatement that) {
        Tree.Term term;
        TypedDeclaration declaration = that.getDeclaration();
        Function optimisedDeclaration = null;
        if (declaration instanceof Function && that.getSpecifierExpression() != null && !(that.getSpecifierExpression() instanceof Tree.LazySpecifierExpression) && (term = Decl.unwrapExpressionsUntilTerm(that.getSpecifierExpression().getExpression())) != null && term instanceof Tree.FunctionArgument) {
            optimisedDeclaration = ((Tree.FunctionArgument)term).getDeclarationModel();
            this.optimisedMethodSpecifiersToMethods.put(optimisedDeclaration, (Function)declaration);
        }
        try {
            super.visit(that);
        }
        finally {
            if (optimisedDeclaration != null) {
                this.optimisedMethodSpecifiersToMethods.remove(optimisedDeclaration);
            }
        }
        if (declaration == null) {
            return;
        }
        if (declaration instanceof Function) {
            this.visitMethod((Function)declaration, that);
        } else if (declaration instanceof Value) {
            this.visitAttributeOrParameter(declaration, that);
        }
    }

    @Override
    public void visit(Tree.ForComprehensionClause that) {
        super.visit(that);
        Tree.ForIterator iter = that.getForIterator();
        if (iter instanceof Tree.ValueIterator) {
            Type typeModel = iter.getSpecifierExpression().getExpression().getTypeModel();
            ((Tree.ValueIterator)iter).getVariable().getDeclarationModel().setUnboxed(iter.getUnit().isJavaArrayType(typeModel));
        } else if (iter instanceof Tree.PatternIterator) {
            this.boxPattern(((Tree.PatternIterator)iter).getPattern());
        }
    }

    private void boxPattern(Tree.Pattern pattern) {
        if (pattern instanceof Tree.KeyValuePattern) {
            this.boxPattern(((Tree.KeyValuePattern)pattern).getKey());
            this.boxPattern(((Tree.KeyValuePattern)pattern).getValue());
        } else if (pattern instanceof Tree.TuplePattern) {
            for (Tree.Pattern p : ((Tree.TuplePattern)pattern).getPatterns()) {
                this.boxPattern(p);
            }
        } else if (pattern instanceof Tree.VariablePattern) {
            ((Tree.VariablePattern)pattern).getVariable().getDeclarationModel().setUnboxed(false);
        } else {
            throw BugException.unhandledCase(pattern);
        }
    }

    @Override
    public void visit(Tree.TypeParameterDeclaration that) {
        super.visit(that);
        TypeParameter typeParameter = that.getDeclarationModel();
        if (typeParameter != null) {
            this.visitTypeParameter(typeParameter);
        }
    }

    private void visitTypeParameter(TypeParameter typeParameter) {
        if (typeParameter.hasNonErasedBounds() != null) {
            return;
        }
        for (Type pt : typeParameter.getSatisfiedTypes()) {
            if (this.willEraseToObject(pt)) continue;
            typeParameter.setNonErasedBounds(true);
            return;
        }
        typeParameter.setNonErasedBounds(false);
    }

    @Override
    public void visit(Tree.ValueIterator that) {
        super.visit(that);
        if (that.getVariable() != null && that.getSpecifierExpression().getExpression().getTerm() instanceof Tree.RangeOp) {
            that.getVariable().getDeclarationModel().setUnboxed(true);
        }
    }
}

