/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.ExpressionAndType;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.loader.NamingBase;
import java.util.Collection;

public class CallBuilder {
    public static final int CB_ALIAS_ARGS = 1;
    public static final int CB_LET = 2;
    private static final String MISSING_TYPE = "Type expression required when evaluateArgumentsFirst()";
    private final AbstractTransformer gen;
    private Kind kind;
    private ListBuffer<JCTree.JCExpression> typeargs = ListBuffer.lb();
    private ListBuffer<ExpressionAndType> argumentsAndTypes = ListBuffer.lb();
    private JCTree.JCExpression methodOrClass;
    private ExpressionAndType instantiateQualfier;
    private int cbOpts;
    private Naming.SyntheticName basename;
    private boolean built = false;
    private final ListBuffer<JCTree.JCStatement> statements = ListBuffer.lb();
    private boolean voidMethod;
    private boolean haveLocation = false;
    private Node location;
    private JCTree.JCClassDecl classDefs;
    private JCTree.JCExpression arrayInstanceReifiedType;
    private JCTree.JCExpression arrayInstanceCast;
    private int arrayInstanceDimensions;
    private boolean arrayWriteNeedsCast;

    private CallBuilder(AbstractTransformer gen) {
        this.gen = gen;
    }

    public static CallBuilder instance(AbstractTransformer gen) {
        CallBuilder builder = new CallBuilder(gen);
        return builder;
    }

    public CallBuilder location(Node at) {
        this.haveLocation = true;
        this.location = at;
        return this;
    }

    public CallBuilder arrayRead(JCTree.JCExpression expr) {
        this.methodOrClass = expr;
        this.instantiateQualfier = null;
        this.kind = Kind.ARRAY_READ;
        return this;
    }

    public CallBuilder arrayWrite(JCTree.JCExpression expr) {
        this.methodOrClass = expr;
        this.instantiateQualfier = null;
        this.kind = Kind.ARRAY_WRITE;
        return this;
    }

    public CallBuilder invoke(JCTree.JCExpression fn) {
        this.methodOrClass = fn;
        this.instantiateQualfier = null;
        this.kind = Kind.APPLY;
        return this;
    }

    public CallBuilder fieldRead(JCTree.JCExpression expr) {
        this.methodOrClass = expr;
        this.instantiateQualfier = null;
        this.kind = Kind.FIELD_READ;
        return this;
    }

    public CallBuilder instantiate(JCTree.JCExpression cls) {
        return this.instantiate(null, cls);
    }

    public CallBuilder instantiate(ExpressionAndType qualifier, JCTree.JCExpression cls) {
        return this.instantiate(qualifier, cls, null);
    }

    public CallBuilder instantiate(ExpressionAndType qualifier, JCTree.JCExpression cls, JCTree.JCClassDecl classDefs) {
        this.methodOrClass = cls;
        this.classDefs = classDefs;
        this.instantiateQualfier = qualifier;
        this.kind = Kind.NEW;
        return this;
    }

    public CallBuilder javaArrayInstance(JCTree.JCExpression type) {
        this.methodOrClass = type;
        this.instantiateQualfier = null;
        this.kind = Kind.NEW_ARRAY;
        return this;
    }

    public CallBuilder typeArgument(JCTree.JCExpression expr) {
        this.typeargs.append(expr);
        return this;
    }

    public CallBuilder typeArguments(List<JCTree.JCExpression> typeArguments) {
        this.typeargs.clear();
        this.typeargs.addAll((Collection<JCTree.JCExpression>)typeArguments);
        return this;
    }

    public CallBuilder argument(JCTree.JCExpression expr) {
        this.argumentAndType(new ExpressionAndType(expr, null));
        return this;
    }

    public CallBuilder argumentAndType(ExpressionAndType argumentAndType) {
        this.argumentsAndTypes.append(argumentAndType);
        return this;
    }

    public CallBuilder prependArgumentAndType(ExpressionAndType argumentAndType) {
        this.argumentsAndTypes = this.argumentsAndTypes.prepend(argumentAndType);
        return this;
    }

    public CallBuilder arguments(List<JCTree.JCExpression> args) {
        for (JCTree.JCExpression arg : args) {
            this.argument(arg);
        }
        return this;
    }

    public CallBuilder argumentsAndTypes(List<ExpressionAndType> argsAndTypes) {
        this.argumentsAndTypes.clear();
        this.argumentsAndTypes.addAll((Collection<ExpressionAndType>)argsAndTypes);
        return this;
    }

    public CallBuilder argumentHandling(int cbOpts, Naming.SyntheticName basename) {
        if (this.built) {
            throw new BugException("already built");
        }
        this.cbOpts = cbOpts;
        this.basename = basename;
        return this;
    }

    public int getArgumentHandling() {
        return this.cbOpts;
    }

    public CallBuilder appendStatement(JCTree.JCStatement stmt) {
        this.statements.append(stmt);
        return this;
    }

    public List<JCTree.JCStatement> getStatements() {
        if (!this.built) {
            throw new BugException("not yet built");
        }
        return this.statements.toList();
    }

    public JCTree.JCExpression build() {
        JCTree.JCExpression result;
        List<JCTree.JCExpression> arguments;
        JCTree.JCExpression newEncl;
        if (this.built) {
            throw new BugException("already built");
        }
        this.built = true;
        if ((this.cbOpts & 1) != 0) {
            if (this.instantiateQualfier != null && this.instantiateQualfier.expression != null) {
                if (this.instantiateQualfier.type == null) {
                    throw new BugException(MISSING_TYPE);
                }
                Naming.SyntheticName qualName = this.getQualifierName(this.basename);
                this.appendStatement(this.gen.makeVar(16L, qualName, this.instantiateQualfier.type, this.instantiateQualfier.expression));
                newEncl = qualName.makeIdent();
            } else {
                newEncl = null;
            }
            arguments = List.nil();
            int argumentNum = 0;
            for (ExpressionAndType argumentAndType : this.argumentsAndTypes) {
                Naming.SyntheticName name = this.getArgumentName(this.basename, argumentNum);
                if (argumentAndType.type == null) {
                    throw new BugException(MISSING_TYPE);
                }
                if ((this.cbOpts & 1) != 0) {
                    this.appendStatement(this.gen.makeVar(16L, name, argumentAndType.type, argumentAndType.expression));
                }
                arguments = arguments.append(name.makeIdent());
                ++argumentNum;
            }
        } else {
            newEncl = this.instantiateQualfier != null ? this.instantiateQualfier.expression : null;
            arguments = ExpressionAndType.toExpressionList(this.argumentsAndTypes);
        }
        if (this.haveLocation) {
            this.gen.at(this.location);
        }
        switch (this.kind) {
            case APPLY: {
                result = this.gen.make().Apply(this.typeargs.toList(), this.methodOrClass, arguments);
                break;
            }
            case NEW: {
                result = this.gen.make().NewClass(newEncl, null, this.methodOrClass, arguments, this.classDefs);
                break;
            }
            case ARRAY_READ: {
                result = this.gen.make().Indexed(this.methodOrClass, (JCTree.JCExpression)arguments.head);
                break;
            }
            case ARRAY_WRITE: {
                JCTree.JCExpression array = this.arrayWriteNeedsCast ? this.gen.make().TypeCast(this.gen.make().TypeArray(this.gen.make().Type(this.gen.syms().objectType)), this.methodOrClass) : this.methodOrClass;
                result = this.gen.make().Assign(this.gen.make().Indexed(array, (JCTree.JCExpression)arguments.head), (JCTree.JCExpression)arguments.tail.head);
                break;
            }
            case NEW_ARRAY: {
                JCTree.JCExpression elementTypeExpr = ((JCTree.JCArrayTypeTree)this.methodOrClass).elemtype;
                if (this.arrayInstanceReifiedType == null) {
                    result = this.gen.make().NewArray(elementTypeExpr, List.of(arguments.head), null);
                    if (this.arrayInstanceCast != null) {
                        result = this.gen.make().TypeCast(this.arrayInstanceCast, result);
                    }
                } else {
                    List<JCTree.JCExpression> dimensions = List.nil();
                    if (this.arrayInstanceDimensions > 1) {
                        for (int i = 1; i < this.arrayInstanceDimensions; ++i) {
                            dimensions = dimensions.prepend(this.gen.makeInteger(0));
                        }
                    }
                    dimensions = dimensions.prepend((JCTree.JCExpression)arguments.head);
                    dimensions = dimensions.prepend(this.arrayInstanceReifiedType);
                    result = this.gen.utilInvocation().makeArray(dimensions);
                }
                if (!arguments.tail.nonEmpty()) break;
                result = this.gen.utilInvocation().fillArray(List.of(result, arguments.tail.head));
                break;
            }
            case FIELD_READ: {
                result = this.methodOrClass;
                break;
            }
            default: {
                throw BugException.unhandledEnumCase(this.kind);
            }
        }
        if ((this.cbOpts & 2) != 0) {
            if (this.voidMethod) {
                result = this.gen.make().LetExpr(this.statements.toList().append(this.gen.make().Exec(result)), (JCTree)this.gen.makeNull());
            } else if (!this.statements.isEmpty()) {
                result = this.gen.make().LetExpr(this.statements.toList(), (JCTree)result);
            }
        }
        return result;
    }

    private Naming.SyntheticName getArgumentName(Naming.SyntheticName basename, int argumentNum) {
        Naming.SyntheticName name = basename.suffixedBy(NamingBase.Suffix.$arg$, argumentNum);
        return name;
    }

    private Naming.SyntheticName getQualifierName(Naming.SyntheticName basename) {
        Naming.SyntheticName qualName = basename.suffixedBy(NamingBase.Suffix.$qual$);
        return qualName;
    }

    public void voidMethod(boolean voidMethod) {
        this.voidMethod = voidMethod;
    }

    public void javaArrayInstanceIsGeneric(JCTree.JCExpression reifiedType, int dimensions) {
        this.arrayInstanceReifiedType = reifiedType;
        this.arrayInstanceDimensions = dimensions;
    }

    public void javaArrayInstanceNeedsCast(JCTree.JCExpression requiredType) {
        this.arrayInstanceCast = requiredType;
    }

    public void javaArrayWriteNeedsCast(boolean arrayWriteNeedsCast) {
        this.arrayWriteNeedsCast = arrayWriteNeedsCast;
    }

    private static enum Kind {
        APPLY,
        NEW,
        ARRAY_READ,
        ARRAY_WRITE,
        NEW_ARRAY,
        FIELD_READ;

    }
}

