/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CallBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.DirectInvocation;
import com.redhat.ceylon.compiler.java.codegen.Invocation;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import java.util.Collections;
import java.util.List;

class CallableInvocation
extends DirectInvocation {
    private final List<Parameter> callableParameters;
    private final List<Parameter> functionalParameters;
    private final int parameterCount;
    private boolean tempVars;
    private Naming.SyntheticName instanceFieldName;
    private boolean instanceFieldIsBoxed;

    public CallableInvocation(AbstractTransformer gen, Naming.SyntheticName primaryName, boolean primaryIsBoxed, Tree.Term primary, Declaration primaryDeclaration, Reference producedReference, Type returnType, Tree.Term expr, ParameterList parameterList, int parameterCount, boolean tempVars) {
        super(gen, primary, primaryDeclaration, producedReference, returnType, expr);
        this.instanceFieldName = primaryName;
        this.instanceFieldIsBoxed = primaryIsBoxed;
        Functional functional = null;
        if (primary instanceof Tree.MemberOrTypeExpression) {
            functional = (Functional)((Object)((Tree.MemberOrTypeExpression)primary).getDeclaration());
        } else if (primary instanceof Tree.FunctionArgument) {
            functional = ((Tree.FunctionArgument)primary).getDeclarationModel();
        }
        this.callableParameters = functional != null ? functional.getFirstParameterList().getParameters() : Collections.emptyList();
        this.functionalParameters = parameterList.getParameters();
        this.parameterCount = parameterCount;
        this.setUnboxed(expr.getUnboxed());
        this.setBoxingStrategy(AbstractTransformer.BoxingStrategy.BOXED);
        this.handleBoxing(true);
        if (producedReference.getDeclaration() instanceof TypedDeclaration) {
            TypedDeclaration tdecl = (TypedDeclaration)producedReference.getDeclaration();
            this.setErased(CodegenUtil.hasTypeErased(tdecl) || CodegenUtil.hasTypeErased(primary));
        }
        this.tempVars = tempVars;
    }

    @Override
    boolean isOnValueType() {
        return super.isOnValueType() && !this.instanceFieldIsBoxed;
    }

    @Override
    protected int getNumArguments() {
        return this.parameterCount;
    }

    @Override
    protected int getNumParameters() {
        return this.functionalParameters.size();
    }

    @Override
    protected boolean isSpread() {
        return this.isParameterSequenced(this.getNumArguments() - 1);
    }

    @Override
    protected boolean isArgumentSpread(int argIndex) {
        return this.isSpread() && argIndex == this.getNumArguments() - 1;
    }

    @Override
    protected boolean isArgumentComprehension(int argIndex) {
        throw new BugException("I override getTransformedArgumentExpression(), so should never be called");
    }

    @Override
    protected JCTree.JCExpression getTransformedArgumentExpression(int argIndex) {
        Parameter param = this.callableParameters.get(argIndex);
        String paramName = this.tempVars ? Naming.getCallableTempVarName(param) : (this.getPrimaryDeclaration() instanceof Class && ((Class)this.getPrimaryDeclaration()).hasConstructors() ? Naming.getAliasedParameterName(param) : param.getName());
        return this.gen.makeUnquotedIdent(paramName);
    }

    @Override
    protected Parameter getParameter(int index) {
        return this.functionalParameters.get(index);
    }

    @Override
    protected Tree.Expression getArgumentExpression(int argIndex) {
        throw new BugException("I override getTransformedArgumentExpression(), so should never be called");
    }

    @Override
    protected Type getArgumentType(int argIndex) {
        Parameter param = this.callableParameters.get(argIndex);
        return this.getParameterTypeForValueType(this.appliedReference(), param);
    }

    @Override
    public void location(CallBuilder callBuilder) {
        callBuilder.location(null);
    }

    @Override
    protected Invocation.TransformedInvocationPrimary transformPrimary(JCTree.JCExpression primaryExpr, String selector) {
        return new Invocation.TransformedInvocationPrimary(this, this.instanceFieldName != null ? this.instanceFieldName.makeIdent() : primaryExpr, selector);
    }

    @Override
    public Constructor getConstructor() {
        return this.getConstructorFromPrimary(this.appliedReference().getDeclaration());
    }
}

