/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AttributeDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CeylonCompilationUnit;
import com.redhat.ceylon.compiler.java.codegen.CeylonVisitor;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.GetterSetterPairingVisitor;
import com.redhat.ceylon.compiler.java.codegen.LabelVisitor;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ToplevelAttributesDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.java.loader.SourceDeclarationVisitor;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.main.OptionName;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.langtools.tools.javac.util.Position;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.Iterator;

public class CeylonTransformer
extends AbstractTransformer {
    private Options options;
    private Position.LineMap map;
    private JavaFileObject fileObject;
    public int disableAnnotations = 0;
    static final int DISABLE_MODEL_ANNOS = 1;
    static final int DISABLE_USER_ANNOS = 2;
    CeylonVisitor visitor;

    public static CeylonTransformer getInstance(Context context) {
        CeylonTransformer trans = context.get(CeylonTransformer.class);
        if (trans == null) {
            trans = new CeylonTransformer(context);
            context.put(CeylonTransformer.class, trans);
        }
        return trans;
    }

    public CeylonTransformer(Context context) {
        super(context);
        this.setup(context);
    }

    private void setup(Context context) {
        this.options = Options.instance(context);
        this.options.put("invokedynamic", "invokedynamic");
    }

    @Override
    public void setMap(Position.LineMap map) {
        this.map = map;
    }

    @Override
    protected Position.LineMap getMap() {
        return this.map;
    }

    public void setFileObject(JavaFileObject fileObject) {
        this.fileObject = fileObject;
    }

    public JavaFileObject getFileObject() {
        return this.fileObject;
    }

    public JCTree.JCCompilationUnit makeJCCompilationUnitPlaceholder(Tree.CompilationUnit t, JavaFileObject file, String pkgName, PhasedUnit phasedUnit) {
        JCTree.JCExpression pkg = pkgName != null ? this.getPackage(pkgName) : null;
        this.at(t);
        List<JCTree> defs = this.makeDefs(t);
        CeylonCompilationUnit topLev = new CeylonCompilationUnit(List.nil(), pkg, defs, null, null, null, null, t, phasedUnit);
        topLev.lineMap = this.getMap();
        topLev.sourcefile = file;
        topLev.isCeylonProgram = true;
        return topLev;
    }

    private List<JCTree> makeDefs(Tree.CompilationUnit t) {
        final ListBuffer defs = new ListBuffer();
        t.visit(new SourceDeclarationVisitor(){

            @Override
            public void loadFromSource(Tree.Declaration decl) {
                if (!this.checkNative(decl)) {
                    return;
                }
                long flags = decl instanceof Tree.AnyInterface ? 512L : 0L;
                String name = Naming.toplevelClassName("", decl);
                defs.add(this.makeClassDef(decl, flags, name, WantedDeclaration.Normal));
                if (decl instanceof Tree.AnyInterface) {
                    String implName = Naming.getImplClassName(name);
                    defs.add(this.makeClassDef(decl, 0L, implName, WantedDeclaration.Normal));
                }
                if (CeylonTransformer.this.options.get(OptionName.BOOTSTRAPCEYLON) != null && decl instanceof Tree.AnyClass && TreeUtil.hasAnnotation(decl.getAnnotationList(), "annotation", decl.getUnit())) {
                    String annotationName = Naming.suffixName(NamingBase.Suffix.$annotation$, name);
                    defs.add(this.makeClassDef(decl, 8192L, annotationName, WantedDeclaration.Annotation));
                    for (Tree.StaticType sat : ((Tree.AnyClass)decl).getSatisfiedTypes().getTypes()) {
                        if (!(sat instanceof Tree.BaseType) || !((Tree.BaseType)sat).getIdentifier().getText().equals("SequencedAnnotation")) continue;
                        String annotationsName = Naming.suffixName(NamingBase.Suffix.$annotations$, name);
                        defs.add(this.makeClassDef(decl, 8192L, annotationsName, WantedDeclaration.AnnotationSequence));
                    }
                }
            }

            private JCTree makeClassDef(Tree.Declaration decl, long flags, String name, WantedDeclaration wantedDeclaration) {
                Tree.ClassOrInterface classDecl;
                ListBuffer<JCTree.JCTypeParameter> typarams = new ListBuffer<JCTree.JCTypeParameter>();
                if (decl instanceof Tree.ClassOrInterface && (classDecl = (Tree.ClassOrInterface)decl).getTypeParameterList() != null) {
                    for (Tree.TypeParameterDeclaration typeParamDecl : classDecl.getTypeParameterList().getTypeParameterDeclarations()) {
                        typarams.add(CeylonTransformer.this.make().TypeParameter(CeylonTransformer.this.names().fromString("BOGUS-" + typeParamDecl.getIdentifier().getText()), List.nil()));
                    }
                }
                return CeylonTransformer.this.make().ClassDef(CeylonTransformer.this.make().Modifiers(flags | 1L), CeylonTransformer.this.names().fromString(name), typarams.toList(), null, List.nil(), this.makeClassBody(decl, wantedDeclaration));
            }

            private List<JCTree> makeClassBody(Tree.Declaration decl, WantedDeclaration wantedDeclaration) {
                if (wantedDeclaration == WantedDeclaration.Annotation) {
                    ListBuffer<JCTree.JCMethodDecl> body = new ListBuffer<JCTree.JCMethodDecl>();
                    for (Tree.Parameter param : ((Tree.ClassDefinition)decl).getParameterList().getParameters()) {
                        String name;
                        JCTree.JCExpression type = CeylonTransformer.this.make().TypeArray(CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType));
                        if (param instanceof Tree.InitializerParameter) {
                            name = ((Tree.InitializerParameter)param).getIdentifier().getText();
                        } else if (param instanceof Tree.ParameterDeclaration) {
                            Tree.TypedDeclaration typedDeclaration = ((Tree.ParameterDeclaration)param).getTypedDeclaration();
                            name = typedDeclaration.getIdentifier().getText();
                            type = this.getAnnotationTypeFor(typedDeclaration.getType());
                        } else {
                            name = "ERROR";
                        }
                        JCTree.JCMethodDecl method = CeylonTransformer.this.make().MethodDef(CeylonTransformer.this.make().Modifiers(1L), CeylonTransformer.this.names().fromString(name), type, List.nil(), List.nil(), List.nil(), null, null);
                        body.append(method);
                    }
                    return body.toList();
                }
                if (wantedDeclaration == WantedDeclaration.AnnotationSequence) {
                    String name = Naming.toplevelClassName("", decl);
                    String annotationName = Naming.suffixName(NamingBase.Suffix.$annotation$, name);
                    JCTree.JCArrayTypeTree type = CeylonTransformer.this.make().TypeArray(CeylonTransformer.this.make().Ident(CeylonTransformer.this.names().fromString(annotationName)));
                    JCTree.JCMethodDecl method = CeylonTransformer.this.make().MethodDef(CeylonTransformer.this.make().Modifiers(1L), CeylonTransformer.this.names().fromString("value"), type, List.nil(), List.nil(), List.nil(), null, null);
                    return List.of(method);
                }
                return List.nil();
            }

            private JCTree.JCExpression getAnnotationTypeFor(Tree.Type type) {
                if (type instanceof Tree.BaseType) {
                    String name = ((Tree.BaseType)type).getIdentifier().getText();
                    if (name.equals("String") || name.equals("Declaration")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType);
                    }
                    if (name.equals("Boolean")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().booleanType);
                    }
                    if (name.equals("Integer")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().longType);
                    }
                    if (name.equals("Float")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().doubleType);
                    }
                    if (name.equals("Byte")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().byteType);
                    }
                    if (name.equals("Character")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().charType);
                    }
                    if (name.equals("Declaration") || name.equals("ClassDeclaration") || name.equals("InterfaceDeclaration") || name.equals("ClassOrInterfaceDeclaration")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType);
                    }
                }
                if (type instanceof Tree.SequencedType) {
                    return CeylonTransformer.this.make().TypeArray(this.getAnnotationTypeFor(((Tree.SequencedType)type).getType()));
                }
                if (type instanceof Tree.SequenceType) {
                    return CeylonTransformer.this.make().TypeArray(this.getAnnotationTypeFor(((Tree.SequenceType)type).getElementType()));
                }
                if (type instanceof Tree.IterableType) {
                    return CeylonTransformer.this.make().TypeArray(this.getAnnotationTypeFor(((Tree.IterableType)type).getElementType()));
                }
                if (type instanceof Tree.TupleType) {
                    Tree.Type sequencedType = ((Tree.TupleType)type).getElementTypes().get(0);
                    return this.getAnnotationTypeFor(sequencedType);
                }
                System.err.println("Unknown Annotation type: " + type);
                return CeylonTransformer.this.make().TypeArray(CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType));
            }

            @Override
            public void loadFromSource(Tree.ModuleDescriptor that) {
            }

            @Override
            public void loadFromSource(Tree.PackageDescriptor that) {
            }
        });
        return defs.toList();
    }

    public ListBuffer<JCTree> transformAfterTypeChecking(Tree.CompilationUnit t) {
        this.disableAnnotations = 0;
        GetterSetterPairingVisitor gspv = new GetterSetterPairingVisitor();
        t.visit(gspv);
        ToplevelAttributesDefinitionBuilder builder = new ToplevelAttributesDefinitionBuilder(this);
        LabelVisitor lv = new LabelVisitor();
        CeylonVisitor visitor = new CeylonVisitor(this, builder, lv, gspv);
        t.visit(lv);
        t.visit(visitor);
        ListBuffer<JCTree> result = ListBuffer.lb();
        result.appendList(visitor.getResult());
        result.appendList(builder.build());
        return result;
    }

    Name makeName(Iterable<String> components) {
        Iterator<String> iterator = components.iterator();
        String s = iterator.next();
        assert (!iterator.hasNext());
        return this.names().fromString(s);
    }

    String toFlatName(Iterable<String> components) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> iterator = components.iterator();
        while (iterator.hasNext()) {
            buf.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    private JCTree.JCExpression getPackage(String fullname) {
        return this.makeQuotedQualIdentFromString(fullname);
    }

    public JCTree.JCImport transform(Tree.ImportPath that) {
        String[] names = new String[that.getIdentifiers().size()];
        int i = 0;
        for (Tree.Identifier component : that.getIdentifiers()) {
            names[i++] = component.getText();
        }
        return this.at(that).Import(this.makeQuotedQualIdent(null, names), false);
    }

    public List<JCTree> transform(Tree.AnyAttribute decl) {
        return this.transformAttribute(decl, null);
    }

    public List<JCTree> transform(Tree.AttributeSetterDefinition decl) {
        return this.transformAttribute(decl, null);
    }

    public List<JCTree> transformAttribute(Tree.TypedDeclaration decl, Tree.AttributeSetterDefinition setterDecl) {
        Tree.Block block;
        Tree.SpecifierOrInitializerExpression expression;
        this.at(decl);
        TypedDeclaration declarationModel = decl.getDeclarationModel();
        String attrName = declarationModel.getName();
        String attrClassName = Naming.getAttrClassName(declarationModel, 0);
        if (decl instanceof Tree.AttributeDeclaration) {
            Tree.AttributeDeclaration adecl = (Tree.AttributeDeclaration)decl;
            expression = adecl.getSpecifierOrInitializerExpression();
            block = null;
        } else if (decl instanceof Tree.AttributeGetterDefinition) {
            expression = null;
            Tree.AttributeGetterDefinition gdef = (Tree.AttributeGetterDefinition)decl;
            block = gdef.getBlock();
        } else if (decl instanceof Tree.AttributeSetterDefinition) {
            Tree.AttributeSetterDefinition sdef = (Tree.AttributeSetterDefinition)decl;
            block = sdef.getBlock();
            expression = sdef.getSpecifierExpression();
            if (Decl.isLocal(decl)) {
                declarationModel = ((Tree.AttributeSetterDefinition)decl).getDeclarationModel().getParameter().getModel();
            }
        } else {
            throw new RuntimeException();
        }
        return this.transformAttribute(declarationModel, attrName, attrClassName, decl, block, expression, decl, setterDecl);
    }

    public List<JCTree> transformAttribute(TypedDeclaration declarationModel, String attrName, String attrClassName, Tree.Declaration annotated, Tree.Block block, Tree.SpecifierOrInitializerExpression expression, Tree.TypedDeclaration decl, Tree.AttributeSetterDefinition setterDecl) {
        Setter setter;
        List<JCTree.JCAnnotation> scopeAnnotations;
        JCTree.JCExpression initialValue;
        HasErrorException expressionError;
        AttributeDefinitionBuilder builder = AttributeDefinitionBuilder.wrapped(this, attrClassName, null, attrName, declarationModel, declarationModel.isToplevel()).is(1L, declarationModel.isShared());
        if (expression != null) {
            expressionError = this.errors().getFirstExpressionErrorAndMarkBrokenness(expression.getExpression());
            initialValue = expressionError != null ? this.make().Erroneous() : this.transformValueInit(declarationModel, attrName, expression);
        } else {
            expressionError = null;
            initialValue = this.transformValueInit(declarationModel, attrName, expression);
        }
        if (Decl.isBoxedVariable(declarationModel)) {
            if (expressionError != null) {
                return List.of(this.makeThrowUnresolvedCompilationError(expressionError));
            }
            return List.of(this.makeVariableBoxDecl(initialValue, declarationModel));
        }
        if (block == null && expression == null && !Decl.isToplevel(declarationModel)) {
            JCTree.JCExpression typeExpr = this.makeJavaType(this.getGetterInterfaceType(declarationModel));
            JCTree.JCVariableDecl var = this.makeVar(attrClassName, typeExpr, null);
            return List.of(var);
        }
        if (decl != null) {
            scopeAnnotations = Decl.isToplevel(declarationModel) && setterDecl != null ? this.makeAtLocalDeclarations(decl, setterDecl) : this.makeAtLocalDeclarations(decl);
            builder.classAnnotations(scopeAnnotations);
        } else if (block != null) {
            scopeAnnotations = this.makeAtLocalDeclarations(block);
            builder.classAnnotations(scopeAnnotations);
        }
        if (Decl.isGetter(declarationModel) && declarationModel.isVariable() && Decl.isLocal(declarationModel) && (setter = ((Value)declarationModel).getSetter()) != null) {
            String setterClassName = Naming.getAttrClassName(setter, 0);
            JCTree.JCIdent setterClassNameExpr = this.naming.makeUnquotedIdent(setterClassName);
            builder.setterClass(this.makeSelect(setterClassNameExpr, "class"));
        }
        if (declarationModel instanceof Setter || declarationModel instanceof FunctionOrValue && ((FunctionOrValue)declarationModel).isParameter()) {
            JCTree.JCBlock setterBlock = this.makeSetterBlock(declarationModel, block, expression);
            builder.setterBlock(setterBlock);
            builder.skipGetter();
            if (Decl.isLocal(decl)) {
                Setter setter2 = (Setter)declarationModel.getContainer();
                String getterClassName = Naming.getAttrClassName(setter2.getGetter(), 0);
                JCTree.JCIdent getterClassNameExpr = this.naming.makeUnquotedIdent(getterClassName);
                builder.isSetter(this.makeSelect(getterClassNameExpr, "class"));
            }
        } else if (Decl.isValue(declarationModel)) {
            if (!declarationModel.isVariable() && !declarationModel.isLate()) {
                builder.immutable();
            }
        } else {
            boolean prevSyntheticClassBody = Decl.isLocal(declarationModel) ? this.expressionGen().withinSyntheticClassBody(true) : this.expressionGen().isWithinSyntheticClassBody();
            JCTree.JCBlock getterBlock = this.makeGetterBlock(declarationModel, block, expression);
            prevSyntheticClassBody = this.expressionGen().withinSyntheticClassBody(prevSyntheticClassBody);
            builder.getterBlock(getterBlock);
            if (Decl.isLocal(declarationModel)) {
                builder.immutable();
            } else if (setterDecl != null) {
                JCTree.JCBlock setterBlock = this.makeSetterBlock(setterDecl.getDeclarationModel(), setterDecl.getBlock(), setterDecl.getSpecifierExpression());
                builder.setterBlock(setterBlock);
                builder.userAnnotationsSetter(this.expressionGen().transformAnnotations(OutputElement.SETTER, setterDecl));
            } else {
                builder.immutable();
            }
        }
        if (annotated != null) {
            builder.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.GETTER, annotated));
        }
        if (Decl.isLocal(declarationModel)) {
            if (expressionError != null) {
                return List.of(this.makeThrowUnresolvedCompilationError(expressionError));
            }
            builder.classAnnotations(this.makeAtLocalDeclaration(declarationModel.getQualifier(), false));
            if (initialValue != null) {
                builder.valueConstructor();
            }
            JCTree.JCExpression typeExpr = declarationModel instanceof Setter || declarationModel instanceof FunctionOrValue && ((FunctionOrValue)declarationModel).isParameter() ? this.makeQuotedIdent(attrClassName) : this.makeJavaType(this.getGetterInterfaceType(declarationModel));
            return builder.build().append(this.makeLocalIdentityInstance(typeExpr, attrClassName, attrClassName, declarationModel.isShared(), initialValue));
        }
        if (expressionError != null) {
            builder.initialValueError(expressionError);
        } else if (initialValue != null) {
            builder.initialValue(initialValue);
        }
        builder.is(8L, true);
        return builder.build();
    }

    private JCTree.JCExpression transformValueInit(TypedDeclaration declarationModel, String attrName, Tree.SpecifierOrInitializerExpression expression) {
        JCTree.JCExpression initialValue = null;
        if (Decl.isNonTransientValue(declarationModel) && !(expression instanceof Tree.LazySpecifierExpression)) {
            if (expression != null) {
                initialValue = this.expressionGen().transform(expression, CodegenUtil.getBoxingStrategy(declarationModel), declarationModel.getType());
            } else {
                Parameter p = CodegenUtil.findParamForDecl(attrName, declarationModel);
                if (p != null) {
                    initialValue = this.naming.makeName(p.getModel(), 257);
                }
            }
        }
        return initialValue;
    }

    public JCTree.JCExpression transformAttributeGetter(TypedDeclaration declarationModel, JCTree.JCExpression expression) {
        String attrName = declarationModel.getName();
        String attrClassName = Naming.getAttrClassName(declarationModel, 0);
        JCTree.JCBlock getterBlock = this.makeGetterBlock(expression);
        AttributeDefinitionBuilder builder = AttributeDefinitionBuilder.indirect(this, attrClassName, attrName, declarationModel, declarationModel.isToplevel()).getterBlock(getterBlock).immutable();
        List<JCTree> attr = builder.build();
        JCTree.JCNewClass newExpr = this.makeNewClass(attrClassName, false, null);
        JCTree.JCExpression result = this.makeLetExpr(this.naming.temp(), List.of((JCTree.JCStatement)attr.get(0)), newExpr);
        return result;
    }

    public List<JCTree> transformModuleDescriptor(Tree.ModuleDescriptor module) {
        this.at(null);
        ClassDefinitionBuilder builder = ClassDefinitionBuilder.klass(this, "$module_", null, false);
        builder.modifiers(16L).annotations(this.makeAtModule(module));
        builder.getInitBuilder().modifiers(2L);
        builder.annotations(this.expressionGen().transformAnnotations(OutputElement.TYPE, module));
        for (Tree.ImportModule imported : module.getImportModuleList().getImportModules()) {
            String quotedName;
            if (!TreeUtil.isForBackend(imported.getAnnotationList(), Backend.Java, imported.getUnit())) continue;
            if (imported.getImportPath() != null) {
                StringBuilder sb = new StringBuilder();
                for (Tree.Identifier part : imported.getImportPath().getIdentifiers()) {
                    sb.append(part.getText()).append('$');
                }
                quotedName = sb.substring(0, sb.length() - 1);
            } else if (imported.getQuotedLiteral() != null) {
                quotedName = imported.getQuotedLiteral().getText();
                quotedName = quotedName.substring(1, quotedName.length() - 1);
                quotedName = quotedName.replace('.', '$');
            } else {
                throw new BugException(imported, "unhandled module import");
            }
            List<JCTree.JCAnnotation> importAnnotations = this.expressionGen().transformAnnotations(OutputElement.FIELD, imported);
            JCTree.JCModifiers mods = this.make().Modifiers(25L, importAnnotations);
            Name fieldName = this.names().fromString(quotedName);
            builder.defs(List.of(this.make().VarDef(mods, fieldName, this.make().Type(this.syms().stringType), this.makeNull())));
        }
        return builder.build();
    }

    public List<JCTree> transformPackageDescriptor(Tree.PackageDescriptor pack) {
        this.at(null);
        ClassDefinitionBuilder builder = ClassDefinitionBuilder.klass(this, "$package_", null, false).modifiers(16L).annotations(this.makeAtPackage(pack.getUnit().getPackage()));
        builder.getInitBuilder().modifiers(2L);
        builder.annotations(this.expressionGen().transformAnnotations(OutputElement.TYPE, pack));
        return builder.build();
    }

    private static enum WantedDeclaration {
        Normal,
        Annotation,
        AnnotationSequence;

    }
}

