/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AnnotationConstructorParameter;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocation;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocationVisitor;
import com.redhat.ceylon.compiler.java.codegen.AttributeDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CallBuilder;
import com.redhat.ceylon.compiler.java.codegen.CallableBuilder;
import com.redhat.ceylon.compiler.java.codegen.CallableSpecifierInvocation;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.codegen.CeylonVisitor;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.CompilerBoxingDeclarationVisitor;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.InitializerBuilder;
import com.redhat.ceylon.compiler.java.codegen.Invocation;
import com.redhat.ceylon.compiler.java.codegen.MethodDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.MethodReferenceSpecifierInvocation;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ParameterDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.ParameterizedBuilder;
import com.redhat.ceylon.compiler.java.codegen.StatementTransformer;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.java.codegen.recovery.Drop;
import com.redhat.ceylon.compiler.java.codegen.recovery.Errors;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.java.codegen.recovery.ThrowerCatchallConstructor;
import com.redhat.ceylon.compiler.java.codegen.recovery.ThrowerMethod;
import com.redhat.ceylon.compiler.java.codegen.recovery.TransformationPlan;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.model.AnnotationTarget;
import com.redhat.ceylon.model.loader.model.JavaBeanValue;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.antlr.runtime.Token;

public class ClassTransformer
extends AbstractTransformer {
    private static final Comparator<Declaration> DeclarationComparator = new Comparator<Declaration>(){

        @Override
        public int compare(Declaration a, Declaration b) {
            int cmp = a.getQualifiedNameString().compareTo(b.getQualifiedNameString());
            if (cmp != 0) {
                return cmp;
            }
            if (a.getDeclarationKind() != null && b.getDeclarationKind() != null && (cmp = a.getDeclarationKind().compareTo(b.getDeclarationKind())) != 0) {
                return cmp;
            }
            if (a instanceof Function && b instanceof Function) {
                Function afn = (Function)a;
                Function bfn = (Function)b;
                if (afn.getParameterLists() != null && !afn.getParameterLists().isEmpty() && bfn.getParameterLists() != null && !bfn.getParameterLists().isEmpty()) {
                    List<Parameter> apl = afn.getFirstParameterList().getParameters();
                    List<Parameter> bpl = bfn.getFirstParameterList().getParameters();
                    if (apl.size() < bpl.size()) {
                        return -1;
                    }
                    if (apl.size() > bpl.size()) {
                        return 1;
                    }
                    Iterator<Parameter> aiter = apl.iterator();
                    Iterator<Parameter> biter = bpl.iterator();
                    while (aiter.hasNext()) {
                        if (biter.hasNext()) {
                            cmp = this.compare(aiter.next().getModel().getTypeDeclaration(), biter.next().getModel().getTypeDeclaration());
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        return 1;
                    }
                    if (biter.hasNext()) {
                        return -1;
                    }
                } else {
                    if (afn.getParameterLists() != null && !afn.getParameterLists().isEmpty() && (bfn.getParameterLists() == null || bfn.getParameterLists().isEmpty())) {
                        return -1;
                    }
                    if ((afn.getParameterLists() == null || afn.getParameterLists().isEmpty()) && bfn.getParameterLists() != null && !bfn.getParameterLists().isEmpty()) {
                        return 1;
                    }
                    return 0;
                }
            }
            return cmp;
        }
    };
    private static int OL_BODY_DELEGATE_CANONICAL = 1;
    private static int OL_COMPANION = 2;
    private static int OL_DELEGATE_INTERFACE_INSTANCE = 4;
    final DaoAbstract daoAbstract = new DaoAbstract();

    public static ClassTransformer getInstance(Context context) {
        ClassTransformer trans = context.get(ClassTransformer.class);
        if (trans == null) {
            trans = new ClassTransformer(context);
            context.put(ClassTransformer.class, trans);
        }
        return trans;
    }

    private ClassTransformer(Context context) {
        super(context);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transform(Tree.ClassOrInterface def) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> result;
        ClassDefinitionBuilder instantiatorDeclCb;
        ClassDefinitionBuilder instantiatorImplCb;
        ClassOrInterface model = def.getDeclarationModel();
        if (model.isAlias() && Decl.isAncestorLocal(def)) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        this.naming.clearSubstitutions(model);
        String ceylonClassName = def.getIdentifier().getText();
        String javaClassName = def instanceof Tree.AnyInterface ? this.naming.makeTypeDeclarationName(model, Naming.DeclNameFlag.QUALIFIED).replaceFirst(".*\\.", "") : Naming.quoteClassName(ceylonClassName);
        if (Decl.withinInterface(model)) {
            instantiatorImplCb = this.gen().current().getCompanionBuilder((Interface)model.getContainer());
            instantiatorDeclCb = this.gen().current();
        } else {
            instantiatorImplCb = this.gen().current();
            instantiatorDeclCb = null;
        }
        ClassDefinitionBuilder classBuilder = ClassDefinitionBuilder.klass(this, javaClassName, ceylonClassName, Decl.isLocal(model)).forDefinition(model).hasDelegatingConstructors(CodegenUtil.hasDelegatingConstructors(def));
        if ("ceylon.language::Anything".equals(model.getQualifiedNameString())) {
            classBuilder.extending(model.getType(), null);
        }
        if (def instanceof Tree.AnyClass) {
            classBuilder.getInitBuilder().modifiers(this.transformConstructorDeclFlags(model));
            Tree.AnyClass classDef = (Tree.AnyClass)def;
            Class cls = classDef.getDeclarationModel();
            boolean generateInstantiator = Strategy.generateInstantiator(cls);
            if (!cls.hasConstructors()) {
                classBuilder.getInitBuilder().userAnnotations(this.expressionGen().transformAnnotations(OutputElement.CONSTRUCTOR, def));
            }
            if (generateInstantiator && !cls.hasConstructors() && !cls.hasEnumerated()) {
                classBuilder.getInitBuilder().modifiers(4L);
                this.generateInstantiators(classBuilder, cls, null, instantiatorDeclCb, instantiatorImplCb, classDef, classDef.getParameterList());
            }
            classBuilder.annotations(this.expressionGen().transformAnnotations(OutputElement.TYPE, def));
            if (def instanceof Tree.ClassDefinition) {
                this.transformClass((Tree.ClassDefinition)def, cls, classBuilder, classDef.getParameterList(), generateInstantiator, instantiatorDeclCb, instantiatorImplCb);
            } else {
                classBuilder.getInitBuilder().modifiers(2L);
                this.transformClassAlias((Tree.ClassDeclaration)def, classBuilder);
            }
            this.addMissingUnrefinedMembers(def, cls, classBuilder);
        }
        if (def instanceof Tree.AnyInterface) {
            classBuilder.annotations(this.expressionGen().transformAnnotations(OutputElement.TYPE, def));
            if (def instanceof Tree.InterfaceDefinition) {
                this.transformInterface(def, (Interface)model, classBuilder);
            } else {
                classBuilder.annotations(this.makeAtAlias(model.getExtendedType(), null));
                classBuilder.isAlias(true);
            }
            classBuilder.isDynamic(model.isDynamic());
        }
        this.addAtContainer(classBuilder, model);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> childDefs = this.visitClassOrInterfaceDefinition(def, classBuilder);
        this.at(null);
        TransformationPlan plan = this.errors().hasDeclarationError(def);
        if (plan instanceof ThrowerCatchallConstructor) {
            MethodDefinitionBuilder initBuilder = classBuilder.addConstructor();
            initBuilder.body(this.statementGen().makeThrowUnresolvedCompilationError(plan.getErrorMessage().getMessage()));
            ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.implicitParameter(this, "ignored");
            pdb.modifiers(0x400000000L);
            pdb.type(this.make().TypeArray(this.make().Type(this.syms().objectType)), null);
            initBuilder.parameter(pdb);
        }
        if (Strategy.generateMain(def)) {
            classBuilder.method(this.makeMainForClass(model));
        }
        classBuilder.modelAnnotations(model.getAnnotations()).modifiers(this.transformClassDeclFlags(model)).satisfies(model.getSatisfiedTypes()).caseTypes(model.getCaseTypes(), model.getSelfType()).defs(childDefs);
        if (!model.isAlias()) {
            if (model instanceof Class) {
                classBuilder.addGetTypeMethod(model.getType());
            }
            if (this.supportsReifiedAlias(model)) {
                classBuilder.reifiedAlias(model.getType());
            }
        }
        if (Strategy.generateJpaCtor(def)) {
            this.buildJpaConstructor((Class)def.getDeclarationModel(), classBuilder);
        }
        if (model instanceof Class && !(model instanceof ClassAlias)) {
            Class c = (Class)model;
            if (Strategy.introduceJavaIoSerializable(c, this.typeFact().getJavaIoSerializable())) {
                classBuilder.introduce(this.make().QualIdent(this.syms().serializableType.tsym));
                if (Strategy.useSerializationProxy(c) && this.noValueConstructorErrors((Tree.ClassDefinition)def)) {
                    this.addWriteReplace(c, classBuilder);
                }
            }
            this.serialization(c, classBuilder);
        }
        this.at(def);
        if (Decl.isAnnotationClass(def)) {
            ListBuffer trees = ListBuffer.lb();
            trees.addAll(this.transformAnnotationClass((Tree.AnyClass)def));
            this.transformAnnotationClassConstructor((Tree.AnyClass)def, classBuilder);
            if (model.inherits(this.typeFact().getAnnotationDeclaration())) {
                classBuilder.addAnnotationTypeMethod(model.getType());
            }
            trees.addAll(classBuilder.build());
            result = trees.toList();
        } else {
            result = classBuilder.build();
        }
        return result;
    }

    private boolean noValueConstructorErrors(Tree.ClassDefinition def) {
        for (Tree.Statement s : def.getClassBody().getStatements()) {
            if (!(s instanceof Tree.Constructor) && !(s instanceof Tree.Enumerated) || !this.errors().hasAnyError((Tree.Declaration)s)) continue;
            return false;
        }
        return true;
    }

    protected void addWriteReplace(Class model, ClassDefinitionBuilder classBuilder) {
        MethodDefinitionBuilder mdb = MethodDefinitionBuilder.systemMethod(this, "writeReplace");
        mdb.resultType(null, this.make().Type(this.syms().objectType));
        mdb.modifiers(18L);
        ListBuffer stmts = ListBuffer.lb();
        Naming.SyntheticName name = this.naming.synthetic(NamingBase.Unfix.$name$);
        stmts.add(this.makeVar(16L, name, this.make().Type(this.syms().stringType), null));
        if (model.hasEnumerated()) {
            JCTree.JCStatement tail = Decl.hasOnlyValueConstructors(model) ? this.make().Throw(this.statementGen().makeNewEnumeratedTypeError("Instance not of any constructor")) : this.make().Return(this.naming.makeThis());
            for (Declaration member : model.getMembers()) {
                if (!Decl.isValueConstructor(member)) continue;
                Value val = (Value)member;
                tail = this.make().If(this.make().Binary(62, this.naming.makeThis(), this.naming.getValueConstructorFieldName(val).makeIdent()), this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(this.make().Assign(name.makeIdent(), this.make().Literal(Naming.getGetterName(member)))))), tail);
            }
            stmts.add(tail);
        } else if (model.isAnonymous()) {
            stmts.add(this.make().Exec(this.make().Assign(name.makeIdent(), this.make().Literal(Naming.getGetterName((Value)model.getContainer().getDirectMember(model.getName(), null, false))))));
        } else {
            throw new BugException("Unsupported need for writeReplace()");
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> args = com.redhat.ceylon.langtools.tools.javac.util.List.of(name.makeIdent());
        if (model.isMember()) {
            ClassOrInterface outer = (ClassOrInterface)model.getContainer();
            args = args.prepend((JCTree.JCIdent)this.makeClassLiteral(outer.getType()));
            args = args.prepend(this.naming.makeQualifiedThis(this.naming.makeTypeDeclarationExpression(null, outer, Naming.DeclNameFlag.QUALIFIED)));
        } else {
            args = args.prepend((JCTree.JCIdent)this.makeClassLiteral(model.getType()));
        }
        stmts.add(this.make().Return(this.make().NewClass(null, null, this.make().QualIdent(this.syms().ceylonSerializationProxyType.tsym), args, null)));
        mdb.body(stmts.toList());
        classBuilder.method(mdb);
    }

    protected void buildJpaConstructor(Class model, ClassDefinitionBuilder classBuilder) {
        MethodDefinitionBuilder ctor = classBuilder.addConstructor();
        ctor.modelAnnotations(this.makeAtJpa());
        ctor.modelAnnotations(this.makeAtIgnore());
        ctor.modifiers(4L);
        for (TypeParameter tp : model.getTypeParameters()) {
            ctor.reifiedTypeParameter(tp);
        }
        ListBuffer<JCTree.JCStatement> stmts = ListBuffer.lb();
        ListBuffer superArgs = ListBuffer.lb();
        if (model.isSerializable()) {
            superArgs.add(this.make().TypeCast(this.make().QualIdent(this.syms().ceylonSerializationType.tsym), (JCTree.JCExpression)this.makeNull()));
            for (JCTree.JCExpression ta : this.makeReifiedTypeArguments(model.getType())) {
                superArgs.add(ta);
            }
        } else {
            for (JCTree.JCExpression ta : this.makeReifiedTypeArguments(model.getExtendedType())) {
                superArgs.add(ta);
            }
        }
        stmts.add(this.make().Exec(this.make().Apply(null, model.isSerializable() ? this.naming.makeThis() : this.naming.makeSuper(), superArgs.toList())));
        if (!model.isSerializable()) {
            this.buildFieldInits(model, classBuilder, stmts);
        }
        ctor.body(stmts.toList());
    }

    private void addMissingUnrefinedMembers(Node def, Class classModel, ClassDefinitionBuilder classBuilder) {
        for (Reference unrefined : classModel.getUnimplementedFormals()) {
            Declaration formalMember = unrefined.getDeclaration();
            String errorMessage = "formal member '" + formalMember.getName() + "' of '" + ((TypeDeclaration)formalMember.getContainer()).getName() + "' not implemented in class hierarchy";
            ArrayList<Type> params = new ArrayList<Type>();
            if (formalMember instanceof Generic) {
                for (TypeParameter tp : ((Generic)((Object)formalMember)).getTypeParameters()) {
                    params.add(tp.getType());
                }
            }
            if (formalMember instanceof Value) {
                this.addRefinedThrowerAttribute(classBuilder, errorMessage, classModel, (Value)formalMember);
                continue;
            }
            if (formalMember instanceof Function) {
                this.addRefinedThrowerMethod(classBuilder, errorMessage, classModel, (Function)formalMember);
                continue;
            }
            if (!(formalMember instanceof Class) || !formalMember.isClassMember()) continue;
            this.addRefinedThrowerInstantiatorMethod(classBuilder, errorMessage, classModel, (Class)formalMember, unrefined);
        }
    }

    private void addRefinedThrowerInstantiatorMethod(ClassDefinitionBuilder classBuilder, String message, ClassOrInterface classModel, Class formalClass, Reference unrefined) {
        MethodDefinitionBuilder mdb = MethodDefinitionBuilder.systemMethod(this, this.naming.getInstantiatorMethodName(formalClass));
        mdb.modifiers(this.transformClassDeclFlags(formalClass) & 0xFFFFFBFF);
        for (TypeParameter tp : formalClass.getTypeParameters()) {
            mdb.typeParameter(tp);
            mdb.reifiedTypeParameter(tp);
        }
        for (Parameter formalP : formalClass.getParameterList().getParameters()) {
            ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.systemParameter(this, formalP.getName());
            pdb.sequenced(formalP.isSequenced());
            pdb.defaulted(formalP.isDefaulted());
            pdb.type(this.makeJavaType(unrefined.getTypedParameter(formalP).getType()), null);
            mdb.parameter(pdb);
        }
        mdb.resultType(this.makeJavaType(unrefined.getType()), null);
        mdb.body(this.makeThrowUnresolvedCompilationError(message));
        classBuilder.method(mdb);
    }

    private Iterable<List<Parameter>> overloads(Functional f) {
        ArrayList<List<Parameter>> result = new ArrayList<List<Parameter>>();
        result.add(f.getFirstParameterList().getParameters());
        int ii = 0;
        for (Parameter p : f.getFirstParameterList().getParameters()) {
            if (p.isDefaulted() || p.isSequenced() && !p.isAtLeastOne()) {
                result.add(f.getFirstParameterList().getParameters().subList(0, ii));
            }
            ++ii;
        }
        return result;
    }

    private void addRefinedThrowerMethod(ClassDefinitionBuilder classBuilder, String error, ClassOrInterface classModel, Function formalMethod) {
        Function refined = this.refineMethod(classModel, classModel.getType().getTypedMember(formalMethod, Collections.emptyList()), classModel, formalMethod, classModel.getUnit());
        for (List<Parameter> parameterList : this.overloads(refined)) {
            MethodDefinitionBuilder mdb = MethodDefinitionBuilder.method(this, refined);
            mdb.isOverride(true);
            mdb.modifiers(this.transformMethodDeclFlags(refined));
            for (TypeParameter tp : formalMethod.getTypeParameters()) {
                mdb.typeParameter(tp);
                mdb.reifiedTypeParameter(tp);
            }
            for (Parameter param : parameterList) {
                mdb.parameter(param, null, 0, MethodDefinitionBuilder.WideningRules.NONE);
            }
            mdb.resultType(refined, 0);
            mdb.body(this.makeThrowUnresolvedCompilationError(error));
            classBuilder.method(mdb);
        }
    }

    private Class refineClass(Scope container, Reference pr, ClassOrInterface classModel, Class formalClass, Unit unit) {
        Class refined = new Class();
        refined.setActual(true);
        refined.setShared(formalClass.isShared());
        refined.setContainer(container);
        refined.setExtendedType(formalClass.getType());
        refined.setDeprecated(formalClass.isDeprecated());
        refined.setName(formalClass.getName());
        refined.setRefinedDeclaration(formalClass.getRefinedDeclaration());
        refined.setScope(container);
        refined.setUnit(unit);
        for (ParameterList formalPl : formalClass.getParameterLists()) {
            ParameterList refinedPl = new ParameterList();
            for (Parameter formalP : formalPl.getParameters()) {
                FunctionOrValue paramModel;
                Parameter refinedP = new Parameter();
                refinedP.setAtLeastOne(formalP.isAtLeastOne());
                refinedP.setDeclaration(refined);
                refinedP.setDefaulted(formalP.isDefaulted());
                refinedP.setDeclaredAnything(formalP.isDeclaredAnything());
                refinedP.setHidden(formalP.isHidden());
                refinedP.setSequenced(formalP.isSequenced());
                refinedP.setName(formalP.getName());
                TypedReference typedParameter = pr.getTypedParameter(formalP);
                if (formalP.getModel() instanceof Value) {
                    Value paramValueModel = this.refineValue((Value)formalP.getModel(), typedParameter, refined, classModel.getUnit());
                    paramValueModel.setInitializerParameter(refinedP);
                    paramModel = paramValueModel;
                } else {
                    Function paramFunctionModel = this.refineMethod(refined, typedParameter, classModel, (Function)formalP.getModel(), unit);
                    paramFunctionModel.setInitializerParameter(refinedP);
                    paramModel = paramFunctionModel;
                }
                refinedP.setModel(paramModel);
                refinedPl.getParameters().add(refinedP);
            }
            refined.addParameterList(refinedPl);
        }
        return refined;
    }

    private Function refineMethod(Scope container, TypedReference pr, ClassOrInterface classModel, Function formalMethod, Unit unit) {
        Function refined = new Function();
        refined.setActual(true);
        refined.setShared(formalMethod.isShared());
        refined.setContainer(container);
        refined.setDefault(true);
        refined.setDeferred(false);
        refined.setDeprecated(formalMethod.isDeprecated());
        refined.setName(formalMethod.getName());
        refined.setRefinedDeclaration(formalMethod.getRefinedDeclaration());
        refined.setScope(container);
        refined.setType(pr.getType());
        refined.setUnit(unit);
        refined.setUnboxed(formalMethod.getUnboxed());
        refined.setUntrustedType(formalMethod.getUntrustedType());
        refined.setTypeErased(formalMethod.getTypeErased());
        ArrayList<TypeParameter> refinedTp = new ArrayList<TypeParameter>();
        for (TypeParameter formalTp : formalMethod.getTypeParameters()) {
            refinedTp.add(formalTp);
        }
        refined.setTypeParameters(refinedTp);
        for (ParameterList formalPl : formalMethod.getParameterLists()) {
            ParameterList refinedPl = new ParameterList();
            for (Parameter formalP : formalPl.getParameters()) {
                FunctionOrValue paramModel;
                Parameter refinedP = new Parameter();
                refinedP.setAtLeastOne(formalP.isAtLeastOne());
                refinedP.setDeclaration(refined);
                refinedP.setDefaulted(formalP.isDefaulted());
                refinedP.setDeclaredAnything(formalP.isDeclaredAnything());
                refinedP.setHidden(formalP.isHidden());
                refinedP.setSequenced(formalP.isSequenced());
                refinedP.setName(formalP.getName());
                TypedReference typedParameter = pr.getTypedParameter(formalP);
                if (formalP.getModel() instanceof Value) {
                    Value paramValueModel = this.refineValue((Value)formalP.getModel(), typedParameter, refined, classModel.getUnit());
                    paramValueModel.setInitializerParameter(refinedP);
                    paramModel = paramValueModel;
                } else {
                    Function paramFunctionModel = this.refineMethod(refined, typedParameter, classModel, (Function)formalP.getModel(), unit);
                    paramFunctionModel.setInitializerParameter(refinedP);
                    paramModel = paramFunctionModel;
                }
                refinedP.setModel(paramModel);
                refinedPl.getParameters().add(refinedP);
            }
            refined.addParameterList(refinedPl);
        }
        return refined;
    }

    private void addRefinedThrowerAttribute(ClassDefinitionBuilder classBuilder, String error, ClassOrInterface classModel, Value formalAttribute) {
        Value refined = this.refineValue(formalAttribute, formalAttribute.appliedTypedReference(null, null), classModel, classModel.getUnit());
        AttributeDefinitionBuilder getterBuilder = AttributeDefinitionBuilder.getter(this, refined.getName(), refined);
        getterBuilder.skipField();
        getterBuilder.modifiers(this.transformAttributeGetSetDeclFlags(refined, false));
        getterBuilder.getterBlock(this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowUnresolvedCompilationError(error))));
        classBuilder.attribute(getterBuilder);
        if (formalAttribute.isVariable()) {
            AttributeDefinitionBuilder setterBuilder = AttributeDefinitionBuilder.setter(this, refined.getName(), refined);
            setterBuilder.skipField();
            setterBuilder.modifiers(this.transformAttributeGetSetDeclFlags(refined, false));
            setterBuilder.setterBlock(this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowUnresolvedCompilationError(error))));
            classBuilder.attribute(setterBuilder);
        }
    }

    private Value refineValue(Value formalAttribute, TypedReference producedValue, Scope container, Unit unit) {
        Value refined = new Value();
        refined.setActual(true);
        refined.setContainer(container);
        refined.setName(formalAttribute.getName());
        refined.setRefinedDeclaration(formalAttribute.getRefinedDeclaration());
        refined.setScope(container);
        refined.setVariable(formalAttribute.isVariable());
        refined.setShared(formalAttribute.isShared());
        refined.setTransient(formalAttribute.isTransient());
        refined.setType(producedValue.getType());
        refined.setTypeErased(formalAttribute.getTypeErased());
        refined.setUnboxed(formalAttribute.getUnboxed());
        refined.setUntrustedType(formalAttribute.getUntrustedType());
        refined.setUnit(unit);
        return refined;
    }

    private void transformClassAlias(Tree.ClassDeclaration def, ClassDefinitionBuilder classBuilder) {
        ClassAlias model = (ClassAlias)def.getDeclarationModel();
        Type aliasedClass = model.getExtendedType();
        TypeDeclaration classOrCtor = def.getClassSpecifier().getType().getDeclarationModel();
        while (classOrCtor instanceof ClassAlias) {
            classOrCtor = ((ClassAlias)classOrCtor).getConstructor();
        }
        classBuilder.annotations(this.makeAtAlias(aliasedClass, classOrCtor instanceof Constructor ? (Constructor)classOrCtor : null));
        classBuilder.isAlias(true);
        MethodDefinitionBuilder instantiator = this.transformClassAliasInstantiator(def, model, aliasedClass);
        ClassDefinitionBuilder cbInstantiator = null;
        switch (Strategy.defaultParameterMethodOwner(model)) {
            case STATIC: {
                cbInstantiator = classBuilder;
                break;
            }
            case OUTER: {
                cbInstantiator = classBuilder.getContainingClassBuilder();
                break;
            }
            case OUTER_COMPANION: {
                cbInstantiator = classBuilder.getContainingClassBuilder().getCompanionBuilder(Decl.getClassOrInterfaceContainer(model, true));
                break;
            }
            default: {
                throw BugException.unhandledEnumCase(Strategy.defaultParameterMethodOwner(model));
            }
        }
        cbInstantiator.method(instantiator);
    }

    private MethodDefinitionBuilder transformClassAliasInstantiator(Tree.AnyClass def, Class model, Type aliasedClass) {
        MethodDefinitionBuilder instantiator = MethodDefinitionBuilder.systemMethod(this, NamingBase.getAliasInstantiatorMethodName(model));
        int f = 0;
        if (Strategy.defaultParameterMethodStatic(def.getDeclarationModel())) {
            f = 8;
        }
        instantiator.modifiers(this.transformClassDeclFlags(model) & 0xFFFFFFEF | f);
        for (TypeParameter tp : this.typeParametersOfAllContainers(model, true)) {
            instantiator.typeParameter(tp);
        }
        instantiator.resultType(null, this.makeJavaType(aliasedClass));
        instantiator.annotationFlags(7);
        for (Tree.Parameter param : def.getParameterList().getParameters()) {
            Parameter paramModel = param.getParameterModel();
            this.at(param);
            this.transformParameter(instantiator, param, paramModel, Decl.getMemberDeclaration(def, param));
        }
        instantiator.body(this.make().Throw(this.makeNewClass(this.makeJavaType(this.typeFact().getExceptionType(), 64))));
        return instantiator;
    }

    private void transformAnnotationClassConstructor(Tree.AnyClass def, ClassDefinitionBuilder classBuilder) {
        Class klass = def.getDeclarationModel();
        MethodDefinitionBuilder annoCtor = classBuilder.addConstructor();
        annoCtor.ignoreModelAnnotations();
        annoCtor.modifiers(this.transformClassDeclFlags(klass) & 0xFFFFFFEF);
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.systemParameter(this, "anno");
        pdb.type(this.makeJavaType(klass.getType(), 4096), null);
        annoCtor.parameter(pdb);
        ListBuffer args = ListBuffer.lb();
        for (Tree.Parameter parameter : def.getParameterList().getParameters()) {
            JCTree.JCExpression argExpr;
            this.at(parameter);
            Parameter parameterModel = parameter.getParameterModel();
            JCTree.JCMethodInvocation annoAttr = this.make().Apply(null, this.naming.makeQuotedQualIdent(this.naming.makeUnquotedIdent("anno"), parameter.getParameterModel().getName()), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
            Type parameterType = parameterModel.getType();
            if (this.typeFact().isIterableType(parameterType) && !this.isCeylonString(parameterType)) {
                Type iteratedType = this.typeFact().getIteratedType(parameterType);
                boolean nonEmpty = this.typeFact().isNonemptyIterableType(parameterType);
                if (this.isCeylonBasicType(iteratedType)) {
                    argExpr = this.utilInvocation().sequentialWrapperBoxed(annoAttr);
                } else if (Decl.isAnnotationClass(iteratedType.getDeclaration())) {
                    argExpr = this.make().Apply(null, this.naming.makeUnquotedIdent(this.naming.getAnnotationSequenceMethodName()), com.redhat.ceylon.langtools.tools.javac.util.List.of(annoAttr));
                    ListBuffer stmts = ListBuffer.lb();
                    Naming.SyntheticName array = this.naming.synthetic(NamingBase.Unfix.$array$);
                    Naming.SyntheticName sb = this.naming.synthetic(NamingBase.Unfix.$sb$);
                    Naming.SyntheticName index = this.naming.synthetic(NamingBase.Unfix.$index$);
                    Naming.SyntheticName element = this.naming.synthetic(NamingBase.Unfix.$element$);
                    stmts.append(this.makeVar(16L, sb, (JCTree.JCExpression)this.make().TypeArray(this.make().Type(this.syms().objectType)), (JCTree.JCExpression)this.make().NewArray(this.make().Type(this.syms().objectType), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.naming.makeQualIdent((JCTree.JCExpression)array.makeIdent(), "length")), null)));
                    stmts.append(this.makeVar(index, this.make().Type(this.syms().intType), (JCTree.JCExpression)this.make().Literal(0)));
                    stmts.append(this.make().ForeachLoop(this.makeVar(element, this.makeJavaType(iteratedType, 4096), null), array.makeIdent(), this.make().Exec(this.make().Assign(this.make().Indexed(sb.makeIdent(), (JCTree.JCExpression)this.make().Unary(54, index.makeIdent())), this.instantiateAnnotationClass(iteratedType, element.makeIdent())))));
                    stmts.append(this.make().Return(this.make().NewClass(null, null, this.make().QualIdent(this.syms().ceylonTupleType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(iteratedType), sb.makeIdent(), this.makeEmpty(), new JCTree.JCExpression[]{this.make().Literal(false)}), null)));
                    classBuilder.method(MethodDefinitionBuilder.systemMethod(this, this.naming.getAnnotationSequenceMethodName()).ignoreModelAnnotations().modifiers(10L).resultType(null, this.makeJavaType(this.typeFact().getSequentialType(iteratedType))).parameter(ParameterDefinitionBuilder.systemParameter(this, array.getName()).type(this.make().TypeArray(this.makeJavaType(iteratedType, 4096)), null)).body(stmts.toList()));
                } else {
                    argExpr = this.isCeylonMetamodelDeclaration(iteratedType) ? this.makeMetamodelInvocation("parseMetamodelReferences", com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(iteratedType), annoAttr), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeJavaType(iteratedType, 1028))) : (Decl.isEnumeratedTypeWithAnonCases(iteratedType) ? this.makeMetamodelInvocation("parseEnumerationReferences", com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeReifiedTypeArgument(iteratedType), annoAttr), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeJavaType(iteratedType, 1028))) : this.makeErroneous(parameter, "compiler bug"));
                }
                if (nonEmpty) {
                    argExpr = this.make().TypeCast(this.makeJavaType(parameterType), argExpr);
                }
            } else if (Decl.isAnnotationClass(parameterType.getDeclaration())) {
                argExpr = this.instantiateAnnotationClass(parameterType, annoAttr);
            } else if (this.isCeylonMetamodelDeclaration(parameterType)) {
                argExpr = this.makeMetamodelInvocation("parseMetamodelReference", com.redhat.ceylon.langtools.tools.javac.util.List.of(annoAttr), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeJavaType(parameterType, 1028)));
            } else if (Decl.isEnumeratedTypeWithAnonCases(parameterType)) {
                argExpr = this.makeMetamodelInvocation("parseEnumerationReference", com.redhat.ceylon.langtools.tools.javac.util.List.of(annoAttr), null);
            } else {
                argExpr = annoAttr;
                argExpr = this.expressionGen().applyErasureAndBoxing((JCTree.JCExpression)annoAttr, parameterType.withoutUnderlyingType(), false, AbstractTransformer.BoxingStrategy.UNBOXED, parameterType);
            }
            args.add(argExpr);
        }
        annoCtor.body(this.at(def).Exec(this.make().Apply(null, this.naming.makeThis(), args.toList())));
    }

    private JCTree.JCNewClass instantiateAnnotationClass(Type annotationClass, JCTree.JCExpression javaAnnotationInstance) {
        return this.make().NewClass(null, null, this.makeJavaType(annotationClass), com.redhat.ceylon.langtools.tools.javac.util.List.of(javaAnnotationInstance), null);
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformAnnotationClass(Tree.AnyClass def) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> result;
        Class klass = def.getDeclarationModel();
        String annotationName = Naming.suffixName(NamingBase.Suffix.$annotation$, klass.getName());
        ClassDefinitionBuilder annoBuilder = ClassDefinitionBuilder.klass(this, annotationName, null, false);
        annoBuilder.modifiers(0x2200 | this.transformClassDeclFlags(klass) & 0xFFFFFFEF);
        annoBuilder.getInitBuilder().modifiers(this.transformClassDeclFlags(klass) & 0xFFFFFFEF);
        annoBuilder.annotations(this.makeAtRetention(RetentionPolicy.RUNTIME));
        annoBuilder.annotations(this.makeAtIgnore());
        annoBuilder.annotations(this.expressionGen().transformAnnotations(OutputElement.ANNOTATION_TYPE, def));
        for (Tree.Parameter p : def.getParameterList().getParameters()) {
            Parameter parameterModel = p.getParameterModel();
            annoBuilder.method(this.makeAnnotationMethod(p));
        }
        if (this.isSequencedAnnotation(klass)) {
            result = annoBuilder.annotations(this.makeAtAnnotationTarget(EnumSet.noneOf(AnnotationTarget.class))).build();
            String wrapperName = Naming.suffixName(NamingBase.Suffix.$annotations$, klass.getName());
            ClassDefinitionBuilder sequencedBuilder = ClassDefinitionBuilder.klass(this, wrapperName, null, false);
            sequencedBuilder.modifiers(0x2200 | this.transformClassDeclFlags(klass) & 0xFFFFFFEF);
            sequencedBuilder.annotations(this.makeAtRetention(RetentionPolicy.RUNTIME));
            MethodDefinitionBuilder mdb = MethodDefinitionBuilder.systemMethod(this, this.naming.getSequencedAnnotationMethodName());
            mdb.annotationFlags(6);
            mdb.modifiers(1025L);
            mdb.resultType(null, this.make().TypeArray(this.makeJavaType(klass.getType(), 4096)));
            mdb.noBody();
            ClassDefinitionBuilder sequencedAnnotation = sequencedBuilder.method(mdb);
            sequencedAnnotation.annotations(this.transformAnnotationConstraints(klass));
            sequencedAnnotation.annotations(this.makeAtIgnore());
            result = result.appendList(sequencedAnnotation.build());
        } else {
            result = annoBuilder.annotations(this.transformAnnotationConstraints(klass)).build();
        }
        return result;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtRetention(RetentionPolicy retentionPolicy) {
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.make().Type(this.syms().retentionType), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.naming.makeQuotedQualIdent(this.make().Type(this.syms().retentionPolicyType), retentionPolicy.name()))));
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtAnnotationTarget(EnumSet<AnnotationTarget> types) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> typeExprs = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (AnnotationTarget type : types) {
            typeExprs = typeExprs.prepend(this.naming.makeQuotedQualIdent(this.make().Type(this.syms().elementTypeType), type.name()));
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.make().Type(this.syms().targetType), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().NewArray(null, null, typeExprs))));
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> transformAnnotationConstraints(Class klass) {
        TypeDeclaration meta = (TypeDeclaration)this.typeFact().getLanguageModuleDeclaration("ConstrainedAnnotation");
        Type constrainedType = klass.getType().getSupertype(meta);
        EnumSet<AnnotationTarget> types = EnumSet.noneOf(AnnotationTarget.class);
        if (constrainedType != null) {
            Type programElement = constrainedType.getTypeArgumentList().get(2);
            if (programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("InterfaceDeclaration")).getType()) || programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("ClassDeclaration")).getType()) || programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("ClassWithInitializerDeclaration")).getType()) || programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("ClassWithConstructorsDeclaration")).getType()) || programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("Package")).getType()) || programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("Module")).getType())) {
                types.add(AnnotationTarget.TYPE);
            }
            if (programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("ValueDeclaration")).getType()) || programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("FunctionDeclaration")).getType())) {
                types.add(AnnotationTarget.METHOD);
                types.add(AnnotationTarget.PARAMETER);
            }
            if (programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("CallableConstructorDeclaration")).getType())) {
                types.add(AnnotationTarget.CONSTRUCTOR);
            }
            if (programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("ValueConstructorDeclaration")).getType())) {
                types.add(AnnotationTarget.METHOD);
            }
            if (programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("Import")).getType())) {
                types.add(AnnotationTarget.FIELD);
            }
            if (programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("SetterDeclaration")).getType())) {
                types.add(AnnotationTarget.METHOD);
            }
            if (programElement.covers(((TypeDeclaration)this.typeFact().getLanguageModuleDeclarationDeclaration("AliasDeclaration")).getType())) {
                types.add(AnnotationTarget.TYPE);
            }
        }
        return this.makeAtAnnotationTarget(types);
    }

    private JCTree.JCExpression transformAnnotationParameterDefault(Tree.Parameter p) {
        Tree.SpecifierOrInitializerExpression defaultArgument = Decl.getDefaultArgument(p);
        Tree.Expression defaultExpression = defaultArgument.getExpression();
        Tree.Term term = defaultExpression.getTerm();
        JCTree.JCExpression defaultLiteral = null;
        if (term instanceof Tree.Literal && !(term instanceof Tree.QuotedLiteral)) {
            defaultLiteral = this.expressionGen().transform((Tree.Literal)term);
        } else if (term instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)term;
            Declaration decl = bme.getDeclaration();
            defaultLiteral = this.isBooleanTrue(decl) ? this.makeBoolean(true) : (this.isBooleanFalse(decl) ? this.makeBoolean(false) : (this.typeFact().isEmptyType(bme.getTypeModel()) ? this.make().NewArray(null, null, com.redhat.ceylon.langtools.tools.javac.util.List.nil()) : (Decl.isAnonCaseOfEnumeratedType(bme) ? this.makeClassLiteral(bme.getTypeModel()) : this.make().Literal(bme.getDeclaration().getQualifiedNameString()))));
        } else if (term instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)term;
            defaultLiteral = this.make().Literal(mte.getDeclaration().getQualifiedNameString());
        } else if (term instanceof Tree.SequenceEnumeration) {
            Tree.SequenceEnumeration seq = (Tree.SequenceEnumeration)term;
            Tree.SequencedArgument sequencedArgument = seq.getSequencedArgument();
            defaultLiteral = this.makeArrayInitializer(sequencedArgument);
        } else if (term instanceof Tree.Tuple) {
            Tree.Tuple seq = (Tree.Tuple)term;
            Tree.SequencedArgument sequencedArgument = seq.getSequencedArgument();
            defaultLiteral = this.makeArrayInitializer(sequencedArgument);
        } else if (term instanceof Tree.InvocationExpression) {
            Tree.InvocationExpression invocation = (Tree.InvocationExpression)term;
            try {
                defaultLiteral = AnnotationInvocationVisitor.transform(this.expressionGen(), invocation);
            }
            catch (BugException e) {
                defaultLiteral = e.makeErroneous(this, invocation);
            }
        } else if (term instanceof Tree.MemberLiteral) {
            defaultLiteral = this.expressionGen().makeMetaLiteralStringLiteralForAnnotation((Tree.MemberLiteral)term);
        } else if (term instanceof Tree.TypeLiteral) {
            defaultLiteral = this.expressionGen().makeMetaLiteralStringLiteralForAnnotation((Tree.TypeLiteral)term);
        }
        if (defaultLiteral == null) {
            defaultLiteral = this.makeErroneous(p, "compiler bug: " + p.getParameterModel().getName() + " has an unsupported defaulted parameter expression");
        }
        return defaultLiteral;
    }

    private JCTree.JCExpression transformAnnotationMethodType(Tree.Parameter parameter) {
        Type parameterType = parameter.getParameterModel().getType();
        JCTree.JCExpression type = null;
        if (this.isScalarAnnotationParameter(parameterType)) {
            type = this.makeJavaType(parameterType.withoutUnderlyingType(), 4096);
        } else if (this.isMetamodelReference(parameterType)) {
            type = this.make().Type(this.syms().stringType);
        } else if (Decl.isEnumeratedTypeWithAnonCases(parameterType)) {
            type = this.makeJavaClassTypeBounded(parameterType);
        } else if (this.typeFact().isIterableType(parameterType)) {
            Type iteratedType = this.typeFact().getIteratedType(parameterType);
            if (this.isScalarAnnotationParameter(iteratedType)) {
                JCTree.JCExpression scalarType = this.makeJavaType(iteratedType, 4096);
                type = this.make().TypeArray(scalarType);
            } else if (this.isMetamodelReference(iteratedType)) {
                JCTree.JCExpression scalarType = this.make().Type(this.syms().stringType);
                type = this.make().TypeArray(scalarType);
            } else if (Decl.isEnumeratedTypeWithAnonCases(iteratedType)) {
                JCTree.JCExpression scalarType = this.makeJavaClassTypeBounded(iteratedType);
                type = this.make().TypeArray(scalarType);
            }
        }
        if (type == null) {
            type = this.makeErroneous(parameter, "compiler bug: " + parameter.getParameterModel().getName() + " has an unsupported annotation parameter type");
        }
        return type;
    }

    private boolean isMetamodelReference(Type parameterType) {
        return this.isCeylonMetamodelDeclaration(parameterType);
    }

    JCTree.JCExpression makeArrayInitializer(Tree.SequencedArgument sequencedArgument) {
        ListBuffer elements = ListBuffer.lb();
        if (sequencedArgument != null) {
            for (Tree.PositionalArgument arg : sequencedArgument.getPositionalArguments()) {
                if (arg instanceof Tree.ListedArgument) {
                    Tree.ListedArgument la = (Tree.ListedArgument)arg;
                    elements.append(this.expressionGen().transformExpression(la.getExpression().getTerm(), AbstractTransformer.BoxingStrategy.UNBOXED, la.getExpression().getTypeModel()));
                    continue;
                }
                elements = null;
                break;
            }
        }
        JCTree.JCNewArray defaultLiteral = elements == null ? null : this.make().NewArray(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), elements.toList());
        return defaultLiteral;
    }

    private boolean isScalarAnnotationParameter(Type parameterType) {
        return this.isCeylonBasicType(parameterType) || Decl.isAnnotationClass(parameterType.getDeclaration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> visitClassOrInterfaceDefinition(Node def, ClassDefinitionBuilder classBuilder) {
        CeylonVisitor visitor = this.gen().visitor;
        ListBuffer<JCTree> prevDefs = visitor.defs;
        boolean prevInInitializer = visitor.inInitializer;
        ClassDefinitionBuilder prevClassBuilder = visitor.classBuilder;
        boolean prevInSynthetic = this.gen().expressionGen().withinSyntheticClassBody(false);
        try {
            visitor.defs = new ListBuffer();
            visitor.inInitializer = true;
            visitor.classBuilder = classBuilder;
            def.visitChildren(visitor);
            com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> list = visitor.getResult().toList();
            return list;
        }
        finally {
            visitor.classBuilder = prevClassBuilder;
            visitor.inInitializer = prevInInitializer;
            visitor.defs = prevDefs;
            this.gen().expressionGen().withinSyntheticClassBody(prevInSynthetic);
            this.naming.closeScopedSubstitutions(def.getScope());
        }
    }

    private void generateInstantiators(ClassDefinitionBuilder classBuilder, Class cls, Constructor ctor, ClassDefinitionBuilder instantiatorDeclCb, ClassDefinitionBuilder instantiatorImplCb, Tree.Declaration node, Tree.ParameterList pl) {
        MethodDefinitionBuilder instBuilder;
        DefaultedArgumentInstantiator overloaded;
        ParameterList parameterList;
        if (Decl.isEnumeratedConstructor(ctor)) {
            return;
        }
        ParameterList parameterList2 = parameterList = ctor != null ? ctor.getFirstParameterList() : cls.getParameterList();
        if (Decl.withinInterface(cls)) {
            overloaded = new DefaultedArgumentInstantiator(this.daoAbstract, cls, ctor, instantiatorDeclCb.isCompanionBuilder());
            instBuilder = overloaded.makeOverload(parameterList, null, cls.getTypeParameters());
            instantiatorDeclCb.method(instBuilder);
        }
        if (!Decl.withinInterface(cls) || !cls.isFormal()) {
            overloaded = new DefaultedArgumentInstantiator(!cls.isFormal() ? new DaoThis(node, pl) : this.daoAbstract, cls, ctor, instantiatorImplCb.isCompanionBuilder());
            instBuilder = overloaded.makeOverload(parameterList, null, cls.getTypeParameters());
            instantiatorImplCb.method(instBuilder);
        }
    }

    private void makeAttributeForValueParameter(ClassDefinitionBuilder classBuilder, Tree.Parameter parameterTree, Tree.TypedDeclaration memberTree) {
        FunctionOrValue member;
        Parameter decl = parameterTree.getParameterModel();
        if (!(decl.getModel() instanceof Value)) {
            return;
        }
        Value value = (Value)decl.getModel();
        if (decl.getDeclaration() instanceof Constructor) {
            classBuilder.field(17, decl.getName(), this.makeJavaType(decl.getType()), null, false, this.expressionGen().transformAnnotations(OutputElement.FIELD, memberTree));
            classBuilder.getInitBuilder().init(this.make().Exec(this.make().Assign(this.naming.makeQualIdent(this.naming.makeThis(), decl.getName()), this.naming.makeName(value, 128))));
        } else if (parameterTree instanceof Tree.ValueParameterDeclaration && (value.isShared() || value.isCaptured())) {
            this.makeFieldForParameter(classBuilder, decl, memberTree);
            AttributeDefinitionBuilder adb = AttributeDefinitionBuilder.getter(this, decl.getName(), decl.getModel());
            adb.modifiers(this.classGen().transformAttributeGetSetDeclFlags(decl.getModel(), false));
            adb.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.GETTER, memberTree));
            classBuilder.attribute(adb);
            if (value.isVariable()) {
                AttributeDefinitionBuilder setter = AttributeDefinitionBuilder.setter(this, decl.getName(), decl.getModel());
                setter.modifiers(this.classGen().transformAttributeGetSetDeclFlags(decl.getModel(), false));
                classBuilder.attribute(setter);
            }
        } else if (decl.isHidden() && decl.getDeclaration() instanceof TypeDeclaration && Strategy.createField(decl, (Value)(member = CodegenUtil.findMethodOrValueForParam(decl)))) {
            TypedReference nonWideningTypedRef;
            JCTree.JCExpression parameterExpr = this.makeUnquotedIdent(Naming.getAliasedParameterName(decl));
            TypedReference typedRef = this.getTypedReference(value);
            Type paramType = this.nonWideningType(typedRef, nonWideningTypedRef = this.nonWideningTypeDecl(typedRef));
            if (!paramType.isExactly(decl.getType())) {
                parameterExpr = this.make().TypeCast(this.classGen().transformClassParameterType(decl), parameterExpr);
            }
            classBuilder.getInitBuilder().init(this.make().Exec(this.make().Assign(this.naming.makeQualifiedName(this.naming.makeThis(), value, 128), parameterExpr)));
        }
    }

    private int transformClassParameterDeclFlags(Parameter param) {
        return param.getModel().isVariable() ? 0 : 16;
    }

    private void makeFieldForParameter(ClassDefinitionBuilder classBuilder, Parameter decl, Tree.Declaration annotated) {
        FunctionOrValue model = decl.getModel();
        classBuilder.defs(this.make().VarDef(this.make().Modifiers(this.transformClassParameterDeclFlags(decl) | 2, this.makeAtIgnore().prependList(this.expressionGen().transformAnnotations(OutputElement.FIELD, annotated))), this.names().fromString(Naming.quoteFieldName(decl.getName())), this.classGen().transformClassParameterType(decl), null));
        classBuilder.getInitBuilder().init(this.make().Exec(this.make().Assign(this.naming.makeQualifiedName(this.naming.makeThis(), model, 128), this.naming.makeName(model, 4224))));
    }

    private void transformParameter(ParameterizedBuilder<?> classBuilder, Tree.Parameter p, Parameter param, Tree.TypedDeclaration member) {
        JCTree.JCExpression type = this.makeJavaType(param.getModel(), param.getType(), 0);
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.explicitParameter(this, param);
        pdb.aliasName(Naming.getAliasedParameterName(param));
        if (Naming.aliasConstructorParameterName(param.getModel())) {
            this.naming.addVariableSubst(param.getModel(), Naming.suffixName(NamingBase.Suffix.$param$, param.getName()));
        }
        pdb.sequenced(param.isSequenced());
        pdb.defaulted(param.isDefaulted());
        pdb.type(type, this.makeJavaTypeAnnotations(param.getModel()));
        pdb.modifiers(this.transformClassParameterDeclFlags(param));
        if (!param.getModel().isShared() && !param.getModel().isCaptured()) {
            pdb.modelAnnotations(param.getModel().getAnnotations());
        }
        if (member != null) {
            pdb.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.PARAMETER, member));
        } else if (p instanceof Tree.ParameterDeclaration && Decl.isConstructor(param.getDeclaration())) {
            pdb.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.PARAMETER, ((Tree.ParameterDeclaration)p).getTypedDeclaration()));
        }
        if (pdb.requiresBoxedVariableDecl()) {
            ((ClassDefinitionBuilder)((Object)classBuilder)).getInitBuilder().init(pdb.buildBoxedVariableDecl());
        }
        classBuilder.parameter(pdb);
    }

    private void transformClass(Tree.AnyClass def, Class model, ClassDefinitionBuilder classBuilder, Tree.ParameterList paramList, boolean generateInstantiator, ClassDefinitionBuilder instantiatorDeclCb, ClassDefinitionBuilder instantiatorImplCb) {
        classBuilder.reifiedTypeParameters(model.getTypeParameters());
        if (def.getParameterList() != null) {
            TransformationPlan error = this.errors().hasDeclarationAndMarkBrokenness(def);
            if (error instanceof ThrowerCatchallConstructor) {
                InitializerBuilder initBuilder = classBuilder.getInitBuilder();
                initBuilder.init(this.make().If(this.make().Literal(true), this.statementGen().makeThrowUnresolvedCompilationError(error.getErrorMessage().getMessage()), null));
            }
            for (Tree.Parameter param : def.getParameterList().getParameters()) {
                Tree.TypedDeclaration member = def != null ? Decl.getMemberDeclaration(def, param) : null;
                this.makeAttributeForValueParameter(classBuilder, param, member);
                this.makeMethodForFunctionalParameter(classBuilder, param, member);
            }
            this.transformClassOrCtorParameters(def, model, null, def, def.getParameterList(), false, classBuilder, classBuilder.getInitBuilder(), generateInstantiator, instantiatorDeclCb, instantiatorImplCb);
        }
        this.satisfaction(def.getSatisfiedTypes(), model, classBuilder);
        this.at(def);
        this.addAtMembers(classBuilder, model, def);
        this.addAtLocalDeclarations(classBuilder, def);
        this.addReifiedTypeInterface(classBuilder, model);
    }

    private void transformClassOrCtorParameters(Tree.AnyClass def, Class cls, Constructor constructor, Tree.Declaration node, Tree.ParameterList paramList, boolean delegationConstructor, ClassDefinitionBuilder classBuilder, ParameterizedBuilder<?> constructorBuilder, boolean generateInstantiator, ClassDefinitionBuilder instantiatorDeclCb, ClassDefinitionBuilder instantiatorImplCb) {
        for (Tree.Parameter param : paramList.getParameters()) {
            ClassDefinitionBuilder cbForDevaultValues;
            Parameter paramModel = param.getParameterModel();
            Parameter refinedParam = CodegenUtil.findParamForDecl((TypedDeclaration)CodegenUtil.getTopmostRefinedDeclaration(param.getParameterModel().getModel()));
            this.at(param);
            Tree.TypedDeclaration member = def != null ? Decl.getMemberDeclaration(def, param) : null;
            this.transformParameter(constructorBuilder, param, paramModel, member);
            if (!Strategy.hasDefaultParameterValueMethod(paramModel) && !Strategy.hasDefaultParameterOverload(paramModel) && (!generateInstantiator || refinedParam == null || !Strategy.hasDefaultParameterValueMethod(refinedParam) && !Strategy.hasDefaultParameterOverload(refinedParam))) continue;
            ClassDefinitionBuilder cbForDevaultValuesDecls = null;
            switch (Strategy.defaultParameterMethodOwner(constructor != null ? constructor : cls)) {
                case STATIC: {
                    cbForDevaultValues = classBuilder;
                    break;
                }
                case OUTER: {
                    cbForDevaultValues = classBuilder.getContainingClassBuilder();
                    break;
                }
                case OUTER_COMPANION: {
                    cbForDevaultValues = classBuilder.getContainingClassBuilder().getCompanionBuilder(Decl.getClassOrInterfaceContainer(cls, true));
                    if (constructor != null && !constructor.isShared() || !cls.isShared()) break;
                    cbForDevaultValuesDecls = classBuilder.getContainingClassBuilder();
                    break;
                }
                default: {
                    cbForDevaultValues = classBuilder.getCompanionBuilder(cls);
                }
            }
            if (!delegationConstructor && (Strategy.hasDefaultParameterValueMethod(paramModel) || refinedParam != null && Strategy.hasDefaultParameterValueMethod(refinedParam))) {
                if (!generateInstantiator || Decl.equal(refinedParam, paramModel)) {
                    cbForDevaultValues.method(this.makeParamDefaultValueMethod(false, constructor != null ? constructor : cls, paramList, param));
                    if (cbForDevaultValuesDecls != null) {
                        cbForDevaultValuesDecls.method(this.makeParamDefaultValueMethod(true, constructor != null ? constructor : cls, paramList, param));
                    }
                } else if (Strategy.hasDelegatedDpm(cls) && cls.getContainer() instanceof Class) {
                    List<Parameter> parameters = paramList.getModel().getParameters();
                    MethodDefinitionBuilder mdb = this.makeDelegateToCompanion((Interface)cls.getRefinedDeclaration().getContainer(), paramModel.getModel().appliedTypedReference(cls.getType(), null), ((TypeDeclaration)cls.getContainer()).getType(), 0x10 | this.transformClassDeclFlags(cls) & 0xFFFFFBFF, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), Collections.emptyList(), paramModel.getType().getFullType(), Naming.getDefaultedParamMethodName(cls, paramModel), parameters.subList(0, parameters.indexOf(paramModel)), false, Naming.getDefaultedParamMethodName(cls, paramModel), DelegateType.FOR_DEFAULT_VALUE);
                    cbForDevaultValues.method(mdb);
                }
            }
            boolean addOverloadedConstructor = false;
            if (generateInstantiator) {
                MethodDefinitionBuilder instBuilder;
                if (Decl.withinInterface(cls)) {
                    instBuilder = new DefaultedArgumentInstantiator(this.daoAbstract, cls, constructor, instantiatorDeclCb.isCompanionBuilder()).makeOverload(paramList.getModel(), param.getParameterModel(), cls.getTypeParameters());
                    instantiatorDeclCb.method(instBuilder);
                }
                if (!Decl.withinInterface(cls) || !cls.isFormal()) {
                    instBuilder = new DefaultedArgumentInstantiator(new DaoThis(node, paramList), cls, constructor, instantiatorImplCb.isCompanionBuilder()).makeOverload(paramList.getModel(), param.getParameterModel(), cls.getTypeParameters());
                    instantiatorImplCb.method(instBuilder);
                } else {
                    addOverloadedConstructor = true;
                }
            } else {
                addOverloadedConstructor = true;
            }
            if (!addOverloadedConstructor) continue;
            DefaultedArgumentConstructor dac = constructor != null ? new DefaultedArgumentConstructor(classBuilder.addConstructor(), constructor, node, paramList, delegationConstructor) : new DefaultedArgumentConstructor(classBuilder.addConstructor(), cls, node, paramList, delegationConstructor);
            MethodDefinitionBuilder methodDefinitionBuilder = dac.makeOverload(paramList.getModel(), param.getParameterModel(), cls.getTypeParameters());
        }
    }

    private ParameterDefinitionBuilder makeConstructorNameParameter(Constructor ctor) {
        return this.makeConstructorNameParameter(ctor, Naming.DeclNameFlag.QUALIFIED);
    }

    private ParameterDefinitionBuilder makeConstructorNameParameter(Constructor ctor, Naming.DeclNameFlag ... flags) {
        Class clz = (Class)ctor.getContainer();
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.implicitParameter(this, NamingBase.Unfix.$name$.toString());
        pdb.ignored();
        JCTree.JCExpression type = this.naming.makeTypeDeclarationExpression(null, ctor, flags);
        pdb.type(type, null);
        return pdb;
    }

    private void serialization(Class model, ClassDefinitionBuilder classBuilder) {
        if (!model.isSerializable()) {
            return;
        }
        this.at(null);
        classBuilder.serializable();
        this.serializationConstructor(model, classBuilder);
        this.serializationReferences(model, classBuilder);
        this.serializationGet(model, classBuilder);
        this.serializationSet(model, classBuilder);
    }

    private boolean hasField(Declaration member) {
        Function function;
        Value value;
        return member instanceof Value ? !(value = (Value)member).isTransient() && !value.isFormal() && !ModelUtil.isConstructor(value) && (value.isShared() || value.isCaptured()) : member instanceof Function && ((function = (Function)member).isShortcutRefinement() || function.isDeferred() && function.isCaptured() || function.isParameter() && (function.isCaptured() || function.isShared() || function.isActual()));
    }

    private void serializationConstructor(Class model, ClassDefinitionBuilder classBuilder) {
        MethodDefinitionBuilder ctor = classBuilder.addConstructor();
        ctor.ignoreModelAnnotations();
        ctor.modifiers(1L);
        ParameterDefinitionBuilder serializationPdb = ParameterDefinitionBuilder.systemParameter(this, "ignored");
        serializationPdb.modifiers(16L);
        serializationPdb.type(this.make().Type(this.syms().ceylonSerializationType), null);
        ctor.parameter(serializationPdb);
        for (TypeParameter tp : model.getTypeParameters()) {
            ctor.reifiedTypeParameter(tp);
        }
        ListBuffer<JCTree.JCStatement> stmts = ListBuffer.lb();
        if (this.extendsSerializable(model)) {
            ListBuffer superArgs = ListBuffer.lb();
            superArgs.add(this.naming.makeUnquotedIdent("ignored"));
            for (JCTree.JCExpression ta : this.makeReifiedTypeArguments(model.getExtendedType())) {
                superArgs.add(ta);
            }
            stmts.add(this.make().Exec(this.make().Apply(null, this.naming.makeSuper(), superArgs.toList())));
        }
        this.buildFieldInits(model, classBuilder, stmts);
        ctor.body(stmts.toList());
    }

    protected void buildFieldInits(Class model, ClassDefinitionBuilder classBuilder, final ListBuffer<JCTree.JCStatement> stmts) {
        final HashSet<String> excludeFields = new HashSet<String>();
        for (TypeParameter tp : model.getTypeParameters()) {
            excludeFields.add(this.naming.getTypeArgumentDescriptorName(tp));
            stmts.add(this.makeReifiedTypeParameterAssignment(tp));
        }
        if (!model.getSatisfiedTypes().isEmpty()) {
            SatisfactionVisitor visitor = new SatisfactionVisitor(){

                @Override
                public void satisfiesDirectly(Class model, Interface iface, boolean alreadySatisfied) {
                    if (!alreadySatisfied) {
                        this.assignCompanion(model, iface);
                    }
                }

                @Override
                public void satisfiesIndirectly(Class model, Interface iface, boolean alreadySatisfied) {
                    if (!alreadySatisfied) {
                        this.assignCompanion(model, iface);
                    }
                }

                private void assignCompanion(Class model, Interface iface) {
                    if (ClassTransformer.this.hasImpl(iface).booleanValue() && excludeFields.add(ClassTransformer.this.getCompanionFieldName(iface))) {
                        stmts.add(ClassTransformer.this.makeCompanionInstanceAssignment(model, iface, model.getType().getSupertype(iface)));
                    }
                }

                @Override
                public void satisfiesIndirectlyViaClass(Class model, Interface iface, Class via, boolean alreadySatisfied) {
                }
            };
            this.walkSatisfiedInterfaces(model, model.getType(), visitor);
        }
        this.appendDefaultFieldInits(classBuilder, stmts, excludeFields);
    }

    protected void appendDefaultFieldInits(ClassDefinitionBuilder model, ListBuffer<JCTree.JCStatement> stmts, Collection<String> excludeFields) {
        for (JCTree.JCVariableDecl field : model.getFields()) {
            JCTree.JCLiteral nullOrZero;
            String fieldName;
            block10: {
                block9: {
                    fieldName = field.name.toString();
                    if (excludeFields != null && excludeFields.contains(fieldName) || field.mods != null && (field.mods.flags & 8L) != 0L) continue;
                    if (!(field.vartype instanceof JCTree.JCPrimitiveTypeTree)) break block9;
                    switch (((JCTree.JCPrimitiveTypeTree)field.vartype).typetag) {
                        case 1: 
                        case 3: 
                        case 4: {
                            nullOrZero = this.make().Literal(0);
                            break block10;
                        }
                        case 5: {
                            nullOrZero = this.make().Literal(0L);
                            break block10;
                        }
                        case 6: {
                            nullOrZero = this.make().Literal(Float.valueOf(0.0f));
                            break block10;
                        }
                        case 7: {
                            nullOrZero = this.make().Literal(0.0);
                            break block10;
                        }
                        case 8: {
                            nullOrZero = this.make().Literal(false);
                            break block10;
                        }
                        case 2: {
                            nullOrZero = this.make().Literal(Character.valueOf('\u0000'));
                            break block10;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                nullOrZero = this.makeNull();
            }
            stmts.add(this.make().Exec(this.make().Assign(this.naming.makeQualIdent(this.naming.makeThis(), fieldName), nullOrZero)));
        }
    }

    private void walkSatisfiedInterfaces(Class model, Type type, SatisfactionVisitor visitor) {
        this.walkSatisfiedInterfacesInternal(model, type, null, visitor, new HashSet<Interface>());
    }

    private void walkSatisfiedInterfacesInternal(Class model, Type type, Class via, SatisfactionVisitor visitor, Set<Interface> satisfiedInterfaces) {
        Type ext = (type = type.resolveAliases()).getExtendedType();
        if (ext != null) {
            this.walkSatisfiedInterfacesInternal(model, ext, (Class)ext.getDeclaration(), visitor, satisfiedInterfaces);
        }
        for (Type sat : type.getSatisfiedTypes()) {
            boolean alreadySatisfied;
            Interface iface = (Interface)sat.getDeclaration();
            if (iface.getType().isExactly(this.typeFact().getIdentifiableDeclaration().getType())) {
                return;
            }
            this.walkSatisfiedInterfacesInternal(model, sat, via, visitor, satisfiedInterfaces);
            boolean bl = alreadySatisfied = !satisfiedInterfaces.add((Interface)model.getType().getSupertype(iface).getDeclaration());
            if (via != null) {
                visitor.satisfiesIndirectlyViaClass(model, iface, via, alreadySatisfied);
                continue;
            }
            if (model.getType().equals(type)) {
                visitor.satisfiesDirectly(model, iface, alreadySatisfied);
                continue;
            }
            visitor.satisfiesIndirectly(model, iface, alreadySatisfied);
        }
    }

    private boolean extendsSerializable(Class model) {
        return !this.typeFact().getObjectType().isExactly(model.getExtendedType()) && !this.typeFact().getBasicType().isExactly(model.getExtendedType());
    }

    private void serializationReferences(Class model, ClassDefinitionBuilder classBuilder) {
        MethodDefinitionBuilder mdb = MethodDefinitionBuilder.systemMethod(this, NamingBase.Unfix.$references$.toString());
        mdb.isOverride(true);
        mdb.ignoreModelAnnotations();
        mdb.modifiers(1L);
        mdb.resultType(null, this.make().TypeApply(this.naming.makeQuotedFQIdent("java.util.Collection"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Type(this.syms().ceylonReachableReferenceType))));
        ListBuffer stmts = ListBuffer.lb();
        Naming.SyntheticName r = this.naming.synthetic(NamingBase.Unfix.reference);
        if (this.extendsSerializable(model)) {
            stmts.add(this.makeVar(r, (JCTree.JCExpression)this.make().TypeApply(this.naming.makeQuotedFQIdent("java.util.Collection"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Type(this.syms().ceylonReachableReferenceType))), (JCTree.JCExpression)this.make().Apply(null, this.naming.makeQualIdent(this.naming.makeSuper(), NamingBase.Unfix.$references$.toString()), com.redhat.ceylon.langtools.tools.javac.util.List.nil())));
        } else {
            stmts.add(this.makeVar(r, (JCTree.JCExpression)this.make().TypeApply(this.naming.makeQuotedFQIdent("java.util.Collection"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Type(this.syms().ceylonReachableReferenceType))), (JCTree.JCExpression)this.make().NewClass(null, null, this.make().TypeApply(this.naming.makeQuotedFQIdent("java.util.ArrayList"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Type(this.syms().ceylonReachableReferenceType))), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null)));
        }
        if (model.isMember()) {
            JCTree.JCExpressionStatement outer = this.make().Exec(this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)r.makeIdent(), "add"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Apply(null, this.naming.makeQualIdent(this.make().Type(this.syms().ceylonOuterImplType), "get_"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()))));
            stmts.add(outer);
        }
        for (Declaration member : model.getMembers()) {
            if (!this.hasField(member)) continue;
            JCTree.JCExpression valueDeclaration = this.expressionGen().makeMemberValueOrFunctionDeclarationLiteral(null, member, false);
            JCTree.JCNewClass mi = this.make().NewClass(null, null, this.make().QualIdent(this.syms().ceylonMemberImplType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(valueDeclaration), null);
            JCTree.JCExpressionStatement attribute = this.make().Exec(this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)r.makeIdent(), "add"), com.redhat.ceylon.langtools.tools.javac.util.List.of(mi)));
            stmts.add(attribute);
        }
        stmts.add(this.make().Return(r.makeIdent()));
        mdb.body(stmts.toList());
        classBuilder.method(mdb);
    }

    private void serializationGet(Class model, ClassDefinitionBuilder classBuilder) {
        MethodDefinitionBuilder mdb = MethodDefinitionBuilder.systemMethod(this, NamingBase.Unfix.$get$.toString());
        mdb.isOverride(true);
        mdb.ignoreModelAnnotations();
        mdb.modifiers(1L);
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.systemParameter(this, NamingBase.Unfix.reference.toString());
        pdb.modifiers(16L);
        pdb.type(this.make().Type(this.syms().ceylonReachableReferenceType), null);
        mdb.parameter(pdb);
        mdb.resultType(null, this.make().Type(this.syms().objectType));
        ListBuffer cases = ListBuffer.lb();
        boolean[] needsLookup = new boolean[]{false};
        for (Declaration member : model.getMembers()) {
            if (!this.hasField(member) || member instanceof Function) continue;
            ListBuffer caseStmts = ListBuffer.lb();
            if (member instanceof Value && ((Value)member).isLate()) {
                JCTree.JCExpression test = CodegenUtil.needsLateInitField((Value)member, this.typeFact()) ? this.make().Unary(50, this.naming.makeUnquotedIdent(Naming.getInitializationFieldName(member.getName()))) : this.make().Binary(62, this.naming.makeQualifiedName(this.naming.makeThis(), (Value)member, 128), this.makeNull());
                caseStmts.add(this.make().If(test, this.make().Return(this.makeLanguageSerializationValue("uninitializedLateValue")), null));
            }
            caseStmts.add(this.make().Return(this.makeSerializationGetter((Value)member)));
            cases.add(this.make().Case(this.make().Literal(member.getQualifiedNameString()), caseStmts.toList()));
        }
        Naming.SyntheticName reference = this.naming.synthetic(NamingBase.Unfix.reference);
        ListBuffer defaultCase = ListBuffer.lb();
        if (this.extendsSerializable(model)) {
            defaultCase.add(this.make().Return(this.make().Apply(null, this.naming.makeQualIdent(this.naming.makeSuper(), NamingBase.Unfix.$get$.toString()), com.redhat.ceylon.langtools.tools.javac.util.List.of(reference.makeIdent()))));
        } else {
            defaultCase.add(this.make().Throw(this.make().NewClass(null, null, this.naming.makeQuotedFQIdent("java.lang.RuntimeException"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Literal("unknown attribute")), null)));
        }
        cases.add(this.make().Case(null, defaultCase.toList()));
        ListBuffer stmts = ListBuffer.lb();
        if (needsLookup[0]) {
            stmts.add(this.makeVar(16L, "lookup", this.naming.makeQualIdent(this.make().Type(this.syms().methodHandlesType), "Lookup"), (JCTree.JCExpression)this.make().Apply(null, this.naming.makeQuotedFQIdent("java.lang.invoke.MethodHandles.lookup"), com.redhat.ceylon.langtools.tools.javac.util.List.nil())));
        }
        JCTree.JCSwitch swtch = this.make().Switch(this.make().Apply(null, this.naming.makeSelect((JCTree.JCExpression)this.make().Apply(null, this.naming.makeSelect((JCTree.JCExpression)this.make().TypeCast(this.make().Type(this.syms().ceylonMemberType), (JCTree.JCExpression)reference.makeIdent()), "getAttribute"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), "getQualifiedName"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), cases.toList());
        if (model.isMember() && !model.getExtendedType().getDeclaration().isMember()) {
            stmts.add(this.make().If(this.make().TypeTest(reference.makeIdent(), this.make().Type(this.syms().ceylonOuterType)), this.make().Return(this.expressionGen().makeOuterExpr(((TypeDeclaration)model.getContainer()).getType())), swtch));
        } else {
            stmts.add(swtch);
        }
        mdb.body(stmts.toList());
        classBuilder.method(mdb);
    }

    private JCTree.JCExpression makeSerializationGetter(Value value) {
        JCTree.JCExpression result = value.isToplevel() || value.isLate() ? this.make().Apply(null, this.naming.makeQualifiedName(this.naming.makeThis(), value, 17), com.redhat.ceylon.langtools.tools.javac.util.List.nil()) : this.naming.makeQualifiedName(this.naming.makeThis(), value, 128);
        result = this.expressionGen().applyErasureAndBoxing(result, value.getType(), !CodegenUtil.isUnBoxed(value), AbstractTransformer.BoxingStrategy.BOXED, value.getType());
        return result;
    }

    private void serializationSet(Class model, ClassDefinitionBuilder classBuilder) {
        MethodDefinitionBuilder mdb = MethodDefinitionBuilder.systemMethod(this, NamingBase.Unfix.$set$.toString());
        mdb.isOverride(true);
        mdb.ignoreModelAnnotations();
        mdb.modifiers(1L);
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.systemParameter(this, NamingBase.Unfix.reference.toString());
        pdb.modifiers(16L);
        pdb.type(this.make().Type(this.syms().ceylonReachableReferenceType), null);
        mdb.parameter(pdb);
        ParameterDefinitionBuilder pdb2 = ParameterDefinitionBuilder.systemParameter(this, NamingBase.Unfix.instance.toString());
        pdb2.modifiers(16L);
        pdb2.type(this.make().Type(this.syms().objectType), null);
        mdb.parameter(pdb2);
        Naming.SyntheticName reference = this.naming.synthetic(NamingBase.Unfix.reference);
        Naming.SyntheticName instance = this.naming.synthetic(NamingBase.Unfix.instance);
        ListBuffer cases = ListBuffer.lb();
        boolean[] needsLookup = new boolean[]{false};
        for (Declaration member : model.getMembers()) {
            if (!this.hasField(member) || member instanceof Function) continue;
            ListBuffer caseStmts = ListBuffer.lb();
            if (member instanceof Value && ((Value)member).isLate()) {
                caseStmts.add(this.make().If(this.make().TypeTest(instance.makeIdent(), this.make().Type(this.syms().ceylonUninitializedLateValueType)), this.make().Break(null), null));
            }
            caseStmts.add(this.makeDeserializationAssignment((Value)member, needsLookup));
            caseStmts.add(this.make().Break(null));
            cases.add(this.make().Case(this.make().Literal(member.getQualifiedNameString()), caseStmts.toList()));
        }
        ListBuffer defaultCase = ListBuffer.lb();
        if (this.extendsSerializable(model)) {
            defaultCase.add(this.make().Exec(this.make().Apply(null, this.naming.makeQualIdent(this.naming.makeSuper(), NamingBase.Unfix.$set$.toString()), com.redhat.ceylon.langtools.tools.javac.util.List.of(reference.makeIdent(), instance.makeIdent()))));
        } else {
            defaultCase.add(this.make().Throw(this.make().NewClass(null, null, this.naming.makeQuotedFQIdent("java.lang.RuntimeException"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Literal("unknown attribute")), null)));
        }
        cases.add(this.make().Case(null, defaultCase.toList()));
        ListBuffer stmts = ListBuffer.lb();
        if (needsLookup[0]) {
            stmts.add(this.makeVar(16L, "lookup", this.naming.makeQualIdent(this.make().Type(this.syms().methodHandlesType), "Lookup"), (JCTree.JCExpression)this.make().Apply(null, this.naming.makeQuotedFQIdent("java.lang.invoke.MethodHandles.lookup"), com.redhat.ceylon.langtools.tools.javac.util.List.nil())));
        }
        JCTree.JCSwitch swtch = this.make().Switch(this.make().Apply(null, this.naming.makeSelect((JCTree.JCExpression)this.make().Apply(null, this.naming.makeSelect((JCTree.JCExpression)this.make().TypeCast(this.make().Type(this.syms().ceylonMemberType), (JCTree.JCExpression)reference.makeIdent()), "getAttribute"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), "getQualifiedName"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), cases.toList());
        stmts.add(this.make().If(this.make().TypeTest(reference.makeIdent(), this.make().Type(this.syms().ceylonMemberType)), swtch, this.make().Throw(this.make().NewClass(null, null, this.make().Type(this.syms().ceylonAssertionErrorType), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Binary(71, this.make().Literal("unexpected reachable reference "), reference.makeIdent())), null))));
        mdb.body(stmts.toList());
        classBuilder.method(mdb);
    }

    private JCTree.JCStatement makeDeserializationAssignment(Value value, boolean[] requiredLookup) {
        JCTree.JCStatement assignment;
        boolean isValueType = Decl.isValueTypeDecl(this.simplifyType(value.getType()));
        Naming.SyntheticName n = this.naming.synthetic(NamingBase.Unfix.instance);
        JCTree.JCExpression newValue = this.make().TypeCast(this.makeJavaType(value.getType(), 4), (JCTree.JCExpression)n.makeIdent());
        if (isValueType) {
            newValue = this.expressionGen().applyErasureAndBoxing(newValue, value.getType(), true, CodegenUtil.getBoxingStrategy(value), value.getType());
        }
        if (value.isToplevel() || value.isLate()) {
            assignment = this.make().Exec(this.make().Apply(null, this.naming.makeQualifiedName(this.naming.makeThis(), value, 33), com.redhat.ceylon.langtools.tools.javac.util.List.of(newValue)));
        } else if (value.isVariable()) {
            assignment = this.make().Exec(this.make().Assign(this.naming.makeQualifiedName(this.naming.makeThis(), value, 128), newValue));
        } else {
            requiredLookup[0] = true;
            String fieldName = value.getName();
            JCTree.JCExpression fieldType = this.makeJavaType(value.getType());
            assignment = this.makeReassignFinalField(fieldType, fieldName, newValue);
        }
        return assignment;
    }

    private JCTree.JCStatement makeReassignFinalField(JCTree.JCExpression fieldType, String fieldName, JCTree.JCExpression newValue) {
        JCTree.JCExpression mhExpr = this.utilInvocation().setter(this.naming.makeUnquotedIdent("lookup"), this.make().Literal(fieldName));
        JCTree.JCMethodInvocation expr = this.make().Apply(null, this.naming.makeQualIdent(mhExpr, "invokeExact"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.naming.makeThis(), this.make().TypeCast(fieldType, newValue)));
        JCTree.JCExpressionStatement assignment = this.make().Exec(expr);
        return assignment;
    }

    private JCTree.JCExpression makeValueDeclaration(Value value) {
        return this.expressionGen().makeMemberValueOrFunctionDeclarationLiteral(null, value, false);
    }

    private void makeMethodForFunctionalParameter(ClassDefinitionBuilder classBuilder, Tree.Parameter paramTree, Tree.TypedDeclaration memberDecl) {
        Parameter paramModel = paramTree.getParameterModel();
        if (Strategy.createMethod(paramModel)) {
            JCTree.JCStatement body;
            Tree.MethodDeclaration methodDecl = (Tree.MethodDeclaration)memberDecl;
            this.makeFieldForParameter(classBuilder, paramModel, memberDecl);
            Function method = (Function)paramModel.getModel();
            List<Parameter> parameters = method.getFirstParameterList().getParameters();
            CallBuilder callBuilder = CallBuilder.instance(this).invoke(this.naming.makeQualIdent(this.naming.makeName(method, 128), Naming.getCallableMethodName(method)));
            for (Parameter parameter : parameters) {
                JCTree.JCExpression parameterExpr = this.naming.makeName(parameter.getModel(), 128);
                parameterExpr = this.expressionGen().applyErasureAndBoxing(parameterExpr, parameter.getType(), !CodegenUtil.isUnBoxed(parameter.getModel()), AbstractTransformer.BoxingStrategy.BOXED, parameter.getType());
                callBuilder.argument(parameterExpr);
            }
            JCTree.JCExpression expr = callBuilder.build();
            if (this.isVoid(memberDecl) && Decl.isUnboxedVoid(method) && !Strategy.useBoxedVoid(method)) {
                body = this.make().Exec(expr);
            } else {
                expr = this.expressionGen().applyErasureAndBoxing(expr, paramModel.getType(), true, CodegenUtil.getBoxingStrategy(method), paramModel.getType());
                body = this.make().Return(expr);
            }
            classBuilder.methods(this.transformMethod(method, null, methodDecl, methodDecl.getParameterLists(), methodDecl, true, method.isActual(), true, com.redhat.ceylon.langtools.tools.javac.util.List.of(body), new DaoThis(methodDecl, methodDecl.getParameterLists().get(0)), false));
        }
    }

    private void addReifiedTypeInterface(ClassDefinitionBuilder classBuilder, ClassOrInterface model) {
        if (model.getExtendedType() == null || this.willEraseToObject(model.getExtendedType()) || !Decl.isCeylon(model.getExtendedType().getDeclaration())) {
            classBuilder.reifiedType();
        }
    }

    JCTree.JCExpression transformClassParameterType(Parameter parameter) {
        JCTree.JCExpression type;
        FunctionOrValue decl = parameter.getModel();
        if (!(decl.getContainer() instanceof Class)) {
            throw new BugException("expected parameter of Class");
        }
        FunctionOrValue attr = decl;
        if (!Decl.isTransient(attr)) {
            TypedReference typedRef = this.getTypedReference(attr);
            TypedReference nonWideningTypedRef = this.nonWideningTypeDecl(typedRef);
            Type paramType = this.nonWideningType(typedRef, nonWideningTypedRef);
            type = this.makeJavaType(nonWideningTypedRef.getDeclaration(), paramType, 0);
        } else {
            Type paramType = decl.getType();
            type = this.makeJavaType(decl, paramType, 0);
        }
        return type;
    }

    private void transformInterface(Tree.ClassOrInterface def, Interface model, ClassDefinitionBuilder classBuilder) {
        List<TypeParameter> typeParameters = this.typeParametersOfAllContainers(model, false);
        for (TypeParameter tp : typeParameters) {
            classBuilder.typeParameter(tp, false);
        }
        if (model.isCompanionClassNeeded().booleanValue()) {
            classBuilder.method(this.makeCompanionAccessor(model, model.getType(), null, false));
            this.buildCompanion(def, model, classBuilder);
        }
        this.addAmbiguousMembers(classBuilder, model);
        this.addAtMembers(classBuilder, model, def);
        this.addAtLocalDeclarations(classBuilder, def);
    }

    private void addAmbiguousMembers(ClassDefinitionBuilder classBuilder, Interface model) {
        List<Type> satisfiedTypes = model.getSatisfiedTypes();
        if (satisfiedTypes.size() <= 1) {
            return;
        }
        HashSet<Interface> satisfiedInterfaces = new HashSet<Interface>();
        for (Type interfaceDecl : model.getSatisfiedTypes()) {
            this.collectInterfaces((Interface)interfaceDecl.getDeclaration(), satisfiedInterfaces);
        }
        HashSet<Interface> ambiguousInterfaces = new HashSet<Interface>();
        for (Interface satisfiedInterface : satisfiedInterfaces) {
            if (this.isInheritedWithDifferentTypeArguments(satisfiedInterface, model.getType()) == null) continue;
            ambiguousInterfaces.add(satisfiedInterface);
        }
        HashSet<String> treated = new HashSet<String>();
        for (Interface ambiguousInterface : ambiguousInterfaces) {
            for (Declaration member : ambiguousInterface.getMembers()) {
                String name = member.getName();
                if (treated.contains(name)) continue;
                if (model.getDirectMember(name, null, false) != null) {
                    treated.add(name);
                    continue;
                }
                block4: for (int i = 0; i < satisfiedTypes.size(); ++i) {
                    Type firstInterface = satisfiedTypes.get(i);
                    Declaration member1 = firstInterface.getDeclaration().getMember(name, null, false);
                    if (member1 == null) continue;
                    for (int j = i + 1; j < satisfiedTypes.size(); ++j) {
                        Type type2;
                        Type secondInterface = satisfiedTypes.get(j);
                        Declaration member2 = secondInterface.getDeclaration().getMember(name, null, false);
                        if (member2 == null) continue;
                        Reference typedMember1 = firstInterface.getTypedReference(member1, Collections.emptyList());
                        Reference typedMember2 = secondInterface.getTypedReference(member2, Collections.emptyList());
                        Type type1 = this.simplifyType(typedMember1.getType());
                        if (type1.isExactly(type2 = this.simplifyType(typedMember2.getType()))) continue;
                        this.addAmbiguousMember(classBuilder, model, name);
                        break block4;
                    }
                }
                treated.add(name);
            }
        }
    }

    private void addAmbiguousMember(ClassDefinitionBuilder classBuilder, Interface model, String name) {
        Declaration member = model.getMember(name, null, false);
        Type satisfiedType = model.getType().getSupertype(model);
        if (member instanceof Class) {
            Class klass = (Class)member;
            if (Strategy.generateInstantiator(member) && !klass.hasConstructors()) {
                this.generateInstantiatorDelegate(classBuilder, satisfiedType, model, klass, null, model.getType(), false);
            }
            if (klass.hasConstructors()) {
                for (Declaration m : klass.getMembers()) {
                    if (!(m instanceof Constructor) || !Strategy.generateInstantiator(m)) continue;
                    Constructor ctor = (Constructor)m;
                    this.generateInstantiatorDelegate(classBuilder, satisfiedType, model, klass, ctor, model.getType(), false);
                }
            }
        } else if (member instanceof Function) {
            Function method = (Function)member;
            TypedReference typedMember = satisfiedType.getTypedMember(method, Collections.emptyList());
            List<List<Type>> producedTypeParameterBounds = this.producedTypeParameterBounds(typedMember, method);
            List<TypeParameter> typeParameters = method.getTypeParameters();
            List<Parameter> parameters = method.getFirstParameterList().getParameters();
            for (Parameter param : parameters) {
                if (!Strategy.hasDefaultParameterOverload(param)) continue;
                MethodDefinitionBuilder overload = new DefaultedArgumentMethodTyped(null, MethodDefinitionBuilder.method(this, method), typedMember, true).makeOverload(method.getFirstParameterList(), param, typeParameters);
                overload.modifiers(1025L);
                classBuilder.method(overload);
            }
            MethodDefinitionBuilder concreteMemberDelegate = this.makeDelegateToCompanion(null, typedMember, model.getType(), 1025L, method.getTypeParameters(), producedTypeParameterBounds, typedMember.getType(), this.naming.selector(method), method.getFirstParameterList().getParameters(), ((Function)member).getTypeErased(), null, DelegateType.OTHER, false);
            classBuilder.method(concreteMemberDelegate);
        } else if (member instanceof Value || member instanceof Setter) {
            TypedDeclaration attr = (TypedDeclaration)member;
            TypedReference typedMember = satisfiedType.getTypedMember(attr, Collections.emptyList());
            if (member instanceof Value) {
                MethodDefinitionBuilder getterDelegate = this.makeDelegateToCompanion(null, typedMember, model.getType(), 1025L, Collections.emptyList(), Collections.emptyList(), typedMember.getType(), Naming.getGetterName(attr), Collections.emptyList(), attr.getTypeErased(), null, DelegateType.OTHER, false);
                classBuilder.method(getterDelegate);
            }
            if (member instanceof Setter) {
                MethodDefinitionBuilder setterDelegate = this.makeDelegateToCompanion(null, typedMember, model.getType(), 1025L, Collections.emptyList(), Collections.emptyList(), this.typeFact().getAnythingType(), Naming.getSetterName(attr), Collections.singletonList(((Setter)member).getParameter()), ((Setter)member).getTypeErased(), null, DelegateType.OTHER, false);
                classBuilder.method(setterDelegate);
            }
        }
    }

    private void addAtMembers(ClassDefinitionBuilder classBuilder, ClassOrInterface model, Tree.ClassOrInterface def) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> members = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (Declaration member : model.getMembers()) {
            TransformationPlan plan;
            TypeDeclaration innerType;
            Tree.Declaration innerTypeTree;
            if (!(member instanceof ClassOrInterface) && !(member instanceof TypeAlias) || (innerTypeTree = this.findInnerType(def, (innerType = (TypeDeclaration)member).getName())) != null && (plan = this.errors().hasDeclarationAndMarkBrokenness(innerTypeTree)) instanceof Drop || innerType.isAlias() && innerTypeTree != null && Decl.isAncestorLocal(innerTypeTree)) continue;
            JCTree.JCAnnotation atMember = Decl.isLocal(model) && model instanceof Interface ? this.makeAtMember(innerType.getName()) : this.makeAtMember(innerType.getType());
            members = members.prepend(atMember);
        }
        classBuilder.annotations(this.makeAtMembers(members));
    }

    private Tree.Declaration findInnerType(Tree.ClassOrInterface def, String name) {
        Tree.Body body;
        if (def instanceof Tree.ClassDefinition) {
            body = ((Tree.ClassDefinition)def).getClassBody();
        } else if (def instanceof Tree.InterfaceDefinition) {
            body = ((Tree.InterfaceDefinition)def).getInterfaceBody();
        } else {
            return null;
        }
        for (Node node : body.getStatements()) {
            if (!(node instanceof Tree.Declaration) || ((Tree.Declaration)node).getIdentifier() == null || !((Tree.Declaration)node).getIdentifier().getText().equals(name)) continue;
            return (Tree.Declaration)node;
        }
        return null;
    }

    private void addAtLocalDeclarations(ClassDefinitionBuilder classBuilder, Tree.ClassOrInterface tree) {
        classBuilder.annotations(this.makeAtLocalDeclarations(tree));
    }

    private void addAtContainer(ClassDefinitionBuilder classBuilder, TypeDeclaration model) {
        Scope scope = Decl.getNonSkippedContainer(model);
        Scope declarationScope = Decl.getFirstDeclarationContainer(model);
        boolean inlineObjectInToplevelAttr = Decl.isTopLevelObjectExpressionType(model);
        if (scope == null || scope instanceof Package && !inlineObjectInToplevelAttr && scope == declarationScope) {
            return;
        }
        if (!(!(scope instanceof ClassOrInterface) || scope != declarationScope || inlineObjectInToplevelAttr || model instanceof Interface && Decl.hasLocalNotInitializerAncestor(model))) {
            ClassOrInterface container = (ClassOrInterface)scope;
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> atContainer = this.makeAtContainer(container.getType());
            classBuilder.annotations(atContainer);
        } else {
            if (model instanceof Interface) {
                classBuilder.annotations(this.makeLocalContainerPath((Interface)model));
            }
            Declaration declarationContainer = this.getDeclarationContainer(model);
            classBuilder.annotations(this.makeAtLocalDeclaration(model.getQualifier(), declarationContainer == null));
        }
    }

    private void satisfaction(Tree.SatisfiedTypes satisfied, Class model, ClassDefinitionBuilder classBuilder) {
        HashSet<Interface> satisfiedInterfaces = new HashSet<Interface>();
        for (Type superClass = model.getExtendedType(); superClass != null; superClass = superClass.getExtendedType()) {
            for (Type interfaceDecl : superClass.getSatisfiedTypes()) {
                this.collectInterfaces((Interface)interfaceDecl.getDeclaration(), satisfiedInterfaces);
            }
        }
        if (satisfied != null) {
            for (Tree.StaticType type : satisfied.getTypes()) {
                try {
                    Type satisfiedType = type.getTypeModel();
                    TypeDeclaration decl = satisfiedType.getDeclaration();
                    if (!(decl instanceof Interface)) continue;
                    satisfiedType = model.getType().getSupertype(decl);
                    this.concreteMembersFromSuperinterfaces(model, classBuilder, satisfiedType, satisfiedInterfaces);
                }
                catch (BugException e) {
                    e.addError(type);
                }
            }
        }
        if (model.getExtendedType() != null) {
            satisfiedInterfaces.clear();
            for (Type interfaceDecl : model.getSatisfiedTypes()) {
                this.collectInterfaces((Interface)interfaceDecl.getDeclaration(), satisfiedInterfaces);
            }
            if (!satisfiedInterfaces.isEmpty()) {
                ArrayList<Interface> sortedInterfaces = new ArrayList<Interface>(satisfiedInterfaces.size());
                sortedInterfaces.addAll(satisfiedInterfaces);
                Collections.sort(sortedInterfaces, DeclarationComparator);
                for (Interface iface : sortedInterfaces) {
                    if (!ClassTransformer.supportsReified(iface) || !CodegenUtil.isCompanionClassNeeded(iface)) continue;
                    Type thisType = model.getType().getSupertype(iface);
                    Type superClassType = model.getExtendedType().getSupertype(iface);
                    if (thisType == null || superClassType == null || thisType.isExactly(superClassType) || !thisType.isSubtypeOf(superClassType)) continue;
                    classBuilder.refineReifiedType(thisType);
                }
            }
        }
    }

    private void collectInterfaces(Interface interfaceDecl, Set<Interface> satisfiedInterfaces) {
        if (satisfiedInterfaces.add(interfaceDecl)) {
            for (Type newInterfaceDecl : interfaceDecl.getSatisfiedTypes()) {
                if (newInterfaceDecl.isUnknown()) continue;
                this.collectInterfaces((Interface)newInterfaceDecl.getDeclaration(), satisfiedInterfaces);
            }
        }
    }

    private void concreteMembersFromSuperinterfaces(Class model, ClassDefinitionBuilder classBuilder, Type satisfiedType, Set<Interface> satisfiedInterfaces) {
        Interface iface = (Interface)(satisfiedType = satisfiedType.resolveAliases()).getDeclaration();
        if (satisfiedInterfaces.contains(iface) || iface.getType().isExactly(this.typeFact().getIdentifiableDeclaration().getType())) {
            return;
        }
        if (this.hasImpl(iface).booleanValue()) {
            this.transformInstantiateCompanions(classBuilder, model, iface, satisfiedType);
        }
        if (!Decl.isCeylon(iface)) {
            return;
        }
        for (Declaration member : this.sortedMembers(iface.getMembers())) {
            Reference typedMember;
            if (member instanceof Class) {
                Class klass = (Class)member;
                typedMember = satisfiedType.getTypeMember(klass, Collections.emptyList());
                if (Strategy.generateInstantiator(member) && !klass.hasConstructors() && !model.isFormal() && this.needsCompanionDelegate(model, typedMember) && model.getDirectMember(member.getName(), null, false) == null) {
                    this.generateInstantiatorDelegate(classBuilder, satisfiedType, iface, klass, null, model.getType(), !member.isFormal());
                }
                if (klass.hasConstructors()) {
                    for (Declaration m : klass.getMembers()) {
                        if (!(m instanceof Constructor) || !Strategy.generateInstantiator(m)) continue;
                        Constructor ctor = (Constructor)m;
                        this.generateInstantiatorDelegate(classBuilder, satisfiedType, iface, klass, ctor, model.getType(), true);
                    }
                }
            }
            if (member instanceof TypeAlias || Strategy.onlyOnCompanion(member)) continue;
            if (member instanceof Function) {
                Function subMethod;
                Function method = (Function)member;
                typedMember = satisfiedType.getTypedMember(method, Collections.emptyList());
                Declaration sub = model.getMember(method.getName(), this.getSignatureIfRequired(typedMember), false, true);
                if (!(sub instanceof Function) || (subMethod = (Function)sub).getParameterLists().isEmpty()) continue;
                List<List<Type>> producedTypeParameterBounds = this.producedTypeParameterBounds(typedMember, subMethod);
                List<TypeParameter> typeParameters = subMethod.getTypeParameters();
                List<Parameter> parameters = subMethod.getFirstParameterList().getParameters();
                boolean hasOverloads = false;
                if (!satisfiedInterfaces.contains((Interface)method.getContainer())) {
                    for (Parameter param : parameters) {
                        if (Strategy.hasDefaultParameterValueMethod(param) && CodegenUtil.getTopmostRefinedDeclaration(param.getModel()).getContainer().equals(member)) {
                            TypedReference typedParameter = typedMember.getTypedParameter(param);
                            MethodDefinitionBuilder defaultValueDelegate = this.makeDelegateToCompanion(iface, typedParameter, model.getType(), 17L, typeParameters, producedTypeParameterBounds, typedParameter.getFullType(), Naming.getDefaultedParamMethodName(method, param), parameters.subList(0, parameters.indexOf(param)), param.getModel().getTypeErased(), null, DelegateType.FOR_DEFAULT_VALUE);
                            classBuilder.method(defaultValueDelegate);
                        }
                        if (!Strategy.hasDefaultParameterOverload(param)) continue;
                        if ((method.isDefault() || method.isShared() && !method.isFormal()) && Decl.equal(method, subMethod)) {
                            MethodDefinitionBuilder overload = new DefaultedArgumentMethodTyped(new DaoThis(null, null), MethodDefinitionBuilder.method(this, subMethod), (TypedReference)typedMember, true).makeOverload(subMethod.getFirstParameterList(), param, typeParameters);
                            classBuilder.method(overload);
                        }
                        hasOverloads = true;
                    }
                }
                if (this.needsCompanionDelegate(model, typedMember)) {
                    MethodDefinitionBuilder concreteMemberDelegate = this.makeDelegateToCompanion(iface, typedMember, model.getType(), 1 | (method.isDefault() ? 0 : 16), typeParameters, producedTypeParameterBounds, ((TypedReference)typedMember).getType(), this.naming.selector(method), method.getFirstParameterList().getParameters(), ((Function)member).getTypeErased(), null, DelegateType.OTHER);
                    classBuilder.method(concreteMemberDelegate);
                }
                if (!hasOverloads || !method.isDefault() && (!method.isShared() || method.isFormal()) || !Decl.equal(method, subMethod)) continue;
                MethodDefinitionBuilder canonicalMethod = this.makeDelegateToCompanion(iface, typedMember, model.getType(), 2L, subMethod.getTypeParameters(), producedTypeParameterBounds, ((TypedReference)typedMember).getType(), Naming.selector(method, 2048), method.getFirstParameterList().getParameters(), ((Function)member).getTypeErased(), this.naming.selector(method), DelegateType.OTHER);
                classBuilder.method(canonicalMethod);
                continue;
            }
            if (member instanceof Value || member instanceof Setter) {
                Setter setter;
                TypedDeclaration attr = (TypedDeclaration)member;
                typedMember = satisfiedType.getTypedMember(attr, null);
                if (!this.needsCompanionDelegate(model, typedMember)) continue;
                Setter setter2 = setter = member instanceof Setter ? (Setter)member : null;
                if (member instanceof Value) {
                    if (member instanceof JavaBeanValue) {
                        setter = ((Value)member).getSetter();
                    }
                    MethodDefinitionBuilder getterDelegate = this.makeDelegateToCompanion(iface, typedMember, model.getType(), 1 | (attr.isDefault() ? 0 : 16), Collections.emptyList(), Collections.emptyList(), ((TypedReference)typedMember).getType(), Naming.getGetterName(attr), Collections.emptyList(), attr.getTypeErased(), null, DelegateType.OTHER);
                    classBuilder.method(getterDelegate);
                }
                if (setter != null) {
                    MethodDefinitionBuilder setterDelegate = this.makeDelegateToCompanion(iface, satisfiedType.getTypedMember(setter, null), model.getType(), 1 | (setter.getGetter().isDefault() ? 0 : 16), Collections.emptyList(), Collections.emptyList(), this.typeFact().getAnythingType(), Naming.getSetterName(attr), Collections.singletonList(setter.getParameter()), setter.getTypeErased(), null, DelegateType.OTHER);
                    classBuilder.method(setterDelegate);
                }
                if (!Decl.isValue(member) || !((Value)attr).isVariable()) continue;
                throw new BugException("assertion failed: " + member.getQualifiedNameString() + " was unexpectedly a variable value");
            }
            Reference typedMember2 = member instanceof TypeDeclaration ? satisfiedType.getTypeMember((TypeDeclaration)member, Collections.emptyList()) : satisfiedType.getTypedMember((TypedDeclaration)member, Collections.emptyList());
            if (!this.needsCompanionDelegate(model, typedMember2)) continue;
            throw new BugException("unhandled concrete interface member " + member.getQualifiedNameString() + " " + member.getClass());
        }
        satisfiedInterfaces.add(iface);
        for (Type sat : iface.getSatisfiedTypes()) {
            sat = model.getType().getSupertype(sat.getDeclaration());
            this.concreteMembersFromSuperinterfaces(model, classBuilder, sat, satisfiedInterfaces);
        }
    }

    private Iterable<Declaration> sortedMembers(List<Declaration> members) {
        TreeSet<Declaration> set = new TreeSet<Declaration>(DeclarationComparator);
        set.addAll(members);
        return set;
    }

    private List<List<Type>> producedTypeParameterBounds(Reference typedMember, Generic subMethod) {
        ArrayList<List<Type>> producedTypeParameterBounds = new ArrayList<List<Type>>(subMethod.getTypeParameters().size());
        for (TypeParameter tp : subMethod.getTypeParameters()) {
            List<Type> satisfiedTypes = tp.getType().getSatisfiedTypes();
            ArrayList<Type> bounds = new ArrayList<Type>(satisfiedTypes.size());
            for (Type bound : satisfiedTypes) {
                if (typedMember instanceof Type) {
                    bounds.add(bound.substitute((Type)typedMember));
                    continue;
                }
                if (!(typedMember instanceof TypedReference)) continue;
                bounds.add(bound.substitute((TypedReference)typedMember));
            }
            producedTypeParameterBounds.add(bounds);
        }
        return producedTypeParameterBounds;
    }

    private void generateInstantiatorDelegate(ClassDefinitionBuilder classBuilder, Type satisfiedType, Interface iface, Class klass, Constructor ctor, Type currentType, boolean includeBody) {
        Type typeMember = satisfiedType.getTypeMember(klass, klass.getType().getTypeArgumentList());
        if (ctor != null) {
            typeMember = ctor.appliedType(typeMember, Collections.emptyList());
        }
        List<TypeParameter> typeParameters = klass.getTypeParameters();
        List<Parameter> parameters = (ctor != null ? ctor.getParameterLists() : klass.getParameterLists()).get(0).getParameters();
        long flags = 1L;
        flags = includeBody ? (flags |= 0x10L) : (flags |= 0x400L);
        String instantiatorMethodName = this.naming.getInstantiatorMethodName(klass);
        for (Parameter param : parameters) {
            if (Strategy.hasDefaultParameterValueMethod(param) && !klass.isActual()) {
                TypedReference typedParameter = typeMember.getTypedParameter(param);
                MethodDefinitionBuilder defaultValueDelegate = this.makeDelegateToCompanion(iface, typedParameter, currentType, flags, typeParameters, this.producedTypeParameterBounds(typeMember, klass), typedParameter.getFullType(), Naming.getDefaultedParamMethodName(ctor != null ? ctor : klass, param), parameters.subList(0, parameters.indexOf(param)), param.getModel().getTypeErased(), null, DelegateType.FOR_DEFAULT_VALUE, includeBody);
                classBuilder.method(defaultValueDelegate);
            }
            if (!Strategy.hasDefaultParameterOverload(param)) continue;
            MethodDefinitionBuilder overload = this.makeDelegateToCompanion(iface, typeMember, currentType, flags, typeParameters, this.producedTypeParameterBounds(typeMember, klass), typeMember.getType(), instantiatorMethodName, parameters.subList(0, parameters.indexOf(param)), false, null, DelegateType.OTHER, includeBody);
            classBuilder.method(overload);
        }
        MethodDefinitionBuilder overload = this.makeDelegateToCompanion(iface, typeMember, currentType, flags, typeParameters, this.producedTypeParameterBounds(typeMember, klass), typeMember.getType(), instantiatorMethodName, parameters, false, null, DelegateType.OTHER, includeBody);
        classBuilder.method(overload);
    }

    private boolean needsCompanionDelegate(Class model, Reference ref) {
        Declaration member = ref.getDeclaration();
        List<Type> sig = this.getSignatureIfRequired(ref);
        Declaration m = model.getMember(member.getName(), sig, false, true);
        boolean mostRefined = member instanceof Setter && Decl.isGetter(m) ? member.equals(((Value)m).getSetter()) : member.equals(m);
        return mostRefined && (member.isDefault() || !member.isFormal());
    }

    private List<Type> getSignatureIfRequired(Reference ref) {
        if (this.requiresMemberSignatureMatch(ref.getDeclaration())) {
            return ModelUtil.getSignature(ref);
        }
        return null;
    }

    private boolean requiresMemberSignatureMatch(Declaration declaration) {
        if (declaration instanceof Function) {
            List<ParameterList> parameterLists = ((Functional)((Object)declaration)).getParameterLists();
            if (parameterLists != null && parameterLists.size() == 1) {
                ParameterList parameterList = parameterLists.get(0);
                for (Parameter param : parameterList.getParameters()) {
                    if (!param.getModel().isFunctional()) continue;
                    return false;
                }
            }
            return declaration.isAbstraction() || declaration.isOverloaded();
        }
        return false;
    }

    private MethodDefinitionBuilder makeDelegateToCompanion(Interface iface, Reference typedMember, Type currentType, long mods, List<TypeParameter> typeParameters, List<List<Type>> producedTypeParameterBounds, Type methodType, String methodName, List<Parameter> parameters, boolean typeErased, String targetMethodName, DelegateType delegateType) {
        return this.makeDelegateToCompanion(iface, typedMember, currentType, mods, typeParameters, producedTypeParameterBounds, methodType, methodName, parameters, typeErased, targetMethodName, delegateType, true);
    }

    private MethodDefinitionBuilder makeDelegateToCompanion(Interface iface, Reference typedMember, Type currentType, long mods, List<TypeParameter> typeParameters, List<List<Type>> producedTypeParameterBounds, Type methodType, String methodName, List<Parameter> parameters, boolean typeErased, String targetMethodName, DelegateType delegateType, boolean includeBody) {
        MethodDefinitionBuilder concreteWrapper = MethodDefinitionBuilder.systemMethod(this.gen(), methodName);
        concreteWrapper.modifiers(mods);
        concreteWrapper.ignoreModelAnnotations();
        if ((mods & 2L) == 0L) {
            concreteWrapper.isOverride(true);
        }
        if (typeParameters != null) {
            concreteWrapper.reifiedTypeParametersFromModel(typeParameters);
        }
        Iterator<List<Type>> iterator = producedTypeParameterBounds.iterator();
        if (typeParameters != null) {
            for (TypeParameter tp : typeParameters) {
                concreteWrapper.typeParameter(tp, iterator.next());
            }
        }
        boolean explicitReturn = false;
        Declaration member = typedMember.getDeclaration();
        Type returnType = null;
        if (!ClassTransformer.isAnything(methodType) || (member instanceof Function || member instanceof Value) && !Decl.isUnboxedVoid(member) || member instanceof Function && Strategy.useBoxedVoid((Function)member)) {
            explicitReturn = true;
            if (CodegenUtil.isHashAttribute(member)) {
                concreteWrapper.resultType(null, this.make().Type(this.syms().intType));
                returnType = typedMember.getType();
            } else if (typedMember instanceof TypedReference) {
                TypedReference typedRef = (TypedReference)typedMember;
                if (delegateType == DelegateType.OTHER) {
                    int flags = 0;
                    if (CodegenUtil.hasTypeErased((TypedDeclaration)member.getRefinedDeclaration()) || CodegenUtil.hasTypeErased((TypedDeclaration)member) && this.isInheritedTwiceWithDifferentTypeArguments(currentType, iface)) {
                        flags |= 8;
                    }
                    concreteWrapper.resultTypeNonWidening(currentType, typedRef, typedMember.getType(), flags);
                    TypedReference nonWideningTypedRef = this.gen().nonWideningTypeDecl(typedRef, currentType);
                    returnType = this.gen().nonWideningType(typedRef, nonWideningTypedRef);
                } else {
                    MethodDefinitionBuilder.NonWideningParam nonWideningParam = concreteWrapper.getNonWideningParam(typedRef, currentType.getDeclaration() instanceof Class ? MethodDefinitionBuilder.WideningRules.FOR_MIXIN : MethodDefinitionBuilder.WideningRules.NONE);
                    returnType = nonWideningParam.nonWideningType;
                    if (member instanceof Function) {
                        returnType = this.typeFact().getCallableType(returnType);
                    }
                    concreteWrapper.resultType(null, this.makeJavaType(returnType, nonWideningParam.flags));
                }
            } else {
                concreteWrapper.resultType(null, this.makeJavaType((Type)typedMember));
                returnType = (Type)typedMember;
            }
        }
        ListBuffer arguments = ListBuffer.lb();
        if (typeParameters != null) {
            for (TypeParameter tp : typeParameters) {
                arguments.add(this.naming.makeUnquotedIdent(this.naming.getTypeArgumentDescriptorName(tp)));
            }
        }
        if (typedMember.getDeclaration() instanceof Constructor && !Decl.isDefaultConstructor((Constructor)typedMember.getDeclaration())) {
            concreteWrapper.parameter(this.makeConstructorNameParameter((Constructor)typedMember.getDeclaration()));
            arguments.add(this.naming.makeUnquotedIdent(NamingBase.Unfix.$name$));
        }
        for (Parameter param : parameters) {
            TypedReference typedParameter = typedMember.getTypedParameter(param);
            concreteWrapper.parameter(param, typedParameter, null, 16, MethodDefinitionBuilder.WideningRules.FOR_MIXIN);
            arguments.add(this.naming.makeName(param.getModel(), 257));
        }
        if (includeBody) {
            JCTree.JCExpression qualifierThis = this.makeUnquotedIdent(this.getCompanionFieldName(iface));
            if (explicitReturn) {
                Type javaType = this.getBestSatisfiedType(currentType, iface);
                Type ceylonType = typedMember.getQualifyingType();
                if (!this.isTurnedToRaw(ceylonType) && !javaType.isExactly(ceylonType)) {
                    qualifierThis = this.expressionGen().applyErasureAndBoxing(qualifierThis, currentType, false, true, AbstractTransformer.BoxingStrategy.BOXED, ceylonType, 32);
                }
            }
            JCTree.JCExpression expr = this.make().Apply(null, this.makeSelect(qualifierThis, targetMethodName != null ? targetMethodName : methodName), arguments.toList());
            if (this.isUnimplementedMemberClass(currentType, typedMember)) {
                concreteWrapper.body(this.makeThrowUnresolvedCompilationError("formal member '" + typedMember.getDeclaration().getName() + "' of '" + iface.getName() + "' not implemented in class hierarchy"));
                this.current().broken();
            } else if (!explicitReturn) {
                concreteWrapper.body(this.gen().make().Exec(expr));
            } else {
                AbstractTransformer.BoxingStrategy boxingStrategy;
                boolean exprBoxed;
                if (member instanceof TypedDeclaration) {
                    TypedDeclaration typedDecl = (TypedDeclaration)member;
                    exprBoxed = !CodegenUtil.isUnBoxed(typedDecl);
                    boxingStrategy = CodegenUtil.getBoxingStrategy(typedDecl);
                } else {
                    exprBoxed = true;
                    boxingStrategy = AbstractTransformer.BoxingStrategy.UNBOXED;
                }
                if (this.isTurnedToRaw(typedMember.getQualifyingType()) || this.needsRawCastForMixinSuperCall(iface, methodType) || this.needsCastForErasedInstantiator(iface, methodName, member)) {
                    typeErased = true;
                }
                expr = this.gen().expressionGen().applyErasureAndBoxing(expr, methodType, typeErased, exprBoxed, boxingStrategy, returnType, 0);
                concreteWrapper.body(this.gen().make().Return(expr));
            }
        }
        return concreteWrapper;
    }

    protected boolean needsCastForErasedInstantiator(Interface iface, String methodName, Declaration member) {
        return Decl.isAncestorLocal(iface) && Decl.isAncestorLocal(member) && methodName.endsWith(NamingBase.Suffix.$new$.toString());
    }

    private boolean isUnimplementedMemberClass(Type currentType, Reference typedMember) {
        if (typedMember instanceof Type && currentType.getDeclaration() instanceof Class) {
            for (Reference formal : ((Class)currentType.getDeclaration()).getUnimplementedFormals()) {
                if (!formal.getDeclaration().equals(typedMember.getDeclaration())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInheritedTwiceWithDifferentTypeArguments(Type currentType, Interface iface) {
        Type firstSatisfiedType = this.getFirstSatisfiedType(currentType, iface);
        Type supertype = currentType.getSupertype(iface);
        return !supertype.isExactly(firstSatisfiedType);
    }

    private Boolean hasImpl(Interface iface) {
        if (this.gen().willEraseToObject(iface.getType())) {
            return false;
        }
        if (iface instanceof LazyInterface && !((LazyInterface)iface).isCeylon()) {
            return false;
        }
        return CodegenUtil.isCompanionClassNeeded(iface);
    }

    private void transformInstantiateCompanions(ClassDefinitionBuilder classBuilder, Class model, Interface iface, Type satisfiedType) {
        this.at(null);
        Type bestSatisfiedType = this.getBestSatisfiedType(model.getType(), iface);
        classBuilder.getInitBuilder().init(this.makeCompanionInstanceAssignment(model, iface, satisfiedType));
        classBuilder.field(20, this.getCompanionFieldName(iface), this.makeJavaType(bestSatisfiedType, 129), null, false, this.makeAtIgnore());
        classBuilder.method(this.makeCompanionAccessor(iface, bestSatisfiedType, model, true));
    }

    private JCTree.JCExpressionStatement makeCompanionInstanceAssignment(Class model, Interface iface, Type satisfiedType) {
        ClassOrInterface interfaceContainer;
        Type bestSatisfiedType = this.getBestSatisfiedType(model.getType(), iface);
        JCTree.JCFieldAccess containerInstance = null;
        if (!Decl.isToplevel(iface) && !Decl.isLocal(iface) && (interfaceContainer = Decl.getClassOrInterfaceContainer(iface, false)) instanceof Interface) {
            ClassOrInterface modelContainer = model;
            while ((modelContainer = Decl.getClassOrInterfaceContainer(modelContainer, false)) != null && !modelContainer.equals(interfaceContainer)) {
            }
            if (modelContainer == null) {
                modelContainer = model;
                while ((modelContainer = Decl.getClassOrInterfaceContainer(modelContainer, false)) != null && modelContainer.getType().getSupertype(interfaceContainer) == null) {
                }
            }
            if (modelContainer == null) {
                throw new BugException("Could not find container that satisfies interface " + iface.getQualifiedNameString() + " to find qualifying instance for companion instance for " + model.getQualifiedNameString());
            }
            if (modelContainer instanceof Interface) {
                JCTree.JCExpression containerType = this.makeJavaType(modelContainer.getType(), 137);
                containerInstance = this.makeSelect(containerType, "this");
            } else {
                String containerFieldName = this.getCompanionFieldName((Interface)interfaceContainer);
                JCTree.JCExpression containerType = this.makeJavaType(modelContainer.getType(), 1);
                containerInstance = this.makeSelect(this.makeSelect(containerType, "this"), containerFieldName);
            }
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> state = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (JCTree.JCExpression t : this.makeReifiedTypeArguments(satisfiedType)) {
            state = state.append(t);
        }
        state = state.append(this.expressionGen().applyErasureAndBoxing(this.naming.makeThis(), model.getType(), false, true, AbstractTransformer.BoxingStrategy.BOXED, bestSatisfiedType, 1));
        JCTree.JCExpression ifaceImplType = !Decl.isToplevel(iface) && !Decl.isLocal(iface) && Decl.getClassOrInterfaceContainer(iface, false) instanceof Interface ? this.makeJavaType(bestSatisfiedType, 448) : this.makeJavaType(bestSatisfiedType, 192);
        JCTree.JCNewClass newInstance = this.make().NewClass(containerInstance, null, ifaceImplType, state, null);
        JCTree.JCExpressionStatement companionInstanceAssign = this.make().Exec(this.make().Assign(this.makeSelect("this", this.getCompanionFieldName(iface)), newInstance));
        return companionInstanceAssign;
    }

    private MethodDefinitionBuilder makeCompanionAccessor(Interface iface, Type satisfiedType, Class currentType, boolean forImplementor) {
        MethodDefinitionBuilder thisMethod = MethodDefinitionBuilder.systemMethod(this, this.naming.getCompanionAccessorName(iface));
        thisMethod.noModelAnnotations();
        if (!forImplementor && Decl.isAncestorLocal(iface)) {
            thisMethod.resultType(null, this.make().Type(this.syms().objectType));
        } else {
            thisMethod.resultType(null, this.makeJavaType(satisfiedType, 128));
        }
        if (forImplementor) {
            thisMethod.isOverride(true);
        } else {
            thisMethod.ignoreModelAnnotations();
        }
        thisMethod.modifiers(1L);
        if (forImplementor) {
            thisMethod.body(this.make().Return(this.naming.makeCompanionFieldName(iface)));
        } else {
            thisMethod.noBody();
        }
        return thisMethod;
    }

    private Type getBestSatisfiedType(Type currentType, Interface iface) {
        Type refinedSuperType = currentType.getSupertype(iface);
        Type firstSatisfiedType = this.getFirstSatisfiedType(currentType, iface);
        Map<TypeParameter, Type> refinedTAs = refinedSuperType.getTypeArguments();
        Map<TypeParameter, Type> firstTAs = firstSatisfiedType.getTypeArguments();
        for (TypeParameter tp : iface.getTypeParameters()) {
            Type refinedTA = refinedTAs.get(tp);
            Type firstTA = firstTAs.get(tp);
            if (!this.willEraseToObject(firstTA) || !this.isTypeParameter(refinedTA)) continue;
            return refinedSuperType;
        }
        return firstSatisfiedType;
    }

    private Type getFirstSatisfiedType(Type currentType, Interface iface) {
        Type supertype;
        Type found = null;
        TypeDeclaration currentDecl = currentType.getDeclaration();
        if (Decl.equal(currentDecl, iface)) {
            return currentType;
        }
        if (currentType.getExtendedType() != null && (found = this.getFirstSatisfiedType(supertype = currentType.getSupertype(currentType.getExtendedType().getDeclaration()), iface)) != null) {
            return found;
        }
        for (Type superInterfaceType : currentType.getSatisfiedTypes()) {
            found = this.getFirstSatisfiedType(superInterfaceType, iface);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void buildCompanion(Tree.ClassOrInterface def, Interface model, ClassDefinitionBuilder classBuilder) {
        this.at(def);
        classBuilder.getCompanionBuilder2(model);
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeLocalContainerPath(Interface model) {
        com.redhat.ceylon.langtools.tools.javac.util.List<String> path = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (Scope container = model.getContainer(); container != null && !(container instanceof Package); container = container.getContainer()) {
            if (!(container instanceof Declaration)) continue;
            path = path.prepend(((Declaration)((Object)container)).getPrefixedName());
        }
        return this.makeAtLocalContainer(path, model.isCompanionClassNeeded() != false ? model.getJavaCompanionClassName() : null);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformRefinementSpecifierStatement(Tree.SpecifierStatement op, ClassDefinitionBuilder classBuilder) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> result = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (op.getRefinement()) {
            Tree.BaseMemberExpression expr;
            Declaration decl;
            Tree.Term baseMemberTerm = op.getBaseMemberExpression();
            if (baseMemberTerm instanceof Tree.ParameterizedExpression) {
                baseMemberTerm = ((Tree.ParameterizedExpression)baseMemberTerm).getPrimary();
            }
            if (Decl.isValue(decl = (expr = (Tree.BaseMemberExpression)baseMemberTerm).getDeclaration()) || Decl.isGetter(decl)) {
                Tree.AttributeDeclaration attrDecl = new Tree.AttributeDeclaration(null);
                attrDecl.setDeclarationModel((Value)decl);
                attrDecl.setIdentifier(expr.getIdentifier());
                attrDecl.setScope(op.getScope());
                attrDecl.setSpecifierOrInitializerExpression(op.getSpecifierExpression());
                attrDecl.setAnnotationList(this.makeShortcutRefinementAnnotationTrees());
                CompilerBoxingDeclarationVisitor v = new CompilerBoxingDeclarationVisitor(this);
                v.visit(attrDecl);
                this.transform(attrDecl, classBuilder);
            } else if (decl instanceof Function) {
                Tree.Expression expression;
                Tree.Term expressionTerm;
                Tree.MethodDeclaration methDecl = new Tree.MethodDeclaration(null);
                Function m = (Function)decl;
                methDecl.setDeclarationModel(m);
                methDecl.setIdentifier(expr.getIdentifier());
                methDecl.setScope(op.getScope());
                methDecl.setAnnotationList(this.makeShortcutRefinementAnnotationTrees());
                Tree.SpecifierExpression specifierExpression = op.getSpecifierExpression();
                methDecl.setSpecifierExpression(specifierExpression);
                if (!(specifierExpression instanceof Tree.LazySpecifierExpression) && !CodegenUtil.canOptimiseMethodSpecifier(expressionTerm = Decl.unwrapExpressionsUntilTerm(expression = specifierExpression.getExpression()), m)) {
                    String name = this.naming.getMethodSpecifierAttributeName(m);
                    JCTree.JCExpression specifierType = this.makeJavaType(expression.getTypeModel());
                    JCTree.JCExpression specifier = this.expressionGen().transformExpression(expression);
                    classBuilder.field(18, name, specifierType, specifier, false);
                }
                ArrayList<Tree.ParameterList> parameterListTrees = null;
                if (op.getBaseMemberExpression() instanceof Tree.ParameterizedExpression) {
                    parameterListTrees = new ArrayList<Tree.ParameterList>(m.getParameterLists().size());
                    parameterListTrees.addAll(((Tree.ParameterizedExpression)op.getBaseMemberExpression()).getParameterLists());
                    Tree.Term term = specifierExpression.getExpression().getTerm();
                    while (term instanceof Tree.FunctionArgument && m.getParameterLists().size() > 1) {
                        Tree.FunctionArgument functionArgument = (Tree.FunctionArgument)term;
                        specifierExpression.setExpression(functionArgument.getExpression());
                        parameterListTrees.addAll(functionArgument.getParameterLists());
                        term = functionArgument.getExpression().getTerm();
                    }
                }
                int plIndex = 0;
                for (ParameterList pl : m.getParameterLists()) {
                    Tree.ParameterList parameterListTree = null;
                    if (parameterListTrees != null) {
                        parameterListTree = (Tree.ParameterList)parameterListTrees.get(plIndex++);
                    }
                    Tree.ParameterList tpl = new Tree.ParameterList(null);
                    tpl.setModel(pl);
                    int pIndex = 0;
                    for (Parameter p : pl.getParameters()) {
                        Tree.Parameter parameterTree = null;
                        if (parameterListTree != null) {
                            parameterTree = parameterListTree.getParameters().get(pIndex++);
                        }
                        Tree.ParameterDeclaration tp = null;
                        if (p.getModel() instanceof Value) {
                            Tree.ValueParameterDeclaration tvpd = new Tree.ValueParameterDeclaration(null);
                            if (parameterTree != null) {
                                tvpd.setTypedDeclaration(((Tree.ParameterDeclaration)parameterTree).getTypedDeclaration());
                            }
                            tvpd.setParameterModel(p);
                            tp = tvpd;
                        } else if (p.getModel() instanceof Function) {
                            Tree.FunctionalParameterDeclaration tfpd = new Tree.FunctionalParameterDeclaration(null);
                            if (parameterTree != null) {
                                tfpd.setTypedDeclaration(((Tree.ParameterDeclaration)parameterTree).getTypedDeclaration());
                            }
                            tfpd.setParameterModel(p);
                            tp = tfpd;
                        } else {
                            throw BugException.unhandledDeclarationCase(p.getModel());
                        }
                        tp.setScope(p.getDeclaration().getContainer());
                        tpl.addParameter(tp);
                    }
                    methDecl.addParameterList(tpl);
                }
                CompilerBoxingDeclarationVisitor v = new CompilerBoxingDeclarationVisitor(this);
                v.visit(methDecl);
                classBuilder.method(methDecl, Errors.GENERATE);
            }
        } else {
            result = result.append(this.expressionGen().transform(op));
        }
        Tree.Term term = op.getBaseMemberExpression();
        if (term instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)term;
            StatementTransformer.DeferredSpecification ds = this.statementGen().getDeferredSpecification(bme.getDeclaration());
            if (ds != null && this.needsInnerSubstitution(term.getScope(), bme.getDeclaration())) {
                result = result.append(ds.openInnerSubstitution());
            }
        }
        return result;
    }

    private Tree.AnnotationList makeShortcutRefinementAnnotationTrees() {
        Tree.AnnotationList annotationList = new Tree.AnnotationList(null);
        Tree.Annotation shared = new Tree.Annotation(null);
        Tree.BaseMemberExpression sharedPrimary = new Tree.BaseMemberExpression(null);
        sharedPrimary.setDeclaration(this.typeFact().getLanguageModuleDeclaration("shared"));
        shared.setPrimary(sharedPrimary);
        annotationList.addAnnotation(shared);
        Tree.Annotation actual = new Tree.Annotation(null);
        Tree.BaseMemberExpression actualPrimary = new Tree.BaseMemberExpression(null);
        actualPrimary.setDeclaration(this.typeFact().getLanguageModuleDeclaration("actual"));
        actual.setPrimary(actualPrimary);
        annotationList.addAnnotation(actual);
        return annotationList;
    }

    private boolean needsInnerSubstitution(Scope scope, Declaration declaration) {
        while (scope != null && !(scope instanceof Package)) {
            Set<Value> specifiedValues;
            if (scope instanceof ControlBlock && (specifiedValues = ((ControlBlock)scope).getSpecifiedValues()) != null && specifiedValues.contains(declaration)) {
                return true;
            }
            scope = scope.getScope();
        }
        return false;
    }

    public void transform(Tree.AttributeDeclaration decl, ClassDefinitionBuilder classBuilder) {
        boolean concrete;
        Value model = decl.getDeclarationModel();
        boolean lazy = decl.getSpecifierOrInitializerExpression() instanceof Tree.LazySpecifierExpression;
        boolean useField = Strategy.useField(model) && !lazy;
        String attrName = decl.getIdentifier().getText();
        Parameter parameter = CodegenUtil.findParamForDecl(decl);
        boolean createField = Strategy.createField(parameter, model) && !lazy;
        boolean bl = concrete = Decl.withinInterface(decl) && decl.getSpecifierOrInitializerExpression() != null;
        if (!lazy && (concrete || !Decl.isFormal(decl) && createField)) {
            JCTree.JCStatement outerSubs;
            int modifiers;
            TypedReference typedRef = this.getTypedReference(model);
            TypedReference nonWideningTypedRef = this.nonWideningTypeDecl(typedRef);
            Type nonWideningType = this.nonWideningType(typedRef, nonWideningTypedRef);
            if (Decl.isIndirect(decl)) {
                attrName = Naming.getAttrClassName(model, 0);
                nonWideningType = this.getGetterInterfaceType(model);
            }
            JCTree.JCExpression initialValue = null;
            if (decl.getSpecifierOrInitializerExpression() != null) {
                Value declarationModel = model;
                initialValue = this.expressionGen().transformExpression(decl.getSpecifierOrInitializerExpression().getExpression(), CodegenUtil.getBoxingStrategy(declarationModel), nonWideningType);
            }
            int flags = 0;
            if (!CodegenUtil.isUnBoxed(nonWideningTypedRef.getDeclaration())) {
                flags |= 4;
            }
            JCTree.JCExpression type = this.makeJavaType(nonWideningType, flags);
            int n = modifiers = useField ? this.transformAttributeFieldDeclFlags(decl) : this.transformLocalDeclFlags(decl);
            if (parameter == null || parameter.isHidden()) {
                if (concrete) {
                    classBuilder.getCompanionBuilder((TypeDeclaration)model.getContainer()).field(modifiers, attrName, type, initialValue, !useField);
                } else {
                    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annos = this.makeAtIgnore().prependList(this.expressionGen().transformAnnotations(OutputElement.FIELD, decl));
                    if (classBuilder.hasDelegatingConstructors()) {
                        annos = annos.prependList(this.makeAtNoInitCheck());
                    }
                    classBuilder.field(modifiers, attrName, type, initialValue, !useField, annos);
                    if (model.isLate() && CodegenUtil.needsLateInitField(model, this.typeFact())) {
                        classBuilder.field(194, Naming.getInitializationFieldName(attrName), this.make().Type(this.syms().booleanType), this.make().Literal(false), false, this.makeAtIgnore());
                    }
                }
            }
            if ((outerSubs = this.statementGen().openOuterSubstitutionIfNeeded(decl.getDeclarationModel(), model.getType(), 0)) != null) {
                classBuilder.getInitBuilder().init(outerSubs);
            }
        }
        boolean withinInterface = Decl.withinInterface(decl);
        if (useField || withinInterface || lazy) {
            if (!withinInterface || model.isShared()) {
                classBuilder.attribute(this.makeGetter(decl, false, lazy));
            }
            if (withinInterface && lazy) {
                classBuilder.getCompanionBuilder((Interface)decl.getDeclarationModel().getContainer()).attribute(this.makeGetter(decl, true, lazy));
            }
            if (Decl.isVariable(decl) || Decl.isLate(decl)) {
                if (!withinInterface || model.isShared()) {
                    classBuilder.attribute(this.makeSetter(decl, false, lazy));
                }
                if (withinInterface && lazy) {
                    classBuilder.getCompanionBuilder((Interface)decl.getDeclarationModel().getContainer()).attribute(this.makeSetter(decl, true, lazy));
                }
            }
        }
    }

    public AttributeDefinitionBuilder transform(Tree.AttributeSetterDefinition decl, boolean forCompanion) {
        if (Strategy.onlyOnCompanion(decl.getDeclarationModel()) && !forCompanion) {
            return null;
        }
        String name = decl.getIdentifier().getText();
        AttributeDefinitionBuilder builder = AttributeDefinitionBuilder.setter(this, name, decl.getDeclarationModel().getGetter()).modifiers(this.transformAttributeGetSetDeclFlags(decl.getDeclarationModel(), forCompanion));
        if (forCompanion) {
            builder.notActual();
        }
        if (Decl.withinClass(decl) || forCompanion) {
            JCTree.JCBlock setterBlock = this.makeSetterBlock(decl.getDeclarationModel(), decl.getBlock(), decl.getSpecifierExpression());
            builder.setterBlock(setterBlock);
        } else {
            builder.isFormal(true);
        }
        builder.userAnnotationsSetter(this.expressionGen().transformAnnotations(OutputElement.SETTER, decl));
        return builder;
    }

    public AttributeDefinitionBuilder transform(Tree.AttributeGetterDefinition decl, boolean forCompanion) {
        if (Strategy.onlyOnCompanion(decl.getDeclarationModel()) && !forCompanion) {
            return null;
        }
        String name = decl.getIdentifier().getText();
        AttributeDefinitionBuilder builder = AttributeDefinitionBuilder.getter(this, name, decl.getDeclarationModel()).modifiers(this.transformAttributeGetSetDeclFlags(decl.getDeclarationModel(), forCompanion));
        if (forCompanion) {
            builder.notActual();
        }
        if (Decl.withinClass(decl) || forCompanion) {
            JCTree.JCBlock body = this.statementGen().transform(decl.getBlock());
            builder.getterBlock(body);
        } else {
            builder.isFormal(true);
        }
        builder.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.GETTER, decl));
        return builder;
    }

    private int transformDeclarationSharedFlags(Declaration decl) {
        return Decl.isShared(decl) && !Decl.isAncestorLocal(decl) ? 1 : 0;
    }

    private int transformClassDeclFlags(ClassOrInterface cdecl) {
        int result = 0;
        result |= this.transformDeclarationSharedFlags(cdecl);
        result |= cdecl instanceof Class && (cdecl.isAbstract() || cdecl.isFormal()) && !cdecl.isAlias() ? 1024 : 0;
        result |= cdecl instanceof Interface ? 512 : 0;
        return result |= cdecl instanceof Class && (cdecl.isAlias() || cdecl.isFinal()) ? 16 : 0;
    }

    private int transformConstructorDeclFlags(ClassOrInterface cdecl) {
        return this.transformDeclarationSharedFlags(cdecl);
    }

    int transformConstructorDeclFlags(Constructor ctor) {
        return Decl.isShared(ctor) && !Decl.isAncestorLocal(ctor) && !ctor.isAbstract() && !Decl.isEnumeratedConstructor(ctor) ? 1 : 2;
    }

    private int transformTypeAliasDeclFlags(TypeAlias decl) {
        int result = 0;
        result |= this.transformDeclarationSharedFlags(decl);
        return result |= 0x10;
    }

    private int transformMethodDeclFlags(Function def) {
        int result = 0;
        if (def.isToplevel()) {
            result |= def.isShared() ? 1 : 0;
            result |= 8;
        } else if (Decl.isLocalNotInitializer(def)) {
            result |= def.isShared() ? 1 : 0;
        } else {
            result |= def.isShared() ? 1 : 2;
            result |= def.isFormal() && !def.isDefault() ? 1024 : 0;
            result |= !def.isFormal() && !def.isDefault() && !(def.getContainer() instanceof Interface) ? 16 : 0;
        }
        return result;
    }

    private int transformAttributeFieldDeclFlags(Tree.AttributeDeclaration cdecl) {
        int result = 0;
        result |= Decl.isVariable(cdecl) || Decl.isLate(cdecl) ? 0 : 16;
        return result |= 2;
    }

    private int transformLocalDeclFlags(Tree.AttributeDeclaration cdecl) {
        int result = 0;
        return result |= Decl.isVariable(cdecl) ? 0 : 16;
    }

    int transformAttributeGetSetDeclFlags(TypedDeclaration tdecl, boolean forCompanion) {
        if (tdecl instanceof Setter) {
            tdecl = ((Setter)tdecl).getGetter();
        }
        int result = 0;
        result |= tdecl.isShared() ? 1 : 2;
        result |= tdecl.isFormal() && !tdecl.isDefault() && !forCompanion ? 1024 : 0;
        return result |= !tdecl.isFormal() && !tdecl.isDefault() && !Decl.withinInterface(tdecl) || forCompanion ? 16 : 0;
    }

    private int transformObjectDeclFlags(Value cdecl) {
        int result = 0;
        result |= 0x10;
        return result |= !Decl.isAncestorLocal(cdecl) && Decl.isShared(cdecl) ? 1 : 0;
    }

    private AttributeDefinitionBuilder makeGetterOrSetter(Tree.AttributeDeclaration decl, boolean forCompanion, boolean lazy, AttributeDefinitionBuilder builder, boolean isGetter) {
        this.at(decl);
        if (forCompanion || lazy) {
            Tree.SpecifierOrInitializerExpression specOrInit = decl.getSpecifierOrInitializerExpression();
            if (specOrInit != null) {
                HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(specOrInit.getExpression());
                if (error != null) {
                    builder.getterBlock(this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowUnresolvedCompilationError(error))));
                } else {
                    Value declarationModel = decl.getDeclarationModel();
                    TypedReference typedRef = this.getTypedReference(declarationModel);
                    TypedReference nonWideningTypedRef = this.nonWideningTypeDecl(typedRef);
                    Type nonWideningType = this.nonWideningType(typedRef, nonWideningTypedRef);
                    JCTree.JCExpression expr = this.expressionGen().transformExpression(specOrInit.getExpression(), CodegenUtil.getBoxingStrategy(declarationModel), nonWideningType);
                    expr = this.convertToIntIfHashAttribute(declarationModel, expr);
                    builder.getterBlock(this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Return(expr))));
                }
            } else {
                JCTree.JCExpression accessor = this.naming.makeQualifiedName(this.naming.makeQuotedThis(), decl.getDeclarationModel(), 1 | (isGetter ? 16 : 32));
                if (isGetter) {
                    builder.getterBlock(this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Return(this.make().Apply(null, accessor, com.redhat.ceylon.langtools.tools.javac.util.List.nil())))));
                } else {
                    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> args = com.redhat.ceylon.langtools.tools.javac.util.List.of(this.naming.makeName(decl.getDeclarationModel(), 129));
                    builder.setterBlock(this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(this.make().Apply(null, accessor, args)))));
                }
            }
        }
        if (forCompanion) {
            builder.notActual();
        }
        return builder.modifiers(this.transformAttributeGetSetDeclFlags(decl.getDeclarationModel(), forCompanion)).isFormal((Decl.isFormal(decl) || Decl.withinInterface(decl)) && !forCompanion);
    }

    private AttributeDefinitionBuilder makeGetter(Tree.AttributeDeclaration decl, boolean forCompanion, boolean lazy) {
        this.at(decl);
        String attrName = decl.getIdentifier().getText();
        AttributeDefinitionBuilder getter = AttributeDefinitionBuilder.getter(this, attrName, decl.getDeclarationModel());
        if (!decl.getDeclarationModel().isInterfaceMember() || decl.getDeclarationModel().isShared() ^ forCompanion) {
            getter.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.GETTER, decl));
        } else {
            getter.ignoreAnnotations();
        }
        if (Decl.isIndirect(decl)) {
            getter.getterBlock(this.generateIndirectGetterBlock(decl.getDeclarationModel()));
        }
        return this.makeGetterOrSetter(decl, forCompanion, lazy, getter, true);
    }

    private JCTree.JCBlock generateIndirectGetterBlock(Value v) {
        JCTree.JCExpression returnExpr = this.naming.makeQualIdent(this.naming.makeName(v, 2), "get_");
        returnExpr = this.make().Apply(null, returnExpr, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        JCTree.JCReturn returnValue = this.make().Return(returnExpr);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = com.redhat.ceylon.langtools.tools.javac.util.List.of(returnValue);
        JCTree.JCBlock block = this.make().Block(0L, stmts);
        return block;
    }

    private AttributeDefinitionBuilder makeSetter(Tree.AttributeDeclaration decl, boolean forCompanion, boolean lazy) {
        this.at(decl);
        String attrName = decl.getIdentifier().getText();
        AttributeDefinitionBuilder setter = AttributeDefinitionBuilder.setter(this, attrName, decl.getDeclarationModel());
        setter.userAnnotationsSetter(this.expressionGen().transformAnnotations(OutputElement.SETTER, decl));
        return this.makeGetterOrSetter(decl, forCompanion, lazy, setter, false);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformWrappedMethod(Tree.AnyMethod def, TransformationPlan plan) {
        AnnotationInvocation ai;
        Function model = def.getDeclarationModel();
        if (model.isParameter()) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        this.naming.clearSubstitutions(model);
        String name = def.getIdentifier().getText();
        ClassDefinitionBuilder builder = ClassDefinitionBuilder.methodWrapper(this, name, Decl.isShared(def));
        if (Decl.isAnnotationConstructor(def) && (ai = (AnnotationInvocation)def.getDeclarationModel().getAnnotationConstructor()) != null) {
            builder.annotations(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeAtAnnotationInstantiation(ai)));
            builder.annotations(this.makeExprAnnotations(def, ai));
        }
        builder.methods(this.classGen().transform(def, plan, builder));
        if (Strategy.generateMain(def)) {
            builder.method(this.makeMainForFunction(model));
        }
        if (Decl.isLocal(model) || Decl.isToplevel(model)) {
            builder.annotations(this.makeAtLocalDeclarations(def));
        }
        if (Decl.isLocal(model)) {
            builder.annotations(this.makeAtLocalDeclaration(model.getQualifier(), false));
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> result = builder.build();
        if (Decl.isLocal(def)) {
            JCTree.JCVariableDecl call = this.at(def).VarDef(this.make().Modifiers(16L), this.naming.getSyntheticInstanceName(model), this.naming.makeSyntheticClassname(model), this.makeSyntheticInstance(model));
            result = result.append(call);
        }
        return result;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeExprAnnotations(Tree.AnyMethod def, AnnotationInvocation ai) {
        AnnotationInvocation ctor = (AnnotationInvocation)def.getDeclarationModel().getAnnotationConstructor();
        return ai.makeExprAnnotations(this.expressionGen(), ctor, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    public JCTree.JCAnnotation makeAtAnnotationInstantiation(AnnotationInvocation invocation) {
        return invocation.encode(this, ListBuffer.lb());
    }

    private MethodDefinitionBuilder makeAnnotationMethod(Tree.Parameter parameter) {
        Parameter parameterModel = parameter.getParameterModel();
        JCTree.JCExpression type = this.transformAnnotationMethodType(parameter);
        JCTree.JCExpression defaultValue = parameterModel.isDefaulted() ? this.transformAnnotationParameterDefault(parameter) : null;
        MethodDefinitionBuilder mdb = MethodDefinitionBuilder.method(this, parameterModel.getModel(), 512);
        if (this.isMetamodelReference(parameterModel.getType()) || this.typeFact().isIterableType(parameterModel.getType()) && this.isMetamodelReference(this.typeFact().getIteratedType(parameterModel.getType()))) {
            mdb.modelAnnotations(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.make().Type(this.syms().ceylonAtDeclarationReferenceType), com.redhat.ceylon.langtools.tools.javac.util.List.nil())));
        } else if (Decl.isEnumeratedTypeWithAnonCases(parameterModel.getType()) || this.typeFact().isIterableType(parameterModel.getType()) && Decl.isEnumeratedTypeWithAnonCases(this.typeFact().getIteratedType(parameterModel.getType()))) {
            mdb.modelAnnotations(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Annotation(this.make().Type(this.syms().ceylonAtEnumerationReferenceType), com.redhat.ceylon.langtools.tools.javac.util.List.nil())));
        }
        mdb.modifiers(1025L);
        mdb.resultType(null, type);
        mdb.defaultValue(defaultValue);
        mdb.noBody();
        return mdb;
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<MethodDefinitionBuilder> transform(Tree.AnyMethod def, TransformationPlan plan, ClassDefinitionBuilder classBuilder) {
        if (def.getDeclarationModel().isParameter()) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        if (plan instanceof ThrowerMethod) {
            this.addRefinedThrowerMethod(classBuilder, plan.getErrorMessage().getMessage(), (Class)def.getDeclarationModel().getContainer(), (Function)def.getDeclarationModel().getRefinedDeclaration());
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        boolean prevSyntheticClassBody = this.expressionGen().withinSyntheticClassBody(Decl.isMpl(def.getDeclarationModel()) || Decl.isLocalNotInitializer(def) || this.expressionGen().isWithinSyntheticClassBody());
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body = this.transformMethodBody(def);
        this.expressionGen().withinSyntheticClassBody(prevSyntheticClassBody);
        return this.transform(def, classBuilder, body);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<MethodDefinitionBuilder> transform(Tree.AnyMethod def, ClassDefinitionBuilder classBuilder, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body) {
        Function model = def.getDeclarationModel();
        com.redhat.ceylon.langtools.tools.javac.util.List<MethodDefinitionBuilder> result = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (!Decl.withinInterface(model)) {
            boolean refinedResultType = !model.getType().isExactly(((TypedDeclaration)model.getRefinedDeclaration()).getType());
            result = this.transformMethod(def, true, true, true, this.transformMplBodyUnlessSpecifier(def, model, body), refinedResultType && !Decl.withinInterface(model.getRefinedDeclaration()) ? new DaoSuper() : new DaoThis(def, def.getParameterLists().get(0)), !Strategy.defaultParameterMethodOnSelf(model));
        } else {
            com.redhat.ceylon.langtools.tools.javac.util.List<MethodDefinitionBuilder> companionDefs;
            if (def instanceof Tree.MethodDeclaration) {
                Tree.SpecifierExpression specifier = ((Tree.MethodDeclaration)def).getSpecifierExpression();
                companionDefs = specifier == null ? this.transformMethod(def, false, true, true, null, new DaoCompanion(def, def.getParameterLists().get(0)), false) : this.transformMethod(def, true, false, !model.isShared(), this.transformMplBodyUnlessSpecifier(def, model, body), new DaoCompanion(def, def.getParameterLists().get(0)), false);
            } else if (def instanceof Tree.MethodDefinition) {
                companionDefs = this.transformMethod(def, true, false, !model.isShared(), this.transformMplBodyUnlessSpecifier(def, model, body), new DaoCompanion(def, def.getParameterLists().get(0)), false);
            } else {
                throw BugException.unhandledNodeCase(def);
            }
            if (!companionDefs.isEmpty()) {
                classBuilder.getCompanionBuilder((TypeDeclaration)model.getContainer()).methods(companionDefs);
            }
            if (Decl.isShared(model)) {
                result = this.transformMethod(def, true, true, true, null, this.daoAbstract, !Strategy.defaultParameterMethodOnSelf(model));
            }
        }
        return result;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<MethodDefinitionBuilder> transformMethod(Tree.AnyMethod def, boolean transformMethod, boolean actual, boolean includeAnnotations, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body, DaoBody daoTransformation, boolean defaultValuesBody) {
        return this.transformMethod(def.getDeclarationModel(), def.getTypeParameterList(), def, def.getParameterLists(), def, transformMethod, actual, includeAnnotations, body, daoTransformation, defaultValuesBody);
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<MethodDefinitionBuilder> transformMethod(Function methodModel, Tree.TypeParameterList typeParameterList, Tree.AnyMethod node, List<Tree.ParameterList> parameterLists, Tree.Declaration annotated, boolean transformMethod, boolean actual, boolean includeAnnotations, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body, DaoBody daoTransformation, boolean defaultValuesBody) {
        boolean createCanonical;
        ListBuffer lb = ListBuffer.lb();
        Declaration refinedDeclaration = methodModel.getRefinedDeclaration();
        MethodDefinitionBuilder methodBuilder = MethodDefinitionBuilder.method(this, methodModel);
        this.gen();
        if (CeylonTransformer.supportsReified(methodModel)) {
            methodBuilder.reifiedTypeParameters(methodModel.getTypeParameters());
        }
        if (methodModel.getParameterLists().size() > 1) {
            methodBuilder.mpl(methodModel.getParameterLists());
        }
        boolean hasOverloads = false;
        Tree.ParameterList parameterList = parameterLists.get(0);
        int flags = 0;
        if (this.rawParameters(methodModel)) {
            flags |= 8;
        }
        for (Tree.Parameter parameter : parameterList.getParameters()) {
            Tree.TypedDeclaration typedDeclaration;
            Parameter parameterModel = parameter.getParameterModel();
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annotations = null;
            if (includeAnnotations && (typedDeclaration = Decl.getMemberDeclaration(annotated, parameter)) != null) {
                annotations = this.expressionGen().transformAnnotations(OutputElement.PARAMETER, typedDeclaration);
            }
            methodBuilder.parameter(parameterModel, annotations, flags, MethodDefinitionBuilder.WideningRules.CAN_WIDEN);
            if (!Strategy.hasDefaultParameterValueMethod(parameterModel) && !Strategy.hasDefaultParameterOverload(parameterModel)) continue;
            if (Decl.equal(refinedDeclaration, methodModel) || !Decl.withinInterface(methodModel) && body != null || Decl.withinInterface(methodModel) && !(daoTransformation instanceof DaoCompanion)) {
                if (!(daoTransformation == null || daoTransformation instanceof DaoCompanion && body == null)) {
                    DaoBody daoTrans = body == null ? this.daoAbstract : new DaoThis(node, parameterList);
                    MethodDefinitionBuilder overloadedMethod = new DefaultedArgumentMethod(daoTrans, MethodDefinitionBuilder.method(this, methodModel), methodModel).makeOverload(parameterList.getModel(), parameter.getParameterModel(), methodModel.getTypeParameters());
                    overloadedMethod.location(null);
                    lb.append(overloadedMethod);
                }
                if (Decl.equal(refinedDeclaration, methodModel) && Strategy.hasDefaultParameterValueMethod(parameterModel)) {
                    lb.append(this.makeParamDefaultValueMethod(defaultValuesBody, methodModel, parameterList, parameter));
                }
            }
            hasOverloads = true;
        }
        boolean bl = createCanonical = hasOverloads && Decl.withinClassOrInterface(methodModel) && body != null;
        if (createCanonical) {
            MethodDefinitionBuilder canonicalMethod = new CanonicalMethod(daoTransformation, methodModel, body).makeOverload(parameterList.getModel(), null, methodModel.getTypeParameters());
            lb.append(canonicalMethod);
        }
        if (transformMethod) {
            methodBuilder.modifiers(this.transformMethodDeclFlags(methodModel));
            if (actual) {
                methodBuilder.isOverride(methodModel.isActual());
            }
            if (includeAnnotations) {
                methodBuilder.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.METHOD, annotated));
                methodBuilder.modelAnnotations(methodModel.getAnnotations());
            } else {
                methodBuilder.ignoreModelAnnotations();
            }
            methodBuilder.resultType(methodModel, 0);
            this.copyTypeParameters(methodModel, methodBuilder);
            if (createCanonical) {
                MethodDefinitionBuilder overloadedMethod = new CanonicalMethod((DaoBody)new DaoThis(node, parameterList), methodBuilder, methodModel).makeOverload(parameterList.getModel(), null, methodModel.getTypeParameters());
                lb.append(overloadedMethod);
            } else {
                if (body != null) {
                    methodBuilder.body(body);
                } else {
                    methodBuilder.noBody();
                }
                lb.append(methodBuilder);
            }
        }
        return lb.toList();
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformMplBodyUnlessSpecifier(Tree.AnyMethod def, Function model, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body) {
        if (def instanceof Tree.MethodDeclaration) {
            Tree.SpecifierExpression specifier = ((Tree.MethodDeclaration)def).getSpecifierExpression();
            if (specifier == null) {
                return body;
            }
            if (!(specifier instanceof Tree.LazySpecifierExpression) && !CodegenUtil.canOptimiseMethodSpecifier(specifier.getExpression().getTerm(), model)) {
                return body;
            }
        }
        return this.transformMplBody(def.getParameterLists(), model, body);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformMplBody(List<Tree.ParameterList> parameterListsTree, Function model, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body) {
        Type resultType = model.getType();
        for (int index = model.getParameterLists().size() - 1; index > 0; --index) {
            ParameterList pl = model.getParameterLists().get(index);
            resultType = this.gen().typeFact().getCallableType(com.redhat.ceylon.langtools.tools.javac.util.List.of(resultType, this.typeFact().getParameterTypesAsTupleType(pl.getParameters(), model.getReference())));
            CallableBuilder cb = CallableBuilder.mpl(this.gen(), resultType, pl, parameterListsTree.get(index), body);
            body = com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Return(cb.build()));
        }
        return body;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformMethodBody(Tree.AnyMethod def) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body = null;
        Function model = def.getDeclarationModel();
        if (model.isDeferred()) {
            JCTree.JCStatement result;
            JCTree.JCExpression initialValue;
            String fieldName = this.naming.selector(model);
            Parameter initializingParameter = CodegenUtil.findParamForDecl(def);
            int mods = 2;
            if (initializingParameter != null) {
                mods |= 0x10;
                initialValue = this.makeUnquotedIdent(Naming.getAliasedParameterName(initializingParameter));
            } else {
                initialValue = this.makeNull();
            }
            Type callableType = model.getReference().getFullType();
            this.current().field(mods, fieldName, this.makeJavaType(callableType), initialValue, false);
            CallableSpecifierInvocation invocation = new CallableSpecifierInvocation((AbstractTransformer)this, model, this.makeUnquotedIdent(fieldName), null, (Node)def);
            invocation.handleBoxing(true);
            JCTree.JCExpression call = this.expressionGen().transformInvocation(invocation);
            JCTree.JCStatement stmt = !this.isVoid(def) || !Decl.isUnboxedVoid(model) || Strategy.useBoxedVoid(model) ? this.make().Return(call) : this.make().Exec(call);
            if (initializingParameter == null) {
                JCTree.JCBinary cond = this.make().Binary(62, this.makeUnquotedIdent(fieldName), this.makeNull());
                JCTree.JCThrow throw_ = this.make().Throw(this.make().NewClass(null, null, this.makeIdent(this.syms().ceylonUninitializedMethodErrorType), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null));
                result = this.make().If(cond, throw_, stmt);
            } else {
                result = stmt;
            }
            return com.redhat.ceylon.langtools.tools.javac.util.List.of(result);
        }
        if (def instanceof Tree.MethodDefinition) {
            body = this.transformMethodBlock((Tree.MethodDefinition)def);
        } else if (def instanceof Tree.MethodDeclaration && ((Tree.MethodDeclaration)def).getSpecifierExpression() != null) {
            body = this.transformSpecifiedMethodBody((Tree.MethodDeclaration)def, ((Tree.MethodDeclaration)def).getSpecifierExpression());
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformMethodBlock(Tree.MethodDefinition def) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body;
        Function model = def.getDeclarationModel();
        Tree.Block block = def.getBlock();
        boolean prevNoExpressionlessReturn = this.statementGen().noExpressionlessReturn;
        try {
            this.statementGen().noExpressionlessReturn = Decl.isMpl(model) || Strategy.useBoxedVoid(model);
            body = this.statementGen().transformBlock(block);
        }
        finally {
            this.statementGen().noExpressionlessReturn = prevNoExpressionlessReturn;
        }
        HasErrorException error = this.errors().getFirstErrorBlock(block);
        if ((Decl.isMpl(model) || Strategy.useBoxedVoid(model)) && !block.getDefinitelyReturns() && error == null) {
            body = Decl.isUnboxedVoid(model) ? body.append(this.make().Return(this.makeNull())) : body.append(this.make().Return(this.makeErroneous(block, "compiler bug: non-void method doesn't definitely return")));
        }
        return body;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformSpecifiedMethodBody(Tree.MethodDeclaration def, Tree.SpecifierExpression specifierExpression) {
        JCTree.JCExpression bodyExpr;
        Function model = def.getDeclarationModel();
        Tree.MethodDeclaration methodDecl = def;
        boolean isLazy = specifierExpression instanceof Tree.LazySpecifierExpression;
        boolean returnNull = false;
        Tree.Term term = null;
        if (specifierExpression != null && specifierExpression.getExpression() != null) {
            term = Decl.unwrapExpressionsUntilTerm(specifierExpression.getExpression());
            HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(term);
            if (error != null) {
                return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowUnresolvedCompilationError(error));
            }
        }
        if (!isLazy && term instanceof Tree.FunctionArgument) {
            Tree.FunctionArgument fa = (Tree.FunctionArgument)term;
            Type resultType = model.getType();
            returnNull = ClassTransformer.isAnything(resultType) && fa.getExpression().getUnboxed();
            List<Tree.Parameter> lambdaParams = fa.getParameterLists().get(0).getParameters();
            List<Tree.Parameter> defParams = def.getParameterLists().get(0).getParameters();
            com.redhat.ceylon.langtools.tools.javac.util.List<Naming.Substitution> substitutions = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            for (int ii = 0; ii < lambdaParams.size(); ++ii) {
                substitutions = substitutions.append(this.naming.addVariableSubst(lambdaParams.get(ii).getParameterModel().getModel(), defParams.get(ii).getParameterModel().getName()));
            }
            bodyExpr = this.gen().expressionGen().transformExpression(fa.getExpression(), returnNull ? AbstractTransformer.BoxingStrategy.INDIFFERENT : CodegenUtil.getBoxingStrategy(model), resultType);
            for (Naming.Substitution subs : substitutions) {
                subs.close();
            }
        } else if (!isLazy && this.typeFact().isCallableType(term.getTypeModel())) {
            Invocation invocation;
            returnNull = ClassTransformer.isAnything(term.getTypeModel()) && term.getUnboxed();
            Function method = methodDecl.getDeclarationModel();
            boolean lazy = specifierExpression instanceof Tree.LazySpecifierExpression;
            boolean inlined = CodegenUtil.canOptimiseMethodSpecifier(term, method);
            if ((lazy || inlined) && term instanceof Tree.MemberOrTypeExpression && ((Tree.MemberOrTypeExpression)term).getDeclaration() instanceof Functional) {
                Declaration primaryDeclaration = ((Tree.MemberOrTypeExpression)term).getDeclaration();
                Reference producedReference = ((Tree.MemberOrTypeExpression)term).getTarget();
                invocation = new MethodReferenceSpecifierInvocation((AbstractTransformer)this, (Tree.MemberOrTypeExpression)term, primaryDeclaration, producedReference, method, specifierExpression);
            } else if (!lazy && !inlined) {
                String name = this.naming.getMethodSpecifierAttributeName(method);
                invocation = new CallableSpecifierInvocation((AbstractTransformer)this, method, this.naming.makeUnquotedIdent(name), term, (Node)term);
            } else if (this.isCeylonCallableSubtype(term.getTypeModel())) {
                invocation = new CallableSpecifierInvocation((AbstractTransformer)this, method, this.expressionGen().transformExpression(term), term, (Node)term);
            } else {
                throw new BugException(term, "unhandled primary: " + term == null ? "null" : term.getNodeType());
            }
            invocation.handleBoxing(true);
            invocation.setErased(CodegenUtil.hasTypeErased(term) || this.getReturnTypeOfCallable(term.getTypeModel()).isNothing());
            bodyExpr = this.expressionGen().transformInvocation(invocation);
        } else {
            bodyExpr = this.expressionGen().transformExpression(model, term);
            boolean bl = returnNull = Decl.isUnboxedVoid(model) && Decl.isMpl(model);
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body = !Decl.isUnboxedVoid(model) || Decl.isMpl(model) || Strategy.useBoxedVoid(model) ? (returnNull ? com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(bodyExpr), this.make().Return(this.makeNull())) : com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Return(bodyExpr))) : com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(bodyExpr));
        return body;
    }

    private boolean isVoid(Tree.Declaration def) {
        return this.isVoid(def.getDeclarationModel());
    }

    private boolean isVoid(Declaration def) {
        if (def instanceof Function) {
            this.gen();
            return CeylonTransformer.isAnything(((Function)def).getType());
        }
        if (def instanceof Class || def instanceof Constructor) {
            return true;
        }
        throw BugException.unhandledDeclarationCase(def);
    }

    private List<TypeParameter> typeParametersForInstantiator(Class model) {
        ArrayList<TypeParameter> filtered = new ArrayList<TypeParameter>();
        List<TypeParameter> tps = model.getTypeParameters();
        if (tps != null) {
            for (TypeParameter tp : tps) {
                boolean omit = false;
                Scope s = model.getContainer();
                while (!(s instanceof Package)) {
                    if (s instanceof Generic) {
                        for (TypeParameter outerTp : ((Generic)((Object)s)).getTypeParameters()) {
                            if (!tp.getName().equals(outerTp.getName())) continue;
                            omit = true;
                        }
                    }
                    s = s.getContainer();
                }
                if (omit) continue;
                filtered.add(tp);
            }
        }
        return filtered;
    }

    private List<TypeParameter> typeParametersOfAllContainers(ClassOrInterface model, boolean includeModelTypeParameters) {
        ArrayList<List<TypeParameter>> r = new ArrayList<List<TypeParameter>>(1);
        Scope s = model.getContainer();
        while (!(s instanceof Package)) {
            if (s instanceof Generic) {
                r.add(0, ((Generic)((Object)s)).getTypeParameters());
            }
            s = s.getContainer();
        }
        HashSet<String> names = new HashSet<String>();
        for (TypeParameter tp : model.getTypeParameters()) {
            names.add(tp.getName());
        }
        ArrayList<TypeParameter> result = new ArrayList<TypeParameter>(1);
        for (List list : r) {
            for (TypeParameter tp : list) {
                if (!names.add(tp.getName())) continue;
                result.add(tp);
            }
        }
        if (includeModelTypeParameters) {
            result.addAll(model.getTypeParameters());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodDefinitionBuilder makeParamDefaultValueMethod(boolean noBody, Declaration container, Tree.ParameterList params, Tree.Parameter currentParam) {
        this.at(currentParam);
        Parameter parameter = currentParam.getParameterModel();
        if (!Strategy.hasDefaultParameterValueMethod(parameter)) {
            throw new BugException();
        }
        MethodDefinitionBuilder methodBuilder = MethodDefinitionBuilder.systemMethod(this, Naming.getDefaultedParamMethodName(container, parameter));
        methodBuilder.ignoreModelAnnotations();
        if (container != null && Decl.isAnnotationConstructor(container)) {
            AnnotationInvocation ac = (AnnotationInvocation)((Function)container).getAnnotationConstructor();
            for (AnnotationConstructorParameter acp : ac.getConstructorParameters()) {
                if (!acp.getParameter().equals(parameter) || acp.getDefaultArgument() == null) continue;
                methodBuilder.userAnnotations(acp.getDefaultArgument().makeDpmAnnotations(this.expressionGen()));
            }
        }
        int modifiers = 0;
        if (noBody) {
            modifiers |= 0x401;
        } else if (container == null || !(container instanceof Class) || !Strategy.defaultParameterMethodStatic(container)) {
            modifiers |= 0x10;
        }
        if (container != null && container.isShared()) {
            modifiers |= 1;
        } else if (container == null || !container.isToplevel() && !noBody) {
            modifiers |= 2;
        }
        boolean staticMethod = Strategy.defaultParameterMethodStatic(container);
        if (staticMethod) {
            modifiers &= 0xFFFFFFFD;
            modifiers |= 9;
        }
        methodBuilder.modifiers(modifiers);
        if (container instanceof Constructor) {
            this.copyTypeParameters((Class)container.getContainer(), methodBuilder);
            methodBuilder.reifiedTypeParameters(((Class)container.getContainer()).getTypeParameters());
        } else if (container instanceof Generic) {
            this.copyTypeParameters((Generic)((Object)container), methodBuilder);
            methodBuilder.reifiedTypeParameters(((Generic)((Object)container)).getTypeParameters());
        }
        MethodDefinitionBuilder.WideningRules wideningRules = !staticMethod && container instanceof Class ? MethodDefinitionBuilder.WideningRules.CAN_WIDEN : MethodDefinitionBuilder.WideningRules.NONE;
        for (Tree.Parameter p : params.getParameters()) {
            if (p.equals(currentParam)) break;
            this.at(p);
            methodBuilder.parameter(p.getParameterModel(), null, 0, wideningRules);
        }
        MethodDefinitionBuilder.NonWideningParam nonWideningParam = methodBuilder.getNonWideningParam(currentParam.getParameterModel().getModel(), wideningRules);
        methodBuilder.resultType(nonWideningParam.nonWideningDecl, nonWideningParam.nonWideningType, nonWideningParam.flags);
        if (noBody) {
            methodBuilder.noBody();
        } else {
            HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(Decl.getDefaultArgument(currentParam).getExpression());
            if (error != null) {
                methodBuilder.body(this.makeThrowUnresolvedCompilationError(error));
            } else {
                List<TypeParameter> copiedTypeParameters = null;
                if (container instanceof Generic && (copiedTypeParameters = ((Generic)((Object)container)).getTypeParameters()) != null) {
                    this.addTypeParameterSubstitution(copiedTypeParameters);
                }
                try {
                    JCTree.JCExpression expr = this.expressionGen().transform(currentParam);
                    JCTree.JCBlock body = this.at(currentParam).Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.at(currentParam).Return(expr)));
                    methodBuilder.block(body);
                }
                finally {
                    if (copiedTypeParameters != null) {
                        this.popTypeParameterSubstitution();
                    }
                }
            }
        }
        return methodBuilder;
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformObjectDefinition(Tree.ObjectDefinition def, ClassDefinitionBuilder containingClassBuilder) {
        return this.transformObject(def, def, def.getSatisfiedTypes(), def.getDeclarationModel(), def.getAnonymousClass(), containingClassBuilder, Decl.isLocalNotInitializer(def));
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformObjectArgument(Tree.ObjectArgument def) {
        return this.transformObject(def, null, def.getSatisfiedTypes(), def.getDeclarationModel(), def.getAnonymousClass(), null, false);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformObjectExpression(Tree.ObjectExpression def) {
        return this.transformObject(def, null, def.getSatisfiedTypes(), null, def.getAnonymousClass(), null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformObject(Node def, Tree.Declaration annotated, Tree.SatisfiedTypes satisfiesTypes, Value model, Class klass, ClassDefinitionBuilder containingClassBuilder, boolean makeLocalInstance) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> childDefs;
        this.naming.clearSubstitutions(klass);
        String name = klass.getName();
        String javaClassName = Naming.quoteClassName(name);
        ClassDefinitionBuilder objectClassBuilder = ClassDefinitionBuilder.object(this, javaClassName, name, Decl.isLocal(klass)).forDefinition(klass);
        if (Strategy.introduceJavaIoSerializable(klass, this.typeFact().getJavaIoSerializable())) {
            objectClassBuilder.introduce(this.make().QualIdent(this.syms().serializableType.tsym));
            if (def instanceof Tree.ObjectDefinition && klass.isMember() && (klass.isShared() || klass.isCaptured() || model.isCaptured())) {
                this.addWriteReplace(klass, objectClassBuilder);
            }
        }
        this.makeReadResolve(objectClassBuilder, klass, model);
        this.addReifiedTypeInterface(objectClassBuilder, klass);
        if (this.supportsReifiedAlias(klass)) {
            objectClassBuilder.reifiedAlias(klass.getType());
        }
        CeylonVisitor visitor = this.gen().visitor;
        ListBuffer<JCTree> prevDefs = visitor.defs;
        boolean prevInInitializer = visitor.inInitializer;
        ClassDefinitionBuilder prevClassBuilder = visitor.classBuilder;
        try {
            visitor.defs = new ListBuffer();
            visitor.inInitializer = true;
            visitor.classBuilder = objectClassBuilder;
            def.visitChildren(visitor);
            childDefs = visitor.getResult().toList();
        }
        finally {
            visitor.classBuilder = prevClassBuilder;
            visitor.inInitializer = prevInInitializer;
            visitor.defs = prevDefs;
        }
        this.addMissingUnrefinedMembers(def, klass, objectClassBuilder);
        this.satisfaction(satisfiesTypes, klass, objectClassBuilder);
        this.serialization(klass, objectClassBuilder);
        if (model != null && Decl.isToplevel(model) && def instanceof Tree.ObjectDefinition) {
            AttributeDefinitionBuilder builder = AttributeDefinitionBuilder.wrapped(this, null, objectClassBuilder, model.getName(), model, true).userAnnotations(this.makeAtIgnore()).userAnnotationsSetter(this.makeAtIgnore()).immutable().initialValue(this.makeNewClass(this.naming.makeName(model, 10))).is(1L, Decl.isShared(klass)).is(8L, true);
            if (annotated != null) {
                builder.fieldAnnotations(this.expressionGen().transformAnnotations(OutputElement.FIELD, annotated));
                builder.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.GETTER, annotated));
            }
            objectClassBuilder.defs(builder.build());
        }
        if (annotated != null) {
            objectClassBuilder.annotations(this.expressionGen().transformAnnotations(OutputElement.TYPE, annotated));
            objectClassBuilder.getInitBuilder().userAnnotations(this.expressionGen().transformAnnotations(OutputElement.CONSTRUCTOR, annotated));
        }
        this.addAtContainer(objectClassBuilder, klass);
        objectClassBuilder.annotations(this.makeAtObject()).satisfies(klass.getSatisfiedTypes()).defs(childDefs);
        objectClassBuilder.getInitBuilder().modifiers(2L);
        objectClassBuilder.addGetTypeMethod(klass.getType());
        if (model != null) {
            objectClassBuilder.modelAnnotations(model.getAnnotations()).modifiers(this.transformObjectDeclFlags(model));
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> result = objectClassBuilder.build();
        if (makeLocalInstance) {
            if (model.isSelfCaptured()) {
                JCTree.JCNewClass newInstance = this.makeNewClass(objectClassBuilder.getClassName(), false, null);
                JCTree.JCFieldAccess setter = this.naming.makeSelect(Naming.getLocalValueName(model), Naming.getSetterName(model));
                JCTree.JCExpressionStatement assign = this.make().Exec(this.make().Assign(setter, newInstance));
                result = result.prepend(assign);
                JCTree.JCVariableDecl localDecl = this.makeVariableBoxDecl(null, model);
                result = result.prepend(localDecl);
            } else {
                JCTree.JCVariableDecl localDecl = this.makeLocalIdentityInstance(name, objectClassBuilder.getClassName(), false);
                result = result.append(localDecl);
            }
        } else if (model != null && Decl.withinClassOrInterface(model)) {
            boolean generateGetter = Decl.isCaptured(model);
            JCTree.JCExpression type = this.makeJavaType(klass.getType());
            if (generateGetter) {
                int modifiers = 130;
                JCTree.JCLiteral initialValue = this.makeNull();
                containingClassBuilder.field(modifiers, name, type, initialValue, false);
                AttributeDefinitionBuilder getter = AttributeDefinitionBuilder.getter(this, name, model).modifiers(this.transformAttributeGetSetDeclFlags(model, false));
                if (def instanceof Tree.ObjectDefinition) {
                    getter.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.GETTER, (Tree.ObjectDefinition)def));
                }
                ListBuffer stmts = ListBuffer.lb();
                stmts.add(this.make().If(this.make().Binary(62, this.naming.makeUnquotedIdent(Naming.quoteFieldName(name)), this.makeNull()), this.make().Exec(this.make().Assign(this.naming.makeUnquotedIdent(Naming.quoteFieldName(name)), this.makeNewClass(this.makeJavaType(klass.getType()), null))), null));
                stmts.add(this.make().Return(this.naming.makeUnquotedIdent(Naming.quoteFieldName(name))));
                getter.getterBlock(this.make().Block(0L, stmts.toList()));
                result = result.appendList(getter.build());
            } else {
                int modifiers = 16;
                JCTree.JCNewClass initialValue = this.makeNewClass(this.makeJavaType(klass.getType()), null);
                containingClassBuilder.field(modifiers, name, type, initialValue, true);
            }
        }
        return result;
    }

    private void makeReadResolve(ClassDefinitionBuilder objectClassBuilder, Class cls, Value model) {
        if (Strategy.addReadResolve(cls)) {
            MethodDefinitionBuilder readResolve = MethodDefinitionBuilder.systemMethod(this, "readResolve");
            readResolve.modifiers(2L);
            readResolve.resultType(null, this.make().Type(this.syms().objectType));
            JCTree.JCExpression apply = cls.isToplevel() ? this.make().Apply(null, this.naming.makeQualifiedName(this.naming.makeTypeDeclarationExpression(null, cls, Naming.DeclNameFlag.QUALIFIED), model, 17), com.redhat.ceylon.langtools.tools.javac.util.List.nil()) : this.makeNull();
            readResolve.body(this.make().Return(apply));
            objectClassBuilder.method(readResolve);
        }
    }

    private MethodDefinitionBuilder makeMainForClass(ClassOrInterface model) {
        this.at(null);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> arguments = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (model.isAlias()) {
            TypeDeclaration constr = ((ClassAlias)model).getConstructor();
            if (constr instanceof Constructor) {
                arguments = com.redhat.ceylon.langtools.tools.javac.util.List.of(this.naming.makeNamedConstructorName((Constructor)constr, false));
            }
            model = (ClassOrInterface)model.getExtendedType().getDeclaration();
        }
        JCTree.JCExpression nameId = this.makeJavaType(model.getType(), 8);
        arguments = this.makeBottomReifiedTypeParameters(model.getTypeParameters(), arguments);
        JCTree.JCNewClass expr = this.make().NewClass(null, null, nameId, arguments, null);
        return this.makeMainMethod(model, expr);
    }

    private MethodDefinitionBuilder makeMainForFunction(Function method) {
        this.at(null);
        JCTree.JCExpression qualifiedName = this.naming.makeName(method, 11);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> arguments = this.makeBottomReifiedTypeParameters(method.getTypeParameters(), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        MethodDefinitionBuilder mainMethod = this.makeMainMethod(method, this.make().Apply(null, qualifiedName, arguments));
        return mainMethod;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> makeBottomReifiedTypeParameters(List<TypeParameter> typeParameters, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> initialArguments) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> arguments = initialArguments;
        for (int i = typeParameters.size() - 1; i >= 0; --i) {
            arguments = arguments.prepend(this.gen().makeNothingTypeDescriptor());
        }
        return arguments;
    }

    private MethodDefinitionBuilder makeMainMethod(Declaration decl, JCTree.JCExpression callee) {
        MethodDefinitionBuilder methbuilder = MethodDefinitionBuilder.main(this).ignoreModelAnnotations();
        JCTree.JCExpression argsId = this.makeUnquotedIdent("args");
        JCTree.JCMethodInvocation processExpr = this.make().Apply(null, this.naming.makeLanguageValue("process"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        methbuilder.body(this.make().Exec(this.make().Apply(null, this.makeSelect(processExpr, "setupArguments"), com.redhat.ceylon.langtools.tools.javac.util.List.of(argsId))));
        methbuilder.body(this.make().Exec(callee));
        return methbuilder;
    }

    void copyTypeParameters(Generic def, MethodDefinitionBuilder methodBuilder) {
        if (def.getTypeParameters() != null) {
            for (TypeParameter t : def.getTypeParameters()) {
                methodBuilder.typeParameter(t);
            }
        }
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transform(Tree.TypeAliasDeclaration def) {
        TypeAlias model = def.getDeclarationModel();
        if (Decl.isAncestorLocal(def)) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        this.naming.clearSubstitutions(model);
        String ceylonClassName = def.getIdentifier().getText();
        String javaClassName = Naming.quoteClassName(def.getIdentifier().getText());
        ClassDefinitionBuilder classBuilder = ClassDefinitionBuilder.klass(this, javaClassName, ceylonClassName, Decl.isLocal(model));
        classBuilder.getInitBuilder().modifiers(2L);
        classBuilder.annotations(this.makeAtTypeAlias(model.getExtendedType()));
        classBuilder.annotations(this.expressionGen().transformAnnotations(OutputElement.TYPE, def));
        classBuilder.isAlias(true);
        this.addAtContainer(classBuilder, model);
        this.visitClassOrInterfaceDefinition(def, classBuilder);
        return classBuilder.modelAnnotations(model.getAnnotations()).modifiers(this.transformTypeAliasDeclFlags(model)).satisfies(model.getSatisfiedTypes()).build();
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> makeNamedConstructor(Tree.Declaration that, Tree.ParameterList parameterList, Constructor ctor, ClassDefinitionBuilder classBuilder, boolean generateInstantiator, int mods, boolean atIgnoreCtor, String ctorName, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> ctorBody, Naming.DeclNameFlag ... declFlags) {
        ListBuffer<JCTree> result = ListBuffer.lb();
        Class clz = (Class)ctor.getContainer();
        this.at(that);
        MethodDefinitionBuilder ctorDb = MethodDefinitionBuilder.constructor(this);
        ClassDefinitionBuilder decl = null;
        ClassDefinitionBuilder impl2 = null;
        if (generateInstantiator) {
            if (clz.getContainer() instanceof Interface) {
                decl = classBuilder.getContainingClassBuilder();
                impl2 = classBuilder.getContainingClassBuilder().getCompanionBuilder((Interface)clz.getContainer());
            } else {
                decl = classBuilder.getContainingClassBuilder();
                impl2 = classBuilder.getContainingClassBuilder();
            }
            this.generateInstantiators(classBuilder, clz, ctor, decl, impl2, that, parameterList);
        }
        ctorDb.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.CONSTRUCTOR, that));
        if (atIgnoreCtor) {
            ctorDb.modelAnnotations(this.makeAtIgnore());
        } else if (!Decl.isDefaultConstructor(ctor)) {
            ctorDb.modelAnnotations(this.makeAtName(ctor.getName()));
        }
        if (Decl.isEnumeratedConstructor(ctor)) {
            ctorDb.modelAnnotations(this.makeAtEnumerated());
        }
        ctorDb.modifiers(mods);
        for (TypeParameter tp : clz.getTypeParameters()) {
            ctorDb.reifiedTypeParameter(tp);
        }
        if (ctorName != null) {
            this.transformConstructorName(classBuilder, result, ctor, clz, mods, ctorName, declFlags);
            ctorDb.parameter(this.makeConstructorNameParameter(ctor, declFlags));
        }
        if (parameterList != null) {
            this.transformClassOrCtorParameters(null, (Class)ctor.getContainer(), ctor, that, parameterList, this.contains(declFlags, Naming.DeclNameFlag.DELEGATION), classBuilder, ctorDb, generateInstantiator, decl, impl2);
        }
        this.at(that);
        ctorDb.block(this.make().Block(0L, ctorBody));
        result.add(ctorDb.build());
        return result.toList();
    }

    <E extends Enum<E>> boolean contains(E[] values, E value) {
        for (E v : values) {
            if (v != value) continue;
            return true;
        }
        return false;
    }

    protected void transformConstructorName(ClassDefinitionBuilder classBuilder, ListBuffer<JCTree> result, Constructor ctor, Class clz, int classMods, String ctorName, Naming.DeclNameFlag ... declFlags) {
        JCTree.JCVariableDecl constructorNameConst;
        ClassDefinitionBuilder constructorNameClass = ClassDefinitionBuilder.klass(this, ctorName, null, true);
        if (Decl.isEnumeratedConstructor(ctor)) {
            if (clz.isToplevel()) {
                classMods &= 0xFFFFFFF8;
                classMods |= 0x1A;
            } else if (clz.isMember() && Decl.isToplevel((Declaration)((Object)clz.getContainer()))) {
                classMods &= 0xFFFFFFF8;
                classMods |= 0x10;
                if (!Decl.isAncestorLocal(ctor)) {
                    classMods |= 8;
                }
                if (!ctor.isShared()) {
                    classMods |= 2;
                }
            } else {
                classMods &= 0xFFFFFFF8;
                classMods |= 0x10;
            }
            constructorNameConst = null;
        } else if (clz.isToplevel() || clz.isMember() && Decl.isToplevel((Declaration)((Object)clz.getContainer()))) {
            constructorNameConst = this.make().VarDef(this.make().Modifiers(classMods |= 0x18, this.makeAtIgnore()), this.names().fromString(ctorName), this.naming.makeTypeDeclarationExpression(null, ctor, declFlags), this.makeNull());
        } else {
            classMods &= 0xFFFFFFF8;
            constructorNameConst = null;
        }
        constructorNameClass.modifiers(classMods);
        constructorNameClass.annotations(this.makeAtIgnore());
        constructorNameClass.annotations(this.makeAtConstructorName(ctor.getName(), this.contains(declFlags, Naming.DeclNameFlag.DELEGATION)));
        constructorNameClass.getInitBuilder().modifiers(2L);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> ctorNameClassDecl = constructorNameClass.build();
        if (clz.isToplevel()) {
            result.addAll((Collection<JCTree>)ctorNameClassDecl);
            classBuilder.defs(constructorNameConst);
        } else if (clz.isClassMember()) {
            classBuilder.getContainingClassBuilder().defs(ctorNameClassDecl);
            classBuilder.getContainingClassBuilder().defs(constructorNameConst);
        } else if (clz.isInterfaceMember()) {
            classBuilder.getContainingClassBuilder().getCompanionBuilder(clz).defs(ctorNameClassDecl);
            classBuilder.getContainingClassBuilder().getCompanionBuilder(clz).defs(constructorNameConst);
        } else {
            classBuilder.defs(ctorNameClassDecl);
        }
    }

    class DefaultedArgumentInstantiator
    extends DefaultedArgumentClass {
        private boolean forCompanionClass;

        DefaultedArgumentInstantiator(DaoBody daoBody, Class klass, Constructor ctor, boolean forCompanionClass) {
            super(daoBody, MethodDefinitionBuilder.systemMethod(ClassTransformer.this, ClassTransformer.this.naming.getInstantiatorMethodName(klass)), klass, ctor, false);
            this.forCompanionClass = forCompanionClass;
        }

        @Override
        protected long getModifiers() {
            long modifiers = ClassTransformer.this.transformClassDeclFlags(this.klass) & 0xFFFFFFEF;
            if (this.klass instanceof Class && this.klass.isActual()) {
                modifiers &= 0xFFFFFFFFFFFFFFF9L;
                modifiers |= 1L;
            }
            if (this.klass.isFormal() && this.klass.isAlias()) {
                modifiers |= 0x400L;
            }
            return modifiers;
        }

        @Override
        protected JCTree.JCExpression makeMethodName() {
            return ClassTransformer.this.naming.makeInstantiatorMethodName(this.daoBody.makeMethodNameQualifier(), this.klass);
        }

        @Override
        protected void resultType() {
            this.overloadBuilder.ignoreModelAnnotations();
            Type et = this.klass.getExtendedType();
            if (!this.forCompanionClass && !this.klass.isAlias() && Strategy.generateInstantiator(et.getDeclaration()) && this.klass.isActual()) {
                this.overloadBuilder.isOverride(true);
            }
            Type type = this.klass.isAlias() ? this.klass.getExtendedType() : this.klass.getType();
            JCTree.JCExpression resultType = Strategy.isInstantiatorUntyped(this.klass) ? ClassTransformer.this.make().Type(ClassTransformer.this.syms().objectType) : ClassTransformer.this.makeJavaType(type);
            this.overloadBuilder.resultType(null, resultType);
        }

        @Override
        protected void typeParameters() {
            for (TypeParameter tp : ClassTransformer.this.typeParametersForInstantiator(this.klass)) {
                this.overloadBuilder.typeParameter(tp);
            }
        }

        @Override
        protected void appendImplicitArgumentsDelegate(List<TypeParameter> typeParameterList, ListBuffer<JCTree.JCExpression> args) {
            Type type = this.klass.isAlias() ? this.klass.getExtendedType() : this.klass.getType();
            type = type.resolveAliases();
            for (Type pt : type.getTypeArgumentList()) {
                args.append(ClassTransformer.this.makeReifiedTypeArgument(pt));
            }
            if (this.constructor != null && !Decl.isDefaultConstructor(this.constructor)) {
                args.append(ClassTransformer.this.naming.makeUnquotedIdent(NamingBase.Unfix.$name$));
            }
        }

        @Override
        protected JCTree.JCExpression makeInvocation(ListBuffer<JCTree.JCExpression> args) {
            Type type = this.klass.isAlias() ? this.klass.getExtendedType() : this.klass.getType();
            return ClassTransformer.this.make().NewClass(null, null, ClassTransformer.this.makeJavaType(type, 320), args.toList(), null);
        }
    }

    class DefaultedArgumentConstructor
    extends DefaultedArgumentClass {
        DefaultedArgumentConstructor(MethodDefinitionBuilder mdb, Class klass, Tree.Declaration node, Tree.ParameterList pl, boolean delegationConstructor) {
            super(new DaoThis(node, pl), mdb, klass, null, delegationConstructor);
        }

        DefaultedArgumentConstructor(MethodDefinitionBuilder mdb, Constructor constructor, Tree.Declaration node, Tree.ParameterList pl, boolean delegationConstructor) {
            super(new DaoThis(node, pl), mdb, (Class)constructor.getContainer(), constructor, delegationConstructor);
        }

        @Override
        protected long getModifiers() {
            return ClassTransformer.this.transformConstructorDeclFlags(this.klass) & 7;
        }

        @Override
        protected JCTree.JCExpression makeMethodName() {
            return ClassTransformer.this.naming.makeQualifiedThis(this.daoBody.makeMethodNameQualifier());
        }

        @Override
        protected void resultType() {
        }

        @Override
        protected void typeParameters() {
        }
    }

    abstract class DefaultedArgumentClass
    extends DefaultedArgumentOverload {
        protected final Class klass;
        protected final Constructor constructor;
        protected Naming.SyntheticName companionInstanceName;
        private final boolean delegationConstructor;

        DefaultedArgumentClass(DaoBody daoBody, MethodDefinitionBuilder mdb, Class klass, Constructor constructor, boolean delegationConstructor) {
            super(daoBody, mdb);
            this.companionInstanceName = null;
            this.klass = klass;
            this.constructor = constructor;
            this.delegationConstructor = delegationConstructor;
        }

        @Override
        protected final Declaration getModel() {
            return this.constructor != null ? this.constructor : this.klass;
        }

        @Override
        protected void appendImplicitParameters(List<TypeParameter> typeParameterList) {
            super.appendImplicitParameters(typeParameterList);
            if (this.constructor != null) {
                if (this.delegationConstructor) {
                    this.overloadBuilder.parameter(ClassTransformer.this.makeConstructorNameParameter(this.constructor, new Naming.DeclNameFlag[]{Naming.DeclNameFlag.QUALIFIED, Naming.DeclNameFlag.DELEGATION}));
                } else if (!Decl.isDefaultConstructor(this.constructor)) {
                    this.overloadBuilder.parameter(ClassTransformer.this.makeConstructorNameParameter(this.constructor));
                }
            }
        }

        @Override
        protected void appendImplicitArgumentsDelegate(List<TypeParameter> typeParameterList, ListBuffer<JCTree.JCExpression> args) {
            this.appendImplicitArgumentsDpm(typeParameterList, args);
            if (this.constructor != null && !Decl.isDefaultConstructor(this.constructor)) {
                args.append(ClassTransformer.this.naming.makeUnquotedIdent(NamingBase.Unfix.$name$));
            }
        }

        @Override
        protected void appendImplicitArgumentsDpm(List<TypeParameter> typeParameterList, ListBuffer<JCTree.JCExpression> args) {
            if (typeParameterList != null) {
                for (TypeParameter tp : typeParameterList) {
                    args.append(ClassTransformer.this.makeUnquotedIdent(ClassTransformer.this.naming.getTypeArgumentDescriptorName(tp)));
                }
            }
        }

        @Override
        protected void initVars(Parameter currentParameter, ListBuffer<JCTree.JCStatement> vars) {
            if (!Strategy.defaultParameterMethodStatic(this.klass) && !Strategy.defaultParameterMethodOnOuter(this.klass) && currentParameter != null) {
                this.companionInstanceName = ClassTransformer.this.naming.temp("impl");
                vars.append(ClassTransformer.this.makeVar(this.companionInstanceName, ClassTransformer.this.makeJavaType(this.klass.getType(), 128), (JCTree.JCExpression)ClassTransformer.this.make().NewClass(null, null, ClassTransformer.this.makeJavaType(this.klass.getType(), 192), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null)));
            }
        }

        @Override
        protected JCTree.JCIdent makeDefaultArgumentValueMethodQualifier() {
            if (this.defaultParameterMethodOnOuter()) {
                if (this.getModel().isActual() && this.getModel().getContainer() instanceof Interface) {
                    return ClassTransformer.this.naming.makeUnquotedIdent("$this");
                }
                return null;
            }
            if (this.defaultParameterMethodOnSelf() || this.daoBody instanceof DaoCompanion) {
                return null;
            }
            if (this.defaultParameterMethodStatic()) {
                return null;
            }
            return this.companionInstanceName.makeIdent();
        }
    }

    class CanonicalMethod
    extends DefaultedArgumentMethod {
        private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body;
        private boolean useBody;

        CanonicalMethod(DaoBody daoBody, MethodDefinitionBuilder mdb, Function method) {
            super(daoBody, mdb, method);
            this.useBody = false;
        }

        CanonicalMethod(DaoBody daoBody, Function method, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body) {
            super(daoBody, MethodDefinitionBuilder.method(ClassTransformer.this, method, 2048), method);
            this.body = body;
            this.useBody = true;
        }

        @Override
        protected long getModifiers() {
            long mods = super.getModifiers();
            if (this.useBody) {
                mods = mods & 0xFFFFFFFFFFFFFFFEL & 0xFFFFFFFFFFFFFFEFL | 2L;
            }
            return mods;
        }

        @Override
        public MethodDefinitionBuilder makeOverload(ParameterList parameterList, Parameter currentParameter, List<TypeParameter> typeParameterList) {
            if (!this.useBody) {
                this.daoBody.makeBody(this, this.overloadBuilder, parameterList, currentParameter, typeParameterList);
            } else {
                this.overloadBuilder.ignoreModelAnnotations();
                this.overloadBuilder.modifiers(this.getModifiers());
                this.resultType();
                this.typeParameters();
                this.appendImplicitParameters(typeParameterList);
                this.parameters(parameterList, currentParameter);
                if (this.body != null) {
                    this.overloadBuilder.body(this.body);
                } else {
                    this.overloadBuilder.noBody();
                }
            }
            return this.overloadBuilder;
        }
    }

    class DefaultedArgumentMethodTyped
    extends DefaultedArgumentMethod {
        private TypedReference typedMember;
        private boolean forMixin;

        DefaultedArgumentMethodTyped(DaoBody daoBody, MethodDefinitionBuilder mdb, TypedReference typedMember, boolean forMixin) {
            super(daoBody, mdb, (Function)typedMember.getDeclaration());
            this.typedMember = typedMember;
            this.forMixin = forMixin;
        }

        @Override
        protected void resultType() {
            if (!AbstractTransformer.isAnything(this.getModel().getType()) || !Decl.isUnboxedVoid(this.getModel()) || Strategy.useBoxedVoid(this.getModel())) {
                TypedReference typedRef = this.typedMember;
                this.overloadBuilder.resultTypeNonWidening(this.typedMember.getQualifyingType(), typedRef, this.typedMember.getType(), 0);
            } else {
                super.resultType();
            }
        }

        @Override
        protected void parameters(ParameterList parameterList, Parameter currentParameter) {
            for (Parameter param : parameterList.getParameters()) {
                if (currentParameter != null && Decl.equal(param, currentParameter)) break;
                TypedReference typedParameter = this.typedMember.getTypedParameter(param);
                this.overloadBuilder.parameter(param, typedParameter, null, 0, this.forMixin ? MethodDefinitionBuilder.WideningRules.FOR_MIXIN : MethodDefinitionBuilder.WideningRules.CAN_WIDEN);
            }
        }

        @Override
        protected Type parameterType(Parameter parameter) {
            TypedReference typedParameter = this.typedMember.getTypedParameter(parameter);
            MethodDefinitionBuilder.NonWideningParam nonWideningParam = this.overloadBuilder.getNonWideningParam(typedParameter, this.forMixin ? MethodDefinitionBuilder.WideningRules.FOR_MIXIN : MethodDefinitionBuilder.WideningRules.CAN_WIDEN);
            Type paramType = nonWideningParam.nonWideningType;
            if (parameter.getModel() instanceof Function) {
                paramType = ClassTransformer.this.typeFact().getCallableType(paramType);
            }
            return paramType;
        }

        @Override
        public MethodDefinitionBuilder makeOverload(ParameterList parameterList, Parameter currentParameter, List<TypeParameter> typeParameterList) {
            this.overloadBuilder.isOverride(true);
            return super.makeOverload(parameterList, currentParameter, typeParameterList);
        }
    }

    class DefaultedArgumentMethod
    extends DefaultedArgumentOverload {
        private final Function method;

        DefaultedArgumentMethod(DaoBody daoBody, MethodDefinitionBuilder mdb, Function method) {
            super(daoBody, mdb);
            this.method = method;
        }

        @Override
        protected Function getModel() {
            return this.method;
        }

        @Override
        protected long getModifiers() {
            long mods = ClassTransformer.this.transformMethodDeclFlags(this.method);
            if (!(this.daoBody instanceof DaoAbstract)) {
                mods &= 0xFFFFFFFFFFFFFBFFL;
            }
            if (this.daoBody instanceof DaoCompanion) {
                mods |= 0x10L;
            }
            return mods;
        }

        @Override
        protected final JCTree.JCExpression makeMethodName() {
            int flags = 1;
            if (Decl.withinClassOrInterface(this.method)) {
                flags |= 0x800;
            }
            return ClassTransformer.this.naming.makeQualifiedName(this.daoBody.makeMethodNameQualifier(), this.method, flags);
        }

        @Override
        protected void resultType() {
            this.overloadBuilder.resultType(this.method, 0);
        }

        @Override
        protected void typeParameters() {
            ClassTransformer.this.copyTypeParameters(this.method, this.overloadBuilder);
        }

        @Override
        protected void appendImplicitArgumentsDelegate(List<TypeParameter> typeParameterList, ListBuffer<JCTree.JCExpression> args) {
            if (typeParameterList != null) {
                for (TypeParameter tp : typeParameterList) {
                    args.append(ClassTransformer.this.makeUnquotedIdent(ClassTransformer.this.naming.getTypeArgumentDescriptorName(tp)));
                }
            }
        }

        @Override
        protected void appendImplicitArgumentsDpm(List<TypeParameter> typeParameterList, ListBuffer<JCTree.JCExpression> args) {
            this.appendImplicitArgumentsDelegate(typeParameterList, args);
        }

        @Override
        protected void initVars(Parameter currentParameter, ListBuffer<JCTree.JCStatement> vars) {
        }

        @Override
        protected JCTree.JCIdent makeDefaultArgumentValueMethodQualifier() {
            return null;
        }
    }

    abstract class DefaultedArgumentOverload {
        protected final DaoBody daoBody;
        protected final MethodDefinitionBuilder overloadBuilder;

        protected DefaultedArgumentOverload(DaoBody daoBody, MethodDefinitionBuilder overloadBuilder) {
            this.daoBody = daoBody;
            this.overloadBuilder = overloadBuilder;
        }

        protected abstract long getModifiers();

        protected abstract JCTree.JCExpression makeMethodName();

        protected abstract void resultType();

        protected abstract void typeParameters();

        protected void parameters(ParameterList parameterList, Parameter currentParameter) {
            for (Parameter parameter : parameterList.getParameters()) {
                if (currentParameter != null && Decl.equal(parameter, currentParameter)) break;
                this.overloadBuilder.parameter(parameter, null, 0, this.getWideningRules(parameter));
            }
        }

        protected void appendImplicitParameters(List<TypeParameter> typeParameterList) {
            if (typeParameterList != null) {
                this.overloadBuilder.reifiedTypeParameters(typeParameterList);
            }
        }

        protected abstract void appendImplicitArgumentsDelegate(List<TypeParameter> var1, ListBuffer<JCTree.JCExpression> var2);

        protected abstract void appendImplicitArgumentsDpm(List<TypeParameter> var1, ListBuffer<JCTree.JCExpression> var2);

        protected Type parameterType(Parameter parameterModel) {
            MethodDefinitionBuilder.NonWideningParam nonWideningParam = this.overloadBuilder.getNonWideningParam(parameterModel.getModel(), this.getWideningRules(parameterModel));
            Type paramType = nonWideningParam.nonWideningType;
            if (parameterModel.getModel() instanceof Function) {
                paramType = ClassTransformer.this.typeFact().getCallableType(paramType);
            }
            return paramType;
        }

        private MethodDefinitionBuilder.WideningRules getWideningRules(Parameter parameterModel) {
            return this.defaultParameterMethodStatic() ? MethodDefinitionBuilder.WideningRules.NONE : MethodDefinitionBuilder.WideningRules.CAN_WIDEN;
        }

        protected abstract void initVars(Parameter var1, ListBuffer<JCTree.JCStatement> var2);

        protected final boolean defaultParameterMethodOnSelf() {
            return Strategy.defaultParameterMethodOnSelf(this.getModel());
        }

        protected final boolean defaultParameterMethodOnOuter() {
            return Strategy.defaultParameterMethodOnOuter(this.getModel());
        }

        protected final boolean defaultParameterMethodStatic() {
            return Strategy.defaultParameterMethodStatic(this.getModel());
        }

        protected abstract Declaration getModel();

        protected JCTree.JCExpression makeInvocation(ListBuffer<JCTree.JCExpression> args) {
            JCTree.JCExpression methName = this.makeMethodName();
            return ClassTransformer.this.make().Apply(com.redhat.ceylon.langtools.tools.javac.util.List.nil(), methName, args.toList());
        }

        protected abstract JCTree.JCIdent makeDefaultArgumentValueMethodQualifier();

        public MethodDefinitionBuilder makeOverload(ParameterList parameterList, Parameter currentParameter, List<TypeParameter> typeParameterList) {
            this.overloadBuilder.ignoreModelAnnotations();
            this.overloadBuilder.modifiers(this.getModifiers());
            this.resultType();
            this.typeParameters();
            this.appendImplicitParameters(typeParameterList);
            this.parameters(parameterList, currentParameter);
            if (this.daoBody != null) {
                this.daoBody.makeBody(this, this.overloadBuilder, parameterList, currentParameter, typeParameterList);
            }
            return this.overloadBuilder;
        }
    }

    private class DaoSuper
    extends DaoBody {
        private DaoSuper() {
        }

        @Override
        JCTree.JCExpression makeMethodNameQualifier() {
            return ClassTransformer.this.naming.makeSuper();
        }

        @Override
        void makeBody(DefaultedArgumentOverload overloaded, MethodDefinitionBuilder overloadBuilder, ParameterList parameterList, Parameter currentParameter, List<TypeParameter> typeParameterList) {
            ListBuffer<JCTree.JCExpression> args = ListBuffer.lb();
            for (Parameter parameter : parameterList.getParameters()) {
                if (currentParameter != null && Decl.equal(parameter, currentParameter)) break;
                args.add(ClassTransformer.this.naming.makeUnquotedIdent(parameter.getName()));
            }
            JCTree.JCExpression superCall = overloaded.makeInvocation(args);
            JCTree.JCExpression refinedType = ClassTransformer.this.makeJavaType(((Function)overloaded.getModel()).getType(), 4);
            overloadBuilder.body(ClassTransformer.this.make().Return(ClassTransformer.this.make().TypeCast(refinedType, superCall)));
        }
    }

    private class DaoCompanion
    extends DaoThis {
        DaoCompanion(Tree.AnyMethod invocation, Tree.ParameterList pl) {
            super(invocation, pl);
        }

        @Override
        protected final com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> makeTypeArguments(DefaultedArgumentOverload ol) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
    }

    private class DaoThis
    extends DaoBody {
        private final Tree.Declaration declTree;
        private final Token firstExecutable;
        private final Tree.ParameterList pl;

        public DaoThis(Tree.Declaration invocation, Tree.ParameterList pl) {
            this.declTree = invocation;
            this.firstExecutable = pl != null ? pl.getEndToken() : null;
            this.pl = pl;
        }

        @Override
        public void makeBody(DefaultedArgumentOverload overloaded, MethodDefinitionBuilder overloadBuilder, ParameterList parameterList, Parameter currentParameter, List<TypeParameter> typeParameterList) {
            ListBuffer<JCTree.JCExpression> delegateArgs = ListBuffer.lb();
            overloaded.appendImplicitArgumentsDelegate(typeParameterList, delegateArgs);
            ListBuffer<JCTree.JCExpression> dpmArgs = ListBuffer.lb();
            overloaded.appendImplicitArgumentsDpm(typeParameterList, dpmArgs);
            ListBuffer<JCTree.JCStatement> vars = ListBuffer.lb();
            boolean initedVars = false;
            boolean useDefault = false;
            for (Parameter parameterModel : parameterList.getParameters()) {
                if (currentParameter != null && Decl.equal(parameterModel, currentParameter)) {
                    useDefault = true;
                }
                if (useDefault) {
                    JCTree.JCExpression defaultArgument;
                    ClassTransformer.this.at(this.parameterLocation(parameterModel));
                    if (Strategy.hasDefaultParameterValueMethod(parameterModel)) {
                        if (!initedVars) {
                            overloaded.initVars(currentParameter, vars);
                        }
                        initedVars = true;
                        JCTree.JCExpression defaultValueMethodName = ClassTransformer.this.naming.makeDefaultedParamMethod(overloaded.makeDefaultArgumentValueMethodQualifier(), parameterModel);
                        defaultArgument = ClassTransformer.this.make().Apply(this.makeTypeArguments(overloaded), defaultValueMethodName, ListBuffer.lb().appendList(dpmArgs).toList());
                    } else {
                        defaultArgument = Strategy.hasEmptyDefaultArgument(parameterModel) ? ClassTransformer.this.makeEmptyAsSequential(true) : ClassTransformer.this.makeErroneous(null, "compiler bug: parameter " + parameterModel.getName() + " has an unsupported default value");
                    }
                    Naming.SyntheticName varName = ClassTransformer.this.naming.temp(parameterModel.getName());
                    Type paramType = overloaded.parameterType(parameterModel);
                    vars.append(ClassTransformer.this.makeVar(varName, ClassTransformer.this.makeJavaType(paramType, CodegenUtil.isUnBoxed(parameterModel.getModel()) ? 0 : 4), defaultArgument));
                    ClassTransformer.this.at(null);
                    delegateArgs.add(varName.makeIdent());
                    dpmArgs.add(varName.makeIdent());
                    continue;
                }
                delegateArgs.add(ClassTransformer.this.naming.makeName(parameterModel.getModel(), 257));
                dpmArgs.add(ClassTransformer.this.naming.makeName(parameterModel.getModel(), 257));
            }
            this.makeBody(overloaded, overloadBuilder, delegateArgs, vars);
        }

        private Node parameterLocation(Parameter parameterModel) {
            if (this.pl != null) {
                for (Tree.Parameter p : this.pl.getParameters()) {
                    if (!p.getParameterModel().equals(parameterModel)) continue;
                    return p;
                }
            }
            return null;
        }

        protected final void makeBody(DefaultedArgumentOverload overloaded, MethodDefinitionBuilder overloadBuilder, ListBuffer<JCTree.JCExpression> args, ListBuffer<JCTree.JCStatement> vars) {
            ClassTransformer.this.at(this.pl, this.firstExecutable);
            JCTree.JCExpression invocation = overloaded.makeInvocation(args);
            Declaration model = overloaded.getModel();
            if (!ClassTransformer.this.isVoid(model) || model instanceof Functional && Decl.isMpl((Functional)((Object)model)) || model instanceof Function && !Decl.isUnboxedVoid(model) || model instanceof Function && Strategy.useBoxedVoid((Function)model) || Strategy.generateInstantiator(model) && overloaded instanceof DefaultedArgumentInstantiator) {
                if (!vars.isEmpty()) {
                    invocation = ClassTransformer.this.at(this.declTree).LetExpr(vars.toList(), invocation);
                }
                overloadBuilder.body(ClassTransformer.this.make().Return(invocation));
            } else {
                vars.append(ClassTransformer.this.at(this.pl, this.firstExecutable).Exec(invocation));
                invocation = ClassTransformer.this.at(this.declTree).LetExpr(vars.toList(), ClassTransformer.this.makeNull());
                overloadBuilder.body(ClassTransformer.this.make().Exec(invocation));
            }
        }
    }

    private class DaoAbstract
    extends DaoBody {
        private DaoAbstract() {
        }

        @Override
        public void makeBody(DefaultedArgumentOverload overloaded, MethodDefinitionBuilder overloadBuilder, ParameterList parameterList, Parameter currentParameter, List<TypeParameter> typeParameterList) {
            overloadBuilder.noBody();
        }
    }

    abstract class DaoBody {
        DaoBody() {
        }

        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> makeTypeArguments(DefaultedArgumentOverload ol) {
            if (ol.defaultParameterMethodOnSelf() || ol.defaultParameterMethodOnOuter()) {
                return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            }
            if (ol.defaultParameterMethodStatic()) {
                Functional f = (Functional)((Object)ol.getModel());
                return ClassTransformer.this.typeArguments(f instanceof Constructor ? (Class)((Constructor)f).getContainer() : f);
            }
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }

        abstract void makeBody(DefaultedArgumentOverload var1, MethodDefinitionBuilder var2, ParameterList var3, Parameter var4, List<TypeParameter> var5);

        JCTree.JCExpression makeMethodNameQualifier() {
            return null;
        }
    }

    static enum DelegateType {
        FOR_DEFAULT_VALUE,
        OTHER;

    }

    static interface SatisfactionVisitor {
        public void satisfiesDirectly(Class var1, Interface var2, boolean var3);

        public void satisfiesIndirectly(Class var1, Interface var2, boolean var3);

        public void satisfiesIndirectlyViaClass(Class var1, Interface var2, Class var3, boolean var4);
    }
}

