/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.BooleanUtil;
import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.List;
import java.util.Map;

public class CodegenUtil {
    private CodegenUtil() {
    }

    static boolean isErasedAttribute(String name) {
        return "hash".equals(name) || "string".equals(name);
    }

    public static boolean isHashAttribute(Declaration model) {
        return model instanceof Value && Decl.withinClassOrInterface(model) && model.isShared() && "hash".equals(model.getName());
    }

    static boolean isUnBoxed(Tree.Term node) {
        return node.getUnboxed();
    }

    static boolean isUnBoxed(TypedDeclaration decl) {
        return BooleanUtil.isTrue(decl.getUnboxed());
    }

    static void markUnBoxed(Tree.Term node) {
        node.setUnboxed(true);
    }

    static AbstractTransformer.BoxingStrategy getBoxingStrategy(Tree.Term node) {
        return CodegenUtil.isUnBoxed(node) ? AbstractTransformer.BoxingStrategy.UNBOXED : AbstractTransformer.BoxingStrategy.BOXED;
    }

    static AbstractTransformer.BoxingStrategy getBoxingStrategy(TypedDeclaration decl) {
        return CodegenUtil.isUnBoxed(decl) ? AbstractTransformer.BoxingStrategy.UNBOXED : AbstractTransformer.BoxingStrategy.BOXED;
    }

    static boolean isRaw(TypedDeclaration decl) {
        Type type = decl.getType();
        return type != null && type.isRaw();
    }

    static boolean isRaw(Tree.Term node) {
        Type type = node.getTypeModel();
        return type != null && type.isRaw();
    }

    static void markRaw(Tree.Term node) {
        Type type = node.getTypeModel();
        if (type != null) {
            type.setRaw(true);
        }
    }

    static boolean hasTypeErased(Tree.Term node) {
        return node.getTypeErased();
    }

    static boolean hasTypeErased(TypedDeclaration decl) {
        return decl.getTypeErased();
    }

    static void markTypeErased(Tree.Term node) {
        CodegenUtil.markTypeErased(node, true);
    }

    static void markTypeErased(Tree.Term node, boolean erased) {
        node.setTypeErased(erased);
    }

    static void markUntrustedType(Tree.Term node) {
        node.setUntrustedType(true);
    }

    static boolean hasUntrustedType(Tree.Term node) {
        return node.getUntrustedType();
    }

    static boolean hasUntrustedType(TypedDeclaration decl) {
        Boolean ret = decl.getUntrustedType();
        return ret != null && ret != false;
    }

    static boolean hasCompilerAnnotation(Tree.StatementOrArgument decl, String name) {
        for (Tree.CompilerAnnotation annotation : decl.getCompilerAnnotations()) {
            if (!annotation.getIdentifier().getText().equals(name)) continue;
            return true;
        }
        return false;
    }

    static boolean hasCompilerAnnotationNoArgument(Tree.StatementOrArgument decl, String name) {
        for (Tree.CompilerAnnotation annotation : decl.getCompilerAnnotations()) {
            if (!annotation.getIdentifier().getText().equals(name) || annotation.getStringLiteral() != null) continue;
            return true;
        }
        return false;
    }

    static boolean hasCompilerAnnotationWithArgument(Tree.StatementOrArgument decl, String name, String argument) {
        for (Tree.CompilerAnnotation annotation : decl.getCompilerAnnotations()) {
            String text;
            if (!annotation.getIdentifier().getText().equals(name) || annotation.getStringLiteral() == null || (text = annotation.getStringLiteral().getText()) == null || !text.equals(argument)) continue;
            return true;
        }
        return false;
    }

    private static String getCompilerAnnotationArgument(Iterable<Tree.CompilerAnnotation> compilerAnnotations, String name) {
        for (Tree.CompilerAnnotation annotation : compilerAnnotations) {
            if (!annotation.getIdentifier().getText().equals(name) || annotation.getStringLiteral() == null) continue;
            String text = annotation.getStringLiteral().getText();
            return text;
        }
        return null;
    }

    static String getCompilerAnnotationArgument(Tree.StatementOrArgument def, String name) {
        return CodegenUtil.getCompilerAnnotationArgument(def.getCompilerAnnotations(), name);
    }

    static String getCompilerAnnotationArgument(Tree.CompilationUnit def, String name) {
        return CodegenUtil.getCompilerAnnotationArgument(def.getCompilerAnnotations(), name);
    }

    static boolean isDirectAccessVariable(Tree.Term term) {
        if (!(term instanceof Tree.BaseMemberExpression) || !term.getUnboxed()) {
            return false;
        }
        Declaration decl = ((Tree.BaseMemberExpression)term).getDeclaration();
        if (decl == null) {
            return false;
        }
        return Decl.isValue(decl) && !decl.isToplevel() && !decl.isClassOrInterfaceMember() && !decl.isCaptured() && !decl.isShared();
    }

    static Declaration getTopmostRefinedDeclaration(Declaration decl) {
        return JvmBackendUtil.getTopmostRefinedDeclaration(decl);
    }

    static Declaration getTopmostRefinedDeclaration(Declaration decl, Map<Function, Function> methodOverrides) {
        return JvmBackendUtil.getTopmostRefinedDeclaration(decl, methodOverrides);
    }

    static Parameter findParamForDecl(Tree.TypedDeclaration decl) {
        String attrName = decl.getIdentifier().getText();
        return CodegenUtil.findParamForDecl(attrName, decl.getDeclarationModel());
    }

    static Parameter findParamForDecl(TypedDeclaration decl) {
        return JvmBackendUtil.findParamForDecl(decl);
    }

    static Parameter findParamForDecl(String attrName, TypedDeclaration decl) {
        return JvmBackendUtil.findParamForDecl(attrName, decl);
    }

    static FunctionOrValue findMethodOrValueForParam(Parameter param) {
        return param.getModel();
    }

    static boolean isVoid(Type type) {
        return type != null && type.getDeclaration() != null && type.getDeclaration().getUnit().getAnythingType().isExactly(type);
    }

    public static boolean canOptimiseMethodSpecifier(Tree.Term expression, Function m) {
        if (expression instanceof Tree.FunctionArgument) {
            return true;
        }
        if (!(expression instanceof Tree.BaseMemberOrTypeExpression)) {
            return false;
        }
        Declaration declaration = ((Tree.BaseMemberOrTypeExpression)expression).getDeclaration();
        if (declaration instanceof Function) {
            return true;
        }
        if (declaration instanceof Class) {
            return true;
        }
        return declaration instanceof FunctionOrValue && ((FunctionOrValue)declaration).isParameter();
    }

    public static Declaration getParameterized(Parameter parameter) {
        return parameter.getDeclaration();
    }

    public static Declaration getParameterized(FunctionOrValue methodOrValue) {
        return JvmBackendUtil.getParameterized(methodOrValue);
    }

    public static boolean isContainerFunctionalParameter(Declaration declaration) {
        Declaration containerDeclaration;
        Scope containerScope = declaration.getContainer();
        if (containerScope instanceof Specification) {
            containerDeclaration = ((Specification)containerScope).getDeclaration();
        } else if (containerScope instanceof Declaration) {
            containerDeclaration = (Declaration)((Object)containerScope);
        } else {
            throw BugException.unhandledCase(containerScope);
        }
        return containerDeclaration instanceof Function && ((Function)containerDeclaration).isParameter();
    }

    public static boolean isMemberReferenceInvocation(Tree.InvocationExpression expr) {
        Tree.QualifiedMemberOrTypeExpression primary;
        Tree.Term q;
        Tree.Term p = TreeUtil.unwrapExpressionUntilTerm(expr.getPrimary());
        return AnalyzerUtil.isIndirectInvocation(expr, true) && p instanceof Tree.QualifiedMemberOrTypeExpression && ((q = TreeUtil.unwrapExpressionUntilTerm((primary = (Tree.QualifiedMemberOrTypeExpression)p).getPrimary())) instanceof Tree.BaseTypeExpression || q instanceof Tree.QualifiedTypeExpression);
    }

    public static boolean containsTypeParameter(Type type) {
        List<Type> types;
        if (type.isTypeParameter()) {
            return true;
        }
        for (Type pt : type.getTypeArgumentList()) {
            if (!CodegenUtil.containsTypeParameter(pt)) continue;
            return true;
        }
        if (type.isIntersection()) {
            types = type.getSatisfiedTypes();
            int l = types.size();
            for (int i = 0; i < l; ++i) {
                if (!CodegenUtil.containsTypeParameter(types.get(i))) continue;
                return true;
            }
            return false;
        }
        if (type.isUnion()) {
            types = type.getCaseTypes();
            int l = types.size();
            for (int i = 0; i < l; ++i) {
                if (!CodegenUtil.containsTypeParameter(types.get(i))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isCompanionClassNeeded(TypeDeclaration decl) {
        return decl instanceof Interface && BooleanUtil.isNotFalse(((Interface)decl).isCompanionClassNeeded());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getJavaNameOfDeclaration(Declaration decl) {
        String result;
        Scope s = decl.getScope();
        while (!(s instanceof Package)) {
            if (!(s instanceof TypeDeclaration)) {
                throw new IllegalArgumentException();
            }
            s = s.getContainer();
        }
        Naming n = new Naming(null, null);
        if (decl instanceof TypeDeclaration) {
            result = n.makeTypeDeclarationName((TypeDeclaration)decl, Naming.DeclNameFlag.QUALIFIED);
            result = result.substring(1);
            if (!decl.isAnonymous()) return result;
            return result + "." + NamingBase.Unfix.get_.toString();
        }
        if (!(decl instanceof TypedDeclaration)) throw new RuntimeException();
        if (decl.isToplevel()) {
            result = n.getName((TypedDeclaration)decl, 11);
            return result.substring(1);
        }
        Scope container = decl.getContainer();
        if (!(container instanceof TypeDeclaration)) throw new IllegalArgumentException();
        String qualifier = CodegenUtil.getJavaNameOfDeclaration((TypeDeclaration)container);
        return qualifier + n.getName((TypedDeclaration)decl, 1);
    }

    public static boolean needsLateInitField(TypedDeclaration attrType, Unit unit) {
        return attrType.isLate() && (CodegenUtil.isUnBoxed(attrType) && !attrType.getType().isString() || unit.isOptionalType(attrType.getType()));
    }

    public static boolean hasDelegatingConstructors(Tree.ClassOrInterface def) {
        if (!(def instanceof Tree.ClassDefinition)) {
            return false;
        }
        for (Tree.Statement stmt : ((Tree.ClassDefinition)def).getClassBody().getStatements()) {
            Tree.ExtendedTypeExpression ete;
            Tree.Constructor ctor;
            if (!(stmt instanceof Tree.Constructor) || (ctor = (Tree.Constructor)stmt).getDelegatedConstructor() == null || ctor.getDelegatedConstructor().getInvocationExpression() == null || !(ctor.getDelegatedConstructor().getInvocationExpression().getPrimary() instanceof Tree.ExtendedTypeExpression) || !Decl.isConstructor((ete = (Tree.ExtendedTypeExpression)ctor.getDelegatedConstructor().getInvocationExpression().getPrimary()).getDeclaration()) || !Decl.getConstructedClass(ete.getDeclaration()).equals(def.getDeclarationModel())) continue;
            return true;
        }
        return false;
    }
}

