/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import java.util.Map;

public class CtorDelegation {
    private final Constructor ctor;
    private final Declaration extending;
    private String error;

    public CtorDelegation(Constructor ctor, Declaration extending) {
        this.ctor = ctor;
        this.extending = extending instanceof FunctionOrValue ? ((FunctionOrValue)extending).getTypeDeclaration() : (extending instanceof Class && ((Class)extending).hasConstructors() ? Decl.getDefaultConstructor((Class)extending) : extending);
        if (!(extending instanceof Class) && !(extending instanceof Constructor)) {
            throw new RuntimeException();
        }
    }

    private CtorDelegation(Constructor ctor, String errorMessage) {
        this.ctor = ctor;
        this.error = errorMessage;
        this.extending = null;
    }

    public static CtorDelegation brokenDelegation(Constructor ctorModel) {
        String message = ctorModel.getName() == null ? "constructor delegates to default constructor which has a compiler error" : "constructor delegates to constructor with a compiler error: " + ctorModel.getName();
        return new CtorDelegation(ctorModel, message);
    }

    public boolean isError() {
        return this.error != null;
    }

    public JCTree.JCStatement makeThrow(AbstractTransformer gen) {
        return gen.makeThrowUnresolvedCompilationError(this.error);
    }

    public Constructor getConstructor() {
        return this.ctor;
    }

    public Declaration getExtending() {
        return this.extending;
    }

    public Constructor getExtendingConstructor() {
        return this.extending instanceof Constructor ? (Constructor)this.extending : null;
    }

    public boolean isSelfDelegation() {
        return this.ctor != null && (this.extending instanceof Constructor && this.ctor.getContainer().equals(this.extending.getContainer()) || this.extending instanceof Class && this.ctor.getContainer().equals(this.extending));
    }

    public boolean isConcreteSelfDelegation() {
        return this.isSelfDelegation() && (this.extending instanceof Class || !((Constructor)this.extending).isAbstract());
    }

    public boolean isAbstractSelfDelegation() {
        return this.isSelfDelegation() && this.extending instanceof Constructor && ((Constructor)this.extending).isAbstract();
    }

    public boolean isAbstractSelfOrSuperDelegation() {
        return !this.isSelfDelegation() || this.extending instanceof Constructor && ((Constructor)this.extending).isAbstract();
    }

    public static boolean isDelegatedTo(Map<Constructor, CtorDelegation> allDelegations, Constructor ctor) {
        for (CtorDelegation d : allDelegations.values()) {
            if (!ctor.equals(d.getExtending())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.ctor + " extends " + this.extending;
    }
}

