/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.util.Util;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.model.FieldValue;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.ConditionScope;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NamedArgumentList;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.List;

public class Decl {
    private Decl() {
    }

    public static boolean equal(Declaration decl, Declaration other) {
        return ModelUtil.equal(decl, other);
    }

    public static boolean equal(Parameter decl, Parameter other) {
        return ModelUtil.eq(decl, other);
    }

    public static boolean equalScopes(Scope scope, Scope other) {
        return ModelUtil.eq(scope, other);
    }

    public static boolean equalScopeDecl(Scope scope, Declaration other) {
        return ModelUtil.eq(scope, other);
    }

    public static boolean equalModules(Module scope, Module other) {
        return ModelUtil.equalModules(scope, other);
    }

    public static Scope container(Tree.Declaration decl) {
        return Decl.container(decl.getDeclarationModel());
    }

    public static Scope container(Declaration decl) {
        return decl.getContainer();
    }

    public static boolean isGetter(Declaration decl) {
        return decl instanceof Value && !((Value)decl).isParameter() && ((Value)decl).isTransient();
    }

    public static boolean isNonTransientValue(Declaration decl) {
        return ModelUtil.isNonTransientValue(decl);
    }

    public static boolean isSharedParameter(Declaration decl) {
        return decl instanceof Value && ((Value)decl).isParameter() && decl.isShared();
    }

    public static boolean isValue(Declaration decl) {
        return JvmBackendUtil.isValue(decl);
    }

    public static boolean isValueOrSharedParam(Declaration decl) {
        return Decl.isValue(decl) || decl instanceof Value && ((Value)decl).isParameter() && decl.isShared();
    }

    public static boolean isValueOrSharedOrCapturedParam(Declaration decl) {
        return Decl.isValue(decl) || decl instanceof Value && ((Value)decl).isParameter() && (decl.isShared() || decl.isCaptured());
    }

    public static boolean isMethodOrSharedOrCapturedParam(Declaration decl) {
        return decl instanceof Function && !Decl.isConstructor(decl) && (!((Function)decl).isParameter() || decl.isShared() || decl.isCaptured());
    }

    public static boolean isMethod(Declaration decl) {
        return JvmBackendUtil.isMethod(decl);
    }

    public static boolean withinMethod(Tree.Declaration decl) {
        return Decl.withinMethod(decl.getDeclarationModel());
    }

    public static boolean withinGetter(Tree.Declaration decl) {
        return Decl.withinGetter(decl.getDeclarationModel());
    }

    public static boolean withinSetter(Tree.Declaration decl) {
        return Decl.withinSetter(decl.getDeclarationModel());
    }

    public static boolean withinMethod(Declaration decl) {
        return Decl.container(decl) instanceof Function;
    }

    public static boolean withinGetter(Declaration decl) {
        Scope s = Decl.container(decl);
        return Decl.isGetter((Declaration)((Object)s));
    }

    public static boolean withinSetter(Declaration decl) {
        return Decl.container(decl) instanceof Setter;
    }

    public static boolean withinPackage(Tree.Declaration decl) {
        return Decl.container(decl) instanceof Package;
    }

    public static boolean withinClass(Tree.Declaration decl) {
        return Decl.container(decl) instanceof Class;
    }

    public static boolean withinClass(Declaration decl) {
        return ModelUtil.withinClass(decl);
    }

    public static boolean withinInterface(Tree.Declaration decl) {
        return Decl.container(decl) instanceof Interface;
    }

    public static boolean withinInterface(Declaration decl) {
        return Decl.container(decl) instanceof Interface;
    }

    public static boolean withinClassOrInterface(Tree.Declaration decl) {
        return Decl.withinClassOrInterface(decl.getDeclarationModel());
    }

    public static boolean withinClassOrInterface(Declaration decl) {
        return ModelUtil.withinClassOrInterface(decl);
    }

    public static boolean isShared(Tree.Declaration decl) {
        return Decl.isShared(decl.getDeclarationModel());
    }

    public static boolean isShared(Declaration decl) {
        return decl.isShared();
    }

    public static boolean isCaptured(Tree.Declaration decl) {
        return Decl.isCaptured(decl.getDeclarationModel());
    }

    public static boolean isCaptured(Declaration decl) {
        return ModelUtil.isCaptured(decl);
    }

    public static boolean isAbstract(Tree.ClassOrInterface decl) {
        return decl.getDeclarationModel().isAbstract();
    }

    public static boolean isDefault(Tree.Declaration decl) {
        return decl.getDeclarationModel().isDefault();
    }

    public static boolean isFormal(Tree.Declaration decl) {
        return decl.getDeclarationModel().isFormal();
    }

    public static boolean isActual(Tree.Declaration decl) {
        return Decl.isActual(decl.getDeclarationModel());
    }

    public static boolean isActual(Declaration decl) {
        return decl.isActual();
    }

    public static boolean isTransient(Tree.AttributeDeclaration decl) {
        return decl.getDeclarationModel().isTransient();
    }

    public static boolean isTransient(Declaration decl) {
        if (decl instanceof FunctionOrValue) {
            return ((FunctionOrValue)decl).isTransient();
        }
        return false;
    }

    public static boolean isVariable(Tree.AttributeDeclaration decl) {
        return decl.getDeclarationModel().isVariable() && !Decl.hasSetter(decl);
    }

    public static boolean hasSetter(Tree.AttributeDeclaration decl) {
        return decl.getDeclarationModel().getSetter() != null;
    }

    public static boolean isLate(Tree.AttributeDeclaration decl) {
        return Decl.isLate(decl.getDeclarationModel());
    }

    public static boolean isLate(Value model) {
        return model.isLate();
    }

    public static boolean isIndirect(Tree.AttributeDeclaration decl) {
        return decl.getDeclarationModel().isTransient() && decl.getSpecifierOrInitializerExpression() == null;
    }

    public static boolean isToplevel(Tree.Declaration decl) {
        return Decl.isToplevel(decl.getDeclarationModel());
    }

    public static boolean isToplevel(Declaration decl) {
        return decl.isToplevel();
    }

    public static boolean isDeferred(Tree.Declaration decl) {
        return Decl.isDeferred(decl.getDeclarationModel());
    }

    public static boolean isDeferred(Declaration decl) {
        return decl instanceof Function && ((Function)decl).isDeferred();
    }

    public static boolean isLocalNotInitializer(Tree.Declaration decl) {
        return Decl.isLocalNotInitializer(decl.getDeclarationModel());
    }

    public static boolean isLocalNotInitializer(Declaration decl) {
        return ModelUtil.isLocalNotInitializer(decl);
    }

    public static boolean isLocal(Tree.Declaration decl) {
        return Decl.isLocal(decl.getDeclarationModel());
    }

    public static boolean isLocal(Declaration decl) {
        return Decl.isLocalNotInitializer(decl) || Decl.isLocalToInitializer(decl);
    }

    public static boolean isLocalNotInitializerScope(Scope scope) {
        return ModelUtil.isLocalNotInitializerScope(scope);
    }

    public static boolean isAncestorLocal(Tree.Declaration decl) {
        return Decl.isAncestorLocal(decl.getDeclarationModel());
    }

    public static boolean isAncestorLocal(Declaration decl) {
        for (Scope container = decl.getContainer(); container != null; container = container.getContainer()) {
            if (!(container instanceof FunctionOrValue) && !(container instanceof ControlBlock) && !(container instanceof NamedArgumentList)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassAttribute(Declaration decl) {
        return !(!Decl.withinClassOrInterface(decl) || !Decl.isValue(decl) && !(decl instanceof Setter) || !decl.isCaptured() && !decl.isShared());
    }

    public static boolean isClassParameter(Declaration decl) {
        return Decl.withinClassOrInterface(decl) && decl instanceof Value && ((Value)decl).isParameter() && (decl.isCaptured() || decl.isShared());
    }

    public static boolean isLocalToInitializer(Tree.Declaration decl) {
        return Decl.isLocalToInitializer(decl.getDeclarationModel());
    }

    public static boolean isLocalToInitializer(Declaration decl) {
        return ModelUtil.isLocalToInitializer(decl);
    }

    public static boolean isOverloaded(Declaration decl) {
        if (decl instanceof Functional) {
            return decl.isOverloaded();
        }
        return false;
    }

    public static boolean isJavaField(Declaration decl) {
        return decl instanceof FieldValue;
    }

    public static boolean isStatic(TypeDeclaration declaration) {
        if (declaration instanceof LazyClass) {
            return ((LazyClass)declaration).isStatic();
        }
        if (declaration instanceof LazyInterface) {
            return ((LazyInterface)declaration).isStatic();
        }
        return false;
    }

    public static boolean isCeylon(TypeDeclaration declaration) {
        return JvmBackendUtil.isCeylon(declaration);
    }

    public static boolean isUnboxedVoid(Declaration decl) {
        return Util.isUnboxedVoid(decl);
    }

    public static boolean isMpl(Functional decl) {
        return decl.getParameterLists().size() > 1;
    }

    public static ClassOrInterface getClassOrInterfaceContainer(Element decl) {
        return ModelUtil.getClassOrInterfaceContainer(decl);
    }

    public static ClassOrInterface getClassOrInterfaceContainer(Element decl, boolean includingDecl) {
        return ModelUtil.getClassOrInterfaceContainer(decl, includingDecl);
    }

    public static Package getPackage(Declaration decl) {
        return ModelUtil.getPackage(decl);
    }

    public static Package getPackageContainer(Scope scope) {
        return ModelUtil.getPackageContainer(scope);
    }

    public static Module getModule(Declaration decl) {
        return ModelUtil.getModule(decl);
    }

    public static Module getModuleContainer(Scope scope) {
        return ModelUtil.getModuleContainer(scope);
    }

    public static boolean isValueTypeDecl(Tree.Term decl) {
        if (decl != null) {
            return Decl.isValueTypeDecl(decl.getTypeModel());
        }
        return false;
    }

    public static boolean isValueTypeDecl(TypedDeclaration decl) {
        if (decl != null) {
            return Decl.isValueTypeDecl(decl.getType());
        }
        return false;
    }

    public static boolean isValueTypeDecl(Type type) {
        if (type == null) {
            return false;
        }
        if ((type = type.resolveAliases()) != null && type.getDeclaration() instanceof LazyClass) {
            return ((LazyClass)type.getDeclaration()).isValueType();
        }
        return false;
    }

    static boolean isRefinableMemberClass(Declaration model) {
        return model instanceof Class && model.isMember() && (model.isFormal() || model.isDefault()) && !model.isAnonymous() && Decl.isCeylon((Class)model);
    }

    public static String className(Declaration decl) {
        String name = decl.getQualifiedNameString().replace("::", ".");
        if (Naming.isLowerCase(decl.getName())) {
            name = name + "_";
        }
        return name;
    }

    public static Tree.Term unwrapExpressionsUntilTerm(Tree.Term term) {
        while (term instanceof Tree.Expression) {
            term = ((Tree.Expression)term).getTerm();
        }
        return term;
    }

    public static boolean isBoxedVariable(Tree.AttributeDeclaration attr) {
        return Decl.isBoxedVariable(attr.getDeclarationModel());
    }

    public static boolean isBoxedVariable(TypedDeclaration attr) {
        return JvmBackendUtil.isBoxedVariable(attr);
    }

    public static boolean isObjectValue(TypedDeclaration attr) {
        Type type = attr.getType();
        if (type != null) {
            TypeDeclaration typeDecl = type.getDeclaration();
            return typeDecl.isAnonymous();
        }
        return false;
    }

    public static boolean isAnnotationConstructor(Tree.AnyMethod def) {
        return Decl.isAnnotationConstructor(def.getDeclarationModel());
    }

    public static boolean isAnnotationConstructor(Declaration def) {
        return def.isToplevel() && def instanceof Function && Decl.containsAnnotationAnnotation(def);
    }

    private static boolean containsAnnotationAnnotation(Declaration decl) {
        List<Annotation> annotations = decl.getAnnotations();
        if (annotations != null) {
            for (Annotation ann : annotations) {
                if (!"annotation".equals(ann.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotationClass(Tree.ClassOrInterface def) {
        return Decl.isAnnotationClass(def.getDeclarationModel());
    }

    public static boolean isAnnotationClass(Declaration declarationModel) {
        return declarationModel instanceof Class && Decl.containsAnnotationAnnotation(declarationModel);
    }

    public static boolean isInteropAnnotationClass(ClassOrInterface annotationClass) {
        return annotationClass.getName().endsWith("$Proxy");
    }

    public static boolean isJavaArray(TypeDeclaration decl) {
        return JvmBackendUtil.isJavaArray(decl);
    }

    public static boolean isJavaObjectArray(TypeDeclaration decl) {
        if (!(decl instanceof Class)) {
            return false;
        }
        Class c = (Class)decl;
        String name = c.getQualifiedNameString();
        return name.equals("java.lang::ObjectArray");
    }

    public static boolean isAnnotationClassOrConstructor(Declaration container) {
        return Decl.isAnnotationClass(container) || Decl.isAnnotationConstructor(container);
    }

    public static Tree.SpecifierOrInitializerExpression getDefaultArgument(Tree.Parameter parameter) {
        Tree.TypedDeclaration typedDeclaration;
        if (parameter instanceof Tree.InitializerParameter) {
            return ((Tree.InitializerParameter)parameter).getSpecifierExpression();
        }
        if (parameter instanceof Tree.ValueParameterDeclaration) {
            Tree.TypedDeclaration typedDeclaration2 = ((Tree.ValueParameterDeclaration)parameter).getTypedDeclaration();
            if (typedDeclaration2 != null) {
                return ((Tree.AttributeDeclaration)typedDeclaration2).getSpecifierOrInitializerExpression();
            }
        } else if (parameter instanceof Tree.FunctionalParameterDeclaration && (typedDeclaration = ((Tree.FunctionalParameterDeclaration)parameter).getTypedDeclaration()) != null) {
            return ((Tree.MethodDeclaration)typedDeclaration).getSpecifierExpression();
        }
        return null;
    }

    public static Tree.TypedDeclaration getMemberDeclaration(Tree.Declaration def, final Tree.Parameter parameter) {
        if (parameter instanceof Tree.ParameterDeclaration) {
            return ((Tree.ParameterDeclaration)parameter).getTypedDeclaration();
        }
        if (parameter instanceof Tree.InitializerParameter) {
            final Tree.TypedDeclaration[] annotationList = new Tree.TypedDeclaration[]{null};
            def.visit(new Visitor(){

                @Override
                public void visit(Tree.MethodDeclaration that) {
                    if (that.getDeclarationModel().equals(parameter.getParameterModel().getModel())) {
                        annotationList[0] = that;
                    }
                }

                @Override
                public void visit(Tree.AttributeDeclaration that) {
                    if (that.getDeclarationModel().equals(parameter.getParameterModel().getModel())) {
                        annotationList[0] = that;
                    }
                }
            });
            return annotationList[0];
        }
        return null;
    }

    public static Tree.AnnotationList getAnnotations(Tree.AnyClass def, Tree.Parameter parameter) {
        return Decl.getMemberDeclaration(def, parameter).getAnnotationList();
    }

    public static boolean isParameter(Declaration decl) {
        return decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter();
    }

    public static boolean isFunctionalParameter(Declaration decl) {
        return decl instanceof Function && ((Function)decl).isParameter();
    }

    public static boolean isValueParameter(Declaration decl) {
        return decl instanceof Value && ((Value)decl).isParameter();
    }

    public static boolean isEnumeratedTypeWithAnonCases(Type parameterType) {
        if (parameterType.isBoolean()) {
            return false;
        }
        if (parameterType.getCaseTypes() == null) {
            return false;
        }
        for (Type type : parameterType.getCaseTypes()) {
            if (type.isClass() && type.getDeclaration().isAnonymous()) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnonCaseOfEnumeratedType(Tree.BaseMemberExpression term) {
        Declaration decl = term.getDeclaration();
        return Decl.isAnonCaseOfEnumeratedType(decl);
    }

    public static boolean isAnonCaseOfEnumeratedType(Declaration decl) {
        Type type;
        if (ModelUtil.isBooleanTrue(decl) || ModelUtil.isBooleanFalse(decl)) {
            return false;
        }
        if (decl instanceof Value && (type = ((Value)decl).getType()).isClass() && type.getDeclaration().isAnonymous()) {
            if (Decl.isEnumeratedTypeWithAnonCases(type.getExtendedType())) {
                return true;
            }
            for (Type s : type.getSatisfiedTypes()) {
                if (!Decl.isEnumeratedTypeWithAnonCases(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJavaStaticOrInterfacePrimary(Tree.Term term) {
        if (!(term instanceof Tree.QualifiedMemberOrTypeExpression)) {
            return false;
        }
        Declaration decl = ((Tree.QualifiedMemberOrTypeExpression)term).getDeclaration();
        return decl != null && (decl.isStaticallyImportable() || decl instanceof Interface) && !(decl instanceof Constructor);
    }

    public static boolean isConstructorPrimary(Tree.Term term) {
        if (term instanceof Tree.MemberOrTypeExpression) {
            Declaration decl = ((Tree.MemberOrTypeExpression)term).getDeclaration();
            return decl != null && (Decl.isConstructor(decl) || decl instanceof Class && ((Class)decl).hasConstructors());
        }
        return false;
    }

    public static boolean isPrivateAccessRequiringUpcast(Tree.StaticMemberOrTypeExpression qual) {
        if (qual instanceof Tree.QualifiedMemberOrTypeExpression) {
            Tree.Primary primary = ((Tree.QualifiedMemberOrTypeExpression)qual).getPrimary();
            Declaration decl = qual.getDeclaration();
            return decl.isMember() && !decl.isShared() && !(decl instanceof Constructor) && decl.getContainer() instanceof Class && !Decl.equalScopeDecl(decl.getContainer(), primary.getTypeModel().getDeclaration());
        }
        return false;
    }

    public static boolean isPrivateAccessRequiringCompanion(Tree.StaticMemberOrTypeExpression qual) {
        if (qual instanceof Tree.QualifiedMemberOrTypeExpression) {
            Tree.Primary primary = ((Tree.QualifiedMemberOrTypeExpression)qual).getPrimary();
            Declaration decl = qual.getDeclaration();
            return decl.isMember() && !decl.isShared() && decl.getContainer() instanceof Interface && !Decl.equalScopeDecl(decl.getContainer(), primary.getTypeModel().getDeclaration());
        }
        return false;
    }

    public static Type getPrivateAccessType(Tree.StaticMemberOrTypeExpression qmte) {
        return ((TypeDeclaration)qmte.getDeclaration().getRefinedDeclaration().getContainer()).getType();
    }

    public static Scope getNonConditionScope(Scope scope) {
        while (scope != null && scope instanceof ConditionScope) {
            scope = scope.getContainer();
        }
        return scope;
    }

    public static boolean isTopLevelObjectExpressionType(Declaration model) {
        return model instanceof Class && model.isAnonymous() && Decl.getNonSkippedContainer(model) instanceof Package && !model.isNamed();
    }

    public static boolean isObjectExpressionType(Declaration model) {
        return model instanceof Class && model.isAnonymous() && !model.isNamed();
    }

    public static Constructor getDefaultConstructor(Class c) {
        for (Declaration d : c.getMembers()) {
            if (!(d instanceof Constructor) || d.getName() != null) continue;
            return (Constructor)d;
        }
        return null;
    }

    public static boolean isDefaultConstructor(Constructor ctor) {
        return ctor.getName() == null || ctor.getName().isEmpty();
    }

    public static Class getConstructedClass(Declaration classOrCtor) {
        return ModelUtil.getConstructedClass(classOrCtor);
    }

    public static boolean hasAbstractConstructor(Class cls) {
        if (cls.hasConstructors()) {
            for (Declaration d : cls.getMembers()) {
                if (!(d instanceof Constructor) || !((Constructor)d).isAbstract()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasOnlyValueConstructors(Class cls) {
        if (cls.hasEnumerated()) {
            for (Declaration d : cls.getMembers()) {
                if (!(d instanceof Constructor) || ((Constructor)d).isValueConstructor()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasAnyValueConstructors(Class cls) {
        if (cls.hasEnumerated()) {
            for (Declaration d : cls.getMembers()) {
                if (!(d instanceof Constructor) || !((Constructor)d).isValueConstructor()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isEnumeratedConstructor(Constructor ctor) {
        return ModelUtil.isEnumeratedConstructor(ctor);
    }

    public static boolean isEnumeratedConstructor(Value value) {
        return ModelUtil.isEnumeratedConstructor(value);
    }

    public static Declaration getDeclarationScope(Scope scope) {
        while (!(scope instanceof Declaration)) {
            if (scope instanceof Package) {
                return null;
            }
            scope = scope.getContainer();
        }
        return (Declaration)((Object)scope);
    }

    public static boolean hasLocalNotInitializerAncestor(Declaration decl) {
        if (Decl.isLocalNotInitializer(decl)) {
            return true;
        }
        for (Scope container = decl.getContainer(); container != null; container = container.getContainer()) {
            if (!ModelUtil.isLocalNotInitializerScope(container)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstructor(Declaration decl) {
        return Decl.getConstructor(decl) != null;
    }

    public static Constructor getConstructor(Declaration decl) {
        return ModelUtil.getConstructor(decl);
    }

    public static Scope getNonSkippedContainer(Declaration decl) {
        if (decl instanceof Scope) {
            return Decl.getNonSkippedContainer((Scope)((Object)decl));
        }
        return Decl.getNonSkippedContainer(decl.getContainer());
    }

    public static Scope getNonSkippedContainer(Scope object) {
        Scope scope = object.getContainer();
        while (Decl.skipContainer(scope)) {
            scope = scope.getContainer();
        }
        return scope;
    }

    public static Scope getFirstDeclarationContainer(Scope object) {
        Scope scope = object.getContainer();
        while (!(scope instanceof Package) && !(scope instanceof Declaration)) {
            scope = scope.getContainer();
        }
        return scope;
    }

    public static boolean skipContainer(Scope container) {
        if (container instanceof Function && ((Declaration)((Object)container)).isAnonymous()) {
            return true;
        }
        return container instanceof Value && !((Value)container).isTransient();
    }

    public static boolean isValueConstructor(Declaration member) {
        return member instanceof Value && ((Value)member).getTypeDeclaration() instanceof Constructor;
    }

    public static boolean isDynamic(Declaration decl) {
        if (decl instanceof TypeDeclaration) {
            return ((TypeDeclaration)decl).isDynamic();
        }
        if (decl instanceof TypedDeclaration) {
            return ((TypedDeclaration)decl).isDynamicallyTyped();
        }
        return false;
    }
}

