/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.HasTypeVisitor;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class LocalTypeVisitor
extends Visitor {
    private HasTypeVisitor hasTypeVisitor = new HasTypeVisitor();
    private Set<String> locals = new HashSet<String>();
    private Set<String> ignored = new HashSet<String>();
    private Set<String> localCompanionClasses = new HashSet<String>();
    private Set<Interface> localInterfaces = new HashSet<Interface>();
    private LinkedList<Integer> anonymous = new LinkedList();
    private String prefix;

    public LocalTypeVisitor() {
        this.anonymous.add(1);
        this.prefix = "";
    }

    public Set<String> getLocals() {
        this.locals.removeAll(this.ignored);
        return this.locals;
    }

    public Set<Interface> getLocalInterfaces() {
        return this.localInterfaces;
    }

    private void collect(Node that, Declaration model) {
        if (model != null && (!model.isMember() || Decl.isObjectExpressionType(model))) {
            String prefixedName;
            String name = Naming.escapeClassName(model.getName());
            Set<String> locals = this.locals;
            if (model instanceof Value && !model.isToplevel()) {
                name = Naming.suffixName(NamingBase.Suffix.$getter$, name);
            }
            if (model instanceof TypedDeclaration || model.isAnonymous()) {
                name = name + "_";
            } else if (model instanceof Interface) {
                this.localInterfaces.add((Interface)model);
                name = Naming.suffixName(NamingBase.Suffix.$impl, name);
                locals = this.localCompanionClasses;
            }
            int i = 1;
            while (locals.contains(prefixedName = this.prefix + i + name)) {
                ++i;
            }
            locals.add(prefixedName);
            if (model instanceof TypedDeclaration && !this.hasTypeVisitor.hasType(that)) {
                this.ignored.add(prefixedName);
            }
        }
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        int i;
        Function model = that.getDeclarationModel();
        int mpl = model.getParameterLists().size();
        String prefix = null;
        if (mpl > 1) {
            prefix = this.prefix;
            for (i = 1; i < mpl; ++i) {
                this.enterAnonymousClass();
            }
        }
        this.collect(that, model);
        if (model.isMember()) {
            super.visit(that);
        }
        if (mpl > 1) {
            for (i = 1; i < mpl; ++i) {
                this.exitAnonymousClass();
            }
            this.prefix = prefix;
        }
    }

    @Override
    public void visit(Tree.FunctionalParameterDeclaration that) {
        Tree.TypedDeclaration typedDeclaration = that.getTypedDeclaration();
        boolean anon = typedDeclaration instanceof Tree.MethodDeclaration && ((Tree.MethodDeclaration)typedDeclaration).getSpecifierExpression() instanceof Tree.LazySpecifierExpression;
        String prefix = this.prefix;
        if (anon) {
            this.enterAnonymousClass();
        }
        super.visit(that);
        if (anon) {
            this.exitAnonymousClass();
        }
        this.prefix = prefix;
    }

    private void exitAnonymousClass() {
        this.anonymous.pop();
        Integer count = this.anonymous.peek();
        this.anonymous.set(0, count + 1);
    }

    private void enterAnonymousClass() {
        this.anonymous.push(1);
        this.prefix = this.getPrefix();
    }

    private String getPrefix() {
        StringBuilder b = new StringBuilder();
        for (int i = this.anonymous.size() - 1; i > 0; --i) {
            Integer c = this.anonymous.get(i);
            b.append(c).append("$");
        }
        return b.toString();
    }

    @Override
    public void visit(Tree.Comprehension that) {
        String prefix = this.prefix;
        this.enterAnonymousClass();
        this.enterAnonymousClass();
        super.visit(that);
        this.exitAnonymousClass();
        this.exitAnonymousClass();
        this.prefix = prefix;
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        String prefix = this.prefix;
        this.enterAnonymousClass();
        super.visit(that);
        this.exitAnonymousClass();
        this.prefix = prefix;
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        String prefix = this.prefix;
        this.enterAnonymousClass();
        super.visit(that);
        this.exitAnonymousClass();
        this.prefix = prefix;
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression that) {
        if (that.getMemberOperator() instanceof Tree.SpreadOp) {
            String prefix = this.prefix;
            this.enterAnonymousClass();
            super.visit(that);
            this.exitAnonymousClass();
            this.prefix = prefix;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.BaseMemberOrTypeExpression that) {
        Declaration model = that.getDeclaration();
        if (model != null && (model instanceof Function || model instanceof Class) && !model.isParameter() && !that.getDirectlyInvoked()) {
            String prefix = this.prefix;
            this.enterAnonymousClass();
            super.visit(that);
            this.exitAnonymousClass();
            this.prefix = prefix;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.SequenceEnumeration that) {
        if (that.getSequencedArgument() == null) {
            super.visit(that);
        } else {
            String prefix = this.prefix;
            this.enterAnonymousClass();
            super.visit(that);
            this.exitAnonymousClass();
            this.prefix = prefix;
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        Value model = that.getDeclarationModel();
        this.collect(that, model);
        if (model.isMember()) {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        Setter model = that.getDeclarationModel();
        if (model.isMember()) {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
    }

    @Override
    public void visit(Tree.ClassOrInterface that) {
        ClassOrInterface model = that.getDeclarationModel();
        if (!model.isAlias()) {
            this.collect(that, model);
        }
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        Value model = that.getDeclarationModel();
        if (model != null) {
            this.collect(that, model.getTypeDeclaration());
        }
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        Value model = that.getDeclarationModel();
        if (model != null) {
            this.collect(that, model.getTypeDeclaration());
        }
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        Class model = that.getAnonymousClass();
        if (model != null) {
            this.collect(that, model);
        }
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        if (that.getBlock() != null) {
            Value model = that.getDeclarationModel();
            if (model != null) {
                this.collect(that, model);
            }
        } else {
            super.visit(that);
        }
    }

    public void startFrom(Node tree) {
        Function model;
        int mpl = 0;
        String prefix = null;
        if (tree instanceof Tree.AnyMethod && (mpl = (model = ((Tree.AnyMethod)tree).getDeclarationModel()).getParameterLists().size()) > 1) {
            prefix = this.prefix;
            for (int i = 1; i < mpl; ++i) {
                this.enterAnonymousClass();
            }
        }
        tree.visitChildren(this);
        if (mpl > 1) {
            for (int i = 1; i < mpl; ++i) {
                this.exitAnonymousClass();
            }
            this.prefix = prefix;
        }
    }
}

