/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.BooleanUtil;
import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CeylonVisitor;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.Optimization;
import com.redhat.ceylon.compiler.java.codegen.Transformer;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.typechecker.tree.CustomTree;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.langtools.tools.javac.main.OptionName;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.DiagnosticSource;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.ConditionScope;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StatementTransformer
extends AbstractTransformer {
    private Name currentForFailVariable = null;
    boolean noExpressionlessReturn = false;
    private final Set<Optimization> disabledOptimizations;
    private final Transformer<JCTree.JCStatement, Tree.Return> defaultReturnTransformer = new DefaultReturnTransformer();
    private Transformer<JCTree.JCStatement, Tree.Return> returnTransformer = this.defaultReturnTransformer;
    private final Transformer<com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement>, Tree.Break> defaultBreakTransformer = new DefaultBreakTransformer();
    private final Transformer<JCTree.JCStatement, Tree.Continue> defaultContinueTransformer = new DefaultContinueTransformer();
    private Transformer<JCTree.JCStatement, Tree.Continue> continueTransformer = this.defaultContinueTransformer;
    private Tree.ControlClause currentForClause = null;
    private HashMap<Value, DeferredSpecification> deferredSpecifications = new HashMap();
    final TryResourceTransformation destroyableResource = new TryResourceTransformation(){

        @Override
        public Type getType() {
            return StatementTransformer.this.typeFact().getDestroyableType();
        }

        @Override
        public String getInitMethodName() {
            return null;
        }

        @Override
        public String getRecoverMethodName() {
            return "destroy";
        }

        @Override
        public JCTree.JCExpression makeRecover(JCTree.JCExpression resVar1, JCTree.JCExpression thrownException) {
            return StatementTransformer.this.make().Apply(null, StatementTransformer.this.makeQualIdent(resVar1, this.getRecoverMethodName()), com.redhat.ceylon.langtools.tools.javac.util.List.of(thrownException));
        }
    };
    final TryResourceTransformation obtainableResource = new TryResourceTransformation(){

        @Override
        public Type getType() {
            return StatementTransformer.this.typeFact().getObtainableType();
        }

        @Override
        public String getInitMethodName() {
            return "obtain";
        }

        @Override
        public String getRecoverMethodName() {
            return "release";
        }

        @Override
        public JCTree.JCExpression makeRecover(JCTree.JCExpression resVar1, JCTree.JCExpression thrownException) {
            return StatementTransformer.this.make().Apply(null, StatementTransformer.this.makeQualIdent(resVar1, this.getRecoverMethodName()), com.redhat.ceylon.langtools.tools.javac.util.List.of(thrownException));
        }
    };
    final TryResourceTransformation javaAutoCloseableResource = new TryResourceTransformation(){

        @Override
        public Type getType() {
            return StatementTransformer.this.javacJavaTypeToProducedType(StatementTransformer.this.syms().autoCloseableType);
        }

        @Override
        public String getInitMethodName() {
            return null;
        }

        @Override
        public String getRecoverMethodName() {
            return "close";
        }

        @Override
        public JCTree.JCExpression makeRecover(JCTree.JCExpression resVar1, JCTree.JCExpression thrownException) {
            return StatementTransformer.this.make().Apply(null, StatementTransformer.this.makeQualIdent(resVar1, this.getRecoverMethodName()), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        }
    };

    public static StatementTransformer getInstance(Context context) {
        StatementTransformer trans = context.get(StatementTransformer.class);
        if (trans == null) {
            trans = new StatementTransformer(context);
            context.put(StatementTransformer.class, trans);
        }
        return trans;
    }

    private StatementTransformer(Context context) {
        super(context);
        Options options = context.get(Options.optionsKey);
        if (options.isSet(OptionName.CEYLONDISABLEOPT)) {
            this.disabledOptimizations = EnumSet.allOf(Optimization.class);
        } else if (options.isSet(OptionName.CEYLONDISABLEOPT_CUSTOM)) {
            this.disabledOptimizations = new HashSet<Optimization>();
            for (String name : options.get(OptionName.CEYLONDISABLEOPT_CUSTOM).split(",")) {
                this.disabledOptimizations.add(Optimization.valueOf(name));
            }
        } else {
            this.disabledOptimizations = EnumSet.noneOf(Optimization.class);
        }
    }

    public JCTree.JCBlock transform(Tree.Block block) {
        return block == null ? null : this.at(block).Block(0L, this.transformBlock(block));
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformBlock(Tree.Block block) {
        return this.transformBlock(block, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformBlock(Tree.Block block, boolean revertRet) {
        com.redhat.ceylon.langtools.tools.javac.util.List<? extends JCTree> result;
        if (block == null) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        this.at(block);
        CeylonVisitor v = this.gen().visitor;
        ListBuffer<JCTree> prevDefs = v.defs;
        boolean prevInInitializer = v.inInitializer;
        ClassDefinitionBuilder prevClassBuilder = v.classBuilder;
        try {
            v.defs = new ListBuffer();
            v.inInitializer = false;
            v.classBuilder = this.current();
            for (Tree.Statement stmt : block.getStatements()) {
                Transformer<JCTree.JCStatement, Tree.Return> returnTransformer = revertRet && stmt instanceof Tree.Declaration ? this.returnTransformer(this.defaultReturnTransformer) : this.returnTransformer;
                try {
                    HasErrorException error = this.errors().getFirstErrorBlock(stmt);
                    if (error == null) {
                        stmt.visit(v);
                        continue;
                    }
                    v.append(this.makeThrowUnresolvedCompilationError(error));
                    break;
                }
                finally {
                    this.returnTransformer(returnTransformer);
                }
            }
            result = v.getResult().toList();
        }
        finally {
            v.classBuilder = prevClassBuilder;
            v.inInitializer = prevInInitializer;
            v.defs = prevDefs;
            Scope scope = block.getScope();
            while (scope instanceof ConditionScope) {
                scope = scope.getScope();
            }
            this.naming.closeScopedSubstitutions(scope);
        }
        return result;
    }

    private boolean definitelySatisfiedOrNot(List<Tree.Condition> conditions, boolean satisfied) {
        if (conditions.size() != 1) {
            return false;
        }
        Tree.Condition condition = conditions.get(0);
        if (!(condition instanceof Tree.BooleanCondition)) {
            return false;
        }
        Tree.Term term = ((Tree.BooleanCondition)condition).getExpression().getTerm();
        if (!(term instanceof Tree.BaseMemberExpression)) {
            return false;
        }
        Declaration declaration = ((Tree.BaseMemberExpression)term).getDeclaration();
        return declaration instanceof Value && satisfied ? this.isBooleanTrue(declaration) : this.isBooleanFalse(declaration);
    }

    boolean definitelySatisfied(List<Tree.Condition> conditions) {
        return this.definitelySatisfiedOrNot(conditions, true);
    }

    boolean definitelyNotSatisfied(List<Tree.Condition> conditions) {
        return this.definitelySatisfiedOrNot(conditions, false);
    }

    JCTree.JCStatement makeFlowAppeaser(Node node) {
        this.at(node);
        return this.make().Throw(this.make().NewClass(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.make().Type(this.syms().errorType), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Literal("Ceylon flow error")), null));
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transform(Tree.IfStatement stmt) {
        Tree.Block thenPart = stmt.getIfClause().getBlock();
        Tree.Block elsePart = stmt.getElseClause() != null ? stmt.getElseClause().getBlock() : null;
        List<Tree.Condition> conditions = stmt.getIfClause().getConditionList().getConditions();
        Tree.Variable elseVar = stmt.getElseClause() != null ? stmt.getElseClause().getVariable() : null;
        return this.transformIf(conditions, thenPart, elseVar, elsePart);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIf(List<Tree.Condition> conditions, Tree.Block thenPart, Tree.Variable elseVar, Tree.Block elsePart) {
        return new IfCondList(conditions, thenPart, elseVar, elsePart).getResult();
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIf(List<Tree.Condition> conditions, Tree.Expression thenPart, Tree.Variable elseVar, Tree.Expression elsePart, String tmpVar, Tree.Term outerExpression, Type expectedType) {
        return new IfCondList(conditions, thenPart, elseVar, elsePart, tmpVar, outerExpression, expectedType).getResult();
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> evaluateAndAssign(String tmpVar, Tree.Expression expr, Tree.Term outerExpression, Type expectedType) {
        this.at(expr);
        if (expectedType == null) {
            expectedType = outerExpression.getTypeModel();
        }
        if (!expectedType.getDeclaration().isAnonymous()) {
            expectedType = this.typeFact().denotableType(expectedType);
        }
        AbstractTransformer.BoxingStrategy boxingStrategy = CodegenUtil.getBoxingStrategy(outerExpression);
        if (!expr.getTypeModel().isNothing() && expr.getTypeModel().isSubtypeOf(this.typeFact().getNullType())) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(this.expressionGen().transformExpression(expr, boxingStrategy, expectedType)), this.make().Exec(this.make().Assign(this.makeUnquotedIdent(tmpVar), this.makeNull())));
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(this.make().Assign(this.makeUnquotedIdent(tmpVar), this.expressionGen().transformExpression(expr, boxingStrategy, expectedType))));
    }

    private JCTree.JCBlock makeThenBlock(Cond cond, Node thenPart, Naming.Substitution subs, String tmpVar, Tree.Term outerExpression, Type expectedType) {
        com.redhat.ceylon.langtools.tools.javac.util.List<Object> blockStmts = thenPart instanceof Tree.Block ? this.statementGen().transformBlock((Tree.Block)thenPart) : (thenPart instanceof Tree.Expression ? this.evaluateAndAssign(tmpVar, (Tree.Expression)thenPart, outerExpression, expectedType) : (thenPart == null ? com.redhat.ceylon.langtools.tools.javac.util.List.nil() : com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(this.makeErroneous(thenPart, "Only block or expression allowed")))));
        if (subs != null) {
            blockStmts = blockStmts.prepend(this.at(cond.getCondition()).VarDef(this.make().Modifiers(16L), this.names().fromString(subs.substituted), cond.getVarTrans().makeTypeExpr(), cond.getVarTrans().makeResultExpr()));
        }
        JCTree.JCBlock thenBlock = this.at(cond.getCondition()).Block(0L, blockStmts);
        return thenBlock;
    }

    protected JCTree.JCStatement makeElseBlock(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts) {
        if (stmts != null) {
            return this.make().Block(0L, stmts);
        }
        return null;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transform(Tree.WhileStatement stmt) {
        Name tempForFailVariable = this.currentForFailVariable;
        this.currentForFailVariable = null;
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> res = new WhileCondList(stmt.getWhileClause()).getResult();
        this.currentForFailVariable = tempForFailVariable;
        return res;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transform(Tree.Assertion ass) {
        return new AssertCondList(ass).getResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDocAnnotationText(Tree.Assertion ass) {
        String docText = null;
        Tree.Annotation doc = this.getAnnotation(ass.getAnnotationList(), "doc");
        if (doc != null) {
            Node arg;
            Tree.Expression expression = null;
            if (doc.getPositionalArgumentList() != null) {
                arg = doc.getPositionalArgumentList().getPositionalArguments().get(0);
                if (!(arg instanceof Tree.ListedArgument)) throw new BugException(arg, "argument to doc annotation cannot be a spread argument or comprehension: " + arg);
                expression = ((Tree.ListedArgument)arg).getExpression();
            } else {
                if (doc.getNamedArgumentList() == null) return null;
                arg = (Tree.SpecifiedArgument)doc.getNamedArgumentList().getNamedArguments().get(0);
                expression = ((Tree.SpecifiedArgument)arg).getSpecifierExpression().getExpression();
            }
            Tree.Literal literal = (Tree.Literal)expression.getTerm();
            return literal.getText();
        }
        if (ass.getAnnotationList() == null) return docText;
        if (ass.getAnnotationList().getAnonymousAnnotation() == null) return docText;
        return ass.getAnnotationList().getAnonymousAnnotation().getStringLiteral().getText();
    }

    private Tree.Annotation getAnnotation(Tree.AnnotationList al, String name) {
        if (al != null) {
            for (Tree.Annotation a : al.getAnnotations()) {
                Tree.BaseMemberExpression p = (Tree.BaseMemberExpression)a.getPrimary();
                if (p == null || !p.getIdentifier().getText().equals(name)) continue;
                return a;
            }
        }
        return null;
    }

    private String getSourceCode(Node node) {
        StringBuilder sb = new StringBuilder();
        DiagnosticSource source = new DiagnosticSource(this.gen().getFileObject(), Log.instance(this.gen().getContext()));
        int startLine = node.getToken().getLine();
        int endLine = node.getEndToken().getLine();
        for (int lineNumber = startLine; lineNumber <= endLine; ++lineNumber) {
            int startPos = this.gen().getMap().getPosition(lineNumber, 1);
            String line = source.getLine(startPos);
            if (lineNumber == endLine) {
                line = line.substring(0, node.getEndToken().getCharPositionInLine() + node.getEndToken().getText().length());
            }
            if (lineNumber == startLine) {
                line = line.substring(node.getToken().getCharPositionInLine());
            }
            sb.append(line).append("\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private Type actualType(Tree.TypedDeclaration decl) {
        return decl.getType().getTypeModel();
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transform(Tree.ForStatement stmt) {
        ForStatementTransformation transformation;
        Tree.QualifiedMemberExpression qme;
        Type primaryType;
        Type iterableType;
        Tree.InvocationExpression invocation;
        Tree.Term iterableTerm;
        Tree.Term baseIterable = iterableTerm = ExpressionTransformer.eliminateParens(stmt.getForClause().getForIterator().getSpecifierExpression().getExpression().getTerm());
        Tree.Term step = null;
        if (this.isJavaIterable(iterableTerm.getTypeModel())) {
            return new JavaIterationTransformation(stmt).transform();
        }
        if (iterableTerm instanceof Tree.InvocationExpression && (invocation = (Tree.InvocationExpression)iterableTerm).getPrimary() instanceof Tree.QualifiedMemberExpression && (iterableType = (primaryType = (qme = (Tree.QualifiedMemberExpression)invocation.getPrimary()).getPrimary().getTypeModel()).getSupertype(this.typeFact().getIterableDeclaration())) != null && "by".equals(qme.getIdentifier().getText())) {
            Tree.NamedArgument positionalArgument;
            if (invocation.getPositionalArgumentList() != null) {
                Tree.PositionalArgument positionalArgument2 = invocation.getPositionalArgumentList().getPositionalArguments().get(0);
                if (positionalArgument2 instanceof Tree.ListedArgument) {
                    step = ((Tree.ListedArgument)positionalArgument2).getExpression().getTerm();
                    baseIterable = ExpressionTransformer.eliminateParens(qme.getPrimary());
                }
            } else if (invocation.getNamedArgumentList() != null && (positionalArgument = invocation.getNamedArgumentList().getNamedArguments().get(0)) instanceof Tree.SpecifiedArgument) {
                step = ((Tree.SpecifiedArgument)positionalArgument).getSpecifierExpression().getExpression().getTerm();
                baseIterable = ExpressionTransformer.eliminateParens(qme.getPrimary());
            }
        }
        if ((transformation = this.stringIteration(stmt, baseIterable, step)) == null) {
            transformation = this.arrayIteration(stmt, baseIterable, step);
        }
        if (transformation == null) {
            transformation = this.segmentOpIteration(stmt, baseIterable, step);
        }
        if (transformation == null) {
            transformation = this.spanOpIteration(stmt);
        }
        if (transformation == null) {
            transformation = new ForStatementTransformation(stmt);
        }
        return transformation.transform();
    }

    protected boolean isJavaIterable(Type iterableType) {
        return iterableType.getSupertype((TypeDeclaration)this.javacJavaTypeDeclaration(this.syms().iterableType)) != null;
    }

    private ForStatementTransformation stringIteration(Tree.ForStatement stmt, Tree.Term baseIterable, Tree.Term step) {
        if (step == null && baseIterable.getTypeModel().getSupertype(this.typeFact().getStringDeclaration()) != null) {
            return new StringIterationOptimization(stmt, baseIterable, step);
        }
        return null;
    }

    private ForStatementTransformation arrayIteration(Tree.ForStatement stmt, Tree.Term baseIterable, Tree.Term step) {
        Type ceylonArrayType = baseIterable.getTypeModel();
        if (this.typeFact().isJavaArrayType(ceylonArrayType)) {
            return new JavaArrayIterationOptimization(false, stmt, baseIterable, step, this.typeFact().getJavaArrayElementType(ceylonArrayType), ceylonArrayType);
        }
        Type elementType = this.typeFact().getArrayElementType(ceylonArrayType);
        if (elementType == null) {
            Tree.QualifiedMemberExpression expr;
            if (baseIterable instanceof Tree.QualifiedMemberExpression && "iterable".equals((expr = (Tree.QualifiedMemberExpression)baseIterable).getIdentifier().getText()) && Decl.isJavaArray(expr.getPrimary().getTypeModel().getDeclaration())) {
                if (this.isOptimizationDisabled(stmt, Optimization.JavaArrayIterationStatic)) {
                    return (ForStatementTransformation)this.optimizationDisabled(stmt, Optimization.JavaArrayIterationStatic);
                }
                elementType = this.typeFact().getIteratedType(ceylonArrayType);
                return new JavaArrayIterationOptimization(true, stmt, baseIterable, step, elementType, expr.getPrimary().getTypeModel());
            }
        } else {
            if (this.isOptimizationRequired(stmt, Optimization.JavaArrayIterationStatic)) {
                return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.JavaArrayIterationStatic, "iterable expression wasn't of form javaArray.array");
            }
            if (this.isOptimizationDisabled(stmt, Optimization.ArrayIterationStatic)) {
                return (ForStatementTransformation)this.optimizationDisabled(stmt, Optimization.ArrayIterationStatic);
            }
            return new ArrayIterationOptimization(stmt, baseIterable, step, ceylonArrayType);
        }
        if (this.isOptimizationRequired(stmt, Optimization.JavaArrayIterationStatic)) {
            return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.JavaArrayIterationStatic, "iterable expression wasn't of form javaArray.iterable");
        }
        if (this.isOptimizationRequired(stmt, Optimization.ArrayIterationStatic)) {
            return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.ArrayIterationStatic, "static type of iterable in for statement is not Array");
        }
        return null;
    }

    private boolean isSpanOf(Tree.RangeOp range, Type ofType) {
        Type rangeType = range.getTypeModel();
        return this.typeFact().getSpanType(ofType).isExactly(rangeType);
    }

    private <T, S extends Tree.StatementOrArgument> T optimizationFailed(S stmt, Optimization optName, String reason) {
        return this.optimizationFailed(stmt, new Optimization[]{optName}, reason);
    }

    private <T, S extends Tree.StatementOrArgument> T optimizationFailed(S stmt, Optimization[] optNames, String reason) {
        for (Optimization optName : optNames) {
            if (!CodegenUtil.hasCompilerAnnotationWithArgument(stmt, "requireOptimization", optName.toString())) continue;
            this.log.error(this.getPosition(stmt), "ceylon.optim.failed", new Object[]{optName, reason});
        }
        return null;
    }

    private <T, S extends Tree.StatementOrArgument> T optimizationDisabled(S stmt, Optimization optName) {
        return this.optimizationFailed(stmt, optName, "optimization explicitly disabled by @disableOptimization");
    }

    private boolean isOptimizationDisabled(Tree.StatementOrArgument stmt, Optimization optName) {
        return this.disabledOptimizations.contains((Object)optName) || CodegenUtil.hasCompilerAnnotationNoArgument(stmt, "disableOptimization") || CodegenUtil.hasCompilerAnnotationWithArgument(stmt, "disableOptimization", optName.toString());
    }

    private boolean isOptimizationRequired(Tree.StatementOrArgument stmt, Optimization optName) {
        return optName == null ? CodegenUtil.hasCompilerAnnotationNoArgument(stmt, "requireOptimization") : CodegenUtil.hasCompilerAnnotationWithArgument(stmt, "requireOptimization", optName.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ForStatementTransformation spanOpIteration(Tree.ForStatement stmt) {
        com.redhat.ceylon.langtools.tools.javac.code.Type type;
        Tree.RangeOp range;
        Tree.Term increment;
        if (this.isOptimizationDisabled(stmt, Optimization.SpanOpIteration)) {
            return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "optimization explicitly disabled by @disableOptimization");
        }
        Tree.ForIterator iterator = stmt.getForClause().getForIterator();
        if (!(iterator instanceof Tree.ValueIterator)) {
            return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "optimization applies only to ValueIterators");
        }
        Tree.ValueIterator vi = (Tree.ValueIterator)iterator;
        Tree.SpecifierExpression specifier = vi.getSpecifierExpression();
        Tree.Term term = specifier.getExpression().getTerm();
        if (term instanceof Tree.RangeOp) {
            increment = null;
            range = (Tree.RangeOp)term;
        } else {
            if (!(term instanceof Tree.InvocationExpression)) return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "Only applies to Iterables of the form 'lhs..rhs' or '(lhs..rhs).by(step)'");
            Tree.InvocationExpression inv = (Tree.InvocationExpression)term;
            if (!(inv.getPrimary() instanceof Tree.QualifiedMemberExpression)) return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "Only applies to Iterables of the form 'lhs..rhs' or '(lhs..rhs).by(step)'");
            Tree.QualifiedMemberExpression prim = (Tree.QualifiedMemberExpression)inv.getPrimary();
            if (!"by".equals(prim.getIdentifier().getText()) || !(prim.getPrimary() instanceof Tree.Expression) || !(((Tree.Expression)prim.getPrimary()).getTerm() instanceof Tree.RangeOp)) return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "Only applies to Iterables of the form 'lhs..rhs' or '(lhs..rhs).by(step)'");
            range = (Tree.RangeOp)((Tree.Expression)prim.getPrimary()).getTerm();
            if (inv.getPositionalArgumentList() != null) {
                Tree.PositionalArgument a = inv.getPositionalArgumentList().getPositionalArguments().get(0);
                if (!(a instanceof Tree.ListedArgument)) return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "Unable to determine expression for argument to by(): appears spread or comprehension");
                increment = ((Tree.ListedArgument)a).getExpression().getTerm();
            } else {
                if (inv.getNamedArgumentList() == null) return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "Unable to get arguments to by()");
                Tree.SpecifiedArgument sarg = null;
                for (Tree.NamedArgument arg : inv.getNamedArgumentList().getNamedArguments()) {
                    if (!"step".equals(arg.getIdentifier().getText()) || !(arg instanceof Tree.SpecifiedArgument)) continue;
                    sarg = (Tree.SpecifiedArgument)arg;
                    break;
                }
                if (sarg == null) return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "Unable to determine expression for argument to by{}");
                increment = sarg.getSpecifierExpression().getExpression().getTerm();
            }
        }
        Type integerType = this.typeFact().getIntegerType();
        Type characterType = this.typeFact().getCharacterType();
        if (this.isSpanOf(range, integerType)) {
            type = this.syms().longType;
            return increment == null ? new SpanOpIterationOptimization(stmt, range, increment, type) : new SpanOpWithStepIterationOptimization(stmt, range, increment, type);
        } else {
            if (!this.isSpanOf(range, characterType)) return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SpanOpIteration, "The RangeOp doesn't produce a Range<Integer>/Range<Character>");
            type = this.syms().intType;
        }
        return increment == null ? new SpanOpIterationOptimization(stmt, range, increment, type) : new SpanOpWithStepIterationOptimization(stmt, range, increment, type);
    }

    private ForStatementTransformation segmentOpIteration(Tree.ForStatement stmt, Tree.Term baseIterable, Tree.Term step) {
        if (!(baseIterable instanceof Tree.SegmentOp)) {
            return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SegmentOpIteration, "base iterable is no a segment op");
        }
        Tree.SegmentOp op = (Tree.SegmentOp)baseIterable;
        Type iteratedType = this.typeFact().getIteratedType(op.getTypeModel());
        if (!iteratedType.isExactly(this.typeFact().getIntegerType()) && !iteratedType.isExactly(this.typeFact().getCharacterType())) {
            return (ForStatementTransformation)this.optimizationFailed(stmt, Optimization.SegmentOpIteration, "base iterable is neither Range<Integer> not Range<Character>");
        }
        Tree.Term start = op.getLeftTerm();
        Tree.Term length = op.getRightTerm();
        if (this.isOptimizationDisabled(stmt, Optimization.SegmentOpIteration)) {
            return (ForStatementTransformation)this.optimizationDisabled(stmt, Optimization.SegmentOpIteration);
        }
        return new SegmentOpIteration(stmt, op, step, start, length);
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIterableIteration(Node node, Name label, Naming.SyntheticName iterationVarName, Naming.SyntheticName iteratorVarName, Type iterableType, Type iteratedType, JCTree.JCExpression iterableExpr, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> itemDecls, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> bodyStmts, boolean allowArrayOpt, boolean allowArraySeqOpt) {
        JCTree.JCExpression getIter;
        JCTree.JCExpression cond;
        Naming.SyntheticName arrayLength;
        Type iteratorElementType = iteratedType;
        ListBuffer result = ListBuffer.lb();
        boolean optForArray = allowArrayOpt && this.typeFact().getArrayType(iteratedType).isSubtypeOf(iterableType);
        boolean optForTuple = allowArraySeqOpt && this.typeFact().getTupleType(Collections.singletonList(iteratedType), true, false, -1).isSubtypeOf(iterableType);
        Naming.SyntheticName iterableName = optForArray || optForTuple ? this.naming.alias("iterable") : null;
        Naming.SyntheticName isArrayName = optForArray ? this.naming.alias("isArray") : null;
        Naming.SyntheticName isTupleName = optForTuple ? this.naming.alias("isTuple") : null;
        Naming.SyntheticName arrayIndex = optForArray || optForTuple ? this.naming.alias("i") : null;
        Naming.SyntheticName syntheticName = arrayLength = optForArray || optForTuple ? this.naming.alias("length") : null;
        if (optForArray || optForTuple) {
            result.append(this.makeVar(16L, iterableName, this.makeJavaType(this.typeFact().getIterableType(iteratorElementType)), iterableExpr));
        }
        if (optForArray) {
            result.append(this.makeVar(16L, isArrayName, this.make().Type(this.syms().booleanType), (JCTree.JCExpression)this.make().TypeTest(iterableName.makeIdent(), this.makeJavaType(this.typeFact().getArrayType(iteratorElementType), 8))));
        }
        if (optForTuple) {
            result.append(this.makeVar(16L, isTupleName, this.make().Type(this.syms().booleanType), (JCTree.JCExpression)this.make().Binary(58, this.make().TypeTest(iterableName.makeIdent(), this.make().QualIdent(this.syms().ceylonTupleType.tsym)), this.make().Binary(63, this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)this.make().TypeCast(this.make().QualIdent(this.syms().ceylonTupleType.tsym), (JCTree.JCExpression)iterableName.makeIdent()), NamingBase.Unfix.$getArray$.toString()), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), this.makeNull()))));
        }
        JCTree.JCVariableDecl elemDecl = this.makeVar(iterationVarName, this.make().Type(this.syms().objectType), (JCTree.JCExpression)(optForArray || optForTuple ? this.makeNull() : null));
        result.append(elemDecl);
        Naming.SyntheticName iterName = iteratorVarName;
        Type iteratorType = this.typeFact().getIteratorType(iteratorElementType);
        JCTree.JCExpression iteratorTypeExpr = this.makeJavaType(iteratorType, 1028);
        if (optForArray || optForTuple) {
            this.at(node);
            result.append(this.makeVar(arrayIndex, this.make().Type(this.syms().intType), (JCTree.JCExpression)this.make().Literal(0)));
            result.append(this.makeVar(16L, arrayLength, this.make().Type(this.syms().intType), null));
            ListBuffer whenTupleOrArray = ListBuffer.lb();
            whenTupleOrArray.append(this.make().Exec(this.make().Assign(arrayLength.makeIdent(), this.make().TypeCast(this.make().Type(this.syms().intType), (JCTree.JCExpression)this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)iterableName.makeIdent(), "getSize"), com.redhat.ceylon.langtools.tools.javac.util.List.nil())))));
            ListBuffer whenIterable = ListBuffer.lb();
            whenIterable.append(this.make().Exec(this.make().Assign(arrayLength.makeIdent(), this.make().Literal(0))));
            cond = optForArray && optForTuple ? this.make().Binary(57, isArrayName.makeIdent(), isTupleName.makeIdent()) : (optForArray ? isArrayName.makeIdent() : isTupleName.makeIdent());
            result.append(this.make().If(cond, this.make().Block(0L, whenTupleOrArray.toList()), this.make().Block(0L, whenIterable.toList())));
            getIter = this.make().Conditional(optForArray && optForTuple ? this.make().Binary(57, isTupleName.makeIdent(), isArrayName.makeIdent()) : (optForArray ? isArrayName.makeIdent() : isTupleName.makeIdent()), this.makeNull(), this.make().Apply(null, this.makeSelect(iterableName.makeIdent(), "iterator"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
        } else {
            getIter = this.at(node).Apply(null, this.makeSelect(iterableExpr, "iterator"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        }
        getIter = this.gen().expressionGen().applyErasureAndBoxing(getIter, iteratorType, true, AbstractTransformer.BoxingStrategy.BOXED, iteratorType);
        JCTree.JCVariableDecl iteratorDecl = this.at(node).VarDef(this.make().Modifiers(0L), iterName.asName(), iteratorTypeExpr, getIter);
        result.append(iteratorDecl);
        ListBuffer loopBody = ListBuffer.lb();
        if (optForArray || optForTuple) {
            cond = optForArray && optForTuple ? this.make().Binary(57, isArrayName.makeIdent(), isTupleName.makeIdent()) : (optForArray ? isArrayName.makeIdent() : isTupleName.makeIdent());
            loopBody.append(this.make().If(cond, this.make().Exec(this.make().Assign(iterationVarName.makeIdent(), this.make().Apply(null, this.naming.makeQualIdent((JCTree.JCExpression)iterableName.makeIdent(), "getFromFirst"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Unary(54, arrayIndex.makeIdent()))))), null));
        }
        if (itemDecls != null) {
            loopBody.appendList(itemDecls);
        }
        loopBody.appendList(bodyStmts);
        JCTree.JCMethodInvocation iter_elem = this.make().Apply(null, this.makeSelect(iterName.makeIdent(), "next"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        JCTree.JCAssign elem_assign = this.make().Assign(iterationVarName.makeIdent(), iter_elem);
        JCTree.JCInstanceOf instof = this.make().TypeTest(elem_assign, this.makeIdent(this.syms().ceylonFinishedType));
        JCTree.JCExpression loopCond = this.make().Unary(50, instof);
        if (optForArray || optForTuple) {
            JCTree.JCExpression cond2 = optForArray && optForTuple ? this.make().Binary(57, isTupleName.makeIdent(), isArrayName.makeIdent()) : (optForArray ? isArrayName.makeIdent() : isTupleName.makeIdent());
            loopCond = this.make().Conditional(cond2, this.make().Binary(64, arrayIndex.makeIdent(), arrayLength.makeIdent()), this.make().Unary(50, instof));
        }
        JCTree.JCStatement whileLoop = this.at(node).WhileLoop(loopCond, this.at(node).Block(0L, loopBody.toList()));
        if (label != null) {
            whileLoop = this.make().Labelled(label, whileLoop);
        }
        return result.append(whileLoop).toList();
    }

    public DeferredSpecification getDeferredSpecification(Declaration value) {
        return this.deferredSpecifications.get(value);
    }

    private void closeInnerSubstituionsForSpecifiedValues(Tree.ControlClause contolClause, boolean enclosing) {
        if (contolClause != null) {
            ControlBlock controlBlock = contolClause.getControlBlock();
            block0: while (true) {
                Set<Value> assigned;
                if ((assigned = controlBlock.getSpecifiedValues()) != null) {
                    for (Value value : assigned) {
                        DeferredSpecification ds = this.statementGen().getDeferredSpecification(value);
                        if (ds == null) continue;
                        ds.closeInnerSubstitution();
                    }
                }
                if (!enclosing) break;
                for (Scope s = controlBlock.getContainer(); s != null; s = s.getContainer()) {
                    if (s instanceof ControlBlock) {
                        controlBlock = (ControlBlock)s;
                        continue block0;
                    }
                    if (s instanceof Declaration) break block0;
                }
                break;
            }
        }
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transform(Tree.AttributeDeclaration decl) {
        ListBuffer result = ListBuffer.lb();
        Parameter parameter = CodegenUtil.findParamForDecl(decl);
        if (parameter == null) {
            Name attrName = this.names().fromString(this.naming.substitute(decl.getDeclarationModel()));
            Type t = decl.getDeclarationModel().getType();
            JCTree.JCExpression initialValue = null;
            Tree.SpecifierOrInitializerExpression initOrSpec = decl.getSpecifierOrInitializerExpression();
            if (initOrSpec != null) {
                HasErrorException error = this.errors().getFirstExpressionErrorAndMarkBrokenness(initOrSpec.getExpression().getTerm());
                if (error != null) {
                    return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowUnresolvedCompilationError(error));
                }
                initialValue = this.expressionGen().transformExpression(initOrSpec.getExpression(), CodegenUtil.getBoxingStrategy(decl.getDeclarationModel()), decl.getDeclarationModel().getType());
            } else if (decl.getDeclarationModel().isVariable()) {
                initialValue = this.makeDefaultExprForType(t);
                if (CodegenUtil.getBoxingStrategy(decl.getDeclarationModel()) == AbstractTransformer.BoxingStrategy.BOXED && this.canUnbox(t)) {
                    initialValue = this.boxType(initialValue, t);
                }
            }
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annots = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            int modifiers = this.transformLocalFieldDeclFlags(decl);
            JCTree.JCExpression typeExpr = this.makeJavaType(decl.getDeclarationModel(), t, modifiers);
            result.append(this.at(decl.getIdentifier()).VarDef(this.at(decl.getIdentifier()).Modifiers(modifiers, annots), attrName, typeExpr, initialValue));
            JCTree.JCStatement outerSubs = this.openOuterSubstitutionIfNeeded(decl.getDeclarationModel(), t, modifiers);
            if (outerSubs != null) {
                result.append(outerSubs);
            }
        }
        return result.toList();
    }

    JCTree.JCStatement openOuterSubstitutionIfNeeded(Value value, Type t, int modifiers) {
        JCTree.JCStatement result = null;
        if (value.isSpecifiedInForElse()) {
            DeferredSpecification d = new DeferredSpecification(value, modifiers, t);
            this.deferredSpecifications.put(value, d);
            result = d.openOuterSubstitution();
        }
        return result;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transform(Tree.Break stmt) {
        return this.defaultBreakTransformer.transform(stmt);
    }

    JCTree.JCStatement transform(Tree.Continue stmt) {
        return this.continueTransformer.transform(stmt);
    }

    Transformer<JCTree.JCStatement, Tree.Return> returnTransformer(Transformer<JCTree.JCStatement, Tree.Return> tx) {
        Transformer<JCTree.JCStatement, Tree.Return> result = this.returnTransformer;
        this.returnTransformer = tx;
        return result;
    }

    JCTree.JCStatement transform(Tree.Return ret) {
        return this.returnTransformer.transform(ret);
    }

    public JCTree.JCStatement transform(Tree.Throw t) {
        JCTree.JCExpression exception;
        this.closeInnerSubstituionsForSpecifiedValues(this.currentForClause, true);
        this.at(t);
        Tree.Expression expr = t.getExpression();
        if (expr == null) {
            exception = this.make().NewClass(null, null, this.makeIdent(this.syms().ceylonExceptionType), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeNull(), this.makeNull()), null);
        } else {
            Type exceptionType = expr.getTypeModel().getSupertype(t.getUnit().getThrowableDeclaration());
            exception = this.gen().expressionGen().transformExpression(expr, AbstractTransformer.BoxingStrategy.UNBOXED, exceptionType);
        }
        return this.make().Throw(exception);
    }

    public JCTree.JCStatement transform(Tree.TryCatchStatement t) {
        JCTree.JCBlock finallyBlock;
        Tree.TryClause tryClause = t.getTryClause();
        this.at(tryClause);
        JCTree.JCBlock tryBlock = this.transform(tryClause.getBlock());
        Tree.ResourceList resList = tryClause.getResourceList();
        if (resList != null) {
            ArrayList<Tree.Resource> resources = new ArrayList<Tree.Resource>(resList.getResources());
            Collections.reverse(resources);
            for (Tree.Resource res : resources) {
                TryResourceTransformation resourceTx;
                String resVarName;
                Tree.Expression resExpr;
                com.redhat.ceylon.langtools.tools.javac.util.List<Object> stats = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
                if (res.getExpression() != null) {
                    resExpr = res.getExpression();
                    resVarName = this.naming.newTemp("try");
                } else if (res.getVariable() != null) {
                    Tree.Variable var = res.getVariable();
                    resExpr = var.getSpecifierExpression().getExpression();
                    resVarName = var.getIdentifier().getText();
                } else {
                    throw new BugException(res, "missing resource expression");
                }
                if (this.typeFact().getDestroyableType().isSupertypeOf(resExpr.getTypeModel())) {
                    resourceTx = this.destroyableResource;
                } else if (this.typeFact().getObtainableType().isSupertypeOf(resExpr.getTypeModel())) {
                    resourceTx = this.obtainableResource;
                } else if (this.javacJavaTypeToProducedType(this.syms().autoCloseableType).isSupertypeOf(resExpr.getTypeModel())) {
                    resourceTx = this.javaAutoCloseableResource;
                } else {
                    throw BugException.unhandledCase(resExpr.getTypeModel());
                }
                Type resVarType = resExpr.getTypeModel();
                Type resVarExpectedType = resourceTx.getType();
                JCTree.JCExpression expr = this.expressionGen().transformExpression(resExpr);
                JCTree.JCExpression javaType = this.makeJavaType(resVarType);
                JCTree.JCVariableDecl var = this.makeVar(16L, resVarName, javaType, expr);
                stats = stats.append(var);
                if (resourceTx.getInitMethodName() != null) {
                    JCTree.JCExpression resVar0 = this.expressionGen().applyErasureAndBoxing(this.makeUnquotedIdent(resVarName), resVarType, true, AbstractTransformer.BoxingStrategy.BOXED, resVarExpectedType);
                    JCTree.JCMethodInvocation openCall = this.make().Apply(null, this.makeQualIdent(resVar0, resourceTx.getInitMethodName()), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
                    stats = stats.append(this.make().Exec(openCall));
                }
                String innerExTmpVarName = this.naming.newTemp("ex");
                JCTree.JCExpression innerExType = this.makeJavaType(this.typeFact().getThrowableType(), 16);
                JCTree.JCVariableDecl innerExTmpVar = this.makeVar(innerExTmpVarName, innerExType, (JCTree.JCExpression)this.makeNull());
                stats = stats.append(innerExTmpVar);
                com.redhat.ceylon.langtools.tools.javac.util.List<Object> innerCatchStats = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
                Name innerCatchVarName = this.naming.tempName("ex");
                JCTree.JCAssign exTmpAssign = this.make().Assign(this.makeUnquotedIdent(innerExTmpVarName), this.make().Ident(innerCatchVarName));
                innerCatchStats = innerCatchStats.append(this.make().Exec(exTmpAssign));
                JCTree.JCThrow innerCatchThrow = this.make().Throw(this.make().Ident(innerCatchVarName));
                innerCatchStats = innerCatchStats.append(innerCatchThrow);
                JCTree.JCBlock innerCatchBlock = this.make().Block(0L, innerCatchStats);
                JCTree.JCExpression exarg = this.makeUnquotedIdent(innerExTmpVarName);
                JCTree.JCExpression resVar1 = this.expressionGen().applyErasureAndBoxing(this.makeUnquotedIdent(resVarName), resVarType, true, AbstractTransformer.BoxingStrategy.BOXED, resVarExpectedType);
                JCTree.JCExpression closeCall = resourceTx.makeRecover(resVar1, exarg);
                JCTree.JCBlock closeTryBlock = this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(closeCall)));
                Name closeCatchVarName = this.naming.tempName("closex");
                JCTree.JCExpression closeCatchExType = this.makeJavaType(this.typeFact().getThrowableType(), 16);
                JCTree.JCVariableDecl closeCatchVar = this.make().VarDef(this.make().Modifiers(16L), closeCatchVarName, closeCatchExType, null);
                JCTree.JCIdent addarg = this.make().Ident(closeCatchVarName);
                JCTree.JCMethodInvocation addSuppressedCall = this.make().Apply(null, this.makeQualIdent(this.makeUnquotedIdent(innerExTmpVarName), "addSuppressed"), com.redhat.ceylon.langtools.tools.javac.util.List.of(addarg));
                JCTree.JCCatch closeCatch = this.make().Catch(closeCatchVar, this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(addSuppressedCall))));
                JCTree.JCTry closeTry = this.at(res).Try(closeTryBlock, com.redhat.ceylon.langtools.tools.javac.util.List.of(closeCatch), null);
                JCTree.JCExpression exarg2 = this.makeUnquotedIdent(innerExTmpVarName);
                JCTree.JCExpression resVar2 = this.expressionGen().applyErasureAndBoxing(this.makeUnquotedIdent(resVarName), resVarType, true, AbstractTransformer.BoxingStrategy.BOXED, resVarExpectedType);
                JCTree.JCExpression closeCall2 = resourceTx.makeRecover(resVar1, exarg);
                JCTree.JCBinary closeCatchCond = this.make().Binary(63, this.makeUnquotedIdent(innerExTmpVarName), this.makeNull());
                JCTree.JCIf closeCatchIf = this.make().If(closeCatchCond, closeTry, this.make().Exec(closeCall2));
                JCTree.JCExpression innerCatchExType = this.makeJavaType(this.typeFact().getThrowableType(), 16);
                JCTree.JCVariableDecl innerCatchVar = this.make().VarDef(this.make().Modifiers(16L), innerCatchVarName, innerCatchExType, null);
                JCTree.JCCatch innerCatch = this.make().Catch(innerCatchVar, innerCatchBlock);
                JCTree.JCBlock innerFinallyBlock = this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(closeCatchIf));
                JCTree.JCTry innerTry = this.at(res).Try(tryBlock, com.redhat.ceylon.langtools.tools.javac.util.List.of(innerCatch), innerFinallyBlock);
                stats = stats.append(innerTry);
                tryBlock = this.at(res).Block(0L, stats);
            }
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCatch> catches = this.usePolymorphicCatches(t.getCatchClauses()) ? this.transformCatchesPolymorphic(t.getCatchClauses()) : this.transformCatchesIfElseIf(t.getCatchClauses());
        Tree.FinallyClause finallyClause = t.getFinallyClause();
        if (finallyClause != null) {
            this.at(finallyClause);
            finallyBlock = this.transform(finallyClause.getBlock());
        } else {
            finallyBlock = null;
        }
        if (!catches.isEmpty() || finallyBlock != null) {
            return this.at(t).Try(tryBlock, catches, finallyBlock);
        }
        return tryBlock;
    }

    boolean usePolymorphicCatches(Iterable<Tree.CatchClause> catchClauses) {
        for (Tree.CatchClause catchClause : catchClauses) {
            Type type = catchClause.getCatchVariable().getVariable().getType().getTypeModel();
            if (this.isOrContainsError(type)) {
                return false;
            }
            if (type.getDeclaration().isParameterized()) {
                return false;
            }
            if (this.typeFact().isIntersection(type)) {
                return false;
            }
            if (!this.typeFact().isUnion(type)) continue;
            return false;
        }
        return true;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCatch> transformCatchesPolymorphic(List<Tree.CatchClause> catchClauses) {
        ListBuffer catches = ListBuffer.lb();
        for (Tree.CatchClause catchClause : catchClauses) {
            this.at(catchClause);
            Tree.Variable variable = catchClause.getCatchVariable().getVariable();
            Type exceptionType = variable.getDeclarationModel().getType();
            JCTree.JCExpression type = this.makeJavaType(exceptionType, 16);
            JCTree.JCVariableDecl param = this.make().VarDef(this.make().Modifiers(16L), this.names().fromString(variable.getIdentifier().getText()), type, null);
            catches.add(this.make().Catch(param, this.transform(catchClause.getBlock())));
        }
        return catches.toList();
    }

    private boolean isOrContainsError(Type exceptionType) {
        if (exceptionType.isTypeAlias()) {
            return this.isOrContainsError(exceptionType.resolveAliases());
        }
        if (exceptionType.isUnion()) {
            for (Type t : exceptionType.getCaseTypes()) {
                if (!this.isOrContainsError(t)) continue;
                return true;
            }
            return false;
        }
        if (exceptionType.isIntersection()) {
            for (Type t : exceptionType.getSatisfiedTypes()) {
                if (!this.isOrContainsError(t)) continue;
                return true;
            }
            return false;
        }
        TypeDeclaration declaration = exceptionType.getDeclaration();
        return "java.lang::Error".equals(declaration.getQualifiedNameString());
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCatch> transformCatchesIfElseIf(List<Tree.CatchClause> catchClauses) {
        Type supertype = this.intersectionOfCatchClauseTypes(catchClauses);
        JCTree.JCExpression exceptionType = this.makeJavaType(supertype, 24);
        Naming.SyntheticName exceptionVar = this.naming.alias("exception");
        JCTree.JCVariableDecl param = this.make().VarDef(this.make().Modifiers(16L), exceptionVar.asName(), exceptionType, null);
        ArrayList<Tree.CatchClause> reversed = new ArrayList<Tree.CatchClause>(catchClauses);
        Collections.reverse(reversed);
        JCTree.JCStatement elsePart = this.make().Throw(exceptionVar.makeIdent());
        for (Tree.CatchClause catchClause : reversed) {
            Tree.Variable caughtVar = catchClause.getCatchVariable().getVariable();
            Type caughtType = caughtVar.getType().getTypeModel();
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> catchBlock = this.transformBlock(catchClause.getBlock());
            catchBlock = catchBlock.prepend(this.makeVar(16L, caughtVar.getIdentifier().getText(), this.makeJavaType(caughtType), this.expressionGen().applyErasureAndBoxing(exceptionVar.makeIdent(), supertype, true, true, AbstractTransformer.BoxingStrategy.BOXED, caughtType, 0)));
            elsePart = this.make().If(this.makeOptimizedTypeTest(null, exceptionVar, caughtType, supertype), this.make().Block(0L, catchBlock), elsePart);
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Catch(param, this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(elsePart))));
    }

    private Type intersectionOfCatchClauseTypes(List<Tree.CatchClause> catchClauses) {
        Type result = this.typeFact().getNothingType();
        for (Tree.CatchClause catchClause : catchClauses) {
            Type pt = catchClause.getCatchVariable().getVariable().getType().getTypeModel();
            result = ModelUtil.unionType(result, this.exceptionSupertype(pt), this.typeFact());
        }
        if (this.typeFact().isUnion(result)) {
            return result.getSupertype(this.typeFact().getThrowableDeclaration());
        }
        return result;
    }

    private Type exceptionSupertype(Type pt) {
        Type result = this.typeFact().getNothingType();
        if (this.typeFact().isUnion(pt)) {
            for (Type t : pt.getCaseTypes()) {
                result = ModelUtil.unionType(result, this.exceptionSupertype(t), this.typeFact());
            }
        } else if (this.typeFact().isIntersection(pt)) {
            for (Type t : pt.getSatisfiedTypes()) {
                if (!t.isSubtypeOf(this.typeFact().getThrowableType())) continue;
                result = ModelUtil.unionType(result, this.exceptionSupertype(t), this.typeFact());
            }
        } else if (pt.isSubtypeOf(this.typeFact().getThrowableType())) {
            if (pt.getDeclaration().isParameterized()) {
                return pt.getDeclaration().getType();
            }
            return pt;
        }
        return result;
    }

    private int transformLocalFieldDeclFlags(Tree.AttributeDeclaration cdecl) {
        int result = 0;
        return result |= cdecl.getDeclarationModel().isVariable() ? 0 : 16;
    }

    protected JCTree.JCBlock transformElseClauseBlock(Tree.ElseClause elseClause, String tmpVar, Tree.Term outerExpression, Type expectedType) {
        return this.make().Block(0L, this.transformElseClause(elseClause, tmpVar, outerExpression, expectedType));
    }

    protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformElseClause(Tree.ElseClause elseClause, String tmpVar, Tree.Term outerExpression, Type expectedType) {
        if (elseClause.getBlock() != null) {
            return this.transformBlock(elseClause.getBlock());
        }
        if (elseClause.getExpression() != null) {
            return this.evaluateAndAssign(tmpVar, elseClause.getExpression(), outerExpression, expectedType);
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(this.makeErroneous(elseClause, "Only block or expression allowed")));
    }

    protected JCTree.JCBlock transformCaseClauseBlock(Tree.CaseClause caseClause, String tmpVar, Tree.Term outerExpression, Type expectedType) {
        return this.make().Block(0L, this.transformCaseClause(caseClause, tmpVar, outerExpression, expectedType));
    }

    protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCaseClause(Tree.CaseClause caseClause, String tmpVar, Tree.Term outerExpression, Type expectedType) {
        int p = this.unblock();
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> result = caseClause.getBlock() != null ? this.transformBlock(caseClause.getBlock()) : (caseClause.getExpression() != null ? this.evaluateAndAssign(tmpVar, caseClause.getExpression(), outerExpression, expectedType) : com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Exec(this.makeErroneous(caseClause, "Only block or expression allowed"))));
        this._at(p);
        this.block();
        return result;
    }

    protected Type switchExpressionType(Tree.SwitchClause switchClause) {
        Tree.Switched sw = switchClause.getSwitched();
        if (sw.getExpression() != null) {
            return sw.getExpression().getTypeModel();
        }
        if (sw.getVariable() != null) {
            return sw.getVariable().getType().getTypeModel();
        }
        throw new BugException("Switch should have expression or variable");
    }

    protected Boolean switchExpressionUnboxed(Tree.SwitchClause switchClause) {
        Tree.Switched sw = switchClause.getSwitched();
        if (sw.getExpression() != null) {
            return sw.getExpression().getUnboxed();
        }
        if (sw.getVariable() != null) {
            return sw.getVariable().getDeclarationModel().getUnboxed();
        }
        throw new BugException("Switch should have expression or variable");
    }

    JCTree.JCExpression makeNewEnumeratedTypeError(String msg) {
        return this.make().NewClass(null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.makeIdent(this.syms().ceylonEnumeratedTypeErrorType), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().Literal(msg)), null);
    }

    Tree.Term getSingletonNullCase(Tree.CaseClause caseClause) {
        Tree.CaseItem caseItem = caseClause.getCaseItem();
        if (caseItem instanceof Tree.MatchCase) {
            List<Tree.Expression> expressions = ((Tree.MatchCase)caseItem).getExpressionList().getExpressions();
            for (Tree.Expression expr : expressions) {
                Tree.Term term = ExpressionTransformer.eliminateParens(expr.getTerm());
                if (!(term instanceof Tree.BaseMemberExpression) || !this.isNullValue(((Tree.BaseMemberExpression)term).getDeclaration()) || expressions.size() != 1) continue;
                return term;
            }
        }
        return null;
    }

    private boolean isJavaSwitchableType(Type type, Boolean switchUnboxed) {
        return BooleanUtil.isNotFalse(switchUnboxed) && (type.isExactly(this.typeFact().getCharacterType()) || type.isExactly(this.typeFact().getStringType())) || this.isJavaEnumType(type);
    }

    JCTree.JCStatement transform(Tree.SwitchStatement stmt) {
        return this.transform(stmt, stmt.getSwitchClause(), stmt.getSwitchCaseList(), null, null, null);
    }

    JCTree.JCStatement transform(Node node, Tree.SwitchClause switchClause, Tree.SwitchCaseList caseList, String tmpVar, Tree.Term outerExpression, Type expectedType) {
        Type definiteType;
        this.at(switchClause);
        this.block();
        SwitchTransformation transformation = null;
        Type exprType = this.switchExpressionType(switchClause);
        Boolean switchUnboxed = this.switchExpressionUnboxed(switchClause);
        if (this.isJavaSwitchableType(exprType, switchUnboxed)) {
            boolean canUseSwitch = true;
            block0: for (Tree.CaseClause clause : caseList.getCaseClauses()) {
                if (clause.getCaseItem() instanceof Tree.MatchCase) {
                    List<Tree.Expression> caseExprs = ((Tree.MatchCase)clause.getCaseItem()).getExpressionList().getExpressions();
                    for (Tree.Expression expr : caseExprs) {
                        Tree.Term e = ExpressionTransformer.eliminateParens(expr);
                        if (e instanceof Tree.StringLiteral || e instanceof Tree.CharLiteral || e instanceof Tree.BaseMemberExpression && ((Tree.BaseMemberExpression)e).getDeclaration() instanceof Value && ((Value)((Tree.BaseMemberExpression)e).getDeclaration()).isEnumValue()) continue;
                        canUseSwitch = false;
                        break block0;
                    }
                    continue;
                }
                canUseSwitch = false;
                break;
            }
            if (canUseSwitch) {
                transformation = new Switch();
            }
        }
        if (transformation == null && this.isOptional(exprType) && this.isJavaSwitchableType(definiteType = this.typeFact().getDefiniteType(exprType), switchUnboxed)) {
            boolean canUseIfElseSwitch = true;
            boolean hasSingletonNullCase = false;
            block2: for (Tree.CaseClause clause : caseList.getCaseClauses()) {
                if (clause.getCaseItem() instanceof Tree.MatchCase) {
                    if (this.getSingletonNullCase(clause) != null) {
                        hasSingletonNullCase = true;
                    }
                    List<Tree.Expression> caseExprs = ((Tree.MatchCase)clause.getCaseItem()).getExpressionList().getExpressions();
                    for (Tree.Expression expr : caseExprs) {
                        Tree.Term e = ExpressionTransformer.eliminateParens(expr);
                        if (e instanceof Tree.StringLiteral || e instanceof Tree.CharLiteral || e instanceof Tree.BaseMemberExpression && this.isNullValue(((Tree.BaseMemberExpression)e).getDeclaration()) && caseExprs.size() == 1 || e instanceof Tree.BaseMemberExpression && ((Tree.BaseMemberExpression)e).getDeclaration() instanceof Value && ((Value)((Tree.BaseMemberExpression)e).getDeclaration()).isEnumValue()) continue;
                        canUseIfElseSwitch = false;
                        break block2;
                    }
                    continue;
                }
                canUseIfElseSwitch = false;
                break;
            }
            if (canUseIfElseSwitch &= hasSingletonNullCase) {
                transformation = new IfNullElseSwitch();
            }
        }
        if (transformation == null) {
            transformation = new IfElseChain();
        }
        JCTree.JCStatement result = ((SwitchTransformation)transformation).transformSwitch(node, switchClause, caseList, tmpVar, outerExpression, expectedType);
        this.unblock();
        return result;
    }

    private boolean isSwitchAllMatchCases(Tree.SwitchCaseList caseList) {
        for (Tree.CaseClause caseClause : caseList.getCaseClauses()) {
            if (caseClause.getCaseItem() instanceof Tree.MatchCase) continue;
            return false;
        }
        return true;
    }

    private JCTree.JCStatement transformCaseMatch(Naming.SyntheticName selectorAlias, Tree.SwitchClause switchClause, Tree.CaseClause caseClause, String tmpVar, Tree.Term outerExpression, Type expectedType, Tree.MatchCase matchCase, JCTree.JCStatement last, Type switchType, boolean primitiveSelector) {
        this.at(matchCase);
        JCTree.JCExpression tests = null;
        List<Tree.Expression> expressions = matchCase.getExpressionList().getExpressions();
        for (Tree.Expression expr : expressions) {
            JCTree.JCExpression test;
            Tree.Term term = ExpressionTransformer.eliminateParens(expr.getTerm());
            boolean unboxedEquality = primitiveSelector || this.isCeylonBasicType(this.typeFact().getDefiniteType(switchType));
            JCTree.JCExpression transformedExpression = this.expressionGen().transformExpression(term, unboxedEquality ? AbstractTransformer.BoxingStrategy.UNBOXED : AbstractTransformer.BoxingStrategy.BOXED, term.getTypeModel());
            if (term instanceof Tree.Literal || term instanceof Tree.NegativeOp) {
                test = unboxedEquality ? (term instanceof Tree.StringLiteral ? this.make().Apply(null, this.makeSelect(this.unboxType(selectorAlias.makeIdent(), term.getTypeModel()), "equals"), com.redhat.ceylon.langtools.tools.javac.util.List.of(transformedExpression)) : this.make().Binary(62, primitiveSelector ? selectorAlias.makeIdent() : this.unboxType(selectorAlias.makeIdent(), term.getTypeModel()), transformedExpression)) : this.make().Apply(null, this.makeSelect(selectorAlias.makeIdent(), "equals"), com.redhat.ceylon.langtools.tools.javac.util.List.of(transformedExpression));
                if (this.isOptional(switchType)) {
                    test = this.make().Binary(58, this.make().Binary(63, selectorAlias.makeIdent(), this.makeNull()), test);
                }
            } else {
                JCTree.JCExpression selectorExpr = !primitiveSelector && this.isCeylonBasicType(this.typeFact().getDefiniteType(switchType)) ? this.unboxType(selectorAlias.makeIdent(), term.getTypeModel()) : selectorAlias.makeIdent();
                test = this.make().Binary(62, selectorExpr, transformedExpression);
            }
            if (tests == null) {
                tests = test;
                continue;
            }
            if (this.isNull(term.getTypeModel())) {
                tests = this.make().Binary(57, test, tests);
                continue;
            }
            tests = this.make().Binary(57, tests, test);
        }
        Naming.Substitution prevSubst = null;
        if (switchClause.getSwitched().getVariable() != null) {
            prevSubst = this.naming.addVariableSubst(switchClause.getSwitched().getVariable().getDeclarationModel(), selectorAlias.toString());
        }
        JCTree.JCBlock block = this.transformCaseClauseBlock(caseClause, tmpVar, outerExpression, expectedType);
        if (prevSubst != null) {
            prevSubst.close();
        }
        return this.at(caseClause).If(tests, block, last);
    }

    private JCTree.JCStatement transformCaseIs(Naming.SyntheticName selectorAlias, Tree.CaseClause caseClause, String tmpVar, Tree.Term outerExpression, Type expectedType, Tree.IsCase isCase, JCTree.JCStatement last, Type expressionType) {
        JCTree.JCExpression toTypeExpr;
        this.at(isCase);
        Type varType = isCase.getVariable().getDeclarationModel().getType();
        Type caseType = isCase.getType().getTypeModel();
        JCTree.JCExpression cond = this.makeTypeTest(null, selectorAlias, caseType, expressionType);
        String name = isCase.getVariable().getIdentifier().getText();
        Value varDecl = isCase.getVariable().getDeclarationModel();
        Naming.SyntheticName tmpVarName = selectorAlias;
        Name substVarName = this.naming.aliasName(name);
        JCTree.JCExpression rawToTypeExpr = this.makeJavaType(varType, 12);
        JCTree.JCExpression tmpVarExpr = this.at(isCase).TypeCast(rawToTypeExpr, tmpVarName.makeIdent());
        if (this.isCeylonBasicType(varType) && varDecl.getUnboxed().booleanValue()) {
            toTypeExpr = this.makeJavaType(varType);
            tmpVarExpr = this.unboxType(tmpVarExpr, varType);
        } else {
            toTypeExpr = this.makeJavaType(varType, 4);
        }
        JCTree.JCVariableDecl decl2 = this.at(isCase).VarDef(this.make().Modifiers(16L), substVarName, toTypeExpr, tmpVarExpr);
        Naming.Substitution prevSubst = this.naming.addVariableSubst(varDecl, substVarName.toString());
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stats = com.redhat.ceylon.langtools.tools.javac.util.List.of(decl2);
        stats = stats.appendList(this.transformCaseClause(caseClause, tmpVar, outerExpression, expectedType));
        JCTree.JCBlock block = this.at(isCase).Block(0L, stats);
        prevSubst.close();
        last = this.make().If(cond, block, last);
        return last;
    }

    private Name getLabel(Tree.Directive dir) {
        Scope scope = dir.getScope();
        while (!(scope instanceof Package)) {
            Integer loopId;
            if (scope instanceof ControlBlock && (loopId = this.gen().visitor.lv.getLoopId((ControlBlock)scope)) != null) {
                return this.names().fromString("loop_" + loopId);
            }
            scope = scope.getContainer();
        }
        throw new BugException(dir, "failed to find label");
    }

    public Name getLabel(Tree.Break brk) {
        return this.getLabel((Tree.Directive)brk);
    }

    public Name getLabel(Tree.Continue cont) {
        return this.getLabel((Tree.Directive)cont);
    }

    public Name getLabel(Tree.WhileClause loop) {
        return this.getLabel(loop.getControlBlock());
    }

    private Name getLabel(ControlBlock block) {
        Integer i = this.gen().visitor.lv.getLoopId(block);
        return this.names().fromString("loop_" + i);
    }

    public Name getLabel(Tree.ForClause loop) {
        return this.getLabel(loop.getControlBlock());
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCVariableDecl> transformVariableOrDestructure(Tree.Statement varOrDes) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCVariableDecl> vars = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (varOrDes instanceof Tree.Variable) {
            Tree.Variable var = (Tree.Variable)varOrDes;
            Tree.Expression expr = var.getSpecifierExpression().getExpression();
            AbstractTransformer.BoxingStrategy boxingStrategy = CodegenUtil.getBoxingStrategy(var.getDeclarationModel());
            JCTree.JCExpression init = this.expressionGen().transformExpression(expr, boxingStrategy, var.getType().getTypeModel());
            vars = vars.append(this.transformVariable(var, init, expr.getTypeModel(), boxingStrategy == AbstractTransformer.BoxingStrategy.BOXED).build());
        } else if (varOrDes instanceof Tree.Destructure) {
            Tree.Destructure des = (Tree.Destructure)varOrDes;
            vars = vars.appendList(this.transform(des));
        } else {
            throw BugException.unhandledCase(varOrDes);
        }
        return vars;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCVariableDecl> transform(Tree.Destructure stmt) {
        com.redhat.ceylon.langtools.tools.javac.util.List<Object> result = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        Tree.Pattern pat = stmt.getPattern();
        Naming.SyntheticName tmpVarName = this.naming.synthetic(pat);
        Tree.Expression destExpr = stmt.getSpecifierExpression().getExpression();
        JCTree.JCExpression typeExpr = this.makeJavaType(destExpr.getTypeModel());
        JCTree.JCExpression expr = this.expressionGen().transformExpression(destExpr);
        this.at(stmt);
        JCTree.JCVariableDecl tmpVar = this.makeVar(16L, tmpVarName, typeExpr, expr);
        result = result.append(tmpVar);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCVariableDecl> vars = VarDefBuilder.buildAll(this.transformPattern(pat, tmpVarName.makeIdent()));
        result = result.appendList(vars);
        return result;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> transformDestructure(Tree.Statement stmt, JCTree.JCExpression varAccessExpr, Type exprType, boolean exprBoxed) {
        com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> result = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (stmt instanceof Tree.Variable) {
            result = result.append(this.transformVariable((Tree.Variable)stmt, varAccessExpr, exprType, exprBoxed));
        } else if (stmt instanceof Tree.Destructure) {
            result = result.appendList(this.transformPattern(((Tree.Destructure)stmt).getPattern(), varAccessExpr));
        } else {
            throw BugException.unhandledCase(stmt);
        }
        return result;
    }

    com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> transformPattern(Tree.Pattern pat, JCTree.JCExpression varAccessExpr) {
        com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> result = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (pat instanceof Tree.TuplePattern) {
            int idx = 0;
            Tree.TuplePattern tuple = (Tree.TuplePattern)pat;
            for (Tree.Pattern p : tuple.getPatterns()) {
                JCTree.JCMethodInvocation fullGetExpr;
                JCTree.JCExpression idxExpr = this.makeInteger(idx++);
                Type ot = this.typeFact().getObjectType();
                if (varAccessExpr != null) {
                    JCTree.JCTypeCast seqVarAccessExpr = this.make().TypeCast(this.makeJavaType(this.typeFact().getSequenceType(ot), 8), varAccessExpr);
                    JCTree.JCExpression tupleAccessExpr = this.isVariadicVariable(p) ? this.makeQualIdent(seqVarAccessExpr, "skip") : this.makeQualIdent(seqVarAccessExpr, "getFromFirst");
                    fullGetExpr = this.make().Apply(null, tupleAccessExpr, com.redhat.ceylon.langtools.tools.javac.util.List.of(idxExpr));
                    if (this.isVariadicVariable(p)) {
                        fullGetExpr = this.make().Apply(null, this.makeQualIdent(fullGetExpr, "sequence"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
                    }
                } else {
                    fullGetExpr = null;
                }
                result = result.appendList(this.transformPattern(p, fullGetExpr));
            }
        } else if (pat instanceof Tree.KeyValuePattern) {
            JCTree.JCMethodInvocation getItemExpr;
            Tree.KeyValuePattern entry = (Tree.KeyValuePattern)pat;
            Type ot = this.typeFact().getObjectType();
            if (varAccessExpr != null) {
                JCTree.JCTypeCast entryVarAccessExpr = this.make().TypeCast(this.makeJavaType(this.typeFact().getEntryType(ot, ot), 8), varAccessExpr);
                JCTree.JCMethodInvocation getKeyExpr = this.make().Apply(null, this.makeQualIdent(entryVarAccessExpr, "getKey"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
                result = result.appendList(this.transformPattern(entry.getKey(), getKeyExpr));
                getItemExpr = this.make().Apply(null, this.makeQualIdent(entryVarAccessExpr, "getItem"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
            } else {
                getItemExpr = null;
            }
            result = result.appendList(this.transformPattern(entry.getValue(), getItemExpr));
        } else if (pat instanceof Tree.VariablePattern) {
            Tree.VariablePattern var = (Tree.VariablePattern)pat;
            result = result.append(this.transformVariable(var.getVariable(), varAccessExpr));
        } else {
            throw BugException.unhandledCase(pat);
        }
        return result;
    }

    private boolean isVariadicVariable(Tree.Pattern pat) {
        if (pat instanceof Tree.VariablePattern) {
            Tree.VariablePattern var = (Tree.VariablePattern)pat;
            return var.getVariable().getType() instanceof Tree.SequencedType;
        }
        return false;
    }

    VarDefBuilder transformVariable(Tree.Variable var, JCTree.JCExpression initExpr) {
        return this.transformVariable(var, initExpr, this.typeFact().getObjectType(), true);
    }

    VarDefBuilder transformVariable(Tree.Variable var, JCTree.JCExpression initExpr, Type exprType, boolean exprBoxed) {
        AbstractTransformer.BoxingStrategy boxingStrategy = CodegenUtil.getBoxingStrategy(var.getDeclarationModel());
        JCTree.JCExpression expr = initExpr;
        if (expr != null) {
            Type type = var.getType().getTypeModel().getDeclaration().isAnonymous() ? var.getType().getTypeModel() : this.simplifyType(this.typeFact().denotableType(var.getType().getTypeModel()));
            expr = this.expressionGen().applyErasureAndBoxing(expr, exprType, false, exprBoxed, boxingStrategy, type, 8);
        }
        return new VarDefBuilder(this.expressionGen(), var, expr);
    }

    Tree.Expression getDestructureExpression(Tree.Statement varOrDes) {
        Tree.SpecifierExpression specExpr;
        if (varOrDes instanceof Tree.Variable) {
            specExpr = ((Tree.Variable)varOrDes).getSpecifierExpression();
        } else if (varOrDes instanceof Tree.Destructure) {
            specExpr = ((Tree.Destructure)varOrDes).getSpecifierExpression();
        } else {
            throw BugException.unhandledCase(varOrDes);
        }
        return specExpr != null ? specExpr.getExpression() : null;
    }

    public JCTree transform(CustomTree.GuardedVariable that) {
        Type exprType;
        AbstractTransformer.BoxingStrategy boxingStrategy = CodegenUtil.getBoxingStrategy(that.getDeclarationModel());
        Tree.Expression expr = that.getSpecifierExpression().getExpression();
        Type fromType = expr.getTypeModel();
        Value newValue = that.getDeclarationModel();
        Type toType = newValue.getType();
        Tree.ConditionList conditionList = that.getConditionList();
        Tree.Condition condition = conditionList.getConditions().get(0);
        JCTree.JCExpression val = this.expressionGen().transformExpression(expr);
        this.at(that);
        if (condition instanceof Tree.IsCondition) {
            if (!this.willEraseToObject(toType)) {
                JCTree.JCExpression rawToTypeExpr = this.makeJavaType(toType, 12);
                val = this.make().TypeCast(rawToTypeExpr, val);
                if (CodegenUtil.isUnBoxed(newValue) && this.canUnbox(toType)) {
                    val = this.unboxType(val, toType);
                }
            }
        } else if (condition instanceof Tree.ExistsCondition) {
            exprType = fromType;
            if (this.isOptional(exprType)) {
                exprType = this.typeFact().getDefiniteType(exprType);
            }
            val = this.expressionGen().applyErasureAndBoxing(val, exprType, CodegenUtil.hasTypeErased(expr), true, CodegenUtil.hasUntrustedType(expr), boxingStrategy, toType, 0);
        } else if (condition instanceof Tree.NonemptyCondition) {
            exprType = fromType;
            if (this.isOptional(exprType)) {
                exprType = this.typeFact().getDefiniteType(exprType);
            }
            val = this.expressionGen().applyErasureAndBoxing(val, exprType, false, true, AbstractTransformer.BoxingStrategy.BOXED, toType, 8);
        }
        Naming.SyntheticName alias = this.naming.alias(that.getIdentifier().getText());
        Naming.Substitution subst = this.naming.addVariableSubst(newValue, alias.getName());
        Scope scope = that.getScope().getScope();
        while (scope instanceof ConditionScope) {
            scope = scope.getScope();
        }
        subst.scopeClose(scope);
        JCTree.JCExpression varType = this.makeJavaType(toType);
        return this.make().VarDef(this.make().Modifiers(16L), alias.asName(), varType, val);
    }

    static class VarDefBuilder {
        private final ExpressionTransformer gen;
        private final Tree.Variable var;
        private final JCTree.JCExpression initExpr;
        private Naming.SyntheticName name;
        private boolean built;

        public VarDefBuilder(ExpressionTransformer gen, Tree.Variable var, JCTree.JCExpression initExpr) {
            this.gen = gen;
            this.var = var;
            this.initExpr = initExpr;
        }

        private Type model() {
            return this.var.getType().getTypeModel();
        }

        private Naming.SyntheticName name() {
            if (this.name == null) {
                this.name = this.gen.naming.substituted(this.var.getDeclarationModel()).capture();
            }
            return this.name;
        }

        private JCTree.JCExpression type() {
            AbstractTransformer.BoxingStrategy boxingStrategy = CodegenUtil.getBoxingStrategy(this.var.getDeclarationModel());
            return this.gen.makeJavaType(this.model(), boxingStrategy == AbstractTransformer.BoxingStrategy.BOXED ? 4 : 0);
        }

        private JCTree.JCExpression expr() {
            if (this.built) {
                throw new BugException(this.var, "Variable expression can only be used once");
            }
            return this.initExpr;
        }

        Naming.Substitution alias() {
            return this.gen.naming.substituteAlias(this.var.getDeclarationModel());
        }

        JCTree.JCVariableDecl buildInternal() {
            this.gen.at(this.var);
            JCTree.JCVariableDecl def = this.gen.makeVar(16L, this.name(), this.type(), this.expr());
            return def;
        }

        JCTree.JCVariableDecl build() {
            JCTree.JCVariableDecl def = this.buildInternal();
            this.built = true;
            return def;
        }

        JCTree.JCVariableDecl buildDefOnly() {
            this.gen.at(this.var);
            JCTree.JCVariableDecl def = this.gen.makeVar(16L, this.name(), this.type(), null);
            return def;
        }

        JCTree.JCVariableDecl buildField() {
            this.gen.at(this.var);
            JCTree.JCVariableDecl def = this.gen.makeVar(2L, this.name(), this.type(), null);
            return def;
        }

        JCTree.JCVariableDecl buildFromField() {
            this.gen.at(this.var);
            JCTree.JCVariableDecl def = this.gen.makeVar(16L, this.name(), this.type(), this.name().makeIdentWithThis());
            return def;
        }

        JCTree.JCAssign buildAssign() {
            this.gen.at(this.var);
            JCTree.JCAssign def = this.gen.make().Assign(this.name().makeIdent(), this.expr());
            this.built = true;
            return def;
        }

        JCTree.JCAssign buildDefaultAssign() {
            this.gen.at(this.var);
            JCTree.JCAssign def = this.gen.make().Assign(this.name().makeIdent(), this.gen.makeDefaultExprForType(this.model()));
            return def;
        }

        static com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCVariableDecl> buildAll(com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> vars) {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCVariableDecl> result = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            for (VarDefBuilder vdb : vars) {
                result = result.append(vdb.build());
            }
            return result;
        }

        public String toString() {
            return "VarDefBuilder [build()=" + this.buildInternal() + "]";
        }
    }

    class IfElseChain
    extends SwitchTransformation {
        IfElseChain() {
        }

        @Override
        protected List<Tree.CaseClause> getCaseClauses(Tree.SwitchClause switchClause, Tree.SwitchCaseList caseList) {
            List<Tree.CaseClause> list = super.getCaseClauses(switchClause, caseList);
            ArrayList<Tree.CaseClause> cheap = new ArrayList<Tree.CaseClause>(list.size());
            int lastCheap = 0;
            Naming.SyntheticName dummy = StatementTransformer.this.naming.synthetic(NamingBase.Unfix.$annotationSequence$);
            Tree.CaseClause containsNull = null;
            block0: for (Tree.CaseClause clause : list) {
                boolean isCheap;
                Tree.CaseItem item = clause.getCaseItem();
                if (item instanceof Tree.IsCase) {
                    isCheap = StatementTransformer.this.isTypeTestCheap(null, dummy, ((Tree.IsCase)item).getType().getTypeModel(), this.getSwitchExpressionType(switchClause));
                } else if (item instanceof Tree.MatchCase) {
                    for (Tree.Expression expr : ((Tree.MatchCase)item).getExpressionList().getExpressions()) {
                        if (!StatementTransformer.this.isNull(expr.getTypeModel())) continue;
                        containsNull = clause;
                        continue block0;
                    }
                    isCheap = true;
                } else {
                    return list;
                }
                int index = isCheap ? lastCheap : cheap.size();
                cheap.add(index, clause);
                if (!isCheap) continue;
                lastCheap = index + 1;
            }
            if (containsNull != null) {
                cheap.add(0, containsNull);
            }
            return cheap;
        }

        @Override
        public JCTree.JCStatement transformSwitch(Node node, Tree.SwitchClause switchClause, Tree.SwitchCaseList caseList, String tmpVar, Tree.Term outerExpression, Type expectedType) {
            JCTree.JCExpression selectorType;
            AbstractTransformer.BoxingStrategy bs;
            boolean primitiveSelector;
            Naming.SyntheticName selectorAlias = StatementTransformer.this.naming.alias("sel");
            Type switchExpressionType = this.getSwitchExpressionType(switchClause);
            Boolean switchUnboxed = this.getSwitchExpressionUnboxed(switchClause);
            boolean allMatches = StatementTransformer.this.isSwitchAllMatchCases(caseList);
            boolean bl = primitiveSelector = allMatches && StatementTransformer.this.isCeylonBasicType(switchExpressionType) && BooleanUtil.isNotFalse(switchUnboxed);
            if (primitiveSelector) {
                bs = AbstractTransformer.BoxingStrategy.UNBOXED;
                selectorType = StatementTransformer.this.makeJavaType(switchExpressionType);
            } else {
                bs = AbstractTransformer.BoxingStrategy.BOXED;
                selectorType = StatementTransformer.this.makeJavaType(switchExpressionType, 12);
            }
            JCTree.JCExpression selectorExpr = StatementTransformer.this.expressionGen().transformExpression(this.getSwitchExpression(switchClause), bs, switchExpressionType);
            JCTree.JCVariableDecl selector = StatementTransformer.this.makeVar(selectorAlias, selectorType, selectorExpr);
            JCTree.JCStatement last = this.transformElse(switchClause, selectorAlias, caseList, tmpVar, outerExpression, expectedType, primitiveSelector);
            List<Tree.CaseClause> caseClauses = this.getCaseClauses(switchClause, caseList);
            for (int ii = caseClauses.size() - 1; ii >= 0; --ii) {
                Tree.CaseClause caseClause = caseClauses.get(ii);
                Tree.CaseItem caseItem = caseClause.getCaseItem();
                if (caseItem instanceof Tree.IsCase) {
                    last = StatementTransformer.this.transformCaseIs(selectorAlias, caseClause, tmpVar, outerExpression, expectedType, (Tree.IsCase)caseItem, last, switchExpressionType);
                    continue;
                }
                if (caseItem instanceof Tree.SatisfiesCase) {
                    return StatementTransformer.this.make().Exec(StatementTransformer.this.makeErroneous(caseItem, "compiler bug: switch/satisfies not implemented yet"));
                }
                if (caseItem instanceof Tree.MatchCase) {
                    last = StatementTransformer.this.transformCaseMatch(selectorAlias, switchClause, caseClause, tmpVar, outerExpression, expectedType, (Tree.MatchCase)caseItem, last, switchExpressionType, primitiveSelector);
                    continue;
                }
                return StatementTransformer.this.make().Exec(StatementTransformer.this.makeErroneous(caseItem, "compiler bug: unknown switch case clause: " + caseItem));
            }
            return StatementTransformer.this.at(node).Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(selector, last));
        }
    }

    class IfNullElseSwitch
    extends SwitchTransformation {
        IfNullElseSwitch() {
        }

        @Override
        public JCTree.JCStatement transformSwitch(Node node, Tree.SwitchClause switchClause, Tree.SwitchCaseList caseList, String tmpVar, Tree.Term outerExpression, Type expectedType) {
            JCTree.JCIdent ident;
            JCTree.JCVariableDecl selector;
            Type switchExpressionType = this.getSwitchExpressionType(switchClause);
            Type switchDefiniteExpressionType = this.getDefiniteSwitchExpressionType(switchClause);
            JCTree.JCExpression selectorExpr = StatementTransformer.this.expressionGen().transformExpression(this.getSwitchExpression(switchClause), AbstractTransformer.BoxingStrategy.BOXED, this.getSwitchExpressionType(switchClause));
            if (this.hasVariable(switchClause)) {
                String name = switchClause.getSwitched().getVariable().getIdentifier().getText();
                selector = StatementTransformer.this.makeVar(name, StatementTransformer.this.makeJavaType(switchExpressionType), selectorExpr);
                ident = StatementTransformer.this.naming.makeQuotedIdent(name);
            } else {
                Naming.SyntheticName selectorAlias = StatementTransformer.this.naming.alias("sel");
                selector = StatementTransformer.this.makeVar(selectorAlias, StatementTransformer.this.makeJavaType(switchExpressionType), selectorExpr);
                ident = selectorAlias.makeIdent();
            }
            JCTree.JCStatement switch_ = new Switch().transformSwitch(switchClause, caseList, tmpVar, outerExpression, expectedType, StatementTransformer.this.expressionGen().applyErasureAndBoxing((JCTree.JCExpression)ident, switchDefiniteExpressionType, true, AbstractTransformer.BoxingStrategy.UNBOXED, switchDefiniteExpressionType));
            JCTree.JCIf ifElse = null;
            for (Tree.CaseClause caseClause : this.getCaseClauses(switchClause, caseList)) {
                Tree.Term term = StatementTransformer.this.getSingletonNullCase(caseClause);
                if (term == null) continue;
                ifElse = StatementTransformer.this.make().If(StatementTransformer.this.make().Binary(62, ident, StatementTransformer.this.makeNull()), StatementTransformer.this.transformCaseClauseBlock(caseClause, tmpVar, outerExpression, expectedType), StatementTransformer.this.make().Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(switch_)));
                break;
            }
            return StatementTransformer.this.at(node).Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(selector, ifElse));
        }
    }

    class Switch
    extends SwitchTransformation {
        @Override
        public JCTree.JCStatement transformSwitch(Node node, Tree.SwitchClause switchClause, Tree.SwitchCaseList caseList, String tmpVar, Tree.Term outerExpression, Type expectedType) {
            JCTree.JCExpression switchExpr = StatementTransformer.this.expressionGen().transformExpression(this.getSwitchExpression(switchClause), AbstractTransformer.BoxingStrategy.UNBOXED, this.getSwitchExpressionType(switchClause));
            if (this.hasVariable(switchClause)) {
                String name = switchClause.getSwitched().getVariable().getIdentifier().getText();
                JCTree.JCVariableDecl selector = StatementTransformer.this.makeVar(name, StatementTransformer.this.makeJavaType(this.getSwitchExpressionType(switchClause)), switchExpr);
                JCTree.JCStatement sw = this.transformSwitch(switchClause, caseList, tmpVar, outerExpression, expectedType, StatementTransformer.this.naming.makeQuotedIdent(name));
                return StatementTransformer.this.at(node).Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(selector, sw));
            }
            return this.transformSwitch(switchClause, caseList, tmpVar, outerExpression, expectedType, switchExpr);
        }

        JCTree.JCStatement transformSwitch(Tree.SwitchClause switchClause, Tree.SwitchCaseList caseList, String tmpVar, Tree.Term outerExpression, Type expectedType, JCTree.JCExpression switchExpr) {
            Name label = StatementTransformer.this.names().fromString("switch_" + StatementTransformer.this.gen().visitor.lv.getSwitchId(switchClause));
            ListBuffer cases = ListBuffer.lb();
            for (Tree.CaseClause caseClause : this.getCaseClauses(switchClause, caseList)) {
                if (StatementTransformer.this.getSingletonNullCase(caseClause) != null) continue;
                Tree.MatchCase match = (Tree.MatchCase)caseClause.getCaseItem();
                List<Tree.Expression> exprs = match.getExpressionList().getExpressions();
                for (int ii = 0; ii < exprs.size() - 1; ++ii) {
                    Tree.Term term = ExpressionTransformer.eliminateParens(exprs.get(ii).getTerm());
                    StatementTransformer.this.at(term);
                    cases.add(StatementTransformer.this.make().Case(this.transformCaseExpr(term), com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
                }
                Tree.Term term = exprs.get(exprs.size() - 1).getTerm();
                JCTree.JCBlock block = StatementTransformer.this.transformCaseClauseBlock(caseClause, tmpVar, outerExpression, expectedType);
                com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
                if (!this.isDefinitelyReturns(caseClause)) {
                    stmts = stmts.prepend(StatementTransformer.this.make().Break(label));
                }
                stmts = stmts.prepend(block);
                cases.add(StatementTransformer.this.make().Case(this.transformCaseExpr(term), stmts));
            }
            Naming.SyntheticName elseSelectorAlias = null;
            if (caseList.getElseClause() != null && caseList.getElseClause().getVariable() != null) {
                Value elseVar = caseList.getElseClause().getVariable().getDeclarationModel();
                if (this.hasVariable(switchClause)) {
                    Type switchVarType = switchClause.getSwitched().getVariable().getDeclarationModel().getType();
                    Type elseVarType = elseVar.getType();
                    if (!elseVarType.isExactly(switchVarType)) {
                        elseSelectorAlias = StatementTransformer.this.naming.synthetic(elseVar);
                    }
                } else if (CodegenUtil.getBoxingStrategy(elseVar) != CodegenUtil.getBoxingStrategy(elseVar.getOriginalDeclaration())) {
                    elseSelectorAlias = StatementTransformer.this.naming.synthetic(elseVar);
                }
            }
            cases.add(StatementTransformer.this.make().Case(null, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.transformElse(switchClause, elseSelectorAlias, caseList, tmpVar, outerExpression, expectedType, false))));
            JCTree.JCStatement last = StatementTransformer.this.make().Switch(switchExpr, cases.toList());
            last = StatementTransformer.this.make().Labelled(label, last);
            return last;
        }

        private JCTree.JCExpression transformCaseExpr(Tree.Term term) {
            if (term instanceof Tree.BaseMemberExpression && ((Tree.BaseMemberExpression)term).getDeclaration() instanceof Value && ((Value)((Tree.BaseMemberExpression)term).getDeclaration()).isEnumValue()) {
                return StatementTransformer.this.naming.makeName((Value)((Tree.BaseMemberExpression)term).getDeclaration(), 1);
            }
            return StatementTransformer.this.expressionGen().transformExpression(term, AbstractTransformer.BoxingStrategy.UNBOXED, term.getTypeModel());
        }
    }

    abstract class SwitchTransformation {
        String exhasutedExhaustiveSwitch = "Supposedly exhaustive switch was not exhaustive";

        protected boolean hasVariable(Tree.SwitchClause switchClause) {
            return switchClause.getSwitched().getVariable() != null;
        }

        protected Tree.Expression getSwitchExpression(Tree.SwitchClause switchClause) {
            Tree.Switched sw = switchClause.getSwitched();
            if (sw.getExpression() != null) {
                return sw.getExpression();
            }
            if (sw.getVariable() != null) {
                return sw.getVariable().getSpecifierExpression().getExpression();
            }
            throw new BugException("Switch should have expression or variable");
        }

        protected Type getSwitchExpressionType(Tree.SwitchClause switchClause) {
            return StatementTransformer.this.switchExpressionType(switchClause);
        }

        protected Boolean getSwitchExpressionUnboxed(Tree.SwitchClause switchClause) {
            return StatementTransformer.this.switchExpressionUnboxed(switchClause);
        }

        protected Type getDefiniteSwitchExpressionType(Tree.SwitchClause switchClause) {
            return StatementTransformer.this.typeFact().getDefiniteType(this.getSwitchExpressionType(switchClause));
        }

        protected List<Tree.CaseClause> getCaseClauses(Tree.SwitchClause switchClause, Tree.SwitchCaseList caseList) {
            return caseList.getCaseClauses();
        }

        protected JCTree.JCStatement transformElse(Tree.SwitchClause switchClause, Naming.SyntheticName selectorAlias, Tree.SwitchCaseList caseList, String tmpVar, Tree.Term outerExpression, Type expectedType, boolean primitiveSelector) {
            JCTree.JCStatement result;
            Tree.ElseClause elseClause = caseList.getElseClause();
            if (elseClause != null) {
                if (elseClause.getVariable() != null && selectorAlias != null) {
                    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stats;
                    Name substVarName;
                    StatementTransformer.this.at(elseClause);
                    Type varType = elseClause.getVariable().getDeclarationModel().getType();
                    String name = elseClause.getVariable().getIdentifier().getText();
                    Value varDecl = elseClause.getVariable().getDeclarationModel();
                    Naming.SyntheticName tmpVarName = selectorAlias;
                    if (primitiveSelector) {
                        substVarName = tmpVarName.asName();
                        stats = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
                    } else {
                        JCTree.JCExpression toTypeExpr;
                        substVarName = StatementTransformer.this.naming.aliasName(name);
                        JCTree.JCExpression rawToTypeExpr = StatementTransformer.this.makeJavaType(varType, 12);
                        JCTree.JCExpression tmpVarExpr = StatementTransformer.this.at(elseClause).TypeCast(rawToTypeExpr, tmpVarName.makeIdent());
                        if (StatementTransformer.this.isCeylonBasicType(varType) && BooleanUtil.isTrue(varDecl.getUnboxed())) {
                            toTypeExpr = StatementTransformer.this.makeJavaType(varType);
                            tmpVarExpr = StatementTransformer.this.unboxType(tmpVarExpr, varType);
                        } else {
                            toTypeExpr = StatementTransformer.this.makeJavaType(varType, 4);
                            if (BooleanUtil.isTrue(varDecl.getUnboxed())) {
                                tmpVarExpr = StatementTransformer.this.boxType(tmpVarExpr, varType);
                            } else if (varDecl.getOriginalDeclaration() != null && BooleanUtil.isTrue(varDecl.getOriginalDeclaration().getUnboxed())) {
                                tmpVarExpr = StatementTransformer.this.boxType(tmpVarName.makeIdent(), varType);
                            }
                        }
                        JCTree.JCVariableDecl decl2 = StatementTransformer.this.at(elseClause).VarDef(StatementTransformer.this.make().Modifiers(16L), substVarName, toTypeExpr, tmpVarExpr);
                        stats = com.redhat.ceylon.langtools.tools.javac.util.List.of(decl2);
                    }
                    Naming.Substitution prevSubst = StatementTransformer.this.naming.addVariableSubst(varDecl, substVarName.toString());
                    stats = stats.appendList(StatementTransformer.this.transformElseClause(elseClause, tmpVar, outerExpression, expectedType));
                    result = StatementTransformer.this.at(elseClause).Block(0L, stats);
                    prevSubst.close();
                } else {
                    Naming.Substitution prevSubst1 = switchClause.getSwitched().getVariable() != null && selectorAlias != null ? StatementTransformer.this.naming.addVariableSubst(switchClause.getSwitched().getVariable().getDeclarationModel(), selectorAlias.toString()) : null;
                    result = StatementTransformer.this.transformElseClauseBlock(elseClause, tmpVar, outerExpression, expectedType);
                    if (prevSubst1 != null) {
                        prevSubst1.close();
                    }
                }
            } else if (outerExpression != null) {
                com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Exec(StatementTransformer.this.make().Assign(StatementTransformer.this.makeUnquotedIdent(tmpVar), StatementTransformer.this.expressionGen().applyErasureAndBoxing(StatementTransformer.this.makeDefaultExprForType(expectedType), expectedType, !StatementTransformer.this.canUnbox(expectedType), CodegenUtil.getBoxingStrategy(outerExpression), expectedType))));
                stmts = stmts.prepend(StatementTransformer.this.make().Exec(StatementTransformer.this.utilInvocation().rethrow(StatementTransformer.this.makeNewEnumeratedTypeError(this.exhasutedExhaustiveSwitch))));
                result = StatementTransformer.this.make().Block(0L, stmts);
            } else {
                result = this.makeThrowEnumeratedTypeError();
            }
            return result;
        }

        protected JCTree.JCStatement makeThrowEnumeratedTypeError() {
            return StatementTransformer.this.make().Throw(StatementTransformer.this.makeNewEnumeratedTypeError(this.exhasutedExhaustiveSwitch));
        }

        public abstract JCTree.JCStatement transformSwitch(Node var1, Tree.SwitchClause var2, Tree.SwitchCaseList var3, String var4, Tree.Term var5, Type var6);

        protected boolean isDefinitelyReturns(Tree.CaseClause caseClause) {
            if (caseClause.getBlock() != null) {
                return caseClause.getBlock().getDefinitelyReturns();
            }
            return false;
        }
    }

    static interface TryResourceTransformation {
        public Type getType();

        public String getInitMethodName();

        public String getRecoverMethodName();

        public JCTree.JCExpression makeRecover(JCTree.JCExpression var1, JCTree.JCExpression var2);
    }

    class DefaultReturnTransformer
    implements Transformer<JCTree.JCStatement, Tree.Return> {
        DefaultReturnTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JCTree.JCStatement transform(Tree.Return ret) {
            StatementTransformer.this.closeInnerSubstituionsForSpecifiedValues(StatementTransformer.this.currentForClause, true);
            Tree.Expression expr = ret.getExpression();
            JCTree.JCExpression returnExpr = null;
            StatementTransformer.this.at(ret);
            if (expr != null) {
                boolean prevNoExpressionlessReturn = StatementTransformer.this.noExpressionlessReturn;
                try {
                    StatementTransformer.this.noExpressionlessReturn = false;
                    TypedDeclaration declaration = (TypedDeclaration)ret.getDeclaration();
                    returnExpr = StatementTransformer.this.expressionGen().transformExpression(declaration, expr.getTerm());
                    returnExpr = StatementTransformer.this.convertToIntIfHashAttribute(declaration, returnExpr);
                }
                finally {
                    StatementTransformer.this.noExpressionlessReturn = prevNoExpressionlessReturn;
                }
            } else if (StatementTransformer.this.noExpressionlessReturn) {
                returnExpr = StatementTransformer.this.makeNull();
            }
            return StatementTransformer.this.at(ret).Return(returnExpr);
        }
    }

    class ConstructorReturnTransformer
    implements Transformer<JCTree.JCStatement, Tree.Return> {
        private final Name label;

        public ConstructorReturnTransformer(Name label) {
            this.label = label;
        }

        @Override
        public JCTree.JCStatement transform(Tree.Return ret) {
            StatementTransformer.this.closeInnerSubstituionsForSpecifiedValues(StatementTransformer.this.currentForClause, true);
            StatementTransformer.this.at(ret);
            return StatementTransformer.this.at(ret).Break(this.label);
        }
    }

    class DefaultContinueTransformer
    implements Transformer<JCTree.JCStatement, Tree.Continue> {
        DefaultContinueTransformer() {
        }

        @Override
        public JCTree.JCStatement transform(Tree.Continue stmt) {
            return StatementTransformer.this.at(stmt).Continue(StatementTransformer.this.getLabel(stmt));
        }
    }

    class DefaultBreakTransformer
    implements Transformer<com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement>, Tree.Break> {
        DefaultBreakTransformer() {
        }

        @Override
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transform(Tree.Break stmt) {
            StatementTransformer.this.closeInnerSubstituionsForSpecifiedValues(StatementTransformer.this.currentForClause, false);
            JCTree.JCBreak brk = StatementTransformer.this.at(stmt).Break(StatementTransformer.this.getLabel(stmt));
            if (StatementTransformer.this.currentForFailVariable != null) {
                JCTree.JCIdent failtest_id = StatementTransformer.this.at(stmt).Ident(StatementTransformer.this.currentForFailVariable);
                com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> list = com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.at(stmt).Exec(StatementTransformer.this.at(stmt).Assign(failtest_id, StatementTransformer.this.make().Literal(8, 0))));
                list = list.append((JCTree.JCExpressionStatement)((Object)brk));
                return list;
            }
            return com.redhat.ceylon.langtools.tools.javac.util.List.of(brk);
        }
    }

    class DeferredSpecification {
        private final Type type;
        private final long modifiers;
        private final Value value;
        private Naming.SyntheticName outerAlias;
        private Naming.Substitution outerSubst = null;
        private Naming.SyntheticName innerAlias;
        private Naming.Substitution innerSubst = null;

        public DeferredSpecification(Value value, int modifiers, Type type) {
            this.value = value;
            this.modifiers = modifiers;
            this.type = type;
        }

        public JCTree.JCStatement openOuterSubstitution() {
            if (this.outerSubst != null || this.outerAlias != null) {
                throw new BugException("An Outer substitution (" + this.outerSubst + ") is already open");
            }
            this.outerAlias = StatementTransformer.this.naming.alias(this.value.getName());
            try (AbstractTransformer.SavedPosition pos = StatementTransformer.this.noPosition();){
                JCTree.JCExpression typeExpr;
                JCTree.JCExpression valueExpr = StatementTransformer.this.makeDefaultExprForType(this.type);
                if (!this.value.getUnboxed().booleanValue()) {
                    typeExpr = StatementTransformer.this.makeJavaType(this.type, 4);
                    valueExpr = StatementTransformer.this.boxType(valueExpr, this.type);
                } else {
                    typeExpr = StatementTransformer.this.makeJavaType(this.type);
                }
                JCTree.JCVariableDecl jCVariableDecl = StatementTransformer.this.make().VarDef(StatementTransformer.this.make().Modifiers(this.modifiers & 0xFFFFFFFFFFFFFFEFL, com.redhat.ceylon.langtools.tools.javac.util.List.nil()), this.outerAlias.asName(), typeExpr, valueExpr);
                return jCVariableDecl;
            }
        }

        public void installOuterSubstitution() {
            this.outerSubst = StatementTransformer.this.naming.addVariableSubst(this.value, this.outerAlias.getName());
        }

        public JCTree.JCStatement openInnerSubstitution() {
            if (this.innerSubst != null || this.innerAlias != null) {
                throw new BugException("An inner substitution (" + this.innerSubst + ") is already open");
            }
            try (AbstractTransformer.SavedPosition pos = StatementTransformer.this.noPosition();){
                this.innerAlias = StatementTransformer.this.naming.alias(this.value.getName());
                JCTree.JCVariableDecl result = StatementTransformer.this.makeVar(this.modifiers, this.innerAlias.getName(), StatementTransformer.this.makeJavaType(this.type, this.value.getUnboxed() == false ? 4 : 0), StatementTransformer.this.naming.makeName(this.value, 128));
                this.innerSubst = StatementTransformer.this.naming.addVariableSubst(this.value, this.innerAlias.getName());
                JCTree.JCVariableDecl jCVariableDecl = result;
                return jCVariableDecl;
            }
        }

        public void closeInnerSubstitution() {
            if (this.innerSubst == null || this.innerAlias == null) {
                throw new BugException("No inner substitution to close");
            }
            this.innerSubst.close();
            this.innerSubst = null;
            this.innerAlias = null;
        }

        public JCTree.JCStatement closeOuterSubstitution() {
            if (this.outerSubst == null) {
                throw new BugException("No outer substitution to close");
            }
            try (AbstractTransformer.SavedPosition pos = StatementTransformer.this.noPosition();){
                JCTree.JCExpression alias = StatementTransformer.this.naming.makeName(this.value, 128);
                this.outerSubst.close();
                this.outerSubst = null;
                JCTree.JCExpression var = StatementTransformer.this.naming.makeName(this.value, 128);
                JCTree.JCExpressionStatement jCExpressionStatement = StatementTransformer.this.make().Exec(StatementTransformer.this.make().Assign(var, alias));
                return jCExpressionStatement;
            }
        }
    }

    class SpanOpWithStepIterationOptimization
    extends SpanOpIterationOptimization {
        protected final Naming.SyntheticName stepName;

        public SpanOpWithStepIterationOptimization(Tree.ForStatement stmt, Tree.RangeOp range, Tree.Term increment, com.redhat.ceylon.langtools.tools.javac.code.Type type) {
            super(stmt, range, increment, type);
            this.stepName = StatementTransformer.this.naming.temp("step");
        }

        @Override
        protected void prelude(ListBuffer<JCTree.JCStatement> result) {
            result.append(StatementTransformer.this.at(this.step).VarDef(StatementTransformer.this.make().Modifiers(16L), this.stepName.asName(), StatementTransformer.this.make().Type(StatementTransformer.this.syms().longType), StatementTransformer.this.expressionGen().transformExpression(this.step, AbstractTransformer.BoxingStrategy.UNBOXED, this.getType())));
            result.append(StatementTransformer.this.at(this.step).If(StatementTransformer.this.make().Binary(66, this.stepName.makeIdent(), StatementTransformer.this.make().Literal(0)), StatementTransformer.this.makeThrowAssertionException(new AssertionExceptionMessageBuilder(null).appendViolatedCondition("step > 0").prependAssertionDoc("step size must be greater than zero").build()), null));
            super.prelude(result);
        }

        @Override
        protected final com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> decorateBlock(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> blockStatements) {
            blockStatements = blockStatements.prepend(this.makeDeclareOrAssignTheirLoopVar());
            blockStatements = blockStatements.prepend(StatementTransformer.this.make().Exec(this.makeAssignOurVar()));
            blockStatements = blockStatements.prepend(StatementTransformer.this.make().Exec(StatementTransformer.this.make().Assign(this.fName.makeIdent(), StatementTransformer.this.make().Literal(true))));
            blockStatements = blockStatements.prepend(StatementTransformer.this.make().If(StatementTransformer.this.make().Binary(58, this.fName.makeIdent(), StatementTransformer.this.make().Binary(62, this.stepName.makeIdent(), StatementTransformer.this.make().Literal(1L))), StatementTransformer.this.make().Exec(this.makeIncrementElement()), null));
            if (!this.getBlock().getDefinitelyReturns()) {
                blockStatements = blockStatements.append(StatementTransformer.this.make().If(StatementTransformer.this.make().Binary(63, this.stepName.makeIdent(), StatementTransformer.this.make().Literal(1L)), StatementTransformer.this.make().Exec(this.makeIncrementElement()), null));
            }
            return blockStatements;
        }

        @Override
        protected JCTree.JCStatement makeLoop(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> blockStatements) {
            return StatementTransformer.this.make().DoLoop(StatementTransformer.this.make().Block(0L, blockStatements), StatementTransformer.this.make().Conditional(StatementTransformer.this.make().Binary(62, this.stepName.makeIdent(), StatementTransformer.this.make().Literal(1L)), this.makeLoopCondition(this.varname), this.makeLoopCondition(this.elementName)));
        }

        @Override
        protected JCTree.JCExpression makeIncrementExpr() {
            JCTree.JCConditional l = StatementTransformer.this.make().Conditional(this.increasingName.makeIdent(), this.makeIncreasingIncrement(), super.makeDecreasingIncrement());
            return this.unitStep(this.stepName, l, StatementTransformer.this.at(this.span).Conditional(this.increasingName.makeIdent(), this.makeIncreasingIncrement(), this.makeDecreasingIncrement()));
        }

        @Override
        protected JCTree.JCExpression makeIncreasingExpr() {
            return this.unitStep(this.stepName, super.makeIncreasingExpr(), StatementTransformer.this.at(this.span).Binary(67, StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(this.makeType(true), "offsetSign"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.lastName.makeIdent(), this.firstName.makeIdent())), StatementTransformer.this.make().Literal(0)));
        }

        private JCTree.JCExpression unitStep(Naming.SyntheticName by, JCTree.JCExpression withoutBy, JCTree.JCExpression withBy) {
            if (by == null) {
                return withoutBy;
            }
            return StatementTransformer.this.make().Conditional(StatementTransformer.this.make().Binary(62, by.makeIdent(), StatementTransformer.this.make().Literal(1)), withoutBy, withBy);
        }

        @Override
        protected JCTree.JCExpression makeIncreasingIncrement() {
            return this.stepName.makeIdent();
        }

        @Override
        protected JCTree.JCExpression makeDecreasingIncrement() {
            return StatementTransformer.this.make().Unary(49, this.stepName.makeIdent());
        }

        @Override
        protected JCTree.JCExpression makeLoopCondition(Naming.SyntheticName varname) {
            JCTree.JCExpression cond = this.unitStep(this.stepName, super.makeLoopCondition(varname), StatementTransformer.this.at(this.span).Conditional(this.increasingName.makeIdent(), StatementTransformer.this.make().Binary(58, StatementTransformer.this.make().Binary(66, StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(this.makeType(true), "offsetSign"), com.redhat.ceylon.langtools.tools.javac.util.List.of(varname.makeIdent(), this.lastName.makeIdent())), this.makeZero()), StatementTransformer.this.make().Binary(67, StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(this.makeType(true), "offsetSign"), com.redhat.ceylon.langtools.tools.javac.util.List.of(varname.makeIdent(), this.firstName.makeIdent())), this.makeZero())), StatementTransformer.this.make().Binary(58, StatementTransformer.this.make().Binary(67, StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(this.makeType(true), "offsetSign"), com.redhat.ceylon.langtools.tools.javac.util.List.of(varname.makeIdent(), this.lastName.makeIdent())), this.makeZero()), StatementTransformer.this.make().Binary(66, StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(this.makeType(true), "offsetSign"), com.redhat.ceylon.langtools.tools.javac.util.List.of(varname.makeIdent(), this.firstName.makeIdent())), this.makeZero()))));
            return cond;
        }

        @Override
        protected JCTree.JCExpression makeIncrementElement() {
            JCTree.JCExpression stepExpr = this.unitStep(this.stepName, super.makeIncrementElement(), StatementTransformer.this.make().Assign(this.elementName.makeIdent(), StatementTransformer.this.at(this.step).Apply(null, StatementTransformer.this.naming.makeSelect(this.makeType(true), "neighbour"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.elementName.makeIdent(), this.incrementName.makeIdent()))));
            return stepExpr;
        }
    }

    class SpanOpIterationOptimization
    extends ForStatementTransformation {
        public static final String OPT_NAME = "RangeOpIteration";
        protected final Tree.RangeOp span;
        protected final Tree.Term first;
        protected final Tree.Term last;
        protected final Tree.Term step;
        protected final com.redhat.ceylon.langtools.tools.javac.code.Type type;
        protected final Type pt;
        protected final Naming.SyntheticName continueName;
        protected final Naming.SyntheticName firstName;
        protected final Naming.SyntheticName lastName;
        protected final Naming.SyntheticName increasingName;
        protected final Naming.SyntheticName incrementName;
        protected final Naming.SyntheticName fName;
        protected final Naming.SyntheticName elementName;
        protected final Naming.SyntheticName varname;

        public SpanOpIterationOptimization(Tree.ForStatement stmt, Tree.RangeOp range, Tree.Term step, com.redhat.ceylon.langtools.tools.javac.code.Type type) {
            super(stmt);
            this.continueName = StatementTransformer.this.naming.temp("continue");
            this.firstName = StatementTransformer.this.naming.temp("first");
            this.lastName = StatementTransformer.this.naming.temp("last");
            this.increasingName = StatementTransformer.this.naming.temp("increasing");
            this.incrementName = StatementTransformer.this.naming.temp("incr");
            this.fName = StatementTransformer.this.naming.temp("f");
            this.elementName = StatementTransformer.this.naming.temp("element");
            this.span = range;
            this.first = range.getLeftTerm();
            this.last = range.getRightTerm();
            this.step = step;
            this.type = type;
            if (this.isCharacterSpan()) {
                this.pt = StatementTransformer.this.typeFact().getCharacterType();
            } else if (this.isIntegerSpan()) {
                this.pt = StatementTransformer.this.typeFact().getIntegerType();
            } else {
                throw new BugException(range, "unhandled Range type: " + type.tag);
            }
            this.varname = StatementTransformer.this.naming.alias(this.getVariable().getIdentifier().getText());
        }

        protected final boolean isIntegerSpan() {
            return this.type.tag == StatementTransformer.this.syms().longType.tag;
        }

        protected final boolean isCharacterSpan() {
            return this.type.tag == StatementTransformer.this.syms().intType.tag;
        }

        protected Tree.Variable getVariable() {
            return ((Tree.ValueIterator)this.stmt.getForClause().getForIterator()).getVariable();
        }

        protected JCTree.JCExpression makeType(boolean boxed) {
            return StatementTransformer.this.makeJavaType(this.pt, boxed ? 4 : 0);
        }

        protected Type getType() {
            return this.pt;
        }

        @Override
        protected ListBuffer<JCTree.JCStatement> transformForClause() {
            ListBuffer<JCTree.JCStatement> result = ListBuffer.lb();
            StatementTransformer.this.at(this.span);
            this.prelude(result);
            Tree.ControlClause prevForclause = StatementTransformer.this.currentForClause;
            StatementTransformer.this.currentForClause = this.stmt.getForClause();
            Transformer currentContinueTransformer = StatementTransformer.this.continueTransformer;
            StatementTransformer.this.continueTransformer = new Transformer<JCTree.JCStatement, Tree.Continue>(){

                @Override
                public JCTree.JCStatement transform(Tree.Continue tree) {
                    return StatementTransformer.this.at(tree).Break(SpanOpIterationOptimization.this.continueName.asName());
                }
            };
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> blockStatements = com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Labelled(this.continueName.asName(), StatementTransformer.this.make().DoLoop(StatementTransformer.this.make().Block(0L, StatementTransformer.this.transformBlock(this.getBlock())), StatementTransformer.this.make().Literal(false))));
            StatementTransformer.this.continueTransformer = currentContinueTransformer;
            StatementTransformer.this.currentForClause = prevForclause;
            blockStatements = this.decorateBlock(blockStatements);
            result.append(StatementTransformer.this.make().Labelled(this.label, this.makeLoop(blockStatements)));
            return result;
        }

        protected void prelude(ListBuffer<JCTree.JCStatement> result) {
            StatementTransformer.this.at(this.first);
            result.append(StatementTransformer.this.makeVar(16L, this.firstName, this.makeType(false), StatementTransformer.this.expressionGen().transformExpression(this.first, AbstractTransformer.BoxingStrategy.UNBOXED, this.getType())));
            StatementTransformer.this.at(this.last);
            result.append(StatementTransformer.this.makeVar(16L, this.lastName, this.makeType(false), StatementTransformer.this.expressionGen().transformExpression(this.last, AbstractTransformer.BoxingStrategy.UNBOXED, this.getType())));
            StatementTransformer.this.at(this.span);
            result.append(StatementTransformer.this.makeVar(16L, this.increasingName, StatementTransformer.this.make().Type(StatementTransformer.this.syms().booleanType), this.makeIncreasingExpr()));
            if (this.isCharacterSpan()) {
                StatementTransformer.this.at(this.span);
                result.append(StatementTransformer.this.makeVar(StatementTransformer.this.naming.temp(), StatementTransformer.this.make().Type(StatementTransformer.this.syms().booleanType), (JCTree.JCExpression)StatementTransformer.this.make().Binary(58, StatementTransformer.this.make().Binary(65, StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent(StatementTransformer.this.make().QualIdent(StatementTransformer.this.syms().ceylonCharacterType.tsym), "offsetSign"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.firstName.makeIdent(), StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent(StatementTransformer.this.make().QualIdent(StatementTransformer.this.syms().ceylonCharacterType.tsym), "getSuccessor"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.firstName.makeIdent())))), StatementTransformer.this.make().Literal(0L)), StatementTransformer.this.make().Binary(65, StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent(StatementTransformer.this.make().QualIdent(StatementTransformer.this.syms().ceylonCharacterType.tsym), "offsetSign"), com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent(StatementTransformer.this.make().QualIdent(StatementTransformer.this.syms().ceylonCharacterType.tsym), "getPredecessor"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.lastName.makeIdent())), this.lastName.makeIdent())), StatementTransformer.this.make().Literal(0L)))));
            }
            StatementTransformer.this.at(this.span);
            result.append(StatementTransformer.this.makeVar(16L, this.incrementName, StatementTransformer.this.make().Type(StatementTransformer.this.syms().longType), this.makeIncrementExpr()));
            result.append(StatementTransformer.this.makeVar(this.varname, this.makeType(false), (JCTree.JCExpression)this.firstName.makeIdent()));
            result.append(StatementTransformer.this.makeVar(this.elementName, this.makeType(false), (JCTree.JCExpression)this.firstName.makeIdent()));
            result.append(StatementTransformer.this.makeVar(this.fName, StatementTransformer.this.make().Type(StatementTransformer.this.syms().booleanType), (JCTree.JCExpression)StatementTransformer.this.make().Literal(false)));
        }

        protected JCTree.JCExpression makeIncrementExpr() {
            return StatementTransformer.this.at(this.span).Conditional(this.increasingName.makeIdent(), this.makeIncreasingIncrement(), this.makeDecreasingIncrement());
        }

        protected JCTree.JCExpression makeIncreasingExpr() {
            JCTree.JCBinary incrExpr = StatementTransformer.this.at(this.span).Binary(67, StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(this.makeType(true), "offset"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.lastName.makeIdent(), this.firstName.makeIdent())), StatementTransformer.this.make().Literal(0));
            return incrExpr;
        }

        protected JCTree.JCExpression makeIncreasingIncrement() {
            if (this.isCharacterSpan()) {
                return StatementTransformer.this.make().Literal(1);
            }
            if (this.isIntegerSpan()) {
                return StatementTransformer.this.make().Literal(1L);
            }
            return StatementTransformer.this.makeErroneous(this.span, "unhandled Span type: " + this.type.tag);
        }

        protected JCTree.JCExpression makeDecreasingIncrement() {
            if (this.isCharacterSpan()) {
                return StatementTransformer.this.make().Literal(-1);
            }
            if (this.isIntegerSpan()) {
                return StatementTransformer.this.make().Literal(-1L);
            }
            return StatementTransformer.this.makeErroneous(this.span, "unhandled Span type: " + this.type.tag);
        }

        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> decorateBlock(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> blockStatements) {
            blockStatements = blockStatements.prepend(this.makeDeclareOrAssignTheirLoopVar());
            blockStatements = blockStatements.prepend(StatementTransformer.this.make().Exec(this.makeAssignOurVar()));
            blockStatements = blockStatements.prepend(StatementTransformer.this.make().Exec(StatementTransformer.this.make().Assign(this.fName.makeIdent(), StatementTransformer.this.make().Literal(true))));
            blockStatements = blockStatements.prepend(StatementTransformer.this.make().If(this.fName.makeIdent(), StatementTransformer.this.make().Exec(this.makeIncrementElement()), null));
            return blockStatements;
        }

        protected JCTree.JCStatement makeDeclareOrAssignTheirLoopVar() {
            boolean elemBoxed = BooleanUtil.isFalse(this.getVariable().getDeclarationModel().getUnboxed());
            JCTree.JCExpression elemInit = this.varname.makeIdent();
            if (elemBoxed) {
                elemInit = StatementTransformer.this.boxType(elemInit, this.getType());
            }
            return StatementTransformer.this.make().VarDef(StatementTransformer.this.make().Modifiers(16L), StatementTransformer.this.names().fromString(Naming.getVariableName(this.getVariable())), this.makeType(elemBoxed), elemInit);
        }

        protected final JCTree.JCExpression makeAssignOurVar() {
            return StatementTransformer.this.make().Assign(this.varname.makeIdent(), this.elementName.makeIdent());
        }

        protected JCTree.JCExpression makeIncrementElement() {
            JCTree.JCExpression stepExpr = this.isCharacterSpan() ? StatementTransformer.this.at(this.span).Assign(this.elementName.makeIdent(), StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(this.makeType(true), "neighbour"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.elementName.makeIdent(), this.incrementName.makeIdent()))) : StatementTransformer.this.at(this.span).Assignop(88, this.elementName.makeIdent(), this.incrementName.makeIdent());
            return stepExpr;
        }

        protected JCTree.JCStatement makeLoop(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> blockStatements) {
            return StatementTransformer.this.make().DoLoop(StatementTransformer.this.make().Block(0L, blockStatements), this.makeLoopCondition(this.varname));
        }

        protected JCTree.JCExpression makeLoopCondition(Naming.SyntheticName varname) {
            JCTree.JCConditional cond = StatementTransformer.this.at(this.span).Conditional(this.increasingName.makeIdent(), StatementTransformer.this.make().Binary(63, StatementTransformer.this.make().Binary(72, varname.makeIdent(), this.lastName.makeIdent()), this.makeZero()), StatementTransformer.this.make().Binary(63, StatementTransformer.this.make().Binary(72, varname.makeIdent(), this.lastName.makeIdent()), this.makeZero()));
            return cond;
        }

        protected JCTree.JCExpression makeZero() {
            if (this.isCharacterSpan()) {
                return StatementTransformer.this.make().Literal(0);
            }
            if (this.isIntegerSpan()) {
                return StatementTransformer.this.make().Literal(0L);
            }
            return StatementTransformer.this.makeErroneous(this.span, "unhandled Range type: " + this.type.tag);
        }
    }

    class ForStatementTransformation {
        protected Tree.ForStatement stmt;
        protected final Name label;
        protected final Name failVar;

        ForStatementTransformation(Tree.ForStatement stmt) {
            this.stmt = stmt;
            this.label = StatementTransformer.this.getLabel(stmt.getForClause().getControlBlock());
            this.failVar = this.needsFailVar() ? StatementTransformer.this.naming.aliasName("doforelse") : null;
        }

        protected final Tree.ForIterator getForIterator() {
            Tree.ForIterator forIterator = this.stmt.getForClause().getForIterator();
            return forIterator;
        }

        protected Tree.Term getIterable() {
            return this.getForIterator().getSpecifierExpression().getExpression().getTerm();
        }

        protected final boolean isValueIterator() {
            return this.getForIterator() instanceof Tree.ValueIterator;
        }

        protected final Tree.Variable getElementOrKeyVariable() {
            Tree.ForIterator forIterator = this.getForIterator();
            if (forIterator instanceof Tree.ValueIterator) {
                return ((Tree.ValueIterator)forIterator).getVariable();
            }
            if (forIterator instanceof Tree.PatternIterator) {
                Tree.PatternIterator patIter = (Tree.PatternIterator)forIterator;
                Tree.Pattern pat = patIter.getPattern();
                return ((Tree.VariablePattern)((Tree.KeyValuePattern)pat).getKey()).getVariable();
            }
            return null;
        }

        protected final Tree.Variable getValueVariable() {
            Tree.ForIterator forIterator = this.getForIterator();
            if (forIterator instanceof Tree.PatternIterator) {
                Tree.PatternIterator patIter = (Tree.PatternIterator)forIterator;
                Tree.Pattern pat = patIter.getPattern();
                return ((Tree.VariablePattern)((Tree.KeyValuePattern)pat).getKey()).getVariable();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transform() {
            StatementTransformer.this.at(this.stmt);
            ListBuffer outer = ListBuffer.lb();
            Name tempForFailVariable = StatementTransformer.this.currentForFailVariable;
            try {
                DeferredSpecification ds;
                Set<Value> deferredSpecifiedInFor = this.stmt.getForClause().getControlBlock().getSpecifiedValues();
                if (deferredSpecifiedInFor != null) {
                    for (Value value : deferredSpecifiedInFor) {
                        ds = (DeferredSpecification)StatementTransformer.this.deferredSpecifications.get(value);
                        ds.installOuterSubstitution();
                    }
                }
                if (this.needsFailVar()) {
                    JCTree.JCVariableDecl failtest_decl = StatementTransformer.this.make().VarDef(StatementTransformer.this.make().Modifiers(0L), this.failVar, StatementTransformer.this.make().TypeIdent(8), StatementTransformer.this.make().Literal(8, 1));
                    outer.append(failtest_decl);
                    StatementTransformer.this.currentForFailVariable = failtest_decl.getName();
                } else {
                    StatementTransformer.this.currentForFailVariable = null;
                }
                outer.appendList(this.transformForClause());
                if (this.stmt.getElseClause() != null) {
                    com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> failblock = StatementTransformer.this.transformBlock(this.stmt.getElseClause().getBlock());
                    StatementTransformer.this.closeInnerSubstituionsForSpecifiedValues(this.stmt.getElseClause(), false);
                    if (this.needsFailVar()) {
                        JCTree.JCIdent failtest_id = StatementTransformer.this.at(this.stmt).Ident(StatementTransformer.this.currentForFailVariable);
                        outer.append(StatementTransformer.this.at(this.stmt).If(failtest_id, StatementTransformer.this.at(this.stmt).Block(0L, failblock), null));
                    } else {
                        outer.appendList(failblock);
                    }
                }
                if (deferredSpecifiedInFor != null) {
                    for (Value value : deferredSpecifiedInFor) {
                        ds = (DeferredSpecification)StatementTransformer.this.deferredSpecifications.get(value);
                        outer.append(ds.closeOuterSubstitution());
                    }
                }
            }
            finally {
                StatementTransformer.this.currentForFailVariable = tempForFailVariable;
            }
            return outer.toList();
        }

        private boolean needsFailVar() {
            return this.stmt.getExits() && this.stmt.getElseClause() != null;
        }

        protected ListBuffer<JCTree.JCStatement> transformForClause() {
            Naming.SyntheticName iteratorVarName;
            Naming.SyntheticName elem_name = StatementTransformer.this.naming.alias("elem");
            Tree.ForIterator forIterator = this.stmt.getForClause().getForIterator();
            com.redhat.ceylon.langtools.tools.javac.util.List<Object> itemDecls = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            if (forIterator instanceof Tree.ValueIterator) {
                Tree.Variable variable = ((Tree.ValueIterator)forIterator).getVariable();
                JCTree.JCVariableDecl varExpr = StatementTransformer.this.transformVariable(variable, elem_name.makeIdent()).build();
                itemDecls = itemDecls.append(varExpr);
                iteratorVarName = StatementTransformer.this.naming.synthetic(variable.getDeclarationModel()).suffixedBy(NamingBase.Suffix.$iterator$).alias();
            } else if (forIterator instanceof Tree.PatternIterator) {
                Tree.PatternIterator patIter = (Tree.PatternIterator)forIterator;
                Tree.Pattern pat = patIter.getPattern();
                com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> varsDefs = StatementTransformer.this.transformPattern(pat, elem_name.makeIdent());
                for (VarDefBuilder vdb : varsDefs) {
                    itemDecls = itemDecls.append(vdb.build());
                }
                iteratorVarName = elem_name.suffixedBy(NamingBase.Suffix.$iterator$);
            } else {
                throw BugException.unhandledNodeCase(forIterator);
            }
            Tree.Expression specifierExpression = forIterator.getSpecifierExpression().getExpression();
            Type sequenceElementType = StatementTransformer.this.typeFact().getIteratedType(specifierExpression.getTypeModel());
            Type sequenceType = specifierExpression.getTypeModel().getSupertype(StatementTransformer.this.typeFact().getIterableDeclaration());
            Type expectedIterableType = StatementTransformer.this.typeFact().isNonemptyIterableType(sequenceType) ? StatementTransformer.this.typeFact().getNonemptyIterableType(sequenceElementType) : StatementTransformer.this.typeFact().getIterableType(sequenceElementType);
            JCTree.JCExpression containment = StatementTransformer.this.expressionGen().transformExpression(specifierExpression, AbstractTransformer.BoxingStrategy.BOXED, expectedIterableType);
            Tree.ControlClause prevControlClause = StatementTransformer.this.currentForClause;
            StatementTransformer.this.currentForClause = this.stmt.getForClause();
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = StatementTransformer.this.transformBlock(this.stmt.getForClause().getBlock());
            StatementTransformer.this.currentForClause = prevControlClause;
            return ListBuffer.lb().appendList(StatementTransformer.this.transformIterableIteration(this.stmt, this.label, elem_name, iteratorVarName, forIterator.getSpecifierExpression().getExpression().getTypeModel(), sequenceElementType, containment, itemDecls, stmts, !StatementTransformer.this.isOptimizationDisabled(this.stmt, Optimization.ArrayIterationDynamic), !StatementTransformer.this.isOptimizationDisabled(this.stmt, Optimization.TupleIterationDynamic)));
        }

        protected final Tree.Block getBlock() {
            return this.stmt.getForClause().getBlock();
        }
    }

    private class SegmentOpIteration
    extends IndexedAccessIterationOptimization {
        private final Tree.Term start;
        private final Tree.Term length;

        SegmentOpIteration(Tree.ForStatement stmt, Tree.SegmentOp op, Tree.Term step, Tree.Term start, Tree.Term length) {
            super(stmt, op, step, StatementTransformer.this.typeFact().getIteratedType(op.getTypeModel()), "start", "length", "i");
            this.start = start;
            this.length = length;
        }

        @Override
        protected JCTree.JCBinary stepCheck(Naming.SyntheticName stepName) {
            return StatementTransformer.this.make().Binary(58, StatementTransformer.this.make().Binary(65, this.lengthName.makeIdent(), StatementTransformer.this.make().Literal(0)), super.stepCheck(stepName));
        }

        @Override
        protected JCTree.JCExpression makeIndexableType() {
            return StatementTransformer.this.makeJavaType(this.elementType);
        }

        @Override
        protected JCTree.JCExpression makeIndexable() {
            return StatementTransformer.this.expressionGen().transformExpression(this.start, AbstractTransformer.BoxingStrategy.UNBOXED, this.length.getTypeModel());
        }

        @Override
        protected JCTree.JCExpression makeIndexType() {
            return StatementTransformer.this.make().Type(StatementTransformer.this.syms().longType);
        }

        @Override
        protected JCTree.JCExpression makeIndexInit() {
            return StatementTransformer.this.make().Literal(0);
        }

        @Override
        protected JCTree.JCExpression makeIndexedAccess() {
            if (this.elementType.isExactly(StatementTransformer.this.typeFact().getIntegerType())) {
                if (this.step == null) {
                    return StatementTransformer.this.make().Binary(71, this.indexName.makeIdent(), this.indexableName.makeIdent());
                }
                return StatementTransformer.this.make().Conditional(StatementTransformer.this.make().Binary(62, this.stepName.makeIdent(), StatementTransformer.this.make().Literal(1L)), StatementTransformer.this.make().Binary(71, this.indexName.makeIdent(), this.indexableName.makeIdent()), StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(StatementTransformer.this.makeJavaType(this.elementType, 4), "neighbour"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.indexableName.makeIdent(), this.indexName.makeIdent())));
            }
            if (this.step == null) {
                return StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(StatementTransformer.this.makeJavaType(this.elementType, 4), "neighbour"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.indexableName.makeIdent(), this.indexName.makeIdent()));
            }
            return StatementTransformer.this.make().Conditional(StatementTransformer.this.make().Binary(62, this.stepName.makeIdent(), StatementTransformer.this.make().Literal(1L)), StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(StatementTransformer.this.makeJavaType(this.elementType, 4), "codepoint"), com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Binary(71, this.indexName.makeIdent(), this.indexableName.makeIdent()))), StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(StatementTransformer.this.makeJavaType(this.elementType, 4), "neighbour"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.indexableName.makeIdent(), this.indexName.makeIdent())));
        }

        @Override
        protected boolean isIndexedAccessBoxed() {
            return false;
        }

        @Override
        protected JCTree.JCExpression makeLengthExpr() {
            JCTree.JCExpression result = StatementTransformer.this.expressionGen().transformExpression(this.length, AbstractTransformer.BoxingStrategy.UNBOXED, this.length.getTypeModel());
            return result;
        }

        @Override
        protected JCTree.JCExpression makeStepExpr() {
            return StatementTransformer.this.expressionGen().transformExpression(this.step, AbstractTransformer.BoxingStrategy.UNBOXED, this.elementType);
        }

        @Override
        protected JCTree.JCExpression makeIncrement(Naming.SyntheticName stepName) {
            if (stepName == null) {
                return StatementTransformer.this.make().Unary(54, this.indexName.makeIdent());
            }
            return StatementTransformer.this.make().Assign(this.indexName.makeIdent(), StatementTransformer.this.make().Conditional(StatementTransformer.this.make().Binary(62, stepName.makeIdent(), StatementTransformer.this.make().Literal(1L)), StatementTransformer.this.make().Binary(71, this.indexName.makeIdent(), StatementTransformer.this.make().Literal(1L)), StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeSelect(StatementTransformer.this.make().Type(StatementTransformer.this.syms().ceylonIntegerType), "neighbour"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.indexName.makeIdent(), stepName.makeIdent()))));
        }
    }

    class JavaArrayIterationOptimization
    extends IndexedAccessIterationOptimization {
        public static final String OPT_NAME = "JavaArrayIterationStatic";
        final boolean dotIterable;
        private final Type javaArrayType;

        JavaArrayIterationOptimization(boolean dotIterable, Tree.ForStatement stmt, Tree.Term baseIterable, Tree.Term step, Type elementType, Type javaArrayType) {
            super(stmt, baseIterable, step, elementType, "array");
            this.dotIterable = dotIterable;
            this.javaArrayType = javaArrayType;
        }

        @Override
        protected JCTree.JCExpression makeIndexableType() {
            return StatementTransformer.this.makeJavaType(this.javaArrayType);
        }

        @Override
        protected JCTree.JCExpression makeIndexable() {
            if (this.dotIterable) {
                Tree.QualifiedMemberExpression expr = (Tree.QualifiedMemberExpression)this.getIterable();
                return StatementTransformer.this.expressionGen().transformExpression(expr.getPrimary());
            }
            return StatementTransformer.this.expressionGen().transformExpression(this.getIterable());
        }

        @Override
        protected JCTree.JCExpression makeCondition() {
            JCTree.JCExpression lengthExpr = StatementTransformer.this.naming.makeQualIdent((JCTree.JCExpression)this.indexableName.makeIdent(), "length");
            return StatementTransformer.this.make().Binary(64, this.indexName.makeIdent(), lengthExpr);
        }

        @Override
        protected JCTree.JCExpression makeLengthExpr() {
            return null;
        }

        @Override
        protected JCTree.JCExpression makeIndexedAccess() {
            return StatementTransformer.this.make().Indexed(this.indexableName.makeIdent(), (JCTree.JCExpression)this.indexName.makeIdent());
        }

        @Override
        protected boolean isIndexedAccessBoxed() {
            return this.dotIterable ? StatementTransformer.this.isOptional(this.elementType) : StatementTransformer.this.typeFact().getJavaObjectArrayDeclaration().equals(this.javaArrayType.resolveAliases().getDeclaration());
        }
    }

    class ArrayIterationOptimization
    extends IndexedAccessIterationOptimization {
        public static final String OPT_NAME = "ArrayIterationStatic";
        private final boolean unboxed;

        ArrayIterationOptimization(Tree.ForStatement stmt, Tree.Term baseIterable, Tree.Term step, Type arrayType) {
            super(stmt, baseIterable, step, StatementTransformer.this.typeFact().getArrayElementType(arrayType), "array");
            this.unboxed = StatementTransformer.this.typeFact().getArrayType(StatementTransformer.this.typeFact().getBooleanType()).isExactly(arrayType) || StatementTransformer.this.typeFact().getArrayType(StatementTransformer.this.typeFact().getByteType()).isExactly(arrayType) || StatementTransformer.this.typeFact().getArrayType(StatementTransformer.this.typeFact().getIntegerType()).isExactly(arrayType) || StatementTransformer.this.typeFact().getArrayType(StatementTransformer.this.typeFact().getCharacterType()).isExactly(arrayType) || StatementTransformer.this.typeFact().getArrayType(StatementTransformer.this.typeFact().getFloatType()).isExactly(arrayType) || StatementTransformer.this.typeFact().getArrayType(StatementTransformer.this.typeFact().getStringType()).isExactly(arrayType);
        }

        @Override
        protected JCTree.JCExpression makeIndexableType() {
            if (this.unboxed) {
                return StatementTransformer.this.make().Type(StatementTransformer.this.syms().objectType);
            }
            return StatementTransformer.this.makeJavaType(StatementTransformer.this.typeFact().getArrayType(this.elementType));
        }

        @Override
        protected JCTree.JCExpression makeIndexable() {
            JCTree.JCExpression iterableExpr = StatementTransformer.this.expressionGen().transformExpression(this.getIterable());
            if (this.unboxed) {
                return StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent(iterableExpr, "toArray"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
            }
            return iterableExpr;
        }

        @Override
        protected JCTree.JCExpression makeCondition() {
            return StatementTransformer.this.make().Binary(64, this.indexName.makeIdent(), this.lengthName.makeIdent());
        }

        @Override
        protected JCTree.JCExpression makeLengthExpr() {
            if (this.unboxed) {
                return StatementTransformer.this.utilInvocation().arrayLength(this.indexableName.makeIdent());
            }
            return StatementTransformer.this.make().TypeCast(StatementTransformer.this.make().Type(StatementTransformer.this.syms().intType), (JCTree.JCExpression)StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent((JCTree.JCExpression)this.indexableName.makeIdent(), "getSize"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
        }

        @Override
        protected JCTree.JCExpression makeIndexedAccess() {
            Type gotType = null;
            JCTree.JCExpression elementGet = null;
            boolean typeErased = false;
            boolean exprBoxed = false;
            if (StatementTransformer.this.isCeylonBoolean(this.elementType)) {
                elementGet = StatementTransformer.this.utilInvocation().getBooleanArray(this.indexableName.makeIdent(), this.indexName.makeIdent());
                gotType = this.elementType;
            } else if (StatementTransformer.this.isCeylonFloat(this.elementType)) {
                elementGet = StatementTransformer.this.utilInvocation().getFloatArray(this.indexableName.makeIdent(), this.indexName.makeIdent());
                gotType = this.elementType;
            } else if (StatementTransformer.this.isCeylonInteger(this.elementType)) {
                elementGet = StatementTransformer.this.utilInvocation().getIntegerArray(this.indexableName.makeIdent(), this.indexName.makeIdent());
                gotType = this.elementType;
            } else if (StatementTransformer.this.isCeylonCharacter(this.elementType)) {
                elementGet = StatementTransformer.this.utilInvocation().getCharacterArray(this.indexableName.makeIdent(), this.indexName.makeIdent());
                gotType = this.elementType;
            } else if (StatementTransformer.this.isCeylonByte(this.elementType)) {
                elementGet = StatementTransformer.this.utilInvocation().getByteArray(this.indexableName.makeIdent(), this.indexName.makeIdent());
                gotType = this.elementType;
            } else if (StatementTransformer.this.isCeylonString(this.elementType)) {
                elementGet = StatementTransformer.this.utilInvocation().getStringArray(this.indexableName.makeIdent(), this.indexName.makeIdent());
                gotType = this.elementType;
            }
            if (elementGet == null) {
                elementGet = StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent((JCTree.JCExpression)this.indexableName.makeIdent(), "unsafeItem"), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.indexName.makeIdent()));
                gotType = StatementTransformer.this.typeFact().getObjectType();
                typeErased = true;
                exprBoxed = true;
            }
            elementGet = StatementTransformer.this.expressionGen().applyErasureAndBoxing(elementGet, gotType, typeErased, exprBoxed, CodegenUtil.getBoxingStrategy(this.getElementOrKeyVariable().getDeclarationModel()), this.elementType, 0);
            return elementGet;
        }

        @Override
        protected boolean isIndexedAccessBoxed() {
            return this.getElementOrKeyVariable().getDeclarationModel().getUnboxed() == false;
        }
    }

    abstract class IndexedAccessIterationOptimization
    extends ForStatementTransformation {
        protected final Type elementType;
        protected final Naming.SyntheticName indexableName;
        protected final Naming.SyntheticName lengthName;
        protected final Naming.SyntheticName indexName;
        protected final Tree.Term baseIterable;
        protected final Tree.Term step;
        protected final Naming.SyntheticName stepName;

        IndexedAccessIterationOptimization(Tree.ForStatement stmt, Tree.Term baseIterable, Tree.Term step, Type elementType, String indexableName) {
            this(stmt, baseIterable, step, elementType, indexableName, "length", "i");
        }

        IndexedAccessIterationOptimization(Tree.ForStatement stmt, Tree.Term baseIterable, Tree.Term step, Type elementType, String indexableName, String lengthName, String indexName) {
            super(stmt);
            this.baseIterable = baseIterable;
            this.step = step;
            this.stepName = step != null ? StatementTransformer.this.naming.alias("step") : null;
            this.elementType = elementType;
            this.indexableName = StatementTransformer.this.naming.alias(indexableName);
            this.lengthName = StatementTransformer.this.naming.alias(lengthName);
            this.indexName = StatementTransformer.this.naming.alias(indexName);
        }

        @Override
        protected final Tree.Term getIterable() {
            return this.baseIterable;
        }

        @Override
        protected ListBuffer<JCTree.JCStatement> transformForClause() {
            ListBuffer<JCTree.JCStatement> result = ListBuffer.lb();
            result.add(StatementTransformer.this.makeVar(16L, this.indexableName, this.makeIndexableType(), this.makeIndexable()));
            JCTree.JCExpression lengthExpr = this.makeLengthExpr();
            if (lengthExpr != null) {
                result.add(StatementTransformer.this.makeVar(16L, this.lengthName, this.makeIndexType(), lengthExpr));
            }
            if (this.step != null) {
                JCTree.JCExpression stepExpr = this.makeStepExpr();
                result.add(StatementTransformer.this.makeVar(16L, this.stepName, this.makeIndexType(), stepExpr));
                result.add(StatementTransformer.this.make().If(this.stepCheck(this.stepName), StatementTransformer.this.makeThrowAssertionException(new AssertionExceptionMessageBuilder(null).appendViolatedCondition("step > 0").prependAssertionDoc("step size must be greater than zero").build()), null));
            }
            JCTree.JCVariableDecl iVar = StatementTransformer.this.makeVar(this.indexName, this.makeIndexType(), this.makeIndexInit());
            JCTree.JCExpression iCond = this.makeCondition();
            JCTree.JCExpression iIncr = this.makeIncrement(this.stepName);
            Tree.ControlClause prevControlClause = StatementTransformer.this.currentForClause;
            StatementTransformer.this.currentForClause = this.stmt.getForClause();
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformedBlock = StatementTransformer.this.transformBlock(this.getBlock());
            StatementTransformer.this.currentForClause = prevControlClause;
            JCTree.JCExpression elementGet = this.makeIndexedAccess();
            Tree.ForIterator forIterator = this.getForIterator();
            if (forIterator instanceof Tree.ValueIterator) {
                Tree.ValueIterator valIter = (Tree.ValueIterator)forIterator;
                JCTree.JCVariableDecl variable = StatementTransformer.this.transformVariable(valIter.getVariable(), elementGet, this.elementType, this.isIndexedAccessBoxed()).build();
                transformedBlock = transformedBlock.prepend(variable);
            } else if (forIterator instanceof Tree.PatternIterator) {
                Tree.PatternIterator patIter = (Tree.PatternIterator)forIterator;
                Tree.KeyValuePattern pat = (Tree.KeyValuePattern)patIter.getPattern();
                Naming.SyntheticName entryName = StatementTransformer.this.naming.alias("entry");
                JCTree.JCVariableDecl entryVariable = StatementTransformer.this.makeVar(16L, entryName, StatementTransformer.this.makeJavaType(StatementTransformer.this.typeFact().getEntryType(StatementTransformer.this.typeFact().getAnythingType(), StatementTransformer.this.typeFact().getAnythingType()), 8), elementGet);
                Type entryType = this.elementType.getSupertype(StatementTransformer.this.typeFact().getEntryDeclaration());
                Type keyType = entryType.getTypeArgumentList().get(0);
                Tree.Variable keyVar = ((Tree.VariablePattern)pat.getKey()).getVariable();
                String keyName = Naming.getVariableName(keyVar);
                Boolean keyUnboxed = keyVar.getDeclarationModel().getUnboxed();
                AbstractTransformer.BoxingStrategy keyBoxStrat = CodegenUtil.getBoxingStrategy(keyVar.getDeclarationModel());
                JCTree.JCVariableDecl keyVariable = StatementTransformer.this.makeVar(16L, keyName, StatementTransformer.this.makeJavaType(keyType, BooleanUtil.isFalse(keyUnboxed) ? 4 : 0), StatementTransformer.this.expressionGen().applyErasureAndBoxing((JCTree.JCExpression)StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent((JCTree.JCExpression)entryName.makeIdent(), "getKey"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), StatementTransformer.this.typeFact().getAnythingType(), true, keyBoxStrat, keyType));
                Type valueType = entryType.getTypeArgumentList().get(1);
                Tree.Variable valueVar = ((Tree.VariablePattern)pat.getValue()).getVariable();
                String valueName = Naming.getVariableName(valueVar);
                Boolean valueUnboxed = keyVar.getDeclarationModel().getUnboxed();
                AbstractTransformer.BoxingStrategy valueBoxStrat = CodegenUtil.getBoxingStrategy(valueVar.getDeclarationModel());
                JCTree.JCVariableDecl valueVariable = StatementTransformer.this.makeVar(16L, valueName, StatementTransformer.this.makeJavaType(valueType, BooleanUtil.isFalse(valueUnboxed) ? 4 : 0), StatementTransformer.this.expressionGen().applyErasureAndBoxing((JCTree.JCExpression)StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent((JCTree.JCExpression)entryName.makeIdent(), "getItem"), com.redhat.ceylon.langtools.tools.javac.util.List.nil()), StatementTransformer.this.typeFact().getAnythingType(), true, valueBoxStrat, valueType));
                transformedBlock = transformedBlock.prepend(valueVariable);
                transformedBlock = transformedBlock.prepend(keyVariable);
                transformedBlock = transformedBlock.prepend(entryVariable);
            } else {
                throw BugException.unhandledCase(forIterator);
            }
            JCTree.JCBlock block = StatementTransformer.this.make().Block(0L, transformedBlock);
            result.add(StatementTransformer.this.make().Labelled(this.label, StatementTransformer.this.make().ForLoop(com.redhat.ceylon.langtools.tools.javac.util.List.of(iVar), iCond, com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Exec(iIncr)), block)));
            return result;
        }

        protected JCTree.JCBinary stepCheck(Naming.SyntheticName stepName) {
            return StatementTransformer.this.make().Binary(66, stepName.makeIdent(), StatementTransformer.this.make().Literal(0));
        }

        protected JCTree.JCExpression makeIndexType() {
            return StatementTransformer.this.make().Type(StatementTransformer.this.syms().intType);
        }

        protected JCTree.JCExpression makeStepExpr() {
            Type intType = StatementTransformer.this.typeFact().getIntegerType();
            intType.setUnderlyingType("int");
            return StatementTransformer.this.expressionGen().transformExpression(this.step, AbstractTransformer.BoxingStrategy.UNBOXED, intType);
        }

        protected JCTree.JCExpression makeIncrement(Naming.SyntheticName stepName) {
            if (stepName == null) {
                return StatementTransformer.this.make().Unary(54, this.indexName.makeIdent());
            }
            return StatementTransformer.this.make().Assignop(88, this.indexName.makeIdent(), stepName.makeIdent());
        }

        protected JCTree.JCExpression makeCondition() {
            return StatementTransformer.this.make().Binary(64, this.indexName.makeIdent(), this.lengthName.makeIdent());
        }

        protected abstract JCTree.JCExpression makeIndexableType();

        protected JCTree.JCExpression makeIndexInit() {
            return StatementTransformer.this.make().Literal(0);
        }

        protected abstract JCTree.JCExpression makeIndexedAccess();

        protected abstract boolean isIndexedAccessBoxed();

        protected abstract JCTree.JCExpression makeLengthExpr();

        protected abstract JCTree.JCExpression makeIndexable();
    }

    class StringIterationOptimization
    extends ForStatementTransformation {
        private Tree.Term baseIterable;

        StringIterationOptimization(Tree.ForStatement stmt, Tree.Term baseIterable, Tree.Term step) {
            super(stmt);
            this.baseIterable = baseIterable;
        }

        @Override
        protected ListBuffer<JCTree.JCStatement> transformForClause() {
            ListBuffer<JCTree.JCStatement> stmts = ListBuffer.lb();
            Naming.SyntheticName stringName = StatementTransformer.this.naming.alias("s");
            stmts.append(StatementTransformer.this.makeVar(stringName, StatementTransformer.this.make().Type(StatementTransformer.this.syms().stringType), StatementTransformer.this.expressionGen().transformExpression(this.baseIterable, AbstractTransformer.BoxingStrategy.UNBOXED, this.baseIterable.getTypeModel())));
            Naming.SyntheticName lengthName = StatementTransformer.this.naming.alias("length");
            stmts.append(StatementTransformer.this.makeVar(lengthName, StatementTransformer.this.make().Type(StatementTransformer.this.syms().intType), (JCTree.JCExpression)StatementTransformer.this.make().Apply(null, StatementTransformer.this.makeQualIdent(stringName.makeIdent(), "length"), com.redhat.ceylon.langtools.tools.javac.util.List.nil())));
            Naming.SyntheticName indexName = StatementTransformer.this.naming.alias("index");
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformedBlock = StatementTransformer.this.transformBlock(this.getBlock());
            Type charType = StatementTransformer.this.typeFact().getCharacterType();
            boolean elemBoxed = BooleanUtil.isFalse(this.getElementOrKeyVariable().getDeclarationModel().getUnboxed());
            JCTree.JCExpression elemNameExpr = StatementTransformer.this.naming.makeQuotedIdent(Naming.getVariableName(this.getElementOrKeyVariable()));
            if (elemBoxed) {
                elemNameExpr = StatementTransformer.this.unboxType(elemNameExpr, charType);
            }
            transformedBlock = transformedBlock.prepend(StatementTransformer.this.make().Exec(StatementTransformer.this.make().Assignop(88, indexName.makeIdent(), StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent(StatementTransformer.this.make().Type(StatementTransformer.this.syms().characterObjectType), "charCount"), com.redhat.ceylon.langtools.tools.javac.util.List.of(elemNameExpr)))));
            JCTree.JCExpression typeExpr = StatementTransformer.this.makeJavaType(charType, elemBoxed ? 4 : 0);
            JCTree.JCExpression codePointAtCallExpr = StatementTransformer.this.make().Apply(null, StatementTransformer.this.naming.makeQualIdent((JCTree.JCExpression)stringName.makeIdent(), "codePointAt"), com.redhat.ceylon.langtools.tools.javac.util.List.of(indexName.makeIdent()));
            if (elemBoxed) {
                codePointAtCallExpr = StatementTransformer.this.boxType(codePointAtCallExpr, charType);
            }
            transformedBlock = transformedBlock.prepend(StatementTransformer.this.makeVar(16L, Naming.getVariableName(this.getElementOrKeyVariable()), typeExpr, codePointAtCallExpr));
            JCTree.JCBlock block = StatementTransformer.this.make().Block(0L, transformedBlock);
            JCTree.JCForLoop loop = StatementTransformer.this.make().ForLoop(com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.makeVar(indexName, StatementTransformer.this.make().Type(StatementTransformer.this.syms().intType), (JCTree.JCExpression)StatementTransformer.this.make().Literal(0))), StatementTransformer.this.make().Binary(64, indexName.makeIdent(), lengthName.makeIdent()), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), block);
            stmts.add(StatementTransformer.this.make().Labelled(this.label, loop));
            return stmts;
        }
    }

    private class JavaIterationTransformation
    extends ForStatementTransformation {
        JavaIterationTransformation(Tree.ForStatement stmt) {
            super(stmt);
        }

        @Override
        protected ListBuffer<JCTree.JCStatement> transformForClause() {
            JCTree.JCVariableDecl loopvar;
            Tree.ForIterator forIterator = this.stmt.getForClause().getForIterator();
            com.redhat.ceylon.langtools.tools.javac.util.List<Object> itemDecls = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            Naming.SyntheticName elem_name = StatementTransformer.this.naming.alias("elem");
            if (forIterator instanceof Tree.ValueIterator) {
                Tree.Variable variable = ((Tree.ValueIterator)forIterator).getVariable();
                elem_name = StatementTransformer.this.naming.synthetic(variable);
                Naming.SyntheticName iteratorVarName = StatementTransformer.this.naming.synthetic(variable.getDeclarationModel()).suffixedBy(NamingBase.Suffix.$iterator$).alias();
                JCTree.JCVariableDecl varExpr = StatementTransformer.this.transformVariable(variable, iteratorVarName.makeIdent()).build();
                itemDecls = itemDecls.append(varExpr);
                loopvar = StatementTransformer.this.makeVar(iteratorVarName, StatementTransformer.this.makeJavaType(variable.getDeclarationModel().getType(), 4), null);
            } else if (forIterator instanceof Tree.PatternIterator) {
                Tree.PatternIterator patIter = (Tree.PatternIterator)forIterator;
                Tree.Pattern pat = patIter.getPattern();
                elem_name = StatementTransformer.this.naming.synthetic(pat);
                Naming.SyntheticName iteratorVarName = elem_name.suffixedBy(NamingBase.Suffix.$iterator$);
                com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> varsDefs = StatementTransformer.this.transformPattern(pat, iteratorVarName.makeIdent());
                for (VarDefBuilder vdb : varsDefs) {
                    itemDecls = itemDecls.append(vdb.build());
                }
                Type t = StatementTransformer.this.typeFact().getIteratedType(forIterator.getSpecifierExpression().getExpression().getTypeModel());
                loopvar = StatementTransformer.this.makeVar(iteratorVarName, StatementTransformer.this.makeJavaType(t, 4), null);
            } else {
                throw BugException.unhandledNodeCase(forIterator);
            }
            com.redhat.ceylon.langtools.tools.javac.util.List<Object> body = StatementTransformer.this.transformBlock(this.stmt.getForClause().getBlock());
            body = body.prependList(itemDecls);
            JCTree.JCLabeledStatement forLoop = StatementTransformer.this.make().Labelled(this.label, StatementTransformer.this.make().ForeachLoop(loopvar, StatementTransformer.this.expressionGen().transformExpression(forIterator.getSpecifierExpression().getExpression()), StatementTransformer.this.make().Block(0L, body)));
            ListBuffer<JCTree.JCStatement> result = ListBuffer.lb();
            result.add(forLoop);
            if (this.failVar != null) {
                // empty if block
            }
            return result;
        }
    }

    class BooleanCond
    implements Cond {
        private final Tree.BooleanCondition cond;
        private final VarTrans var;

        private BooleanCond(Tree.BooleanCondition booleanCondition) {
            this.cond = booleanCondition;
            this.var = new VarTrans(){

                @Override
                public Tree.Variable getVariable() {
                    return null;
                }

                @Override
                public com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> getVarDefBuilders() {
                    return null;
                }

                @Override
                public final boolean isDestructure() {
                    return false;
                }

                @Override
                public Naming.CName getVariableName() {
                    return null;
                }

                @Override
                public Naming.CName getTestVariableName() {
                    return null;
                }

                @Override
                public Tree.Expression getExpression() {
                    return null;
                }

                @Override
                public boolean hasResultDecl() {
                    return false;
                }

                @Override
                public boolean hasAliasedVariable() {
                    return false;
                }

                @Override
                public JCTree.JCExpression makeTypeExpr() {
                    return null;
                }

                @Override
                public JCTree.JCExpression makeResultExpr() {
                    return null;
                }

                @Override
                public Type getType() {
                    return null;
                }

                @Override
                public Type getResultType() {
                    return null;
                }

                @Override
                public JCTree.JCStatement makeTestVarDecl(int flags, boolean init) {
                    return null;
                }
            };
        }

        @Override
        public JCTree.JCExpression makeTest() {
            StatementTransformer.this.at(this.cond);
            return StatementTransformer.this.expressionGen().transformExpression(this.cond.getExpression(), AbstractTransformer.BoxingStrategy.UNBOXED, StatementTransformer.this.typeFact().getBooleanType());
        }

        @Override
        public Tree.Condition getCondition() {
            return this.cond;
        }

        @Override
        public VarTrans getVarTrans() {
            return this.var;
        }

        @Override
        public VarTrans getElseVarTrans() {
            return this.var;
        }
    }

    class NonemptyCond
    extends SpecialFormCond<Tree.NonemptyCondition, NonemptyVarTrans> {
        private NonemptyCond(Tree.NonemptyCondition nonempty, NonemptyVarTrans var, NonemptyVarTrans elseVar) {
            super(StatementTransformer.this, (Tree.Condition)nonempty, (VarTrans)var, (VarTrans)elseVar, nonempty.getNot());
        }

        @Override
        public JCTree.JCExpression makeTest() {
            JCTree.JCExpression expr = StatementTransformer.this.expressionGen().transformExpression(((NonemptyVarTrans)this.var).getExpression());
            StatementTransformer.this.at(this.cond);
            expr = StatementTransformer.this.make().Assign(((NonemptyVarTrans)this.var).getTestVariableName().makeIdent(), expr);
            expr = StatementTransformer.this.makeNonEmptyTest(expr);
            if (this.negate) {
                expr = StatementTransformer.this.make().Unary(50, expr);
            }
            return expr;
        }
    }

    class ExistsCond
    extends SpecialFormCond<Tree.ExistsCondition, ExistsVarTrans> {
        private ExistsCond(Tree.ExistsCondition exists, ExistsVarTrans var, ExistsVarTrans elseVar) {
            super(StatementTransformer.this, (Tree.Condition)exists, (VarTrans)var, (VarTrans)elseVar, exists.getNot());
        }

        @Override
        public JCTree.JCExpression makeTest() {
            Type specifierType = ((ExistsVarTrans)this.var).getExpression().getTypeModel();
            if (!StatementTransformer.this.typeFact().isOptionalType(specifierType)) {
                specifierType = StatementTransformer.this.typeFact().getOptionalType(specifierType);
            }
            JCTree.JCExpression expr = StatementTransformer.this.expressionGen().transformExpression(((ExistsVarTrans)this.var).getExpression(), AbstractTransformer.BoxingStrategy.BOXED, specifierType);
            StatementTransformer.this.at(this.cond);
            expr = StatementTransformer.this.make().Assign(((ExistsVarTrans)this.var).getTestVariableName().makeIdent(), expr);
            expr = StatementTransformer.this.make().Binary(63, expr, StatementTransformer.this.makeNull());
            if (this.negate) {
                expr = StatementTransformer.this.make().Unary(50, expr);
            }
            return expr;
        }
    }

    class IsCond
    extends SpecialFormCond<Tree.IsCondition, IsVarTrans> {
        private IsCond(Tree.IsCondition isdecl, IsVarTrans var, IsVarTrans elseVar) {
            super(StatementTransformer.this, (Tree.Condition)isdecl, (VarTrans)var, (VarTrans)elseVar, isdecl.getNot());
        }

        @Override
        public JCTree.JCExpression makeTest() {
            boolean useTempVar;
            Type expressionType = ((Tree.IsCondition)this.cond).getVariable().getSpecifierExpression() != null ? ((Tree.IsCondition)this.cond).getVariable().getSpecifierExpression().getExpression().getTypeModel() : ((Tree.IsCondition)this.cond).getVariable().getDeclarationModel().getOriginalDeclaration().getType();
            Type specifierType = this.negate ? expressionType : StatementTransformer.this.getOptionalTypeForInteropIfAllowed(((Tree.IsCondition)this.cond).getType().getTypeModel(), expressionType, ((IsVarTrans)this.var).getExpression());
            JCTree.JCExpression expr = StatementTransformer.this.expressionGen().transformExpression(((IsVarTrans)this.var).getExpression(), AbstractTransformer.BoxingStrategy.BOXED, specifierType);
            StatementTransformer.this.at(this.cond);
            boolean bl = useTempVar = !((IsVarTrans)this.var).isErasedToObjectOptimization() && !((IsVarTrans)this.var).isNothingOptimization();
            if (this.elseVar != null) {
                boolean bl2 = useTempVar = useTempVar || !((IsVarTrans)this.elseVar).isErasedToObjectOptimization() && !((IsVarTrans)this.elseVar).isNothingOptimization();
            }
            if (useTempVar) {
                expr = StatementTransformer.this.make().Assign(((IsVarTrans)this.var).getTestVariableName().makeIdent(), expr);
            }
            expr = StatementTransformer.this.makeOptimizedTypeTest(expr, ((IsVarTrans)this.var).isErasedToObjectOptimization() ? ((IsVarTrans)this.var).getVariableName() : ((IsVarTrans)this.var).getTestVariableName(), ((Tree.IsCondition)this.cond).getType().getTypeModel(), expressionType);
            if (this.negate) {
                expr = StatementTransformer.this.make().Unary(50, expr);
            }
            return expr;
        }
    }

    abstract class SpecialFormCond<C extends Tree.Condition, V extends VarTrans>
    implements Cond {
        protected final C cond;
        protected final V var;
        protected final V elseVar;
        protected final boolean negate;
        final /* synthetic */ StatementTransformer this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        SpecialFormCond(C cond, V var, V elseVar, boolean negate) {
            this.this$0 = (StatementTransformer)n;
            this.cond = cond;
            this.var = var;
            this.elseVar = elseVar;
            this.negate = negate;
        }

        public final C getCondition() {
            return this.cond;
        }

        public final V getVarTrans() {
            return this.var;
        }

        public final V getElseVarTrans() {
            return this.elseVar;
        }
    }

    static interface Cond {
        public Tree.Condition getCondition();

        public VarTrans getVarTrans();

        public VarTrans getElseVarTrans();

        public JCTree.JCExpression makeTest();
    }

    class NonemptyVarTrans
    extends BaseVarTransImpl {
        private NonemptyVarTrans(Tree.Statement varOrDes) {
            super(varOrDes);
        }

        private NonemptyVarTrans(Tree.Statement varOrDes, Naming.CName testVarName) {
            super(varOrDes, testVarName);
        }

        @Override
        public JCTree.JCExpression makeResultExpr() {
            Type exprType = this.getExpression().getTypeModel();
            if (StatementTransformer.this.isOptional(exprType)) {
                exprType = StatementTransformer.this.typeFact().getDefiniteType(exprType);
            }
            Type expectedType = this.getVariable().getDeclarationModel().getType();
            return StatementTransformer.this.expressionGen().applyErasureAndBoxing(this.getTestVariableName().makeIdent(), exprType, false, true, AbstractTransformer.BoxingStrategy.BOXED, expectedType, 8);
        }
    }

    class ExistsVarTrans
    extends BaseVarTransImpl {
        private ExistsVarTrans(Tree.Statement varOrDes) {
            super(varOrDes);
        }

        private ExistsVarTrans(Tree.Statement varOrDes, Naming.CName testVarName) {
            super(varOrDes, testVarName);
        }

        @Override
        public JCTree.JCExpression makeResultExpr() {
            AbstractTransformer.BoxingStrategy boxing;
            if (this.isDestructure()) {
                boxing = AbstractTransformer.BoxingStrategy.BOXED;
            } else {
                Value decl = this.getVariable().getDeclarationModel();
                boxing = CodegenUtil.getBoxingStrategy(decl);
            }
            return StatementTransformer.this.expressionGen().applyErasureAndBoxing(this.getTestVariableName().makeIdent(), this.getResultType(), StatementTransformer.this.willEraseToObject(this.toType), true, boxing, this.toType, 0);
        }
    }

    class IsVarTrans
    extends BaseVarTransImpl {
        private IsVarTrans(Tree.Variable var) {
            super(var);
        }

        private IsVarTrans(Tree.Variable var, Naming.CName testVarName) {
            super(var, testVarName);
        }

        @Override
        public boolean hasResultDecl() {
            return this.isErasedToObjectOptimization() || this.isNothingOptimization() ? false : super.hasResultDecl();
        }

        private boolean isNothingOptimization() {
            return this.toType.isExactly(StatementTransformer.this.typeFact().getNothingType()) && !this.hasAliasedVariable();
        }

        private boolean isErasedToObjectOptimization() {
            return !this.typecastRequired() && !this.hasAliasedVariable() && !StatementTransformer.this.canUnbox(this.getExpression().getTypeModel());
        }

        private boolean typecastRequired() {
            return !StatementTransformer.this.willEraseToObject(this.toType);
        }

        @Override
        public JCTree.JCStatement makeTestVarDecl(int flags, boolean init) {
            return this.isErasedToObjectOptimization() || this.isNothingOptimization() ? null : super.makeTestVarDecl(flags, init);
        }

        @Override
        protected JCTree.JCExpression makeResultType() {
            StatementTransformer.this.at(this.getVariable());
            return StatementTransformer.this.make().Type(StatementTransformer.this.syms().objectType);
        }

        @Override
        public Type getResultType() {
            return StatementTransformer.this.typeFact().getObjectType();
        }

        @Override
        public JCTree.JCExpression makeResultExpr() {
            StatementTransformer.this.at(this.getVariable());
            JCTree.JCExpression expr = this.getTestVariableName().makeIdent();
            if (this.typecastRequired()) {
                JCTree.JCExpression rawToTypeExpr = StatementTransformer.this.makeJavaType(this.toType, 12);
                expr = StatementTransformer.this.at(this.getVariable()).TypeCast(rawToTypeExpr, expr);
                if (this.getVariable().getDeclarationModel().getUnboxed().booleanValue() && StatementTransformer.this.canUnbox(this.toType)) {
                    expr = StatementTransformer.this.unboxType(expr, this.toType);
                }
            }
            return expr;
        }
    }

    abstract class BaseVarTransImpl
    implements VarTrans {
        protected final Type toType;
        private final boolean toTypeBoxed;
        private final Tree.Expression specifierExpr;
        private final Tree.Statement varOrDes;
        private final Naming.CName testVarName;
        private final com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> vdBuilders;
        private Naming.CName variableName;

        BaseVarTransImpl(Tree.Statement varOrDes) {
            this(varOrDes, statementTransformer.naming.syntheticDestructure(varOrDes).alias());
        }

        BaseVarTransImpl(Tree.Statement varOrDes, Naming.CName testVarName) {
            Tree.Type type;
            this.specifierExpr = StatementTransformer.this.getDestructureExpression(varOrDes);
            this.varOrDes = varOrDes;
            this.testVarName = testVarName;
            if (varOrDes instanceof Tree.Variable) {
                Tree.Variable var = (Tree.Variable)varOrDes;
                type = var.getType();
                this.toTypeBoxed = !CodegenUtil.isUnBoxed(var.getDeclarationModel());
            } else if (varOrDes instanceof Tree.Destructure) {
                type = ((Tree.Destructure)varOrDes).getType();
                this.toTypeBoxed = false;
            } else {
                throw BugException.unhandledCase(varOrDes);
            }
            this.toType = type != null ? type.getTypeModel() : this.specifierExpr.getTypeModel();
            this.vdBuilders = StatementTransformer.this.transformDestructure(varOrDes, this.getTestVariableName().makeIdent(), this.getResultType(), true);
        }

        @Override
        public final Tree.Variable getVariable() {
            return (Tree.Variable)this.varOrDes;
        }

        @Override
        public com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> getVarDefBuilders() {
            return this.vdBuilders;
        }

        @Override
        public final boolean isDestructure() {
            return this.varOrDes instanceof Tree.Destructure;
        }

        @Override
        public final Naming.CName getVariableName() {
            if (this.variableName == null) {
                this.variableName = StatementTransformer.this.naming.substituted(this.getVariable().getDeclarationModel()).capture();
            }
            return this.variableName;
        }

        @Override
        public final Naming.CName getTestVariableName() {
            return this.testVarName;
        }

        @Override
        public final Tree.Expression getExpression() {
            return this.specifierExpr;
        }

        @Override
        public boolean hasResultDecl() {
            return true;
        }

        @Override
        public boolean hasAliasedVariable() {
            return !(this.getVariable().getType() instanceof Tree.SyntheticVariable) || StatementTransformer.this.naming.isSubstituted(this.getVariable().getDeclarationModel().getOriginalDeclaration());
        }

        @Override
        public final Type getType() {
            return this.toType;
        }

        @Override
        public final JCTree.JCExpression makeTypeExpr() {
            return StatementTransformer.this.makeJavaType(this.toType, this.toTypeBoxed ? 4 : 0);
        }

        @Override
        public JCTree.JCStatement makeTestVarDecl(int flags, boolean init) {
            return StatementTransformer.this.make().VarDef(StatementTransformer.this.make().Modifiers(flags), this.testVarName.asName(), this.makeResultType(), init ? StatementTransformer.this.makeNull() : null);
        }

        protected JCTree.JCExpression makeResultType() {
            return StatementTransformer.this.makeJavaType(this.getResultType(), 4);
        }

        @Override
        public Type getResultType() {
            Type exprType = this.getExpression().getTypeModel();
            if (StatementTransformer.this.isOptional(exprType)) {
                exprType = StatementTransformer.this.typeFact().getDefiniteType(exprType);
            }
            return exprType;
        }
    }

    static interface VarTrans {
        public Tree.Variable getVariable();

        public com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> getVarDefBuilders();

        public Naming.CName getVariableName();

        public Naming.CName getTestVariableName();

        public Tree.Expression getExpression();

        public boolean hasResultDecl();

        public boolean hasAliasedVariable();

        public boolean isDestructure();

        public JCTree.JCExpression makeTypeExpr();

        public JCTree.JCExpression makeResultExpr();

        public Type getType();

        public Type getResultType();

        public JCTree.JCStatement makeTestVarDecl(int var1, boolean var2);
    }

    class AssertCondList
    extends BlockCondList {
        private final Tree.Assertion ass;
        private final ListBuffer<JCTree.JCStatement> varDecls;
        private final ListBuffer<JCTree.JCStatement> fieldDecls;
        private final Naming.SyntheticName messageSb;
        private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> unassignedResultVars;

        public AssertCondList(Tree.Assertion ass) {
            super(ass.getConditionList().getConditions(), (Tree.Block)null);
            this.varDecls = ListBuffer.lb();
            this.fieldDecls = ListBuffer.lb();
            this.messageSb = StatementTransformer.this.naming.temp("assert");
            this.unassignedResultVars = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            this.ass = ass;
        }

        private boolean isMulti() {
            return this.conditions.size() > 1;
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<Naming.Substitution> getSubstitutions(VarTrans vartrans) {
            com.redhat.ceylon.langtools.tools.javac.util.List<Naming.Substitution> subs = super.getSubstitutions(vartrans);
            if (subs == null) {
                return subs;
            }
            com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> vars = vartrans.getVarDefBuilders();
            HashSet<Scope> scopes = new HashSet<Scope>();
            for (VarDefBuilder v : vars) {
                Scope scope = v.var.getScope().getScope();
                while (scope instanceof ConditionScope) {
                    scope = scope.getScope();
                }
                scopes.add(scope);
                v.name();
            }
            for (Scope scope : scopes) {
                for (Naming.Substitution s : subs) {
                    s.scopeClose(scope);
                }
            }
            return subs;
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommon(Cond cond, List<Tree.Condition> rest, JCTree.JCExpression test, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> elseStmts) {
            if (this.isMulti()) {
                elseStmts = elseStmts.prependList(this.unassignedResultVars);
            }
            stmts = com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().If(test, StatementTransformer.this.make().Block(0L, stmts), StatementTransformer.this.makeElseBlock(elseStmts)));
            JCTree.JCStatement testVarDecl = cond.getVarTrans().makeTestVarDecl(0, true);
            if (testVarDecl != null) {
                stmts = stmts.prepend(testVarDecl);
            }
            return stmts;
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommonResultDecl(VarTrans vartrans, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts) {
            if (vartrans.hasResultDecl()) {
                com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> vars = vartrans.getVarDefBuilders();
                for (VarDefBuilder v : vars) {
                    this.unassignedResultVars = this.unassignedResultVars.prepend(StatementTransformer.this.make().Exec(v.buildDefaultAssign()));
                    (Decl.getNonConditionScope(this.ass.getScope()) instanceof ClassOrInterface && v.var.getDeclarationModel().isCaptured() ? this.fieldDecls : this.varDecls).append(v.buildDefOnly());
                    stmts = stmts.prepend(StatementTransformer.this.make().Exec(v.buildAssign()));
                }
            }
            return stmts;
        }

        @Override
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> getResult() {
            if (StatementTransformer.this.definitelyNotSatisfied(this.conditions)) {
                return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowAssertionFailure((Tree.Condition)this.conditions.get(0)));
            }
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = this.transformList(this.conditions);
            StatementTransformer.this.at(this.ass);
            ListBuffer result = ListBuffer.lb();
            if (this.isMulti()) {
                result.append(StatementTransformer.this.makeVar(this.messageSb, StatementTransformer.this.make().Type(StatementTransformer.this.syms().stringType), (JCTree.JCExpression)StatementTransformer.this.makeNull()));
            }
            result.appendList(this.varDecls);
            StatementTransformer.this.current().defs(this.fieldDecls.toList());
            result.appendList(stmts);
            JCTree.JCExpression message = new AssertionExceptionMessageBuilder(this.messageSb.makeIdent()).prependAssertionDoc(this.ass).build();
            JCTree.JCThrow throw_ = StatementTransformer.this.makeThrowAssertionException(message);
            if (this.isMulti()) {
                result.append(StatementTransformer.this.make().If(StatementTransformer.this.make().Binary(63, this.messageSb.makeIdent(), StatementTransformer.this.makeNull()), throw_, null));
            }
            return result.toList();
        }

        private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommonElse(Cond cond, List<Tree.Condition> rest) {
            if (!this.isMulti()) {
                return null;
            }
            AssertionExceptionMessageBuilder msg = new AssertionExceptionMessageBuilder(null);
            boolean seen = false;
            for (Tree.Condition condition : this.conditions) {
                if (cond.getCondition() == condition) {
                    msg.appendViolatedCondition(condition);
                    seen = true;
                    continue;
                }
                if (seen) {
                    msg.appendUntestedCondition(condition);
                    continue;
                }
                msg.appendUnviolatedCondition(condition);
            }
            return com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Exec(StatementTransformer.this.make().Assign(this.messageSb.makeIdent(), msg.build())));
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermostThen(Cond cond) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermostElse(Cond cond, List<Tree.Condition> rest) {
            if (!this.isMulti()) {
                return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowAssertionFailure(cond.getCondition()));
            }
            return this.transformCommonElse(cond, rest);
        }

        private JCTree.JCStatement makeThrowAssertionFailure(Tree.Condition condition) {
            StatementTransformer.this.at(condition);
            AssertionExceptionMessageBuilder msg = new AssertionExceptionMessageBuilder(null);
            msg.appendViolatedCondition(condition);
            msg.prependAssertionDoc(this.ass);
            return StatementTransformer.this.makeThrowAssertionException(msg.build());
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIntermediateElse(Cond cond, List<Tree.Condition> rest) {
            return this.transformCommonElse(cond, rest);
        }
    }

    class BreakVisitor
    extends Visitor {
        private boolean breaks = false;

        BreakVisitor() {
        }

        @Override
        public void visit(Tree.WhileStatement stmt) {
        }

        @Override
        public void visit(Tree.ForStatement stmt) {
        }

        @Override
        public void visit(Tree.Declaration stmt) {
        }

        @Override
        public void visit(Tree.Break stmt) {
            this.breaks = true;
        }
    }

    class WhileCondList
    extends BlockCondList {
        private final ListBuffer<JCTree.JCStatement> varDecls;
        private final Name label;

        public WhileCondList(Tree.WhileClause whileClause) {
            super(whileClause.getConditionList().getConditions(), whileClause.getBlock());
            this.varDecls = ListBuffer.lb();
            this.label = StatementTransformer.this.getLabel(whileClause.getControlBlock());
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIntermediateElse(Cond cond, List<Tree.Condition> rest) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Break(this.label));
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermostThen(Cond cond) {
            return StatementTransformer.this.makeThenBlock(cond, this.thenPart, null, null, null, null).getStatements();
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermostElse(Cond cond, List<Tree.Condition> rest) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Break(this.label));
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommon(Cond cond, List<Tree.Condition> rest, JCTree.JCExpression test, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> elseStmts) {
            if (cond.getVarTrans().makeTestVarDecl(0, false) != null) {
                this.varDecls.append(cond.getVarTrans().makeTestVarDecl(0, false));
            }
            stmts = com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().If(test, StatementTransformer.this.make().Block(0L, stmts), StatementTransformer.this.makeElseBlock(elseStmts)));
            return stmts;
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommonResultDecl(VarTrans vartrans, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts) {
            if (vartrans.hasResultDecl()) {
                com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> vars = vartrans.getVarDefBuilders();
                for (VarDefBuilder v : vars) {
                    stmts = stmts.prepend(v.build());
                }
            }
            return stmts;
        }

        @Override
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> getResult() {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = this.transformList(this.conditions);
            ListBuffer loopStmts = ListBuffer.lb();
            loopStmts.appendList(this.varDecls);
            loopStmts.appendList(stmts);
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> result = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            if (StatementTransformer.this.definitelySatisfied(this.conditions)) {
                BreakVisitor v = new BreakVisitor();
                this.thenPart.visit(v);
                if (!v.breaks) {
                    result = result.prepend(StatementTransformer.this.makeFlowAppeaser((Node)this.conditions.get(0)));
                }
            }
            result = result.prepend(StatementTransformer.this.make().Labelled(this.label, StatementTransformer.this.make().WhileLoop(StatementTransformer.this.makeBoolean(true), StatementTransformer.this.make().Block(0L, loopStmts.toList()))));
            return result;
        }
    }

    class IfCondList
    extends BlockCondList {
        final ListBuffer<JCTree.JCStatement> varDecls;
        final Naming.SyntheticName ifVar;
        private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> unassignedResultVars;
        private JCTree.JCBlock thenBlock;
        private Tree.Variable elseVar;
        private Node elsePart;

        public IfCondList(List<Tree.Condition> conditions, Tree.Block thenPart, Tree.Variable elseVar, Tree.Block elsePart) {
            super(conditions, thenPart);
            this.varDecls = ListBuffer.lb();
            this.ifVar = StatementTransformer.this.naming.temp("if");
            this.unassignedResultVars = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            this.elseVar = elseVar;
            this.elsePart = elsePart;
        }

        public IfCondList(List<Tree.Condition> conditions, Tree.Expression thenPart, Tree.Variable elseVar, Tree.Expression elsePart, String tmpVar, Tree.Term outerExpression, Type expectedType) {
            super(conditions, thenPart, tmpVar, outerExpression, expectedType);
            this.varDecls = ListBuffer.lb();
            this.ifVar = StatementTransformer.this.naming.temp("if");
            this.unassignedResultVars = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            this.elseVar = elseVar;
            this.elsePart = elsePart;
        }

        private boolean isDeferred() {
            return this.conditions.size() > 1 && this.elsePart != null;
        }

        @Override
        protected Cond getConditionTransformer(Tree.Condition cond) {
            return this.getConditionTransformer(cond, this.elseVar);
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIntermediateElse(Cond cond, List<Tree.Condition> rest) {
            return null;
        }

        private boolean isThenDefinitelyReturns() {
            return this.isDefinitelyReturns(this.thenPart);
        }

        private boolean isElseDefinitelyReturns() {
            return this.isDefinitelyReturns(this.elsePart);
        }

        private boolean isDefinitelyReturns(Node thenPart) {
            if (thenPart instanceof Tree.Block) {
                return ((Tree.Block)thenPart).getDefinitelyReturns();
            }
            if (thenPart instanceof Tree.Expression) {
                return false;
            }
            return false;
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermostThen(Cond cond) {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts;
            if (StatementTransformer.this.definitelyNotSatisfied(this.conditions) && !this.isThenDefinitelyReturns() && this.elsePart != null && this.isElseDefinitelyReturns()) {
                stmts = com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.makeFlowAppeaser((Node)this.conditions.get(0)));
            } else if (this.isDeferred()) {
                stmts = com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Exec(StatementTransformer.this.make().Assign(this.ifVar.makeIdent(), StatementTransformer.this.makeBoolean(true))));
                this.thenBlock = StatementTransformer.this.makeThenBlock(cond, this.thenPart, null, this.tmpVar, this.outerExpression, this.expectedType);
            } else {
                stmts = StatementTransformer.this.makeThenBlock(cond, this.thenPart, null, this.tmpVar, this.outerExpression, this.expectedType).getStatements();
            }
            return stmts;
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermostElse(Cond cond, List<Tree.Condition> rest) {
            com.redhat.ceylon.langtools.tools.javac.util.List<Object> stmts = null;
            if (this.elsePart != null && !this.isDeferred()) {
                stmts = this.elsePart instanceof Tree.Block ? StatementTransformer.this.transformBlock((Tree.Block)this.elsePart) : (this.elsePart instanceof Tree.Expression ? StatementTransformer.this.evaluateAndAssign(this.tmpVar, (Tree.Expression)this.elsePart, this.outerExpression, this.expectedType) : com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Exec(StatementTransformer.this.makeErroneous(this.thenPart, "Only block or expression allowed"))));
            }
            return stmts;
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommon(Cond cond, List<Tree.Condition> rest, JCTree.JCExpression test, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> elseStmts) {
            JCTree.JCStatement testVarDecl = cond.getVarTrans().makeTestVarDecl(0, false);
            if (testVarDecl == null && cond.getElseVarTrans() != null) {
                testVarDecl = cond.getElseVarTrans().makeTestVarDecl(0, false);
            }
            if (testVarDecl != null) {
                this.varDecls.prepend(testVarDecl);
            }
            if (this.isDeferred()) {
                elseStmts = this.unassignedResultVars.isEmpty() ? null : this.unassignedResultVars;
            }
            stmts = com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().If(test, StatementTransformer.this.make().Block(0L, stmts), StatementTransformer.this.makeElseBlock(elseStmts)));
            return stmts;
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommonResultDecl(VarTrans vartrans, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts) {
            if (vartrans.hasResultDecl()) {
                com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> vars = vartrans.getVarDefBuilders();
                for (VarDefBuilder vdb : vars) {
                    if (this.isDeferred()) {
                        this.unassignedResultVars = this.unassignedResultVars.prepend(StatementTransformer.this.make().Exec(vdb.buildDefaultAssign()));
                        this.varDecls.prepend(vdb.buildDefOnly());
                        stmts = stmts.prepend(StatementTransformer.this.make().Exec(vdb.buildAssign()));
                        continue;
                    }
                    stmts = stmts.prepend(vdb.build());
                }
            }
            return stmts;
        }

        @Override
        public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> getResult() {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = this.transformList(this.conditions);
            if (StatementTransformer.this.definitelySatisfied(this.conditions) && this.isThenDefinitelyReturns() && (this.elsePart == null || !this.isElseDefinitelyReturns())) {
                stmts = stmts.append(StatementTransformer.this.makeFlowAppeaser((Node)this.conditions.get(0)));
            }
            ListBuffer result = ListBuffer.lb();
            if (this.isDeferred()) {
                result.append(StatementTransformer.this.makeVar(this.ifVar, StatementTransformer.this.make().Type(StatementTransformer.this.syms().booleanType), StatementTransformer.this.makeBoolean(false)));
            }
            result.appendList(this.varDecls);
            result.appendList(stmts);
            if (this.isDeferred()) {
                Object elseBlock = this.elsePart instanceof Tree.Block ? StatementTransformer.this.transform((Tree.Block)this.elsePart) : (this.elsePart instanceof Tree.Expression ? StatementTransformer.this.at(this.elsePart).Block(0L, StatementTransformer.this.evaluateAndAssign(this.tmpVar, (Tree.Expression)this.elsePart, this.outerExpression, this.expectedType)) : (this.elsePart == null ? null : StatementTransformer.this.at(this.elsePart).Block(0L, com.redhat.ceylon.langtools.tools.javac.util.List.of(StatementTransformer.this.make().Exec(StatementTransformer.this.makeErroneous(this.thenPart, "Only block or expression allowed"))))));
                result.append(StatementTransformer.this.make().If(this.ifVar.makeIdent(), this.thenBlock, (JCTree.JCStatement)elseBlock));
            }
            return result.toList();
        }
    }

    abstract class BlockCondList
    extends CondList {
        protected final String tmpVar;
        protected final Tree.Term outerExpression;
        protected final Type expectedType;

        public BlockCondList(List<Tree.Condition> conditions, Tree.Block thenPart) {
            super(conditions, thenPart);
            this.tmpVar = null;
            this.outerExpression = null;
            this.expectedType = null;
        }

        public BlockCondList(List<Tree.Condition> conditions, Tree.Expression thenPart, String tmpVar, Tree.Term outerExpression, Type expectedType) {
            super(conditions, thenPart);
            this.tmpVar = tmpVar;
            this.outerExpression = outerExpression;
            this.expectedType = expectedType;
        }

        @Override
        protected final com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermost(Tree.Condition condition) {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> elseStmts;
            com.redhat.ceylon.langtools.tools.javac.util.List<Naming.Substitution> subs;
            Cond transformedCond = this.getConditionTransformer(condition);
            JCTree.JCExpression test = transformedCond.makeTest();
            List<Tree.Condition> rest = Collections.emptyList();
            if (transformedCond.getElseVarTrans() != null) {
                subs = this.getSubstitutions(transformedCond.getElseVarTrans());
                elseStmts = this.transformInnermostElse(transformedCond, rest);
                elseStmts = this.transformCommonResultDecl(transformedCond.getElseVarTrans(), elseStmts);
                this.closeSubstitutions(subs);
            } else {
                elseStmts = this.transformInnermostElse(transformedCond, rest);
            }
            subs = this.getSubstitutions(transformedCond.getVarTrans());
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = this.transformInnermostThen(transformedCond);
            stmts = this.transformCommonResultDecl(transformedCond.getVarTrans(), stmts);
            this.closeSubstitutions(subs);
            stmts = this.transformCommon(transformedCond, rest, test, stmts, elseStmts);
            return stmts;
        }

        protected com.redhat.ceylon.langtools.tools.javac.util.List<Naming.Substitution> getSubstitutions(VarTrans vartrans) {
            if (vartrans.hasResultDecl()) {
                com.redhat.ceylon.langtools.tools.javac.util.List<Naming.Substitution> subs = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
                com.redhat.ceylon.langtools.tools.javac.util.List<VarDefBuilder> vars = vartrans.getVarDefBuilders();
                for (VarDefBuilder v : vars) {
                    subs = subs.append(StatementTransformer.this.naming.substituteAlias(v.var.getDeclarationModel()));
                }
                return subs;
            }
            return null;
        }

        protected void closeSubstitutions(com.redhat.ceylon.langtools.tools.javac.util.List<Naming.Substitution> subs) {
            if (subs != null) {
                for (Naming.Substitution s : subs) {
                    s.close();
                }
            }
        }

        @Override
        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIntermediate(Tree.Condition condition, List<Tree.Condition> rest) {
            Cond intermediate = this.getConditionTransformer(condition);
            JCTree.JCExpression test = intermediate.makeTest();
            com.redhat.ceylon.langtools.tools.javac.util.List<Naming.Substitution> subs = this.getSubstitutions(intermediate.getVarTrans());
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> stmts = this.transformList(rest);
            stmts = this.transformCommonResultDecl(intermediate.getVarTrans(), stmts);
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> intermediateElse = this.transformIntermediateElse(intermediate, rest);
            stmts = this.transformCommon(intermediate, rest, test, stmts, intermediateElse);
            this.closeSubstitutions(subs);
            return stmts;
        }

        protected JCTree.JCStatement makeDefaultAssignment(Type type, Naming.CName name) {
            return StatementTransformer.this.make().Exec(StatementTransformer.this.make().Assign(name.makeIdent(), StatementTransformer.this.makeDefaultExprForType(type)));
        }

        protected abstract com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermostThen(Cond var1);

        protected abstract com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermostElse(Cond var1, List<Tree.Condition> var2);

        protected abstract com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIntermediateElse(Cond var1, List<Tree.Condition> var2);

        protected abstract com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommon(Cond var1, List<Tree.Condition> var2, JCTree.JCExpression var3, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> var4, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> var5);

        protected abstract com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformCommonResultDecl(VarTrans var1, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> var2);
    }

    abstract class CondList {
        protected final Node thenPart;
        protected final List<Tree.Condition> conditions;

        public CondList(List<Tree.Condition> conditions, Tree.Block thenPart) {
            this.conditions = conditions;
            this.thenPart = thenPart;
        }

        public CondList(List<Tree.Condition> conditions, Tree.Expression thenPart) {
            this.conditions = conditions;
            this.thenPart = thenPart;
        }

        protected Cond getConditionTransformer(Tree.Condition cond) {
            return this.getConditionTransformer(cond, null);
        }

        protected Cond getConditionTransformer(Tree.Condition cond, Tree.Variable elseVariable) {
            if (cond instanceof Tree.IsCondition) {
                Tree.IsCondition is = (Tree.IsCondition)cond;
                IsVarTrans var = new IsVarTrans(is.getVariable());
                IsVarTrans elseVar = elseVariable != null ? new IsVarTrans(elseVariable, var.getTestVariableName()) : null;
                return new IsCond(is, var, elseVar);
            }
            if (cond instanceof Tree.ExistsCondition) {
                Tree.ExistsCondition exists = (Tree.ExistsCondition)cond;
                ExistsVarTrans var = new ExistsVarTrans(exists.getVariable());
                ExistsVarTrans elseVar = elseVariable != null ? new ExistsVarTrans(elseVariable, var.getTestVariableName()) : null;
                return new ExistsCond(exists, var, elseVar);
            }
            if (cond instanceof Tree.NonemptyCondition) {
                Tree.NonemptyCondition nonempty = (Tree.NonemptyCondition)cond;
                NonemptyVarTrans var = new NonemptyVarTrans(nonempty.getVariable());
                NonemptyVarTrans elseVar = elseVariable != null ? new NonemptyVarTrans(elseVariable, var.getTestVariableName()) : null;
                return new NonemptyCond(nonempty, var, elseVar);
            }
            if (cond instanceof Tree.BooleanCondition) {
                return new BooleanCond((Tree.BooleanCondition)cond);
            }
            throw BugException.unhandledNodeCase(cond);
        }

        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformList(List<Tree.Condition> conditions) {
            Tree.Condition condition = conditions.get(0);
            StatementTransformer.this.at(condition);
            if (conditions.size() == 1) {
                return this.transformInnermost(condition);
            }
            return this.transformIntermediate(condition, conditions.subList(1, conditions.size()));
        }

        protected abstract com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformInnermost(Tree.Condition var1);

        protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> transformIntermediate(Tree.Condition condition, List<Tree.Condition> rest) {
            return this.transformList(rest);
        }

        public abstract com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> getResult();
    }

    class AssertionExceptionMessageBuilder {
        private JCTree.JCExpression expr;

        private JCTree.JCExpression cat(JCTree.JCExpression str1, JCTree.JCExpression str2) {
            if (str2 == null) {
                return str1;
            }
            return StatementTransformer.this.make().Binary(71, str1, str2);
        }

        private JCTree.JCExpression cat(JCTree.JCExpression strExpr, String literal) {
            return this.cat(strExpr, StatementTransformer.this.make().Literal(literal));
        }

        private JCTree.JCExpression newline() {
            return StatementTransformer.this.make().Apply(null, StatementTransformer.this.makeQualIdent(StatementTransformer.this.makeIdent(StatementTransformer.this.syms().systemType), "lineSeparator"), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        }

        public AssertionExceptionMessageBuilder(JCTree.JCExpression expr) {
            this.expr = expr;
        }

        public AssertionExceptionMessageBuilder prependAssertionDoc(Tree.Assertion ass) {
            return this.prependAssertionDoc(StatementTransformer.this.getDocAnnotationText(ass));
        }

        public AssertionExceptionMessageBuilder prependAssertionDoc(String docText) {
            JCTree.JCExpression p = StatementTransformer.this.make().Literal("Assertion failed");
            if (docText != null) {
                p = this.cat(p, ": " + docText);
            }
            this.expr = this.cat(p, this.expr);
            return this;
        }

        private AssertionExceptionMessageBuilder appendCondition(String state, String sourceCode) {
            JCTree.JCExpression m = this.cat(this.newline(), StatementTransformer.this.make().Literal("\t" + state + " "));
            this.expr = this.expr != null ? this.cat(this.expr, m) : m;
            this.expr = this.cat(this.expr, StatementTransformer.this.make().Literal(sourceCode));
            return this;
        }

        public AssertionExceptionMessageBuilder appendViolatedCondition(String sourceCode) {
            return this.appendCondition("violated", sourceCode);
        }

        public AssertionExceptionMessageBuilder appendViolatedCondition(Tree.Condition condition) {
            return this.appendViolatedCondition(StatementTransformer.this.getSourceCode(condition));
        }

        public AssertionExceptionMessageBuilder appendUnviolatedCondition(Tree.Condition condition) {
            return this.appendCondition("unviolated", StatementTransformer.this.getSourceCode(condition));
        }

        public AssertionExceptionMessageBuilder appendUntestedCondition(Tree.Condition condition) {
            return this.appendCondition("untested", StatementTransformer.this.getSourceCode(condition));
        }

        public JCTree.JCExpression build() {
            return this.expr;
        }
    }
}

