/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.ErroneousException;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.List;

class Strategy {
    private Strategy() {
    }

    public static boolean defaultParameterMethodTakesThis(Tree.Declaration decl) {
        return Strategy.defaultParameterMethodTakesThis(decl.getDeclarationModel());
    }

    public static boolean defaultParameterMethodTakesThis(Declaration decl) {
        return decl instanceof Function && decl.isToplevel();
    }

    public static DefaultParameterMethodOwner defaultParameterMethodOwner(Declaration decl) {
        if (decl instanceof Function && !Decl.withinInterface(decl) && !((Function)decl).isParameter()) {
            return DefaultParameterMethodOwner.SELF;
        }
        if (decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter()) {
            decl = (Declaration)((Object)decl.getContainer());
        }
        if (Decl.isConstructor(decl)) {
            decl = Decl.getConstructedClass(decl);
        }
        if ((decl instanceof Function || decl instanceof Class) && decl.isToplevel()) {
            return DefaultParameterMethodOwner.STATIC;
        }
        if (decl instanceof Class && !decl.isToplevel() && !Decl.isLocalNotInitializer(decl)) {
            return Decl.getClassOrInterfaceContainer(decl, false) instanceof Class ? DefaultParameterMethodOwner.OUTER : DefaultParameterMethodOwner.OUTER_COMPANION;
        }
        return DefaultParameterMethodOwner.INIT_COMPANION;
    }

    public static boolean defaultParameterMethodStatic(Tree.Declaration decl) {
        return Strategy.defaultParameterMethodStatic(decl.getDeclarationModel());
    }

    public static boolean defaultParameterMethodStatic(Element decl) {
        if (decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter()) {
            decl = (Element)((Object)decl.getContainer());
        }
        if (decl instanceof Declaration && Decl.isConstructor((Declaration)decl)) {
            decl = Decl.getConstructedClass((Declaration)decl);
        }
        return (decl instanceof Function && !((Function)decl).isParameter() || decl instanceof Class) && ((Declaration)decl).isToplevel();
    }

    public static boolean defaultParameterMethodOnOuter(Tree.Declaration decl) {
        return Strategy.defaultParameterMethodOnOuter(decl.getDeclarationModel());
    }

    public static boolean defaultParameterMethodOnOuter(Element elem) {
        if (elem instanceof Declaration && Decl.isConstructor((Declaration)elem)) {
            elem = Decl.getConstructedClass((Declaration)elem);
        }
        if (elem instanceof FunctionOrValue && ((FunctionOrValue)elem).isParameter()) {
            elem = (Element)((Object)((FunctionOrValue)elem).getContainer());
        }
        return elem instanceof Class && !((Class)elem).isToplevel() && !Decl.isLocalNotInitializer((Class)elem);
    }

    public static boolean defaultParameterMethodOnSelf(Tree.Declaration decl) {
        return Strategy.defaultParameterMethodOnSelf(decl.getDeclarationModel());
    }

    public static boolean defaultParameterMethodOnSelf(Declaration decl) {
        return decl instanceof Function && !((Function)decl).isParameter() && !Decl.withinInterface(decl);
    }

    public static boolean hasDefaultParameterValueMethod(Parameter param) {
        return param.isDefaulted();
    }

    public static boolean hasDefaultParameterOverload(Parameter param) {
        return param.isDefaulted() || param.isSequenced() && !param.isAtLeastOne();
    }

    public static boolean hasEmptyDefaultArgument(Parameter param) {
        return param.isSequenced() && !param.isAtLeastOne();
    }

    public static boolean generateMain(Tree.ClassOrInterface def) {
        for (Tree.CompilerAnnotation c : def.getCompilerAnnotations()) {
            if (!c.getIdentifier().getText().equals("nomain")) continue;
            return false;
        }
        return def instanceof Tree.AnyClass && Decl.isToplevel(def) && Decl.isShared(def) && !Decl.isAbstract(def) && !def.getDeclarationModel().isNativeHeader() && Strategy.hasNoRequiredParameters((Class)def.getDeclarationModel());
    }

    private static boolean hasNoRequiredParameters(Functional model) {
        List<ParameterList> parameterLists = model.getParameterLists();
        if (parameterLists == null || parameterLists.size() != 1) {
            return false;
        }
        ParameterList parameterList = parameterLists.get(0);
        if (parameterList == null) {
            return false;
        }
        List<Parameter> parameters = parameterList.getParameters();
        if (parameters == null) {
            return false;
        }
        if (parameters.isEmpty()) {
            return true;
        }
        return parameters.get(0).isDefaulted();
    }

    public static boolean generateMain(Tree.AnyMethod def) {
        return Decl.isToplevel(def) && Decl.isShared(def) && Strategy.hasNoRequiredParameters(def.getDeclarationModel());
    }

    public static boolean generateThisDelegates(Tree.AnyMethod def) {
        return Decl.withinInterface(def.getDeclarationModel()) && def instanceof Tree.MethodDeclaration && ((Tree.MethodDeclaration)def).getSpecifierExpression() == null;
    }

    public static boolean needsOuterMethodInCompanion(ClassOrInterface model) {
        return Decl.withinClassOrInterface(model);
    }

    public static boolean useField(Value attr) {
        return !Decl.withinInterface(attr) && Decl.isCaptured(attr);
    }

    public static boolean createField(Parameter p, Value v) {
        return !Decl.withinInterface(v) && (p == null || Strategy.useField(v));
    }

    static boolean createMethod(Tree.Parameter parameter) {
        return Strategy.createMethod(parameter.getParameterModel());
    }

    static boolean createMethod(Parameter parameter) {
        FunctionOrValue model = parameter.getModel();
        return JvmBackendUtil.createMethod(model);
    }

    public static boolean onlyOnCompanion(Declaration model) {
        return Decl.withinInterface(model) && (model instanceof ClassOrInterface || !Decl.isShared(model));
    }

    static boolean generateInstantiator(Declaration model) {
        if (model instanceof Class) {
            Class cls = (Class)model;
            return !cls.isAbstract() && (Decl.isRefinableMemberClass(cls) || Decl.isCeylon(cls) && model.isMember() && cls.isShared() && !cls.isAnonymous());
        }
        if (Decl.isConstructor(model)) {
            Constructor ctor = Decl.getConstructor(model);
            Class cls = Decl.getConstructedClass(ctor);
            return cls.isMember() && cls.isShared() && ctor.isShared();
        }
        return false;
    }

    static boolean isInstantiatorUntyped(Declaration model) {
        return Strategy.generateInstantiator(model) && Decl.isAncestorLocal(model);
    }

    static boolean useBoxedVoid(Function m) {
        return m.isMember() && (m.isDefault() || m.isFormal() || m.isActual()) && m.getType().isAnything() && Decl.isCeylon((TypeDeclaration)m.getRefinedDeclaration().getContainer());
    }

    public static boolean hasDelegatedDpm(Class cls) {
        return Decl.isRefinableMemberClass(cls.getRefinedDeclaration()) && Strategy.defaultParameterMethodOnOuter(cls) && Decl.withinInterface(cls.getRefinedDeclaration());
    }

    public static boolean inlinePowerAsMultiplication(Tree.PowerOp op) {
        try {
            Long power = ExpressionTransformer.getIntegerLiteralPower(op);
            if (power != null) {
                TypecheckerUnit unit = op.getUnit();
                Type baseType = op.getLeftTerm().getTypeModel();
                if (power > 0L && power <= 64L && baseType.isExactly(unit.getIntegerType())) {
                    return true;
                }
                if (power > 0L && power <= 64L && baseType.isExactly(unit.getFloatType())) {
                    return true;
                }
            }
        }
        catch (ErroneousException e) {
            return false;
        }
        return false;
    }

    public static boolean preferLazySwitchingIterable(List<Tree.PositionalArgument> positionalArguments) {
        return positionalArguments.size() < 128;
    }

    public static boolean generateJpaCtor(Tree.ClassOrInterface def) {
        return Strategy.generateJpaCtor(def.getDeclarationModel());
    }

    static boolean generateJpaCtor(ClassOrInterface declarationModel) {
        if (declarationModel instanceof Class && !(declarationModel instanceof ClassAlias) && declarationModel.isToplevel()) {
            Class cls = (Class)declarationModel;
            if (cls.getCaseValues() != null && !cls.getCaseValues().isEmpty()) {
                return false;
            }
            if (Strategy.hasNullaryNonJpaConstructor(cls)) {
                return false;
            }
            boolean hasDelegatableSuper = false;
            Class superClass = (Class)cls.getExtendedType().getDeclaration();
            if (superClass instanceof LazyClass && !((LazyClass)superClass).isCeylon()) {
                if (superClass.isAbstraction()) {
                    for (Declaration s : superClass.getOverloads()) {
                        if (!(s instanceof Class) || !Strategy.isNullary((Class)s)) continue;
                        hasDelegatableSuper = true;
                        break;
                    }
                } else {
                    hasDelegatableSuper = Strategy.isNullary(superClass);
                }
            } else {
                hasDelegatableSuper = Strategy.hasNullaryNonJpaConstructor(superClass) || Strategy.hasJpaConstructor(superClass);
            }
            boolean constrained = cls.getCaseValues() != null && !cls.getCaseValues().isEmpty() || cls.hasEnumerated() && Decl.hasOnlyValueConstructors(cls);
            return hasDelegatableSuper && !constrained;
        }
        return false;
    }

    private static boolean isNullary(Class superClass) {
        return superClass.getParameterList() != null && superClass.getParameterList().getParameters() != null && superClass.getParameterList().getParameters().isEmpty();
    }

    public static boolean hasJpaConstructor(Class c) {
        if (c instanceof LazyClass && !(c instanceof ClassAlias)) {
            return ((LazyClass)c).hasJpaConstructor();
        }
        return Strategy.generateJpaCtor(c);
    }

    protected static boolean hasNullaryNonJpaConstructor(Class c) {
        if (c.isToplevel() && !(c instanceof ClassAlias)) {
            List<Parameter> parameters = null;
            if (c.hasConstructors()) {
                Constructor defaultConstructor = Decl.getDefaultConstructor(c);
                if (defaultConstructor != null && defaultConstructor.getParameterList() != null) {
                    parameters = defaultConstructor.getParameterList().getParameters();
                }
            } else if (c.getParameterList() != null) {
                parameters = c.getParameterList().getParameters();
            }
            return parameters != null && (parameters.isEmpty() || parameters.get(0).isDefaulted() || parameters.get(0).isSequenced() && !parameters.get(0).isAtLeastOne());
        }
        return false;
    }

    public static boolean introduceJavaIoSerializable(Class cls, Interface ser) {
        return !(cls instanceof ClassAlias) && (Decl.hasOnlyValueConstructors(cls) || cls.isAnonymous() || cls.getExtendedType() != null && (cls.getExtendedType().isBasic() || cls.getExtendedType().isObject())) && !cls.getSatisfiedTypes().contains(ser.getType());
    }

    public static boolean addReadResolve(Class cls) {
        return cls.isAnonymous() && cls.isToplevel();
    }

    public static boolean useSerializationProxy(Class model) {
        return model.hasEnumerated() && (model.isToplevel() || model.isMember());
    }

    static enum DefaultParameterMethodOwner {
        INIT_COMPANION,
        STATIC,
        OUTER,
        OUTER_COMPANION,
        SELF;

    }
}

