/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import java.util.ArrayList;
import java.util.HashMap;

public class ToplevelAttributesDefinitionBuilder {
    private CeylonTransformer gen;
    private ArrayList<Tree.AnyAttribute> attribs;
    private HashMap<String, Tree.AttributeSetterDefinition> setters;

    public ToplevelAttributesDefinitionBuilder(CeylonTransformer gen) {
        this.gen = gen;
        this.attribs = new ArrayList();
        this.setters = new HashMap();
    }

    public void add(Tree.AttributeDeclaration decl) {
        this.attribs.add(decl);
    }

    public void add(Tree.AttributeGetterDefinition decl) {
        this.attribs.add(decl);
    }

    public void add(Tree.AttributeSetterDefinition decl) {
        String attrName = decl.getIdentifier().getText();
        this.setters.put(attrName, decl);
    }

    public ListBuffer<JCTree> build() {
        ListBuffer<JCTree> result = ListBuffer.lb();
        for (Tree.AnyAttribute attrib : this.attribs) {
            int annots = this.gen.checkCompilerAnnotations(attrib, result);
            String attrName = attrib.getIdentifier().getText();
            Tree.AttributeSetterDefinition setter = this.setters.get(attrName);
            result.appendList(this.gen.transformAttribute(attrib, setter));
            this.gen.resetCompilerAnnotations(annots);
        }
        return result;
    }
}

